/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.connect.Messaging;
import com.db.Database;
import com.gui.DFendImportDialog;
import com.gui.EditDosboxVersionDialog;
import com.gui.EditProfileDialog;
import com.gui.EditTemplateDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.SettingsDialog;
import com.gui.Thumb;
import com.model.DosboxVersion;
import com.model.OrderingVector;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.swtdesigner.SWTResourceManager;
import com.util.FileUtils;
import com.util.ListUtils;
import com.util.PlatformUtils;
import com.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

public class MainWindow {
    public static final String PROGRAM_NAME = "DOSBox Game Launcher v0.54";
    public static final String[] COLUMNNAMES = new String[]{"Title", "Setup", "Developer", "Publisher", "Genre", "Year", "Status", "Favorite", "ID"};
    private static final int THUMB_HEIGHT = 100;
    private Display display;
    protected Shell shell;
    private OrderingVector orderingVector = null;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private Database db = null;
    private Settings settings = null;
    private String currentThumbFile = null;
    private int[] columnIds;
    private Table template_table;
    private Table dosboxversion_table;
    private Table profile_table;
    private Text notesField;
    private ToolBar thumbsToolBar;
    private Link link1;
    private Link link2;

    public static void main(String[] args) {
        try {
            MainWindow window = new MainWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.db = Database.getInstance();
        this.settings = Settings.getInstance();
        this.display = Display.getDefault();
        this.createContents();
        Messaging mess = null;
        if (this.settings.getBooleanValue("communication", "port_enabled")) {
            mess = new Messaging(this.settings.getIntValue("communication", "port"), this);
            mess.start();
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        SWTResourceManager.dispose();
        this.display.dispose();
        if (mess != null) {
            mess.close();
        }
        try {
            this.settings.save();
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        try {
            this.db.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void createContents() {
        this.initColumnIds();
        this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
        this.shell = new Shell();
        try {
            this.profilesList = this.db.readProfilesList(this.orderingVector.toClause());
            this.dbversionsList = this.db.readDosboxVersionsList();
            this.templatesList = this.db.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                boolean isMaximized = MainWindow.this.shell.getMaximized();
                if (!isMaximized) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "width", rec.width);
                    MainWindow.this.settings.setIntValue("gui", "height", rec.height);
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
                MainWindow.this.settings.setBooleanValue("gui", "maximized", isMaximized);
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
            }
        });
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setMaximized(this.settings.getBooleanValue("gui", "maximized"));
        this.shell.setLocation(this.settings.getIntValue("gui", "x"), this.settings.getIntValue("gui", "y"));
        this.shell.setSize(this.settings.getIntValue("gui", "width"), this.settings.getIntValue("gui", "height"));
        this.shell.setText(PROGRAM_NAME);
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem fileMenuItem = new MenuItem(menu, 64);
        fileMenuItem.setText("File");
        Menu menu_1 = new Menu(fileMenuItem);
        fileMenuItem.setMenu(menu_1);
        if (PlatformUtils.IS_WINDOWS) {
            MenuItem dfendImportMenuItem = new MenuItem(menu_1, 0);
            dfendImportMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainWindow.this.doDFendImport();
                }
            });
            dfendImportMenuItem.setText("Import D-Fend Profiles");
            new MenuItem(menu_1, 2);
        }
        MenuItem confImportMenuItem = new MenuItem(menu_1, 0);
        confImportMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doImportConfigfile();
            }
        });
        confImportMenuItem.setText("Import Profile");
        new MenuItem(menu_1, 2);
        MenuItem settingsMenuItem = new MenuItem(menu_1, 0);
        settingsMenuItem.setText("Adjust Settings");
        settingsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doOpenSettingsDialog();
            }
        });
        MenuItem exitMenuItem = new MenuItem(menu_1, 0);
        exitMenuItem.setText("Exit");
        exitMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.shell.close();
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem profilesTabItem = new TabItem(tabFolder, 0);
        profilesTabItem.setText("Profiles");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        profilesTabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        ToolItem newItemToolItem = new ToolItem(toolBar, 8);
        newItemToolItem.setText("Add profile");
        newItemToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddProfile();
            }
        });
        ToolItem newItemToolItem_2 = new ToolItem(toolBar, 8);
        newItemToolItem_2.setText("Edit Profile");
        newItemToolItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditProfile();
            }
        });
        ToolItem newItemToolItem_1 = new ToolItem(toolBar, 8);
        newItemToolItem_1.setText("Remove profile");
        newItemToolItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveProfile();
            }
        });
        final SashForm sashForm = new SashForm(composite, 0);
        this.profile_table = new Table((Composite)sashForm, 67584);
        Composite informationGroup = new Composite((Composite)sashForm, 0);
        informationGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValues("gui", "sashweights", sashForm.getWeights());
            }
        });
        informationGroup.setLayout((Layout)new BorderLayout(0, 0));
        this.notesField = new Text(informationGroup, 2634);
        Composite composite_2 = new Composite(informationGroup, 0);
        composite_2.setLayout((Layout)new BorderLayout(0, 0));
        composite_2.setLayoutData((Object)"South");
        this.link1 = new Link(composite_2, 0);
        this.link1.setLayoutData((Object)"North");
        this.link1.setText(" ");
        this.link1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformUtils.openForBrowsing(e.text);
            }
        });
        this.link2 = new Link(composite_2, 0);
        this.link2.setText(" ");
        this.link2.setLayoutData((Object)"South");
        this.link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlatformUtils.openForBrowsing(e.text);
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(120);
        scrolledComposite.setLayoutData((Object)"South");
        this.thumbsToolBar = new ToolBar((Composite)scrolledComposite, 0);
        this.thumbsToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MainWindow.this.currentThumbFile = MainWindow.this.thumbsToolBar.getItem(new Point(e.x, e.y)).getToolTipText();
            }
        });
        scrolledComposite.setContent((Control)this.thumbsToolBar);
        Menu menu_thumb = new Menu((Control)this.thumbsToolBar);
        this.thumbsToolBar.setMenu(menu_thumb);
        MenuItem thumbMenuItem = new MenuItem(menu_thumb, 0);
        thumbMenuItem.setText("Remove");
        thumbMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveThumb();
            }
        });
        this.profile_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.doRemoveProfile();
                } else if (e.keyCode == 0x1000009) {
                    MainWindow.this.doAddProfile();
                } else if (e.keyCode == 0x100000B) {
                    MainWindow.this.doEditProfile(true);
                } else if (e.stateMask == 262144 && Character.toLowerCase(e.keyCode) == 109) {
                    MainWindow.this.doToggleFavoriteProfile();
                } else if (e.stateMask == 262144 && Character.toLowerCase(e.keyCode) == 100) {
                    MainWindow.this.doDuplicateProfile();
                }
            }
        });
        this.profile_table.setLayoutData((Object)"West");
        this.profile_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.stateMask == 262144 && e.detail == 4) {
                    MainWindow.this.doEditProfile();
                } else if (e.stateMask == 131072 && e.detail == 4) {
                    MainWindow.this.doRunProfile(true);
                } else if (e.detail == 4) {
                    MainWindow.this.doRunProfile(false);
                }
            }
        });
        this.profile_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainWindow.this.doRunProfile(false);
            }
        });
        this.profile_table.setLinesVisible(true);
        this.profile_table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnIds.length) {
            this.addProfileColumn(COLUMNNAMES[this.columnIds[i]], i);
            ++i;
        }
        this.profile_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.displayProfileInformation();
            }
        });
        Menu menu_2 = new Menu((Control)this.profile_table);
        this.profile_table.setMenu(menu_2);
        MenuItem runMenuItem = new MenuItem(menu_2, 0);
        runMenuItem.setText("Run");
        runMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRunProfile(false);
            }
        });
        final MenuItem setupMenuItem = new MenuItem(menu_2, 0);
        setupMenuItem.setText("Setup");
        setupMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRunProfile(true);
            }
        });
        new MenuItem(menu_2, 2);
        MenuItem addMenuItem = new MenuItem(menu_2, 0);
        addMenuItem.setText("Add");
        addMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddProfile();
            }
        });
        MenuItem editMenuItem = new MenuItem(menu_2, 0);
        editMenuItem.setText("Edit");
        editMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditProfile();
            }
        });
        MenuItem duplicateMenuItem = new MenuItem(menu_2, 0);
        duplicateMenuItem.setText("Duplicate");
        duplicateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doDuplicateProfile();
            }
        });
        MenuItem removeMenuItem = new MenuItem(menu_2, 0);
        removeMenuItem.setText("Remove");
        removeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveProfile();
            }
        });
        new MenuItem(menu_2, 2);
        MenuItem toggleMenuItem = new MenuItem(menu_2, 0);
        toggleMenuItem.setText("Toggle favorite");
        toggleMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doToggleFavoriteProfile();
            }
        });
        if (PlatformUtils.IS_WINDOWS) {
            new MenuItem(menu_2, 2);
            MenuItem shortcutMenuItem = new MenuItem(menu_2, 0);
            shortcutMenuItem.setText("Create shortcut");
            shortcutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainWindow.this.doCreateShortcut();
                }
            });
        }
        menu_2.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (MainWindow.this.profile_table.getSelectionIndex() != -1) {
                    setupMenuItem.setEnabled(((Profile)MainWindow.this.profilesList.get(MainWindow.this.profile_table.getSelectionIndex())).hasSetupBoolean());
                }
            }
        });
        sashForm.setWeights(this.settings.getIntValues("gui", "sashweights"));
        TabItem dosboxTabItem = new TabItem(tabFolder, 0);
        dosboxTabItem.setText("DOSBox versions");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        dosboxTabItem.setControl((Control)composite_1);
        ToolBar toolBar_1 = new ToolBar(composite_1, 0);
        toolBar_1.setLayoutData((Object)"North");
        ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, 8);
        newItemToolItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddDosboxVersion();
            }
        });
        newItemToolItem_3.setText("Add version");
        ToolItem newItemToolItem_2_1 = new ToolItem(toolBar_1, 8);
        newItemToolItem_2_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditDosboxVersion();
            }
        });
        newItemToolItem_2_1.setText("Edit version");
        ToolItem newItemToolItem_1_1 = new ToolItem(toolBar_1, 8);
        newItemToolItem_1_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        });
        newItemToolItem_1_1.setText("Remove version");
        this.dosboxversion_table = new Table(composite_1, 67584);
        this.dosboxversion_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (e.keyCode == 0x1000009) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (e.stateMask == 262144 && Character.toLowerCase(e.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        });
        this.dosboxversion_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.stateMask == 262144 && e.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (e.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        });
        this.dosboxversion_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainWindow.this.doRunDosbox();
            }
        });
        this.dosboxversion_table.setLinesVisible(true);
        this.dosboxversion_table.setHeaderVisible(true);
        this.addDBColumn("Title", 0);
        this.addDBColumn("Path", 1);
        this.addDBColumn("Default", 2);
        Menu menu_4 = new Menu((Control)this.dosboxversion_table);
        this.dosboxversion_table.setMenu(menu_4);
        MenuItem runDBMenuItem = new MenuItem(menu_4, 0);
        runDBMenuItem.setText("Run");
        runDBMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRunDosbox();
            }
        });
        new MenuItem(menu_4, 2);
        MenuItem addDBMenuItem = new MenuItem(menu_4, 0);
        addDBMenuItem.setText("Add");
        addDBMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddDosboxVersion();
            }
        });
        MenuItem editDBMenuItem = new MenuItem(menu_4, 0);
        editDBMenuItem.setText("Edit");
        editDBMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditDosboxVersion();
            }
        });
        MenuItem removeDBMenuItem = new MenuItem(menu_4, 0);
        removeDBMenuItem.setText("Remove");
        removeDBMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        });
        new MenuItem(menu_4, 2);
        MenuItem toggleDefaultMenuItem = new MenuItem(menu_4, 0);
        toggleDefaultMenuItem.setText("Toggle default");
        toggleDefaultMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doToggleDefaultVersion();
            }
        });
        TabItem templatesTabItem = new TabItem(tabFolder, 0);
        templatesTabItem.setText("Templates");
        Composite composite_1_1 = new Composite((Composite)tabFolder, 0);
        composite_1_1.setLayout((Layout)new BorderLayout(0, 0));
        templatesTabItem.setControl((Control)composite_1_1);
        ToolBar toolBar_1_1 = new ToolBar(composite_1_1, 0);
        toolBar_1_1.setLayoutData((Object)"North");
        ToolItem newItemToolItem_3_1 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_3_1.setText("Add template");
        newItemToolItem_3_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddTemplate();
            }
        });
        ToolItem newItemToolItem_2_1_1 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_2_1_1.setText("Edit template");
        newItemToolItem_2_1_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditTemplate();
            }
        });
        ToolItem newItemToolItem_1_1_1 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_1_1_1.setText("Remove template");
        newItemToolItem_1_1_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveTemplate();
            }
        });
        this.template_table = new Table(composite_1_1, 67584);
        this.template_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MainWindow.this.doRemoveTemplate();
                } else if (e.keyCode == 0x1000009) {
                    MainWindow.this.doAddTemplate();
                } else if (e.stateMask == 262144 && Character.toLowerCase(e.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        });
        this.template_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.stateMask == 262144 && e.detail == 4) {
                    MainWindow.this.doEditTemplate();
                }
            }
        });
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        this.addTemplateColumn("Title", 0);
        this.addTemplateColumn("Default", 1);
        Menu menu_3 = new Menu((Control)this.template_table);
        this.template_table.setMenu(menu_3);
        MenuItem addTemplateMenuItem = new MenuItem(menu_3, 0);
        addTemplateMenuItem.setText("Add");
        addTemplateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doAddTemplate();
            }
        });
        MenuItem editTemplateMenuItem = new MenuItem(menu_3, 0);
        editTemplateMenuItem.setText("Edit");
        editTemplateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doEditTemplate();
            }
        });
        MenuItem removeTemplateMenuItem = new MenuItem(menu_3, 0);
        removeTemplateMenuItem.setText("Remove");
        removeTemplateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doRemoveTemplate();
            }
        });
        new MenuItem(menu_3, 2);
        MenuItem toggleTemplateMenuItem = new MenuItem(menu_3, 0);
        toggleTemplateMenuItem.setText("Toggle default");
        toggleTemplateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        });
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        for (DosboxVersion dbversion : this.dbversionsList) {
            this.addDosboxVersionToTable(dbversion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
        this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
        this.profile_table.setColumnOrder(this.settings.getIntValues("gui", "columnorder"));
    }

    private void doReorderProfiles(int columnId, SelectionEvent e) {
        TableColumn sortColumn = this.profile_table.getSortColumn();
        TableColumn currentColumn = (TableColumn)e.widget;
        int dir = this.profile_table.getSortDirection();
        if (sortColumn == currentColumn) {
            dir = dir == 128 ? 1024 : 128;
        } else {
            this.profile_table.setSortColumn(currentColumn);
            dir = 128;
        }
        int currentProfileId = -1;
        if (this.profile_table.getSelectionIndex() != -1) {
            currentProfileId = this.profilesList.get(this.profile_table.getSelectionIndex()).getId();
        }
        try {
            this.orderingVector.addOrdering(this.columnIds[columnId], dir == 128);
            this.profilesList = this.db.readProfilesList(this.orderingVector.toClause());
        }
        catch (SQLException ex) {
            GeneralPurposeDialogs.warningMessage(this.shell, ex.getMessage());
        }
        int i = 0;
        while (i < this.profilesList.size()) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
            ++i;
        }
        this.profile_table.setSortDirection(dir);
        if (currentProfileId != -1) {
            this.profile_table.setSelection(ListUtils.findTIProfile(this.profilesList, currentProfileId));
            this.profile_table.showSelection();
        }
        this.settings.setIntValues("gui", "sortcolumn", this.orderingVector.getColumns());
        this.settings.setBooleanValues("gui", "sortascending", this.orderingVector.getAscendings());
    }

    private void displayNotes(String notes) {
        this.notesField.setText(notes);
    }

    private void displayLinks(String p_link1, String p_link2) {
        if (p_link1 != null && !p_link1.equals("")) {
            this.link1.setText("<a href=\"" + p_link1 + "\">" + p_link1 + "</a>");
        } else {
            this.link1.setText(" ");
        }
        if (p_link2 != null && !p_link2.equals("")) {
            this.link2.setText("<a href=\"" + p_link2 + "\">" + p_link2 + "</a>");
        } else {
            this.link2.setText(" ");
        }
    }

    private void displayScreenshots(Profile prof) {
        File path;
        String[] files;
        ToolItem[] toolItems = this.thumbsToolBar.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
        if (prof != null && (files = (path = new File(prof.getCaptures())).list()) != null) {
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].toLowerCase().endsWith(".png")) {
                    String file = String.valueOf(prof.getCaptures()) + File.separatorChar + files[i2];
                    Image thumb = SWTResourceManager.getImage(file);
                    ImageData smallThumb = thumb.getImageData();
                    int width = smallThumb.width;
                    int height = smallThumb.height;
                    double factor = 100.0 / (double)height;
                    smallThumb = smallThumb.scaledTo((int)((double)width * factor), (int)((double)height * factor));
                    final ToolItem toolItem = new ToolItem(this.thumbsToolBar, 8);
                    toolItem.setToolTipText(file);
                    toolItem.setText(files[i2]);
                    toolItem.setImage(new Image((Device)this.display, smallThumb));
                    toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Thumb thumbDialog = new Thumb(MainWindow.this.shell);
                            thumbDialog.setThumb(toolItem.getToolTipText());
                            thumbDialog.open();
                        }
                    });
                    toolItem.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            toolItem.getImage().dispose();
                        }
                    });
                }
                ++i2;
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getItemCount() != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        this.doAddProfile(null);
    }

    private void doAddProfile(String file) {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditProfileDialog addProfileDialog = new EditProfileDialog(this.shell);
        if (file != null) {
            addProfileDialog.sendToProfile(file);
        }
        this.updateWithAddedProfile((Profile)addProfileDialog.open());
    }

    public void addProfile(final String file) {
        this.display.syncExec(new Runnable(){

            public void run() {
                MainWindow.this.doAddProfile(file);
            }
        });
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog addDosboxVersionDialog = new EditDosboxVersionDialog(this.shell);
        DosboxVersion dbversion = (DosboxVersion)addDosboxVersionDialog.open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditTemplateDialog addTemplateDialog = new EditTemplateDialog(this.shell);
        Template template = (Template)addTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doToggleFavoriteProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile = this.profilesList.get(index);
            try {
                this.db.toggleFavorite(profile.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            profile.toggleFavorite();
            this.profilesList.set(index, profile);
            this.setTableItem(this.profile_table.getItem(index), profile);
        }
    }

    private void doToggleDefaultVersion() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1) {
            DosboxVersion ver = this.dbversionsList.get(index);
            ver.toggleDefault();
            try {
                this.db.addOrEditDosboxVersion(ver.getTitle(), ver.getPath(), ver.isMultiConfig(), ver.isDefaultVersion(), ver.getParameters(), ver.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateDosboxVersionList(ver);
        }
    }

    private void doToggleDefaultTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template temp = this.templatesList.get(index);
            temp.toggleDefault();
            try {
                this.db.addOrEditTemplate(temp.getTitle(), temp.getdbversionId(), temp.isDefault(), temp.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateTemplateList(temp);
        }
    }

    private void doEditProfile() {
        this.doEditProfile(false);
    }

    private void doEditProfile(boolean focusTitle) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile;
            EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
            editProfileDialog.setProfile(this.profilesList.get(index));
            if (focusTitle) {
                editProfileDialog.focusTitle();
            }
            if ((profile = (Profile)editProfileDialog.open()) != null) {
                if (this.settings.getBooleanValue("gui", "autosortonupdate")) {
                    this.updateProfilesList(profile);
                } else {
                    this.profilesList.set(index, profile);
                    this.setTableItem(this.profile_table.getItem(index), profile);
                }
                this.displayProfileInformation();
            }
        }
    }

    private void doDuplicateProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile orgProf = this.profilesList.get(index);
            this.updateWithAddedProfile(EditProfileDialog.duplicateProfile(orgProf, this.db, this.shell));
        }
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.settings.getBooleanValue("gui", "autosortonupdate")) {
                this.updateProfilesList(profile);
            } else {
                this.profilesList.add(profile);
                this.addProfileToTable(profile);
                this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
                this.profile_table.showSelection();
                this.profile_table.setFocus();
            }
            this.displayProfileInformation();
        }
    }

    private void doEditDosboxVersion() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1) {
            EditDosboxVersionDialog editDosboxVersionDialog = new EditDosboxVersionDialog(this.shell);
            editDosboxVersionDialog.setDosboxVersion(this.dbversionsList.get(index));
            DosboxVersion dbversion = (DosboxVersion)editDosboxVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void updateProfilesList(Profile profile) {
        try {
            this.profilesList = this.db.readProfilesList(this.orderingVector.toClause());
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.profile_table.setRedraw(false);
        this.profile_table.removeAll();
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        if (profile != null) {
            this.profile_table.setSelection(ListUtils.findTIProfile(this.profilesList, profile.getId()));
        }
        this.profile_table.setRedraw(true);
        this.profile_table.showSelection();
        this.profile_table.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        try {
            this.dbversionsList = this.db.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.dosboxversion_table.removeAll();
        for (DosboxVersion version : this.dbversionsList) {
            this.addDosboxVersionToTable(version);
        }
        this.dosboxversion_table.setSelection(ListUtils.findTIDosboxVersion(this.dbversionsList, dbversion.getId()));
        this.dosboxversion_table.showSelection();
        this.dosboxversion_table.setFocus();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList = this.db.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.template_table.removeAll();
        for (Template temp : this.templatesList) {
            this.addTemplateToTable(temp);
        }
        this.template_table.setSelection(ListUtils.findTITemplate(this.templatesList, template.getId()));
        this.template_table.showSelection();
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            EditTemplateDialog editTemplateDialog = new EditTemplateDialog(this.shell);
            editTemplateDialog.setTemplate(this.templatesList.get(index));
            Template template = (Template)editTemplateDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected profile?")) {
            Profile prof = this.profilesList.get(index);
            try {
                this.db.removeProfile(prof.getId());
                this.profile_table.remove(index);
                this.profilesList.remove(index);
                this.displayProfileInformation();
                SWTResourceManager.disposeImages();
                if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated conf file " + prof.getConfPathAndFile() + " ?")) {
                    FileUtils.removeFile(prof.getConfPathAndFile());
                }
                if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated captures directory " + prof.getCaptures() + " including its files?")) {
                    FileUtils.removeFilesInDirAndDir(prof.getCaptures());
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected DOSBox version?")) {
            try {
                this.db.removeDosboxVersion(this.dbversionsList.get(index).getId());
                this.dosboxversion_table.remove(index);
                this.dbversionsList.remove(index);
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected template?")) {
            int templateId = this.templatesList.get(index).getId();
            try {
                this.db.removeTemplate(templateId);
                this.template_table.remove(index);
                this.templatesList.remove(index);
                String conffile = FileUtils.constructTemplateFileLocation(templateId);
                if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated conf file " + conffile + " ?")) {
                    FileUtils.removeFile(conffile);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void addProfileToTable(Profile prof) {
        TableItem newItemTableItem = new TableItem(this.profile_table, 2048);
        this.setTableItem(newItemTableItem, prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        TableItem newItemTableItem = new TableItem(this.dosboxversion_table, 2048);
        this.setTableItem(newItemTableItem, dbversion);
    }

    private void addTemplateToTable(Template template) {
        TableItem newItemTableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(newItemTableItem, template);
    }

    private void setTableItem(TableItem newItemTableItem, Profile prof) {
        int i = 0;
        while (i < this.columnIds.length) {
            String value;
            switch (this.columnIds[i]) {
                case 0: {
                    value = prof.getTitle();
                    break;
                }
                case 1: {
                    value = prof.hasSetup();
                    break;
                }
                case 2: {
                    value = prof.getDeveloperName();
                    break;
                }
                case 3: {
                    value = prof.getPublisherName();
                    break;
                }
                case 4: {
                    value = prof.getGenre();
                    break;
                }
                case 5: {
                    value = prof.getYear();
                    break;
                }
                case 6: {
                    value = prof.getStatus();
                    break;
                }
                case 7: {
                    value = prof.isFavoriteString();
                    break;
                }
                case 8: {
                    value = String.valueOf(prof.getId());
                    break;
                }
                default: {
                    value = "";
                }
            }
            newItemTableItem.setText(i, value);
            ++i;
        }
    }

    private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getPath());
        newItemTableItem.setText(2, dbversion.isDefaultVersionString());
    }

    private void setTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefaultString());
    }

    private void doRunProfile(boolean setup) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            if (!setup || prof.hasSetupBoolean()) {
                try {
                    FileUtils.doRunProfile(prof, this.dbversionsList, setup);
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                }
            }
        }
    }

    private void doRunDosbox() {
        int index = this.dosboxversion_table.getSelectionIndex();
        if (index != -1) {
            try {
                FileUtils.doRunDosbox(this.dbversionsList.get(index));
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private DosboxVersion checkDefaultDBVersion() {
        int defaultDosboxVersionIndex = ListUtils.findTIDefaultDosboxVersion(this.dbversionsList);
        if (defaultDosboxVersionIndex == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "You must first define a default DOSBox version!");
            return null;
        }
        return this.dbversionsList.get(defaultDosboxVersionIndex);
    }

    private void doDFendImport() {
        DosboxVersion defaultDosboxVersion = this.checkDefaultDBVersion();
        if (defaultDosboxVersion == null) {
            return;
        }
        if (this.settings.getIntValue("profiledefaults", "confpath") == 1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "Please realize that you have currently configured DBGL to store profile configuration files in the game directory. Therefore, if you continue and perform the import, all configuration files are saved to the various game directories configured in D-Fend.\n\nIf you'd rather have those DOSBox config files stored in a central place, please open the Settings dialog first and change the default configuration-file location to '" + SettingsDialog.confLocations[0] + "'!");
        }
        DFendImportDialog importDialog = new DFendImportDialog(this.shell);
        importDialog.setDefaultDosboxVersion(defaultDosboxVersion);
        if (importDialog.open() != null) {
            try {
                this.profilesList = this.db.readProfilesList(this.orderingVector.toClause());
                this.profile_table.removeAll();
                for (Profile prof : this.profilesList) {
                    this.addProfileToTable(prof);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void displayProfileInformation() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            this.displayScreenshots(prof);
            this.displayNotes(prof.getNotes());
            this.displayLinks(prof.getLink1(), prof.getLink2());
        } else {
            this.displayScreenshots(null);
            this.displayNotes("");
            this.displayLinks("", "");
        }
    }

    private void doRemoveThumb() {
        if (GeneralPurposeDialogs.confirmMessage(this.shell, "Would you like to remove the selected screenshot \"" + this.currentThumbFile + "\"?")) {
            FileUtils.removeFile(this.currentThumbFile);
            this.displayProfileInformation();
        }
        this.currentThumbFile = null;
    }

    private void doCreateShortcut() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            PlatformUtils.createShortcut(this.profilesList.get(index), this.dbversionsList);
        }
    }

    private void addProfileColumn(String title, final int nr) {
        final String width = "column" + (this.columnIds[nr] + 1) + "width";
        final TableColumn column = new TableColumn(this.profile_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setMoveable(true);
        column.setText(title);
        if (this.columnIds[nr] == 8) {
            column.setAlignment(131072);
        }
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainWindow.this.doReorderProfiles(nr, e);
            }
        });
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }

            public void controlMoved(ControlEvent e) {
                MainWindow.this.settings.setIntValues("gui", "columnorder", MainWindow.this.profile_table.getColumnOrder());
            }
        });
    }

    private void addDBColumn(String title, int nr) {
        final String width = "column2_" + (nr + 1) + "width";
        final TableColumn column = new TableColumn(this.dosboxversion_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void addTemplateColumn(String title, int nr) {
        final String width = "column3_" + (nr + 1) + "width";
        final TableColumn column = new TableColumn(this.template_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void doOpenSettingsDialog() {
        SettingsDialog s = new SettingsDialog(this.shell);
        if (((Boolean)s.open()).booleanValue()) {
            int index = this.profile_table.getSelectionIndex();
            int nrColumns = this.profile_table.getColumnCount();
            String order = this.settings.getValue("gui", "columnorder");
            this.profile_table.removeAll();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < nrColumns) {
                sb.append(String.valueOf(i) + " ");
                ++i;
            }
            this.profile_table.setColumnOrder(StringUtils.stringToIntArray(sb.toString()));
            i = nrColumns - 1;
            while (i >= 0) {
                this.profile_table.getColumn(i).dispose();
                --i;
            }
            this.initColumnIds();
            i = 0;
            while (i < this.columnIds.length) {
                this.addProfileColumn(COLUMNNAMES[this.columnIds[i]], i);
                ++i;
            }
            this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
            this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
            this.settings.setValue("gui", "columnorder", order);
            this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
            Profile prof = index != -1 ? this.profilesList.get(index) : null;
            this.updateProfilesList(prof);
        }
    }

    private void doImportConfigfile() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"DOSBox configuration files", "Executables, Booter Disk Images", "*.*"});
        dialog.setFilterExtensions(new String[]{"*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*.*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private void initColumnIds() {
        int amount = 0;
        int i = 0;
        while (i < COLUMNNAMES.length) {
            if (this.settings.getBooleanValue("gui", "column" + (i + 1) + "visible")) {
                ++amount;
            }
            ++i;
        }
        int cNr = 0;
        this.columnIds = new int[amount];
        int i2 = 0;
        while (i2 < COLUMNNAMES.length) {
            if (this.settings.getBooleanValue("gui", "column" + (i2 + 1) + "visible")) {
                this.columnIds[cNr++] = i2;
            }
            ++i2;
        }
    }

    private int findColumnById(int id) {
        int i = 0;
        while (i < this.columnIds.length) {
            if (this.columnIds[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

