/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditMountDialog;
import com.gui.EditProfileDialog;
import com.gui.GeneralPurposeDialogs;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.Mount;
import com.model.Settings;
import com.model.Template;
import com.util.FileUtils;
import com.util.ListUtils;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    private Text keyboard_layout;
    private Button timed;
    private Button autofire;
    private Button swap34;
    private Button buttonwrap;
    private Button glide;
    private Text glideport;
    private Text vsyncrate;
    private Combo vsyncmode;
    private Combo videoram;
    private Combo svgachipset;
    private Text overscan;
    private Combo mt32rate;
    private Combo pixelshader;
    private TabItem infoTabItem;
    private Text title;
    private Button reloadSettingsButton;
    private Combo dbversion;
    private Button waitonerror;
    private Button exit;
    private Combo priority_inactive;
    private Combo priority_active;
    private Text captures;
    private Text language;
    private Combo windowresolution;
    private Combo fullresolution;
    private Combo frameskip;
    private Combo output;
    private Button fullscreen;
    private Button fulldouble;
    private Combo scaler;
    private Button aspect;
    private Combo machine;
    private Combo cycles_down;
    private Combo cycles_up;
    private Combo cycles;
    private Combo core;
    private Button timesynched;
    private Button xms;
    private Button ems;
    private Combo umb;
    private Combo memsize;
    private Button nosound;
    private Button mixer;
    private Button pcspeaker;
    private Button disney;
    private Button gus;
    private Combo tandy;
    private Combo tandyrate;
    private Text midi_config;
    private Combo device;
    private Combo mpu401;
    private Text ultradir;
    private Combo gusrate;
    private Combo irq2;
    private Combo dma2;
    private Combo dma1;
    private Combo irq1;
    private Combo gusbase;
    private Combo pcrate;
    private Combo hdma;
    private Combo dma;
    private Combo irq;
    private Combo sbbase;
    private Combo oplrate;
    private Combo oplmode;
    private Combo sbtype;
    private Combo prebuffer;
    private Combo blocksize;
    private Combo rate;
    private Button usescancodes;
    private Button autolock;
    private Text serial4;
    private Text serial3;
    private Text serial2;
    private Text serial1;
    private Combo joysticktype;
    private Text mapperfile;
    private Combo sensitivity;
    private Button ipx;
    private org.eclipse.swt.widgets.List mountingpoints;
    private Button booterButton;
    private Button dosButton;
    protected Shell shell;
    private List<DosboxVersion> dbversionsList;
    private Database db;
    private Configuration templateConf;
    private Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell parent) {
        super(parent, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.db = Database.getInstance();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        try {
            this.dbversionsList = this.db.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(610, 475);
        if (this.result != null) {
            this.shell.setText("Edit Template " + ((Template)this.result).getTitle() + " (" + ((Template)this.result).getId() + ")");
        } else {
            this.shell.setText("Add Template");
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText("Info");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title");
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        generalTabItem.setControl((Control)composite_1);
        Label dosboxVersionLabel = new Label(composite_1, 0);
        dosboxVersionLabel.setText("Dosbox version");
        this.dbversion = new Combo(composite_1, 8);
        this.dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(10);
        final Button setButton = new Button(composite_1, 0);
        setButton.setText("Set");
        setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.doLoadTemplateConf(setButton, true);
            }
        });
        setButton.setEnabled(false);
        this.dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                setButton.setEnabled(true);
            }
        });
        this.reloadSettingsButton = new Button(composite_1, 0);
        this.reloadSettingsButton.setText("Reload Settings");
        this.reloadSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.doLoadTemplateConf(setButton, false);
            }
        });
        Label label = new Label(composite_1, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        new Label(composite_1, 0);
        Label activeLabel = new Label(composite_1, 0);
        activeLabel.setText("Active");
        new Label(composite_1, 0);
        Label inactiveLabel = new Label(composite_1, 0);
        inactiveLabel.setText("Inactive");
        Label priorityLabel = new Label(composite_1, 0);
        priorityLabel.setText("Priority");
        this.priority_active = new Combo(composite_1, 8);
        this.priority_active.setItems(this.settings.getValues("profile", "priority_active"));
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        gridData.minimumWidth = 150;
        this.priority_active.setLayoutData((Object)gridData);
        new Label(composite_1, 0);
        this.priority_inactive = new Combo(composite_1, 8);
        this.priority_inactive.setItems(this.settings.getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label waitOnErrorLabel = new Label(composite_1, 0);
        waitOnErrorLabel.setText("Wait On Error");
        this.waitonerror = new Button(composite_1, 32);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        Label exitAfterwardsLabel = new Label(composite_1, 0);
        exitAfterwardsLabel.setText("Exit afterwards");
        this.exit = new Button(composite_1, 32);
        new Label(composite_1, 0);
        new Label(composite_1, 0);
        Label languageFileLabel = new Label(composite_1, 0);
        languageFileLabel.setLayoutData((Object)new GridData());
        languageFileLabel.setText("Language File");
        this.language = new Text(composite_1, 2048);
        this.language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText("Display");
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_5);
        displayTabItem.setControl((Control)composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText("Output");
        this.output = new Combo(composite_2, 8);
        this.output.setItems(this.settings.getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText("Frameskip");
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(this.settings.getValues("profile", "frameskip"));
        this.frameskip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText("Scaler");
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(this.settings.getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label pixelshaderLabel = new Label(composite_2, 0);
        pixelshaderLabel.setLayoutData((Object)new GridData());
        pixelshaderLabel.setText("Pixelshader");
        this.pixelshader = new Combo(composite_2, 8);
        this.pixelshader.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(15);
        this.pixelshader.setItems(this.settings.getValues("profile", "pixelshader"));
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText("Fullscreen");
        this.fullscreen = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBufferingLabel = new Label(composite_2, 0);
        doubleBufferingLabel.setText("Double Buffering");
        this.fulldouble = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText("Fullscreen Resolution");
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(this.settings.getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        Label windowResolutionLabel = new Label(composite_2, 0);
        windowResolutionLabel.setText("Window Resolution");
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(this.settings.getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        Label aspectCorrectionLabel = new Label(composite_2, 0);
        aspectCorrectionLabel.setText("Aspect Correction");
        this.aspect = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText("Machine");
        Composite composite_3 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout((Layout)gridLayout_2);
        machineTabItem.setControl((Control)composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText("CPU");
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout((Layout)gridLayout_3);
        Label overscanLabel = new Label(composite_2, 0);
        overscanLabel.setText("Overscan");
        this.overscan = new Text(composite_2, 2048);
        this.overscan.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label svgaChipsetLabel = new Label(composite_2, 0);
        svgaChipsetLabel.setText("SVGA Chipset");
        this.svgachipset = new Combo(composite_2, 8);
        this.svgachipset.setItems(this.settings.getValues("profile", "svgachipset"));
        this.svgachipset.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label videoRamLabel = new Label(composite_2, 0);
        videoRamLabel.setText("Video RAM in KB");
        this.videoram = new Combo(composite_2, 8);
        this.videoram.setItems(this.settings.getValues("profile", "videoram"));
        this.videoram.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label vsyncModeLabel = new Label(composite_2, 0);
        vsyncModeLabel.setText("Vsync Mode");
        this.vsyncmode = new Combo(composite_2, 8);
        this.vsyncmode.setItems(this.settings.getValues("profile", "vsyncmode"));
        this.vsyncmode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label vsyncRateLabel = new Label(composite_2, 0);
        vsyncRateLabel.setLayoutData((Object)new GridData());
        vsyncRateLabel.setText("Vsync Rate");
        this.vsyncrate = new Text(composite_2, 2048);
        this.vsyncrate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label glideLabel = new Label(composite_2, 0);
        glideLabel.setText("Glide");
        this.glide = new Button(composite_2, 32);
        this.glide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.glideport.setEnabled(EditTemplateDialog.this.glide.getSelection());
            }
        });
        Label glidePortLabel = new Label(composite_2, 0);
        glidePortLabel.setText("Glide port");
        this.glideport = new Text(composite_2, 2048);
        this.glideport.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label machineLabel = new Label((Composite)cpuGroup, 0);
        machineLabel.setText("Machine");
        this.machine = new Combo((Composite)cpuGroup, 8);
        this.machine.setItems(this.settings.getValues("profile", "machine"));
        this.machine.setLayoutData((Object)new GridData());
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label coreLabel = new Label((Composite)cpuGroup, 0);
        coreLabel.setText("Core");
        this.core = new Combo((Composite)cpuGroup, 8);
        this.core.setItems(this.settings.getValues("profile", "core"));
        this.core.setLayoutData((Object)new GridData());
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label cyclesLabel = new Label((Composite)cpuGroup, 0);
        cyclesLabel.setText("Cycles");
        this.cycles = new Combo((Composite)cpuGroup, 0);
        this.cycles.setItems(this.settings.getValues("profile", "cycles"));
        this.cycles.setLayoutData((Object)new GridData());
        this.cycles.setVisibleItemCount(15);
        Label upLabel = new Label((Composite)cpuGroup, 0);
        upLabel.setLayoutData((Object)new GridData());
        upLabel.setText("Up");
        this.cycles_up = new Combo((Composite)cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData((Object)new GridData());
        Label downLabel = new Label((Composite)cpuGroup, 0);
        downLabel.setLayoutData((Object)new GridData());
        downLabel.setText("Down");
        this.cycles_down = new Combo((Composite)cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData((Object)new GridData());
        Label timesynchedLabel = new Label((Composite)cpuGroup, 0);
        timesynchedLabel.setText("Timesynched");
        this.timesynched = new Button((Composite)cpuGroup, 32);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Group memoryGroup = new Group(composite_3, 0);
        memoryGroup.setText("Memory");
        memoryGroup.setLayoutData((Object)new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 2;
        memoryGroup.setLayout((Layout)gridLayout_4);
        Label sizeLabel = new Label((Composite)memoryGroup, 0);
        sizeLabel.setText("Size");
        this.memsize = new Combo((Composite)memoryGroup, 8);
        this.memsize.setItems(this.settings.getValues("profile", "memsize"));
        this.memsize.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label xmsLabel = new Label((Composite)memoryGroup, 0);
        xmsLabel.setText("XMS");
        this.xms = new Button((Composite)memoryGroup, 32);
        Label emsLabel = new Label((Composite)memoryGroup, 0);
        emsLabel.setText("EMS");
        this.ems = new Button((Composite)memoryGroup, 32);
        Label umbLabel = new Label((Composite)memoryGroup, 0);
        umbLabel.setText("UMB");
        this.umb = new Combo((Composite)memoryGroup, 8);
        this.umb.setItems(this.settings.getValues("profile", "umb"));
        this.umb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText("Audio");
        Composite composite_4 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_9);
        audioTabItem.setControl((Control)composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout((Layout)gridLayout_6);
        generalGroup.setText("General");
        Label silentModeLabel = new Label((Composite)generalGroup, 0);
        silentModeLabel.setText("Silent Mode");
        this.nosound = new Button((Composite)generalGroup, 32);
        Label sampleRateLabel = new Label((Composite)generalGroup, 0);
        sampleRateLabel.setText("Sample Rate");
        this.rate = new Combo((Composite)generalGroup, 8);
        this.rate.setItems(this.settings.getValues("profile", "rate"));
        this.rate.setLayoutData((Object)new GridData());
        Label blockSizeLabel = new Label((Composite)generalGroup, 0);
        blockSizeLabel.setText("Block Size");
        this.blocksize = new Combo((Composite)generalGroup, 8);
        this.blocksize.setItems(this.settings.getValues("profile", "blocksize"));
        this.blocksize.setLayoutData((Object)new GridData());
        Label prebufferLabel = new Label((Composite)generalGroup, 0);
        prebufferLabel.setText("Prebuffer");
        this.prebuffer = new Combo((Composite)generalGroup, 0);
        this.prebuffer.setItems(this.settings.getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData((Object)new GridData());
        Label mpu401Label = new Label((Composite)generalGroup, 0);
        mpu401Label.setText("MPU-401");
        this.mpu401 = new Combo((Composite)generalGroup, 8);
        this.mpu401.setItems(this.settings.getValues("profile", "mpu401"));
        this.mpu401.setLayoutData((Object)new GridData());
        Label midiDeviceLabel = new Label((Composite)generalGroup, 0);
        midiDeviceLabel.setText("Midi Device");
        this.device = new Combo((Composite)generalGroup, 8);
        this.device.setItems(this.settings.getValues("profile", "device"));
        this.device.setLayoutData((Object)new GridData());
        Label configLabel = new Label((Composite)generalGroup, 0);
        configLabel.setText("Config");
        this.midi_config = new Text((Composite)generalGroup, 2048);
        this.midi_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label mt32RateLabel = new Label((Composite)generalGroup, 0);
        mt32RateLabel.setText("MT-32 Rate");
        this.mt32rate = new Combo((Composite)generalGroup, 8);
        this.mt32rate.setItems(this.settings.getValues("profile", "mt32rate"));
        this.mt32rate.setLayoutData((Object)new GridData());
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        soundblasterGroup.setText("Soundblaster");
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout((Layout)gridLayout_7);
        Label typeLabel = new Label((Composite)soundblasterGroup, 0);
        typeLabel.setText("Type");
        this.sbtype = new Combo((Composite)soundblasterGroup, 8);
        this.sbtype.setItems(this.settings.getValues("profile", "sbtype"));
        this.sbtype.setLayoutData((Object)new GridData());
        Label oplRateLabel = new Label((Composite)soundblasterGroup, 0);
        oplRateLabel.setText("OPL Rate");
        this.oplrate = new Combo((Composite)soundblasterGroup, 8);
        this.oplrate.setItems(this.settings.getValues("profile", "oplrate"));
        this.oplrate.setLayoutData((Object)new GridData());
        Label oplModeLabel = new Label((Composite)soundblasterGroup, 0);
        oplModeLabel.setLayoutData((Object)new GridData());
        oplModeLabel.setText("OPL Mode");
        this.oplmode = new Combo((Composite)soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getValues("profile", "oplmode"));
        this.oplmode.setLayoutData((Object)new GridData());
        Label addressLabel = new Label((Composite)soundblasterGroup, 0);
        addressLabel.setText("Address");
        this.sbbase = new Combo((Composite)soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getValues("profile", "sbbase"));
        this.sbbase.setLayoutData((Object)new GridData());
        Label irqLabel = new Label((Composite)soundblasterGroup, 0);
        irqLabel.setText("IRQ");
        this.irq = new Combo((Composite)soundblasterGroup, 8);
        this.irq.setItems(this.settings.getValues("profile", "irq"));
        this.irq.setLayoutData((Object)new GridData());
        Label dmaLabel = new Label((Composite)soundblasterGroup, 0);
        dmaLabel.setText("DMA");
        this.dma = new Combo((Composite)soundblasterGroup, 8);
        this.dma.setItems(this.settings.getValues("profile", "dma"));
        this.dma.setLayoutData((Object)new GridData());
        Label hdmaLabel = new Label((Composite)soundblasterGroup, 0);
        hdmaLabel.setLayoutData((Object)new GridData());
        hdmaLabel.setText("HDMA");
        this.hdma = new Combo((Composite)soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getValues("profile", "hdma"));
        this.hdma.setLayoutData((Object)new GridData());
        Label mixerLabel = new Label((Composite)soundblasterGroup, 0);
        mixerLabel.setText("Mixer");
        this.mixer = new Button((Composite)soundblasterGroup, 32);
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        gusGroup.setText("Gravis Ultrasound");
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout((Layout)gridLayout_8);
        Label enableLabel_1 = new Label((Composite)gusGroup, 0);
        enableLabel_1.setLayoutData((Object)new GridData());
        enableLabel_1.setText("Enable");
        this.gus = new Button((Composite)gusGroup, 32);
        this.gus.setLayoutData((Object)new GridData());
        Label sampleRateLabel_2 = new Label((Composite)gusGroup, 0);
        sampleRateLabel_2.setText("Sample Rate");
        this.gusrate = new Combo((Composite)gusGroup, 8);
        this.gusrate.setItems(this.settings.getValues("profile", "gusrate"));
        this.gusrate.setLayoutData((Object)new GridData());
        Label addressLabel_1 = new Label((Composite)gusGroup, 0);
        addressLabel_1.setText("Address");
        this.gusbase = new Combo((Composite)gusGroup, 8);
        this.gusbase.setItems(this.settings.getValues("profile", "gusbase"));
        this.gusbase.setLayoutData((Object)new GridData());
        Label irqLabel_1 = new Label((Composite)gusGroup, 0);
        irqLabel_1.setText("IRQ1");
        this.irq1 = new Combo((Composite)gusGroup, 8);
        this.irq1.setItems(this.settings.getValues("profile", "irq1"));
        this.irq1.setLayoutData((Object)new GridData());
        Label irq2Label = new Label((Composite)gusGroup, 0);
        irq2Label.setText("IRQ2");
        this.irq2 = new Combo((Composite)gusGroup, 8);
        this.irq2.setItems(this.settings.getValues("profile", "irq2"));
        this.irq2.setLayoutData((Object)new GridData());
        Label dmaLabel_1 = new Label((Composite)gusGroup, 0);
        dmaLabel_1.setText("DMA1");
        this.dma1 = new Combo((Composite)gusGroup, 8);
        this.dma1.setItems(this.settings.getValues("profile", "dma1"));
        this.dma1.setLayoutData((Object)new GridData());
        Label hdmaLabel_1 = new Label((Composite)gusGroup, 0);
        hdmaLabel_1.setLayoutData((Object)new GridData());
        hdmaLabel_1.setText("DMA2");
        this.dma2 = new Combo((Composite)gusGroup, 8);
        this.dma2.setItems(this.settings.getValues("profile", "dma2"));
        this.dma2.setLayoutData((Object)new GridData());
        Label ultradirLabel = new Label((Composite)gusGroup, 0);
        ultradirLabel.setText("Ultradir");
        this.ultradir = new Text((Composite)gusGroup, 2048);
        this.ultradir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        speakerGroup.setText("PC Speaker");
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout((Layout)gridLayout_10);
        Label enableLabel = new Label((Composite)speakerGroup, 0);
        enableLabel.setText("Enable");
        this.pcspeaker = new Button((Composite)speakerGroup, 32);
        Label sampleRateLabel_1 = new Label((Composite)speakerGroup, 0);
        sampleRateLabel_1.setText("Sample Rate");
        this.pcrate = new Combo((Composite)speakerGroup, 8);
        this.pcrate.setItems(this.settings.getValues("profile", "pcrate"));
        this.pcrate.setLayoutData((Object)new GridData());
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        tandyGroup.setText("Tandy");
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout((Layout)gridLayout_11);
        Label enableLabel_2 = new Label((Composite)tandyGroup, 0);
        enableLabel_2.setText("Enable");
        this.tandy = new Combo((Composite)tandyGroup, 8);
        this.tandy.setItems(this.settings.getValues("profile", "tandy"));
        this.tandy.setLayoutData((Object)new GridData());
        Label sampleRateLabel_1_1 = new Label((Composite)tandyGroup, 0);
        sampleRateLabel_1_1.setText("Sample Rate");
        this.tandyrate = new Combo((Composite)tandyGroup, 8);
        this.tandyrate.setItems(this.settings.getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData((Object)new GridData());
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        disneyGroup.setText("Disney Sound Source");
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout((Layout)gridLayout_12);
        Label enableLabel_3 = new Label((Composite)disneyGroup, 0);
        enableLabel_3.setText("Enable");
        this.disney = new Button((Composite)disneyGroup, 32);
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText("I/O");
        Composite composite_5 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout((Layout)gridLayout_17);
        inputTabItem.setControl((Control)composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mouseGroup.setText("Mouse");
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout((Layout)gridLayout_13);
        Label autolockLabel = new Label((Composite)mouseGroup, 0);
        autolockLabel.setText("Autolock");
        this.autolock = new Button((Composite)mouseGroup, 32);
        Label sensitivityLabel = new Label((Composite)mouseGroup, 0);
        sensitivityLabel.setText("Sensitivity");
        this.sensitivity = new Combo((Composite)mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        keyboardGroup.setText("Keyboard");
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout((Layout)gridLayout_14);
        Label useScancodesLabel = new Label((Composite)keyboardGroup, 0);
        useScancodesLabel.setText("Use Scancodes");
        this.usescancodes = new Button((Composite)keyboardGroup, 32);
        Label mapperFileLabel = new Label((Composite)keyboardGroup, 0);
        mapperFileLabel.setText("Mapper File");
        this.mapperfile = new Text((Composite)keyboardGroup, 2048);
        this.mapperfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label layoutLabel = new Label((Composite)keyboardGroup, 0);
        layoutLabel.setText("Layout");
        this.keyboard_layout = new Text((Composite)keyboardGroup, 2048);
        this.keyboard_layout.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        joystickGroup.setText("Joystick");
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout((Layout)gridLayout_15);
        Label typeLabel_1 = new Label((Composite)joystickGroup, 0);
        typeLabel_1.setText("Type");
        this.joysticktype = new Combo((Composite)joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label timedEmulationLabel = new Label((Composite)joystickGroup, 0);
        timedEmulationLabel.setText("Timed emulation");
        this.timed = new Button((Composite)joystickGroup, 32);
        Label autofireLabel = new Label((Composite)joystickGroup, 0);
        autofireLabel.setText("Autofire");
        this.autofire = new Button((Composite)joystickGroup, 32);
        Label swapAxes3Label = new Label((Composite)joystickGroup, 0);
        swapAxes3Label.setText("Swap axes 3&&4");
        this.swap34 = new Button((Composite)joystickGroup, 32);
        Label buttonWrappingLabel = new Label((Composite)joystickGroup, 0);
        buttonWrappingLabel.setText("Button wrapping");
        this.buttonwrap = new Button((Composite)joystickGroup, 32);
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText("Modem");
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout((Layout)gridLayout_16);
        Label serial1Label = new Label((Composite)modemGroup, 0);
        serial1Label.setText("Serial 1");
        this.serial1 = new Text((Composite)modemGroup, 2048);
        this.serial1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial2Label = new Label((Composite)modemGroup, 0);
        serial2Label.setText("Serial 2");
        this.serial2 = new Text((Composite)modemGroup, 2048);
        this.serial2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial3Label = new Label((Composite)modemGroup, 0);
        serial3Label.setText("Serial 3");
        this.serial3 = new Text((Composite)modemGroup, 2048);
        this.serial3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial4Label = new Label((Composite)modemGroup, 0);
        serial4Label.setText("Serial 4");
        this.serial4 = new Text((Composite)modemGroup, 2048);
        this.serial4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        networkGroup.setText("Network");
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout((Layout)gridLayout_20);
        Label ipxLabel = new Label((Composite)networkGroup, 0);
        ipxLabel.setText("Enable IPX");
        this.ipx = new Button((Composite)networkGroup, 32);
        new Label(composite_5, 0);
        TabItem mountingTabItem = new TabItem(tabFolder, 0);
        mountingTabItem.setText("Mounting");
        Composite composite_6 = new Composite((Composite)tabFolder, 0);
        composite_6.setLayout((Layout)new GridLayout());
        mountingTabItem.setControl((Control)composite_6);
        Group mountGroup = new Group(composite_6, 0);
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mountGroup.setText("Mounting Overview");
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout((Layout)gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)mountGroup, 2560);
        GridData gridData_2 = new GridData(4, 4, true, false, 1, 3);
        this.mountingpoints.setLayoutData((Object)gridData_2);
        Button addButton = new Button((Composite)mountGroup, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mount;
                EditMountDialog addMountDialog = new EditMountDialog(EditTemplateDialog.this.shell);
                List<Character> freeDriveletters = Mount.getFreeDriveletters(EditTemplateDialog.this.booterButton.getSelection(), EditTemplateDialog.this.mountingpoints.getItems());
                if (freeDriveletters.size() > 0) {
                    addMountDialog.setDefaultDriveletter(freeDriveletters.get(0).charValue());
                }
                if ((mount = (String)addMountDialog.open()) != null) {
                    EditTemplateDialog.this.mountingpoints.add(mount);
                    EditTemplateDialog.this.mountingpoints.select(EditTemplateDialog.this.mountingpoints.getItemCount() - 1);
                }
            }
        });
        addButton.setText("Add");
        Button editButton = new Button((Composite)mountGroup, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText("Edit");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() != -1) {
                    EditMountDialog editMountDialog = new EditMountDialog(EditTemplateDialog.this.shell);
                    editMountDialog.setMount(EditTemplateDialog.this.mountingpoints.getItem(EditTemplateDialog.this.mountingpoints.getSelectionIndex()));
                    String mount = (String)editMountDialog.open();
                    if (mount != null) {
                        EditTemplateDialog.this.mountingpoints.setItem(EditTemplateDialog.this.mountingpoints.getSelectionIndex(), mount);
                    }
                }
            }
        });
        Button removeButton = new Button((Composite)mountGroup, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() != -1) {
                    EditTemplateDialog.this.mountingpoints.remove(EditTemplateDialog.this.mountingpoints.getSelectionIndex());
                } else if (EditTemplateDialog.this.mountingpoints.getItemCount() == 1) {
                    EditTemplateDialog.this.mountingpoints.removeAll();
                }
            }
        });
        Group executeGroup = new Group(composite_6, 0);
        executeGroup.setLayoutData((Object)new GridData());
        executeGroup.setText("Execute");
        GridLayout gridLayout_18 = new GridLayout();
        executeGroup.setLayout((Layout)gridLayout_18);
        this.dosButton = new Button((Composite)executeGroup, 16);
        this.dosButton.setText("Dos");
        Label label_1 = new Label((Composite)executeGroup, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.booterButton = new Button((Composite)executeGroup, 16);
        this.booterButton.setText("Booter");
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new RowLayout());
        composite_7.setLayoutData((Object)"South");
        Label capturesLabel = new Label(composite_1, 0);
        capturesLabel.setLayoutData((Object)new GridData());
        capturesLabel.setText("Captures");
        this.captures = new Text(composite_1, 2048);
        this.captures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.captures.setEditable(false);
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText("Default");
        final Button defaultButton = new Button(composite, 32);
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData((Object)rowData);
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                int dbversionId = ((DosboxVersion)EditTemplateDialog.this.dbversionsList.get(EditTemplateDialog.this.dbversion.getSelectionIndex())).getId();
                try {
                    DosboxVersion selectedDBVersion = (DosboxVersion)EditTemplateDialog.this.dbversionsList.get(EditTemplateDialog.this.dbversion.getSelectionIndex());
                    Configuration dosboxConf = EditProfileDialog.loadDBVersionConfig(selectedDBVersion, false, EditTemplateDialog.this.shell);
                    if (dosboxConf == null) {
                        if (!GeneralPurposeDialogs.confirmMessage(EditTemplateDialog.this.shell, "There was a problem loading the associated DOSBox configuration file.\nStoring this template may result in a broken template configuration file.\n\nSave the template anyway (not recommended)?")) {
                            return;
                        }
                        dosboxConf = new Configuration();
                    }
                    int templateId = EditTemplateDialog.this.db.addOrEditTemplate(EditTemplateDialog.this.title.getText(), dbversionId, defaultButton.getSelection(), EditTemplateDialog.this.result != null ? ((Template)EditTemplateDialog.this.result).getId() : -1);
                    EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), dbversionId, defaultButton.getSelection());
                    EditTemplateDialog.this.getConfigurationBySettings(dosboxConf, EditTemplateDialog.this.templateConf);
                    EditTemplateDialog.this.templateConf.substract(dosboxConf);
                    EditProfileDialog.saveConfig(EditTemplateDialog.this.templateConf, FileUtils.constructTemplateFileLocation(templateId), EditTemplateDialog.this.shell);
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, e1.getMessage());
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData((Object)rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.result = null;
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        if (this.result != null) {
            this.title.setText(((Template)this.result).getTitle());
            defaultButton.setSelection(((Template)this.result).isDefault());
            int dbversionIndex = ListUtils.findTIDosboxVersion(this.dbversionsList, ((Template)this.result).getdbversionId());
            this.dbversion.select(dbversionIndex);
            this.templateConf = EditProfileDialog.loadTemplateConfig(this.dbversionsList.get(dbversionIndex), (Template)this.result, true, this.shell);
            this.selectSettingsByConfiguration(this.templateConf);
        } else {
            int dbversionIndex = ListUtils.findTIDefaultDosboxVersion(this.dbversionsList);
            this.dbversion.select(dbversionIndex);
            this.templateConf = EditProfileDialog.loadDBVersionConfig(this.dbversionsList.get(dbversionIndex), true, this.shell);
            this.selectSettingsByConfiguration(this.templateConf);
            this.exit.setSelection(true);
            this.title.setFocus();
        }
    }

    private String getAutoexecSectionBySettings() {
        return new Autoexec(this.mountingpoints.getItems(), false, "", "", "", "", "", this.booterButton.getSelection() ? "file" : "", "", this.exit.getSelection()).toString(false);
    }

    private void selectSettingsByAutoexec(Configuration templateConf) {
        Autoexec autoexec = new Autoexec(templateConf.getValue("autoexec", "autoexec"));
        this.exit.setSelection(autoexec.isExit());
        if (this.mountingpoints.getItemCount() == 0) {
            this.mountingpoints.setItems(autoexec.getMountingpoints());
            this.mountingpoints.setSelection(0);
        }
        this.dosButton.setSelection(!autoexec.isBooter());
        this.booterButton.setSelection(autoexec.isBooter());
    }

    private void selectSettingsByConfiguration(Configuration profileConf) {
        String priority = profileConf.getValue("sdl", "priority");
        String[] priorities = priority.split(",");
        if (priorities != null && priorities.length >= 2) {
            this.priority_active.setText(priorities[0]);
            this.priority_inactive.setText(priorities[1]);
        }
        this.waitonerror.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "waitonerror")).booleanValue());
        this.language.setText(profileConf.getValue("dosbox", "language"));
        this.captures.setText(profileConf.getValue("dosbox", "captures"));
        this.output.setText(profileConf.getValue("sdl", "output"));
        this.frameskip.setText(profileConf.getValue("render", "frameskip"));
        this.scaler.setText(profileConf.getValue("render", "scaler"));
        this.pixelshader.setText(profileConf.getValue("sdl", "pixelshader"));
        this.pixelshader.setEnabled(profileConf.hasValue("sdl", "pixelshader"));
        this.fullscreen.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "fullscreen")).booleanValue());
        this.fulldouble.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "fulldouble")).booleanValue());
        this.fullresolution.setText(profileConf.getValue("sdl", "fullresolution"));
        this.windowresolution.setText(profileConf.getValue("sdl", "windowresolution"));
        this.aspect.setSelection(Boolean.valueOf(profileConf.getValue("render", "aspect")).booleanValue());
        this.overscan.setText(profileConf.getValue("sdl", "overscan"));
        this.overscan.setEnabled(profileConf.hasValue("sdl", "overscan"));
        this.svgachipset.setText(profileConf.getValue("vga", "svgachipset"));
        this.svgachipset.setEnabled(profileConf.hasValue("vga", "svgachipset"));
        this.videoram.setText(profileConf.getValue("vga", "videoram"));
        this.videoram.setEnabled(profileConf.hasValue("vga", "videoram"));
        this.vsyncmode.setText(profileConf.getValue("vsync", "vsyncmode"));
        this.vsyncmode.setEnabled(profileConf.hasValue("vsync", "vsyncmode"));
        this.vsyncrate.setText(profileConf.getValue("vsync", "vsyncrate"));
        this.vsyncrate.setEnabled(profileConf.hasValue("vsync", "vsyncrate"));
        this.glide.setSelection(Boolean.valueOf(profileConf.getValue("glide", "glide")).booleanValue());
        this.glide.setEnabled(profileConf.hasValue("glide", "glide"));
        this.glideport.setText(profileConf.getValue("glide", "port"));
        this.glideport.setEnabled(profileConf.hasValue("glide", "port") && this.glide.getSelection());
        this.machine.setText(profileConf.getValue("dosbox", "machine"));
        this.core.setText(profileConf.getValue("cpu", "core"));
        this.cycles.setText(profileConf.getValue("cpu", "cycles"));
        this.cycles_up.setText(profileConf.getValue("cpu", "cycleup"));
        this.cycles_down.setText(profileConf.getValue("cpu", "cycledown"));
        this.timesynched.setSelection(Boolean.valueOf(profileConf.getValue("cpu", "timesynched")).booleanValue());
        this.timesynched.setEnabled(profileConf.hasValue("cpu", "timesynched"));
        this.memsize.setText(profileConf.getValue("dosbox", "memsize"));
        this.xms.setSelection(Boolean.valueOf(profileConf.getValue("dos", "xms")).booleanValue());
        this.ems.setSelection(Boolean.valueOf(profileConf.getValue("dos", "ems")).booleanValue());
        this.umb.setText(profileConf.getValue("dos", "umb"));
        this.nosound.setSelection(Boolean.valueOf(profileConf.getValue("mixer", "nosound")).booleanValue());
        this.rate.setText(profileConf.getValue("mixer", "rate"));
        this.mt32rate.setText(profileConf.getValue("midi", "mt32rate"));
        this.mt32rate.setEnabled(profileConf.hasValue("midi", "mt32rate"));
        this.blocksize.setText(profileConf.getValue("mixer", "blocksize"));
        this.prebuffer.setText(profileConf.getValue("mixer", "prebuffer"));
        this.mpu401.setText(profileConf.getValue("midi", "mpu401"));
        this.device.setText(profileConf.getValue("midi", "device"));
        this.midi_config.setText(profileConf.getValue("midi", "config"));
        this.sbtype.setText(profileConf.getValue("sblaster", "sbtype"));
        this.oplmode.setText(profileConf.getValue("sblaster", "oplmode"));
        this.oplrate.setText(profileConf.getValue("sblaster", "oplrate"));
        this.sbbase.setText(profileConf.getValue("sblaster", "sbbase"));
        this.irq.setText(profileConf.getValue("sblaster", "irq"));
        this.dma.setText(profileConf.getValue("sblaster", "dma"));
        this.hdma.setText(profileConf.getValue("sblaster", "hdma"));
        this.mixer.setSelection(Boolean.valueOf(profileConf.getValue("sblaster", "mixer")).booleanValue());
        this.gus.setSelection(Boolean.valueOf(profileConf.getValue("gus", "gus")).booleanValue());
        this.gusrate.setText(profileConf.getValue("gus", "gusrate"));
        this.gusbase.setText(profileConf.getValue("gus", "gusbase"));
        this.irq1.setText(profileConf.getValue("gus", "irq1"));
        this.irq2.setText(profileConf.getValue("gus", "irq2"));
        this.dma1.setText(profileConf.getValue("gus", "dma1"));
        this.dma2.setText(profileConf.getValue("gus", "dma2"));
        this.ultradir.setText(profileConf.getValue("gus", "ultradir"));
        this.pcspeaker.setSelection(Boolean.valueOf(profileConf.getValue("speaker", "pcspeaker")).booleanValue());
        this.pcrate.setText(profileConf.getValue("speaker", "pcrate"));
        this.tandy.setText(profileConf.getValue("speaker", "tandy"));
        this.tandyrate.setText(profileConf.getValue("speaker", "tandyrate"));
        this.disney.setSelection(Boolean.valueOf(profileConf.getValue("speaker", "disney")).booleanValue());
        this.autolock.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "autolock")).booleanValue());
        this.sensitivity.setText(profileConf.getValue("sdl", "sensitivity"));
        this.usescancodes.setSelection(Boolean.valueOf(profileConf.getValue("sdl", "usescancodes")).booleanValue());
        this.mapperfile.setText(profileConf.getValue("sdl", "mapperfile"));
        this.keyboard_layout.setText(profileConf.getValue("dos", "keyboardlayout"));
        this.keyboard_layout.setEnabled(profileConf.hasValue("dos", "keyboardlayout"));
        boolean usingNewJoystickSection = profileConf.hasValue("joystick", "joysticktype");
        if (!usingNewJoystickSection) {
            this.joysticktype.setText(profileConf.getValue("bios", "joysticktype"));
        } else {
            this.joysticktype.setText(profileConf.getValue("joystick", "joysticktype"));
            this.timed.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "timed")).booleanValue());
            this.autofire.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "autofire")).booleanValue());
            this.swap34.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "swap34")).booleanValue());
            this.buttonwrap.setSelection(Boolean.valueOf(profileConf.getValue("joystick", "buttonwrap")).booleanValue());
        }
        this.timed.setEnabled(usingNewJoystickSection);
        this.autofire.setEnabled(usingNewJoystickSection);
        this.swap34.setEnabled(usingNewJoystickSection);
        this.buttonwrap.setEnabled(usingNewJoystickSection);
        this.serial1.setText(profileConf.getValue("serial", "serial1"));
        this.serial2.setText(profileConf.getValue("serial", "serial2"));
        this.serial3.setText(profileConf.getValue("serial", "serial3"));
        this.serial4.setText(profileConf.getValue("serial", "serial4"));
        this.ipx.setSelection(Boolean.valueOf(profileConf.getValue("ipx", "ipx")).booleanValue());
        this.selectSettingsByAutoexec(profileConf);
    }

    private void getConfigurationBySettings(Configuration dbversionConf, Configuration profileConf) {
        boolean usingNewJoystickSection;
        profileConf.setValue("sdl", "priority", String.valueOf(this.priority_active.getText()) + "," + this.priority_inactive.getText());
        profileConf.setValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()));
        profileConf.setValue("dosbox", "language", this.language.getText());
        profileConf.setValue("dosbox", "captures", this.captures.getText());
        profileConf.setValue("sdl", "output", this.output.getText());
        profileConf.setValue("render", "frameskip", this.frameskip.getText());
        profileConf.setValue("render", "scaler", this.scaler.getText());
        profileConf.updateValue("sdl", "pixelshader", this.pixelshader.getText());
        profileConf.setValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()));
        profileConf.setValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()));
        profileConf.setValue("sdl", "fullresolution", this.fullresolution.getText());
        profileConf.setValue("sdl", "windowresolution", this.windowresolution.getText());
        profileConf.setValue("render", "aspect", String.valueOf(this.aspect.getSelection()));
        profileConf.updateValue("sdl", "overscan", this.overscan.getText());
        profileConf.updateValue("vga", "svgachipset", this.svgachipset.getText());
        profileConf.updateValue("vga", "videoram", this.videoram.getText());
        profileConf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText());
        profileConf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText());
        profileConf.updateValue("glide", "glide", String.valueOf(this.glide.getSelection()));
        profileConf.updateValue("glide", "port", this.glideport.getText());
        profileConf.setValue("dosbox", "machine", this.machine.getText());
        profileConf.setValue("cpu", "core", this.core.getText());
        profileConf.setValue("cpu", "cycles", this.cycles.getText());
        profileConf.setValue("cpu", "cycleup", this.cycles_up.getText());
        profileConf.setValue("cpu", "cycledown", this.cycles_down.getText());
        profileConf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()));
        profileConf.setValue("dosbox", "memsize", this.memsize.getText());
        profileConf.setValue("dos", "xms", String.valueOf(this.xms.getSelection()));
        profileConf.setValue("dos", "ems", String.valueOf(this.ems.getSelection()));
        profileConf.setValue("dos", "umb", this.umb.getText());
        profileConf.setValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()));
        profileConf.setValue("mixer", "rate", this.rate.getText());
        profileConf.updateValue("midi", "mt32rate", this.mt32rate.getText());
        profileConf.setValue("mixer", "blocksize", this.blocksize.getText());
        profileConf.setValue("mixer", "prebuffer", this.prebuffer.getText());
        profileConf.setValue("midi", "mpu401", this.mpu401.getText());
        profileConf.setValue("midi", "device", this.device.getText());
        profileConf.setValue("midi", "config", this.midi_config.getText());
        profileConf.setValue("sblaster", "sbtype", this.sbtype.getText());
        profileConf.setValue("sblaster", "oplmode", this.oplmode.getText());
        profileConf.setValue("sblaster", "oplrate", this.oplrate.getText());
        profileConf.setValue("sblaster", "sbbase", this.sbbase.getText());
        profileConf.setValue("sblaster", "irq", this.irq.getText());
        profileConf.setValue("sblaster", "dma", this.dma.getText());
        profileConf.setValue("sblaster", "hdma", this.hdma.getText());
        profileConf.setValue("sblaster", "mixer", String.valueOf(this.mixer.getSelection()));
        profileConf.setValue("gus", "gus", String.valueOf(this.gus.getSelection()));
        profileConf.setValue("gus", "gusrate", this.gusrate.getText());
        profileConf.setValue("gus", "gusbase", this.gusbase.getText());
        profileConf.setValue("gus", "irq1", this.irq1.getText());
        profileConf.setValue("gus", "irq2", this.irq2.getText());
        profileConf.setValue("gus", "dma1", this.dma1.getText());
        profileConf.setValue("gus", "dma2", this.dma2.getText());
        profileConf.setValue("gus", "ultradir", this.ultradir.getText());
        profileConf.setValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()));
        profileConf.setValue("speaker", "pcrate", this.pcrate.getText());
        profileConf.setValue("speaker", "tandy", this.tandy.getText());
        profileConf.setValue("speaker", "tandyrate", this.tandyrate.getText());
        profileConf.setValue("speaker", "disney", String.valueOf(this.disney.getSelection()));
        profileConf.setValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()));
        profileConf.setValue("sdl", "sensitivity", this.sensitivity.getText());
        profileConf.setValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()));
        profileConf.setValue("sdl", "mapperfile", this.mapperfile.getText());
        profileConf.setValue("dos", "keyboardlayout", this.keyboard_layout.getText());
        if (!dbversionConf.hasValue("dos", "keyboardlayout") || dbversionConf.hasValue("dos", "keyboardlayout") && !this.keyboard_layout.getEnabled()) {
            profileConf.removeValue("dos", "keyboardlayout");
        }
        if (!(usingNewJoystickSection = dbversionConf.hasValue("joystick", "joysticktype"))) {
            profileConf.removeSection("joystick");
            profileConf.setValue("bios", "joysticktype", this.joysticktype.getText());
        } else {
            profileConf.removeSection("bios");
            profileConf.setValue("joystick", "joysticktype", this.joysticktype.getText());
            profileConf.setValue("joystick", "timed", String.valueOf(this.timed.getSelection()));
            profileConf.setValue("joystick", "autofire", String.valueOf(this.autofire.getSelection()));
            profileConf.setValue("joystick", "swap34", String.valueOf(this.swap34.getSelection()));
            profileConf.setValue("joystick", "buttonwrap", String.valueOf(this.buttonwrap.getSelection()));
        }
        profileConf.setValue("serial", "serial1", this.serial1.getText());
        profileConf.setValue("serial", "serial2", this.serial2.getText());
        profileConf.setValue("serial", "serial3", this.serial3.getText());
        profileConf.setValue("serial", "serial4", this.serial4.getText());
        profileConf.setValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()));
        profileConf.setValue("autoexec", "autoexec", this.getAutoexecSectionBySettings());
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a template title", (Control)this.title, this.infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void enableSettingsByConfiguration(Configuration profileConf, Configuration dbConf) {
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "sdl", "pixelshader", (Control)this.pixelshader, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "sdl", "overscan", (Control)this.overscan, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "vga", "svgachipset", (Control)this.svgachipset, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "vga", "videoram", (Control)this.videoram, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "vsync", "vsyncmode", (Control)this.vsyncmode, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "vsync", "vsyncrate", (Control)this.vsyncrate, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "glide", "glide", (Control)this.glide, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "glide", "port", (Control)this.glideport, this.glide.getSelection());
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "cpu", "timesynched", (Control)this.timesynched, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "midi", "mt32rate", (Control)this.mt32rate, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "joystick", "timed", (Control)this.timed, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "joystick", "autofire", (Control)this.autofire, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "joystick", "swap34", (Control)this.swap34, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "joystick", "buttonwrap", (Control)this.buttonwrap, true);
        EditProfileDialog.enableDisableControl(profileConf, dbConf, "dos", "keyboardlayout", (Control)this.keyboard_layout, true);
    }

    private void doLoadTemplateConf(Button setButton, boolean keepValues) {
        Configuration dbConf = EditProfileDialog.loadDBVersionConfig(this.dbversionsList.get(this.dbversion.getSelectionIndex()), false, this.shell);
        if (dbConf != null) {
            if (keepValues) {
                this.enableSettingsByConfiguration(this.templateConf, dbConf);
            }
            this.templateConf = new Configuration(dbConf);
            if (keepValues) {
                this.getConfigurationBySettings(dbConf, this.templateConf);
            } else {
                this.selectSettingsByConfiguration(this.templateConf);
                this.exit.setSelection(true);
            }
            setButton.setEnabled(false);
        } else {
            GeneralPurposeDialogs.infoMessage(this.shell, "Could not load settings, so nothing was changed.");
        }
    }
}

