/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import java.util.Enumeration;
import java.util.Vector;

public class OrderingVector {
    private static final int MAX_ORDERING_COLUMNS = 8;
    private static final String[] GAME_LIST_ORDER = new String[]{"GAM.TITLE", "GAM.SETUP", "DEV.NAME", "PUBL.NAME", "GEN.NAME", "YR.YEAR", "STAT.STAT", "GAM.FAVORITE", "GAM.ID", "GAM.DBVERSION_ID", "CUST1.VALUE", "CUST2.VALUE", "CUST3.VALUE", "CUST4.VALUE", "GAM.CUSTOM5", "GAM.CUSTOM6", "GAM.CUSTOM7", "GAM.CUSTOM8", "GAM.CUSTOM9", "GAM.CUSTOM10"};
    private Vector<OrderingElement> vector = new Vector();

    public OrderingVector() {
    }

    public OrderingVector(int[] columnArray, boolean[] ascendingArray) {
        this();
        int i = 0;
        while (i < columnArray.length) {
            this.vector.add(new OrderingElement(columnArray[i], ascendingArray[i]));
            ++i;
        }
    }

    public void addOrdering(int column, boolean ascending) {
        OrderingElement newOrdering = new OrderingElement(column, ascending);
        int existingIndex = this.vector.indexOf(newOrdering);
        if (existingIndex != -1) {
            this.vector.removeElementAt(existingIndex);
        }
        this.vector.insertElementAt(newOrdering, 0);
        if (this.vector.size() > 8) {
            this.vector.remove(8);
        }
    }

    public int[] getColumns() {
        int[] columnArray = new int[this.vector.size()];
        int i = 0;
        while (i < columnArray.length) {
            columnArray[i] = this.vector.get(i).column;
            ++i;
        }
        return columnArray;
    }

    public boolean[] getAscendings() {
        boolean[] ascendingArray = new boolean[this.vector.size()];
        int i = 0;
        while (i < ascendingArray.length) {
            ascendingArray[i] = this.vector.get(i).ascending;
            ++i;
        }
        return ascendingArray;
    }

    public String toClause() {
        StringBuffer orderingClause = new StringBuffer();
        Enumeration<OrderingElement> e = this.vector.elements();
        while (e.hasMoreElements()) {
            orderingClause.append(e.nextElement().toString());
            if (!e.hasMoreElements()) continue;
            orderingClause.append(",");
        }
        return orderingClause.toString();
    }

    public String toString() {
        return this.vector.toString();
    }

    private class OrderingElement {
        private int column;
        private boolean ascending;

        OrderingElement(int c, boolean a) {
            this.column = c;
            this.ascending = a;
        }

        public boolean equals(Object obj) {
            return this.column == ((OrderingElement)obj).column;
        }

        public String toString() {
            return String.valueOf(GAME_LIST_ORDER[this.column]) + (this.ascending ? " ASC" : " DESC");
        }
    }
}

