/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.gui.StreamGobbler;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Settings;
import com.util.ListUtils;
import com.util.PlatformUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUtils {
    public static final String DBFILE = "./db/database";
    public static final String[] DBFILES = new String[]{"db/database.script", "db/database.properties"};
    public static final String[] DEFDBFILES = new String[]{"db/initial.script", "db/initial.properties"};
    public static final String DFEND_PATH = "C:\\Program Files\\D-Fend\\";
    public static final String DFEND_PROFILES = "Profiles.dat";
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String CAPTURES_DIR = "captures" + File.separatorChar;
    public static final String PROFILES_DIR = "profiles" + File.separatorChar;
    public static final String CONF_EXT = ".conf";
    private static final String TEMPLATES_DIR = "templates" + File.separatorChar;
    private static final String SETUP_CONF = "setup.conf";
    private static String CWD;

    static {
        try {
            CWD = String.valueOf(new File(".").getCanonicalPath()) + File.separatorChar;
        }
        catch (IOException ex) {
            System.err.println("FATAL ERROR: Couldn't get current working directory\n");
            System.exit(1);
        }
    }

    private static String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    private static boolean isExistingFile(String filename) {
        File file = new File(filename);
        return file.isFile() && file.exists();
    }

    private static void copy(File source, File dest) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            catch (IOException e) {
                System.err.println("Couldn't copy file " + source + " to directory " + dest + "!!\n");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void executeCommand(List<String> execCommands, String cwd, boolean waitFor) throws IOException {
        StringBuffer cmd = new StringBuffer();
        try {
            if (Settings.getInstance().getBooleanValue("dosbox", "hideconsole")) {
                execCommands.add("-noconsole");
            }
            String[] rtCmds = new String[execCommands.size()];
            int i = 0;
            while (i < execCommands.size()) {
                rtCmds[i] = execCommands.get(i);
                cmd.append(String.valueOf(rtCmds[i]) + " ");
                ++i;
            }
            System.out.println(cmd);
            File dir = cwd != null ? new File(cwd) : null;
            Process proc = Runtime.getRuntime().exec(rtCmds, null, dir);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
            outputGobbler.start();
            errorGobbler.start();
            if (waitFor) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Dosbox could not be started with the following command:\n" + cmd);
        }
    }

    private static void doRunDosbox(DosboxVersion dbversion, List<String> parameters, boolean waitFor) throws IOException {
        ArrayList<String> commandItems = new ArrayList<String>();
        commandItems.add(dbversion.getExecutable());
        commandItems.addAll(parameters);
        if (dbversion.getParameters().length() > 0) {
            String[] stringArray = dbversion.getParameters().split(" ");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String p = stringArray[n];
                commandItems.add(p);
                ++n;
            }
        }
        FileUtils.executeCommand(commandItems, FileUtils.getCanonicalPath(dbversion.getPath()), waitFor);
    }

    public static void createDir(String dir) {
        if (!new File(dir).exists() && !new File(dir).mkdirs()) {
            System.err.println("Couldn't create " + dir + " directory!!\n");
        }
    }

    public static void copyFiles(String srcDir, String dstDir) {
        File[] srcFiles = new File(srcDir).listFiles();
        if (srcFiles != null) {
            File[] fileArray = srcFiles;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File src = fileArray[n];
                if (src.isFile()) {
                    FileUtils.copy(src, new File(String.valueOf(dstDir) + File.separatorChar + src.getName()));
                }
                ++n;
            }
        }
    }

    public static void removeFile(String filename) {
        File file = new File(filename);
        if (!file.isFile() || !file.delete()) {
            System.err.println("Couldn't delete file " + filename);
        }
    }

    public static void removeFilesInDirAndDir(String dirname) {
        File dir;
        File[] files = new File(dirname).listFiles();
        if (files != null) {
            File file;
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                file = fileArray[n];
                if (file.isDirectory()) {
                    System.err.println("Directory found inside " + dirname + ", aborting removal");
                    return;
                }
                ++n;
            }
            fileArray = files;
            n = 0;
            n2 = fileArray.length;
            while (n < n2) {
                file = fileArray[n];
                if (!file.delete()) {
                    System.err.println("Couldn't delete file " + file);
                }
                ++n;
            }
        }
        if (!(dir = new File(dirname)).isDirectory() || !dir.delete()) {
            System.err.println("Couldn't delete directory " + dirname);
        }
    }

    public static boolean isExistingReadableFile(String filename) {
        File file = new File(filename);
        return file.isFile() && file.canRead();
    }

    public static String constructCanonicalProfileConfig(String configPathAndFilename) {
        return FileUtils.getCanonicalPath(configPathAndFilename);
    }

    public static String constructCapturesDir(int profileId) {
        return String.valueOf(CAPTURES_DIR) + profileId;
    }

    public static String constructCanonicalCapturesDir(int profileId) {
        return String.valueOf(CWD) + CAPTURES_DIR + profileId;
    }

    public static String constructCanonicalDBConfLocation(String path) {
        return FileUtils.getCanonicalPath(String.valueOf(path) + DOSBOX_CONF);
    }

    public static String constructCanonicalDBExeLocation(String path) {
        return FileUtils.getCanonicalPath(String.valueOf(path) + PlatformUtils.DB_EXECUTABLE);
    }

    public static String constructTemplateFileLocation(int templateId) {
        return String.valueOf(TEMPLATES_DIR) + templateId + CONF_EXT;
    }

    public static void doRunDosbox(DosboxVersion dbversion) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-conf");
        parameters.add(DOSBOX_CONF);
        FileUtils.doRunDosbox(dbversion, parameters, false);
    }

    public static void doCreateDosboxConf(DosboxVersion dbversion) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-c");
        parameters.add("config -writeconf dosbox.conf");
        parameters.add("-c");
        parameters.add("exit");
        FileUtils.doRunDosbox(dbversion, parameters, true);
    }

    public static void doRunProfile(Profile prof, List<DosboxVersion> dbversionsList, boolean setup) throws IOException {
        int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, prof.getDbversionId());
        DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
        FileUtils.doRunProfile(prof, dbversion, setup);
    }

    public static void doRunProfile(Profile prof, DosboxVersion dbversion, boolean setup) throws IOException {
        ArrayList<String> confs = new ArrayList<String>();
        confs.add(dbversion.getExecutable());
        if (dbversion.isMultiConfig()) {
            confs.add("-conf");
            confs.add(DOSBOX_CONF);
        }
        String filename = prof.getCanonicalConfPathAndFile();
        if (setup && prof.hasSetupBoolean()) {
            Configuration conf = new Configuration(prof.getConfPathAndFile());
            Autoexec autoexec = new Autoexec(conf.getValue("autoexec", "autoexec"));
            autoexec.setSetup(prof.getSetup());
            autoexec.setSetupParameters(prof.getSetupParameters());
            conf.setValue("autoexec", "autoexec", autoexec.toString(true));
            conf.saveToFile(String.valueOf(PROFILES_DIR) + SETUP_CONF);
            filename = String.valueOf(CWD) + PROFILES_DIR + SETUP_CONF;
        }
        confs.add("-conf");
        confs.add(filename);
        if (dbversion.getParameters().length() > 0) {
            String[] stringArray = dbversion.getParameters().split(" ");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String p = stringArray[n];
                confs.add(p);
                ++n;
            }
        }
        FileUtils.executeCommand(confs, FileUtils.getCanonicalPath(dbversion.getPath()), false);
    }

    public static String constructUniqueConfigFile(int profileId, String profileTitle, String gameLocation) {
        Settings set = Settings.getInstance();
        String candidateFilename = "";
        int candidateNr = 1;
        boolean unique = false;
        while (!unique) {
            candidateFilename = PROFILES_DIR;
            if (set.getIntValue("profiledefaults", "confpath") == 1 && gameLocation != null) {
                candidateFilename = gameLocation;
            }
            if (set.getIntValue("profiledefaults", "conffile") == 1) {
                String candidateTitle = profileTitle;
                if (candidateNr > 1) {
                    candidateTitle = String.valueOf(candidateTitle) + "(" + candidateNr + ")";
                }
                candidateFilename = String.valueOf(candidateFilename) + candidateTitle.replaceAll("[^a-zA-Z_0-9()]", "") + CONF_EXT;
            } else {
                if (candidateNr > 1) {
                    return null;
                }
                candidateFilename = String.valueOf(candidateFilename) + profileId + CONF_EXT;
            }
            ++candidateNr;
            boolean bl = unique = !FileUtils.isExistingFile(candidateFilename);
        }
        return candidateFilename;
    }

    public static void renameDatabaseIfNecessary() {
        if (!FileUtils.isExistingFile(DBFILES[0]) && !FileUtils.isExistingFile(DBFILES[1]) && FileUtils.isExistingReadableFile(DEFDBFILES[0]) && FileUtils.isExistingReadableFile(DEFDBFILES[1])) {
            new File(DEFDBFILES[0]).renameTo(new File(DBFILES[0]));
            new File(DEFDBFILES[1]).renameTo(new File(DBFILES[1]));
        }
    }
}

