/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.util.FileUtils;
import com.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mount {
    private MountingType mountingType;
    private String mountAs;
    private char driveletter;
    private String label;
    private String path;
    private boolean ioctl;
    private String write;
    private String freesize;

    public Mount(MountingType mountingType, String mountAs, String driveletter, String path, String label, boolean ioctl, String write, String freesize) {
        this.mountingType = mountingType;
        this.mountAs = mountAs.toLowerCase();
        this.driveletter = Character.toUpperCase(driveletter.charAt(0));
        while (path.endsWith("\n")) {
            path = path.substring(0, path.length() - 1);
        }
        this.path = StringUtils.fixDir(path);
        this.label = label;
        this.ioctl = ioctl;
        this.write = StringUtils.fixDir(write);
        this.freesize = freesize;
    }

    private void init() {
        this.mountingType = MountingType.DIR;
        this.mountAs = "";
        this.driveletter = '\u0000';
        this.label = "";
        this.path = "";
        this.ioctl = false;
        this.write = "";
        this.freesize = "";
    }

    private void initForPhysFS(String physFSPath) {
        int colonIndex2;
        this.mountingType = MountingType.PHYSFS;
        int colonIndex1 = physFSPath.indexOf(":");
        if (colonIndex1 == 1) {
            colonIndex1 = physFSPath.indexOf(":", colonIndex1 + 1);
        }
        if (colonIndex1 != (colonIndex2 = physFSPath.lastIndexOf(":"))) {
            this.write = StringUtils.fixDir(physFSPath.substring(0, colonIndex1));
            this.path = physFSPath.substring(colonIndex1 + 1, colonIndex2);
        } else {
            this.path = physFSPath.substring(0, colonIndex2);
        }
    }

    public Mount(boolean floppy, String hostFileLocation, String[] existingMounts) {
        this.init();
        if (hostFileLocation.equals("")) {
            return;
        }
        List<Character> freeDriveletters = Mount.getFreeDriveletters(floppy, existingMounts);
        if (freeDriveletters.size() < 1) {
            return;
        }
        this.driveletter = freeDriveletters.get(0).charValue();
        if (FileUtils.containsPhysFS(hostFileLocation)) {
            this.initForPhysFS(hostFileLocation);
        } else {
            int lastSlashIndex = hostFileLocation.lastIndexOf(File.separatorChar);
            this.path = StringUtils.fixDir(hostFileLocation.substring(0, lastSlashIndex + 1));
        }
    }

    public Mount(String mount) {
        this.init();
        if (mount.equals("")) {
            return;
        }
        int spaceIndex = mount.indexOf(32);
        this.driveletter = Character.toUpperCase(mount.charAt(spaceIndex + 1));
        int firstQuoteIndex = mount.indexOf(34);
        int secondQuoteIndex = mount.lastIndexOf(34);
        if (firstQuoteIndex == -1 && secondQuoteIndex == -1 && (secondQuoteIndex = mount.indexOf(32, (firstQuoteIndex = mount.indexOf(32, spaceIndex + 1)) + 1)) == -1) {
            secondQuoteIndex = mount.length();
        }
        this.path = mount.substring(firstQuoteIndex + 1, secondQuoteIndex);
        if (mount.toLowerCase().startsWith("mount ")) {
            int freesizeIndex;
            int labelIndex;
            int typeIndex = mount.indexOf("-t ");
            if (typeIndex != -1) {
                int spaceIndex2 = mount.indexOf(" ", typeIndex + 3);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.mountAs = mount.substring(typeIndex + 3, spaceIndex2);
            }
            if ((labelIndex = mount.indexOf("-label ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", labelIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.label = mount.substring(labelIndex + 7, spaceIndex2);
            }
            if (mount.indexOf("-ioctl") != -1) {
                this.ioctl = true;
            }
            if ((freesizeIndex = mount.indexOf("-freesize ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", freesizeIndex + 10);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.freesize = mount.substring(freesizeIndex + 10, spaceIndex2);
            }
            if (FileUtils.isPhysFS(this.path)) {
                this.initForPhysFS(this.path);
            }
        } else if (mount.toLowerCase().startsWith("imgmount ")) {
            this.mountingType = MountingType.IMAGE;
            this.path = this.path.replaceAll("\" \"", "\n");
            this.mountAs = "iso";
        }
        if (this.mountingType == MountingType.DIR) {
            this.path = StringUtils.fixDir(this.path);
        }
    }

    public static List<Character> getFreeDriveletters(boolean floppy, String[] existingMounts) {
        int start;
        Mount[] mnts = new Mount[existingMounts.length];
        int i = 0;
        while (i < mnts.length) {
            mnts[i] = new Mount(existingMounts[i]);
            ++i;
        }
        ArrayList<Character> freeDriveletters = new ArrayList<Character>();
        int i2 = start = floppy ? 65 : 67;
        while (i2 < 90) {
            freeDriveletters.add(Character.valueOf((char)i2));
            i2 = (char)(i2 + '\u0001');
        }
        if (!floppy) {
            freeDriveletters.add(Character.valueOf('A'));
            freeDriveletters.add(Character.valueOf('B'));
        }
        i2 = 0;
        while (i2 < mnts.length) {
            freeDriveletters.remove(new Character(mnts[i2].getDriveletter()));
            ++i2;
        }
        return freeDriveletters;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        switch (this.mountingType) {
            case DIR: {
                result.append("mount " + this.driveletter + " \"" + this.path + File.separatorChar + "\"");
                if (!this.ioctl) break;
                result.append(" -ioctl");
                break;
            }
            case PHYSFS: {
                result.append("mount " + this.driveletter + " \"");
                if (!this.write.equals("")) {
                    result.append(String.valueOf(this.write) + "\\:");
                }
                result.append(String.valueOf(this.path) + ":\\\"");
                break;
            }
            case IMAGE: {
                result.append("imgmount " + this.driveletter + " \"" + this.path.replaceAll("\n", "\" \"") + "\"");
            }
        }
        if (!this.label.equals("")) {
            result.append(" -label " + this.label);
        }
        if (!this.mountAs.equals("")) {
            result.append(" -t " + this.mountAs);
        }
        if (!this.freesize.equals("")) {
            result.append(" -freesize " + this.freesize);
        }
        return result.toString();
    }

    public char getDriveletter() {
        return this.driveletter;
    }

    public String getDriveletterString() {
        return String.valueOf(this.driveletter);
    }

    public boolean isIoctl() {
        return this.ioctl;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    public String getHostPath() {
        return this.mountingType == MountingType.PHYSFS ? String.valueOf(this.path) + ':' : this.path;
    }

    public MountingType getMountingType() {
        return this.mountingType;
    }

    public String getMountAs() {
        return this.mountAs;
    }

    public String getWrite() {
        return this.write;
    }

    public String getFreesize() {
        return this.freesize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MountingType {
        DIR,
        IMAGE,
        PHYSFS;

    }
}

