/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.db.Database;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.DosboxVersion;
import com.model.KeyValuePair;
import com.util.FileUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class DFendImportThread
extends Thread {
    private String title;
    private int profileNumber;
    StringBuffer messageLog;
    private boolean performCleanup;
    private DosboxVersion defaultDBVersion;
    private Configuration standardProfile;
    private Configuration profiles;
    private Display display;
    private Text log;
    private ProgressBar progressBar;
    private Label profileLabel;

    public DFendImportThread(String dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.performCleanup = performCleanup;
        this.defaultDBVersion = defaultDBVersion;
        this.standardProfile = new Configuration(defaultDBVersion.getConfigFile());
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profiles = new Configuration(dfendProfilesFile, false);
        this.progressBar.setMaximum(this.profiles.getSectionKeys().size());
        this.profileNumber = 0;
    }

    public void run() {
        Database db = Database.getInstance();
        try {
            Iterator<String> it = this.profiles.getSectionKeys().iterator();
            while (it.hasNext()) {
                this.messageLog = new StringBuffer();
                this.title = it.next();
                String profFile = this.profiles.getValue(this.title, "prof");
                String confFile = this.profiles.getValue(this.title, "conf");
                boolean favorite = this.profiles.getValue(this.title, "fav").equals("1");
                try {
                    Configuration dfendExtra = new Configuration(profFile, false);
                    String setup = dfendExtra.getValue("Extra", "Setup");
                    String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
                    String notes = dfendExtra.getValue("ExtraInfo", "Notes");
                    String dev = dfendExtra.getValue("ExtraInfo", "Developer");
                    String pub = dfendExtra.getValue("ExtraInfo", "Publisher");
                    String gen = dfendExtra.getValue("ExtraInfo", "Genre");
                    String yr = dfendExtra.getValue("ExtraInfo", "Year");
                    String st = "Unknown";
                    String cap = dfendExtra.getValue("dosbox", "captures");
                    int devIndex = -1;
                    int publIndex = -1;
                    int genIndex = -1;
                    int yrIndex = -1;
                    int statIndex = -1;
                    Iterator<KeyValuePair> devIt = db.readDevelopersList().iterator();
                    Iterator<KeyValuePair> pubIt = db.readPublishersList().iterator();
                    Iterator<KeyValuePair> genIt = db.readGenresList().iterator();
                    Iterator<KeyValuePair> yrIt = db.readYearsList().iterator();
                    Iterator<KeyValuePair> statIt = db.readStatusList().iterator();
                    while (devIt.hasNext()) {
                        KeyValuePair developer = devIt.next();
                        if (!developer.getValue().equals(dev)) continue;
                        devIndex = developer.getId();
                        break;
                    }
                    while (pubIt.hasNext()) {
                        KeyValuePair publisher = pubIt.next();
                        if (!publisher.getValue().equals(pub)) continue;
                        publIndex = publisher.getId();
                        break;
                    }
                    while (genIt.hasNext()) {
                        KeyValuePair genre = genIt.next();
                        if (!genre.getValue().equals(gen)) continue;
                        genIndex = genre.getId();
                        break;
                    }
                    while (yrIt.hasNext()) {
                        KeyValuePair year = yrIt.next();
                        if (!year.getValue().equals(yr)) continue;
                        yrIndex = year.getId();
                        break;
                    }
                    while (statIt.hasNext()) {
                        KeyValuePair stat = statIt.next();
                        if (!stat.getValue().equals(st)) continue;
                        statIndex = stat.getId();
                        break;
                    }
                    try {
                        int profileId = db.addOrEditProfile(this.title, dev, pub, gen, yr, st, setup, setupParams, notes, favorite, devIndex, publIndex, genIndex, yrIndex, statIndex, this.defaultDBVersion.getId(), new String[]{"", "", "", ""}, new String[]{"", "", "", "", "", "", "", ""}, new int[2], new int[4], -1);
                        Configuration dfendProfile = new Configuration(confFile);
                        Autoexec autoexec = new Autoexec(dfendProfile.getValue("autoexec", "autoexec"));
                        dfendProfile.setValue("autoexec", "autoexec", autoexec.toString(false));
                        String dstCap = FileUtils.constructCapturesDir(profileId);
                        FileUtils.createDir(dstCap);
                        FileUtils.copyFiles(cap, dstCap);
                        dfendProfile.setValue("dosbox", "captures", FileUtils.constructCanonicalCapturesDir(profileId));
                        if (this.performCleanup) {
                            dfendProfile.removeSection("directserial");
                            dfendProfile.removeSection("modem");
                            dfendProfile.removeSection("ipx");
                            dfendProfile.removeSection("sdl");
                        }
                        dfendProfile.removeValue("gus", "base");
                        dfendProfile.removeValue("gus", "rate");
                        dfendProfile.removeValue("sblaster", "base");
                        dfendProfile.removeValue("sblaster", "type");
                        if (dfendProfile.getValue("midi", "mpu401").equals("true")) {
                            if (dfendProfile.getValue("midi", "intelligent").equals("true")) {
                                dfendProfile.setValue("midi", "mpu401", "intelligent");
                            } else if (dfendProfile.getValue("midi", "intelligent").equals("false")) {
                                dfendProfile.setValue("midi", "mpu401", "uart");
                            }
                        } else if (dfendProfile.getValue("midi", "mpu401").equals("false")) {
                            dfendProfile.setValue("midi", "mpu401", "none");
                        }
                        dfendProfile.removeValue("midi", "intelligent");
                        if (this.defaultDBVersion.isMultiConfig()) {
                            dfendProfile.substract(this.standardProfile);
                        }
                        String newConfFile = FileUtils.constructUniqueConfigFile(profileId, this.title, dfendProfile.getGameLocation());
                        dfendProfile.saveToFile(newConfFile);
                        db.updateProfileConf(newConfFile, dstCap, profileId);
                        this.messageLog.append(dfendExtra.getParsingProblems());
                        this.messageLog.append(dfendProfile.getParsingProblems());
                    }
                    catch (SQLException se) {
                        this.messageLog.append(String.valueOf(se.getMessage()) + "\n");
                    }
                }
                catch (IOException e) {
                    this.messageLog.append(String.valueOf(e.getMessage()) + "\n");
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            DFendImportThread.this.profileLabel.setText("Importing " + DFendImportThread.this.title + "...");
                            DFendImportThread.this.profileLabel.pack();
                            DFendImportThread.this.log.append(DFendImportThread.this.messageLog.toString());
                            ProgressBar progressBar = DFendImportThread.this.progressBar;
                            DFendImportThread dFendImportThread = DFendImportThread.this;
                            int n = dFendImportThread.profileNumber;
                            dFendImportThread.profileNumber = n + 1;
                            progressBar.setSelection(n);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            this.messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    DFendImportThread.this.log.append(DFendImportThread.this.messageLog.toString());
                }
            });
        }
    }
}

