/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Settings;
import com.util.ListUtils;
import java.io.File;
import java.util.List;
import net.jimmc.jshortcut.JShellLink;
import org.eclipse.swt.program.Program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlatformUtils {
    public static final boolean IS_WINDOWS = File.separatorChar == '\\';
    public static final boolean IS_LINUX = File.separatorChar == '/';
    public static final String DB_EXECUTABLE = IS_WINDOWS ? "DOSBox.exe" : "dosbox";

    public static String toNativePath(String dosboxFileLocation) {
        if (IS_LINUX) {
            return dosboxFileLocation.replace('\\', File.separatorChar);
        }
        return dosboxFileLocation;
    }

    public static String toDosboxPath(String hostFileLocation) {
        if (IS_LINUX) {
            return hostFileLocation.replace('/', '\\');
        }
        return hostFileLocation;
    }

    public static String archiveToNativePath(String archiveEntry) {
        if (IS_LINUX) {
            return archiveEntry.replace('\\', File.separatorChar);
        }
        return archiveEntry.replace('/', File.separatorChar);
    }

    public static void openForEditing(String file) {
        Program p = Program.findProgram((String)".conf");
        if (p == null) {
            p = Program.findProgram((String)".txt");
        }
        if (p == null) {
            p = Program.findProgram((String)".inf");
        }
        if (p == null) {
            p = Program.findProgram((String)".ini");
        }
        if (p == null) {
            p = Program.findProgram((String)".cfg");
        }
        if (p == null) {
            p = Program.findProgram((String)".java");
        }
        if (p == null) {
            p = Program.findProgram((String)".doc");
        }
        if (p != null) {
            p.execute(file);
        } else {
            System.err.println("Cannot open \"" + file + "\"");
        }
    }

    public static void openForBrowsing(String url) {
        Program p = Program.findProgram((String)".html");
        if (p != null) {
            p.execute(url);
        } else {
            System.err.println("Cannot open \"" + url + "\"");
        }
    }

    public static void createShortcut(Profile profile, List<DosboxVersion> dbversionsList) {
        int dbversionIndex = ListUtils.findTIDosboxVersion(dbversionsList, profile.getDbversionId());
        DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
        String params = "";
        if (dbversion.isMultiConfig()) {
            params = String.valueOf(params) + "-conf dosbox.conf ";
        }
        params = String.valueOf(params) + "-conf \"" + profile.getCanonicalConfPathAndFile() + "\"";
        if (Settings.getInstance().getBooleanValue("dosbox", "hideconsole")) {
            params = String.valueOf(params) + " -noconsole";
        }
        JShellLink link = new JShellLink();
        link.setFolder(JShellLink.getDirectory((String)"desktop"));
        link.setName(profile.getTitle().replaceAll("[:?*]", " "));
        link.setPath(dbversion.getExecutable());
        link.setArguments(params);
        link.setDescription("Run " + profile.getTitle() + " in DOSBox");
        link.save();
    }
}

