/*
 * Decompiled with CFR 0.152.
 */
package com.db;

import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import com.model.KeyValuePair;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.util.FileUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private Connection con = null;
    private static final String GET_IDENTITY_QUERY = "CALL IDENTITY()";
    private static final String GAME_LIST_QUERY = "SELECT GAM.ID, GAM.TITLE, DEV.NAME, PUBL.NAME, GEN.NAME, YR.YEAR, GAM.DBVERSION_ID, GAM.SETUP, GAM.SETUP_PARAMS, GAM.NOTES, GAM.LINK1, GAM.LINK2, GAM.FAVORITE, STAT.STAT, GAM.CONFFILE, GAM.CAPTURES, GAM.LINK3, GAM.LINK4, CUST1.VALUE, CUST2.VALUE, CUST3.VALUE, CUST4.VALUE, GAM.CUSTOM5, GAM.CUSTOM6, GAM.CUSTOM7, GAM.CUSTOM8, GAM.CUSTOM9, GAM.CUSTOM10 FROM GAMES GAM, DEVELOPERS DEV, PUBLISHERS PUBL, GENRES GEN, PUBLYEARS YR, STATUS STAT, CUSTOM1 CUST1, CUSTOM2 CUST2, CUSTOM3 CUST3, CUSTOM4 CUST4 WHERE GAM.DEV_ID=DEV.ID AND GAM.PUBL_ID=PUBL.ID AND GAM.GENRE_ID=GEN.ID AND GAM.YEAR_ID=YR.ID AND GAM.STAT_ID=STAT.ID AND   GAM.CUST1_ID=CUST1.ID AND GAM.CUST2_ID=CUST2.ID AND GAM.CUST3_ID=CUST3.ID AND GAM.CUST4_ID=CUST4.ID ORDER BY ";
    private static final String DUPLICATE_GAME_QUERY = "INSERT INTO GAMES(        TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, DBVERSION_ID, STAT_ID, SETUP, SETUP_PARAMS, NOTES, LINK1, LINK2, FAVORITE, CONFFILE, CAPTURES, LINK3, LINK4, CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10) (SELECT TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, DBVERSION_ID, STAT_ID, SETUP, SETUP_PARAMS, NOTES, LINK1, LINK2, FAVORITE, NULL,     NULL,     LINK3, LINK4, CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10 FROM GAMES WHERE ID = ?)";
    private static final String DEVELOPER_LIST_QUERY = "SELECT ID, NAME FROM DEVELOPERS ORDER BY NAME";
    private static final String PUBLISHER_LIST_QUERY = "SELECT ID, NAME FROM PUBLISHERS ORDER BY NAME";
    private static final String GENRE_LIST_QUERY = "SELECT ID, NAME FROM GENRES ORDER BY NAME";
    private static final String PUBLYEAR_LIST_QUERY = "SELECT ID, YEAR FROM PUBLYEARS ORDER BY YEAR";
    private static final String DOSBOXVERSIONS_LIST_QUERY = "SELECT ID, TITLE, PATH, MULTICONF, DEFAULT, PARAMETERS FROM DOSBOXVERSIONS ORDER BY TITLE";
    private static final String TEMPLATES_LIST_QUERY = "SELECT ID, TITLE, DBVERSION_ID, DEFAULT FROM TEMPLATES ORDER BY TITLE";
    private static final String STATUS_LIST_QUERY = "SELECT ID, STAT FROM STATUS ORDER BY STAT";
    private static final String[] CUSTOM_LIST_QUERY = new String[]{"SELECT ID, VALUE FROM CUSTOM1 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM2 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM3 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM4 ORDER BY VALUE"};
    private static final String ADD_GAME_QUERY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, DBVERSION_ID, STAT_ID, SETUP, SETUP_PARAMS, NOTES, LINK1, LINK2, FAVORITE, CONFFILE, CAPTURES, LINK3, LINK4, CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID,CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_DEVELOPER_QUERY = "INSERT INTO DEVELOPERS(NAME) VALUES (?)";
    private static final String ADD_PUBLISHER_QUERY = "INSERT INTO PUBLISHERS(NAME) VALUES (?)";
    private static final String ADD_GENRE_QUERY = "INSERT INTO GENRES(NAME) VALUES (?)";
    private static final String ADD_YEAR_QUERY = "INSERT INTO PUBLYEARS(YEAR) VALUES (?)";
    private static final String ADD_DOSBOXVERSION_QUERY = "INSERT INTO DOSBOXVERSIONS(TITLE, PATH, MULTICONF, DEFAULT, PARAMETERS) VALUES (?, ?, ?, ?, ?)";
    private static final String ADD_TEMPLATE_QUERY = "INSERT INTO TEMPLATES(TITLE, DBVERSION_ID, DEFAULT) VALUES (?, ?, ?)";
    private static final String ADD_STATUS_QUERY = "INSERT INTO STATUS(STAT) VALUES (?)";
    private static final String[] ADD_CUSTOM_QUERY = new String[]{"INSERT INTO CUSTOM1(VALUE) VALUES (?)", "INSERT INTO CUSTOM2(VALUE) VALUES (?)", "INSERT INTO CUSTOM3(VALUE) VALUES (?)", "INSERT INTO CUSTOM4(VALUE) VALUES (?)"};
    private static final String UPDATE_GAME_QUERY = "UPDATE GAMES SET TITLE = ?, DEV_ID = ?, PUBL_ID = ?, GENRE_ID = ?, YEAR_ID = ?, DBVERSION_ID = ?, STAT_ID = ?, SETUP = ?, SETUP_PARAMS = ?, NOTES = ?, LINK1 = ?, LINK2 = ?, FAVORITE = ?, LINK3 = ?, LINK4 = ?, CUST1_ID = ?, CUST2_ID = ?, CUST3_ID = ?, CUST4_ID = ?, CUSTOM5 = ?, CUSTOM6 = ?, CUSTOM7 = ?, CUSTOM8 = ?, CUSTOM9 = ?, CUSTOM10 = ?  WHERE ID = ?";
    private static final String UPDATE_GAME_CONF_QUERY = "UPDATE GAMES SET CONFFILE = ?, CAPTURES = ? WHERE ID = ?";
    private static final String UPDATE_GAME_SETUP_AND_LINKS_QUERY = "UPDATE GAMES SET SETUP = ?, LINK1 = ?, LINK2 = ?, LINK3 = ?, LINK4 = ? WHERE ID = ?";
    private static final String UPDATE_DOSBOXVERSION_NODEFAULT = "UPDATE DOSBOXVERSIONS SET DEFAULT = FALSE";
    private static final String UPDATE_DOSBOXVERSION_QUERY = "UPDATE DOSBOXVERSIONS SET TITLE = ?, PATH = ?, MULTICONF = ?, DEFAULT = ?, PARAMETERS = ? WHERE ID = ?";
    private static final String UPDATE_TEMPLATE_QUERY = "UPDATE TEMPLATES SET TITLE = ?, DBVERSION_ID = ?, DEFAULT = ? WHERE ID = ?";
    private static final String UPDATE_TEMPLATE_NODEFAULT = "UPDATE TEMPLATES SET DEFAULT = FALSE";
    private static final String REMOVE_GAME_QUERY = "DELETE FROM GAMES WHERE ID = ?";
    private static final String REMOVE_DOSBOXVERSION_QUERY = "DELETE FROM DOSBOXVERSIONS WHERE ID = ?";
    private static final String REMOVE_TEMPLATE_QUERY = "DELETE FROM TEMPLATES WHERE ID = ?";
    private static final String TOGGLE_FAVORITE_QUERY = "UPDATE GAMES SET FAVORITE = NOT FAVORITE WHERE ID = ?";
    private static final String GET_VERSION = "SELECT MAJORVERSION, MINORVERSION FROM VERSION";
    private static final String UPGRADE_TO_V050_QUERY = "ALTER TABLE GAMES ADD COLUMN CONFFILE VARCHAR(256);ALTER TABLE GAMES ADD COLUMN CAPTURES VARCHAR(256);CREATE TABLE VERSION(MAJORVERSION INTEGER NOT NULL, MINORVERSION INTEGER NOT NULL);INSERT INTO VERSION VALUES(0, 50);UPDATE GAMES SET CAPTURES = '" + FileUtils.CAPTURES_DIR + "' || GAMES.ID," + " CONFFILE = '" + FileUtils.PROFILES_DIR + "' || GAMES.ID || '" + ".conf" + "';";
    private static final String UPGRADE_TO_V051_QUERY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN PARAMETERS VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 51;";
    private static final String UPGRADE_TO_V056_QUERY = "ALTER TABLE GAMES ADD COLUMN LINK3 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUST1_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST2_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST3_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST4_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM5 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM6 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM7 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM8 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM9  INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM10 INTEGER DEFAULT 0;CREATE TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);INSERT INTO CUSTOM1(VALUE) VALUES('');INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES('');INSERT INTO CUSTOM4(VALUE) VALUES('');UPDATE VERSION SET MINORVERSION = 56;";
    private static final int COMPLEX_CUSTOM_STRINGS = CUSTOM_LIST_QUERY.length;
    private static final int SIMPLE_CUSTOM_STRINGS = 4;
    private static final int SIMPLE_CUSTOM_INTS = 2;

    private Database() {
        this.init();
    }

    public static Database getInstance() {
        return DatabaseHolder.instance;
    }

    private int[] getVersion() {
        int[] result = new int[2];
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(GET_VERSION);
            if (rs != null && rs.next()) {
                result[0] = rs.getInt(1);
                result[1] = rs.getInt(2);
            }
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result;
    }

    private void upgradeToV050() throws SQLException {
        System.out.println("upgrading database to v0.50");
        try {
            Statement stmt = this.con.createStatement();
            stmt.executeQuery(UPGRADE_TO_V050_QUERY);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Could not upgrade the database to v0.50");
        }
    }

    private void upgradeToV051() throws SQLException {
        System.out.println("upgrading database to v0.51");
        try {
            Statement stmt = this.con.createStatement();
            stmt.executeQuery(UPGRADE_TO_V051_QUERY);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Could not upgrade the database to v0.51");
        }
    }

    private void upgradeToV056() throws SQLException {
        System.out.println("upgrading database to v0.56");
        try {
            Statement stmt = this.con.createStatement();
            stmt.executeQuery(UPGRADE_TO_V056_QUERY);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Could not upgrade the database to v0.56");
        }
    }

    private void upgradeIfNecessary() throws SQLException {
        int[] version = this.getVersion();
        if (version[0] <= 0 && version[1] < 50) {
            this.upgradeToV050();
        }
        if (version[0] <= 0 && version[1] < 51) {
            this.upgradeToV051();
        }
        if (version[0] <= 0 && version[1] < 56) {
            this.upgradeToV056();
        }
    }

    private void init() {
        System.out.println("startup");
        Settings settings = Settings.getInstance();
        String connectionString = settings.getValue("database", "connectionstring");
        if (connectionString.contains("file:")) {
            FileUtils.renameDatabaseIfNecessary();
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.con = DriverManager.getConnection(connectionString, settings.getValue("database", "username"), settings.getValue("database", "password"));
            this.upgradeIfNecessary();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException exc) {
                System.err.println("JDBC Connection could not be closed properly!!\n");
                exc.printStackTrace();
            }
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, "There was a problem initializing the database connection!\n\nTechnical information:\n" + e.toString());
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, "There was a problem registering the database JDBC driver!\n\nTechnical information:\n" + e.toString());
            System.exit(1);
        }
    }

    public void shutdown() throws SQLException {
        System.out.println("shutdown");
        try {
            Statement st = this.con.createStatement();
            st.execute("SHUTDOWN");
            this.con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database connection could not be shutdown properly");
        }
    }

    public List<Profile> readProfilesList(String orderingClause) throws SQLException {
        ArrayList<Profile> profilesList = new ArrayList<Profile>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(GAME_LIST_QUERY + orderingClause);
            if (rs != null) {
                while (rs.next()) {
                    profilesList.add(new Profile(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), rs.getInt(7), rs.getString(8), rs.getString(9), rs.getString(10), rs.getString(11), rs.getString(12), rs.getBoolean(13), rs.getString(14), rs.getString(15), rs.getString(16), rs.getString(17), rs.getString(18), rs.getString(19), rs.getString(20), rs.getString(21), rs.getString(22), rs.getString(23), rs.getString(24), rs.getString(25), rs.getString(26), rs.getInt(27), rs.getInt(28)));
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'read profiles' failed");
        }
        return profilesList;
    }

    public List<KeyValuePair> readDevelopersList() throws SQLException {
        return this.readKeyValuePairList(DEVELOPER_LIST_QUERY);
    }

    public List<KeyValuePair> readPublishersList() throws SQLException {
        return this.readKeyValuePairList(PUBLISHER_LIST_QUERY);
    }

    public List<KeyValuePair> readGenresList() throws SQLException {
        return this.readKeyValuePairList(GENRE_LIST_QUERY);
    }

    public List<KeyValuePair> readYearsList() throws SQLException {
        return this.readKeyValuePairList(PUBLYEAR_LIST_QUERY);
    }

    public List<KeyValuePair> readStatusList() throws SQLException {
        return this.readKeyValuePairList(STATUS_LIST_QUERY);
    }

    public List<KeyValuePair> readCustomList(int i) throws SQLException {
        return this.readKeyValuePairList(CUSTOM_LIST_QUERY[i]);
    }

    public List<KeyValuePair> readKeyValuePairList(String query) throws SQLException {
        ArrayList<KeyValuePair> customList = new ArrayList<KeyValuePair>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            if (rs != null) {
                while (rs.next()) {
                    customList.add(new KeyValuePair(rs.getInt(1), rs.getString(2)));
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'read KeyValuePairsList' failed");
        }
        return customList;
    }

    public List<DosboxVersion> readDosboxVersionsList() throws SQLException {
        ArrayList<DosboxVersion> dosboxVersionsList = new ArrayList<DosboxVersion>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(DOSBOXVERSIONS_LIST_QUERY);
            if (rs != null) {
                while (rs.next()) {
                    dosboxVersionsList.add(new DosboxVersion(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getBoolean(4), rs.getBoolean(5), rs.getString(6)));
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'read dosboxversions' failed");
        }
        return dosboxVersionsList;
    }

    public List<Template> readTemplatesList() throws SQLException {
        ArrayList<Template> templatesList = new ArrayList<Template>();
        try {
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(TEMPLATES_LIST_QUERY);
            if (rs != null) {
                while (rs.next()) {
                    templatesList.add(new Template(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getBoolean(4)));
                }
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'read templates' failed");
        }
        return templatesList;
    }

    public void removeProfile(int gameId) throws SQLException {
        try {
            PreparedStatement stmt = this.con.prepareStatement(REMOVE_GAME_QUERY);
            stmt.setInt(1, gameId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'remove profile' failed");
        }
    }

    public void removeDosboxVersion(int dbversionId) throws SQLException {
        try {
            PreparedStatement stmt = this.con.prepareStatement(REMOVE_DOSBOXVERSION_QUERY);
            stmt.setInt(1, dbversionId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'remove dosboxversion' failed");
        }
    }

    public void removeTemplate(int templateId) throws SQLException {
        try {
            PreparedStatement stmt = this.con.prepareStatement(REMOVE_TEMPLATE_QUERY);
            stmt.setInt(1, templateId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'remove template' failed");
        }
    }

    public int addOrEditProfile(String title, String developer, String publisher, String genre, String year, String status, String setup, String setupParams, String notes, boolean favorite, int devId, int publId, int genId, int yrId, int statId, int dbversionId, String[] link, String[] sCust, int[] iCust, int[] custId, int profileId) throws SQLException {
        int result = -1;
        try {
            ResultSet rs;
            Statement stmt;
            PreparedStatement pstmt;
            if (devId == -1) {
                pstmt = this.con.prepareStatement(ADD_DEVELOPER_QUERY);
                pstmt.setString(1, developer);
                pstmt.executeUpdate();
                pstmt.close();
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    devId = rs.getInt(1);
                }
                stmt.close();
            }
            if (publId == -1) {
                pstmt = this.con.prepareStatement(ADD_PUBLISHER_QUERY);
                pstmt.setString(1, publisher);
                pstmt.executeUpdate();
                pstmt.close();
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    publId = rs.getInt(1);
                }
                stmt.close();
            }
            if (genId == -1) {
                pstmt = this.con.prepareStatement(ADD_GENRE_QUERY);
                pstmt.setString(1, genre);
                pstmt.executeUpdate();
                pstmt.close();
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    genId = rs.getInt(1);
                }
                stmt.close();
            }
            if (yrId == -1) {
                pstmt = this.con.prepareStatement(ADD_YEAR_QUERY);
                pstmt.setString(1, year);
                pstmt.executeUpdate();
                pstmt.close();
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    yrId = rs.getInt(1);
                }
                stmt.close();
            }
            if (statId == -1) {
                pstmt = this.con.prepareStatement(ADD_STATUS_QUERY);
                pstmt.setString(1, status);
                pstmt.executeUpdate();
                pstmt.close();
                stmt = this.con.createStatement();
                rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    statId = rs.getInt(1);
                }
                stmt.close();
            }
            int i = 0;
            while (i < COMPLEX_CUSTOM_STRINGS) {
                if (custId[i] == -1) {
                    PreparedStatement pstmt2 = this.con.prepareStatement(ADD_CUSTOM_QUERY[i]);
                    pstmt2.setString(1, sCust[i]);
                    pstmt2.executeUpdate();
                    pstmt2.close();
                    Statement stmt2 = this.con.createStatement();
                    ResultSet rs2 = stmt2.executeQuery(GET_IDENTITY_QUERY);
                    if (rs2 != null && rs2.next()) {
                        custId[i] = rs2.getInt(1);
                    }
                    stmt2.close();
                }
                ++i;
            }
            PreparedStatement pstmt3 = this.con.prepareStatement(profileId == -1 ? ADD_GAME_QUERY : UPDATE_GAME_QUERY);
            pstmt3.setString(1, title);
            pstmt3.setInt(2, devId);
            pstmt3.setInt(3, publId);
            pstmt3.setInt(4, genId);
            pstmt3.setInt(5, yrId);
            pstmt3.setInt(6, dbversionId);
            pstmt3.setInt(7, statId);
            pstmt3.setString(8, setup);
            pstmt3.setString(9, setupParams);
            pstmt3.setString(10, notes);
            pstmt3.setString(11, link[0]);
            pstmt3.setString(12, link[1]);
            pstmt3.setBoolean(13, favorite);
            pstmt3.setString(14, link[2]);
            pstmt3.setString(15, link[3]);
            int i2 = 0;
            while (i2 < COMPLEX_CUSTOM_STRINGS) {
                pstmt3.setInt(i2 + 16, custId[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                pstmt3.setString(i2 + COMPLEX_CUSTOM_STRINGS + 16, sCust[i2 + COMPLEX_CUSTOM_STRINGS]);
                ++i2;
            }
            i2 = 0;
            while (i2 < 2) {
                pstmt3.setInt(i2 + COMPLEX_CUSTOM_STRINGS + 4 + 16, iCust[i2]);
                ++i2;
            }
            if (profileId == -1) {
                pstmt3.executeUpdate();
                pstmt3.close();
                Statement stmt3 = this.con.createStatement();
                rs = stmt3.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    result = rs.getInt(1);
                }
                stmt3.close();
            } else {
                pstmt3.setInt(COMPLEX_CUSTOM_STRINGS + 4 + 2 + 16, profileId);
                pstmt3.executeUpdate();
                pstmt3.close();
                result = profileId;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'add/edit profile' failed");
        }
        return result;
    }

    public void updateProfileConf(String confFile, String captures, int profileId) throws SQLException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement(UPDATE_GAME_CONF_QUERY);
            pstmt.setString(1, confFile);
            pstmt.setString(2, captures);
            pstmt.setInt(3, profileId);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'update profile conf' failed");
        }
    }

    public void updateProfileSetupAndLinks(String setup, String[] links, int profileId) throws SQLException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement(UPDATE_GAME_SETUP_AND_LINKS_QUERY);
            pstmt.setString(1, setup);
            pstmt.setString(2, links[0]);
            pstmt.setString(3, links[1]);
            pstmt.setString(4, links[2]);
            pstmt.setString(5, links[3]);
            pstmt.setInt(6, profileId);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'update profile setup and links' failed");
        }
    }

    public void toggleFavorite(int profileId) throws SQLException {
        try {
            PreparedStatement pstmt = this.con.prepareStatement(TOGGLE_FAVORITE_QUERY);
            pstmt.setInt(1, profileId);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'toggle favorite' failed");
        }
    }

    public int duplicateProfile(int profileId) throws SQLException {
        int result = -1;
        try {
            PreparedStatement pstmt = this.con.prepareStatement(DUPLICATE_GAME_QUERY);
            pstmt.setInt(1, profileId);
            pstmt.executeUpdate();
            pstmt.close();
            Statement stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(GET_IDENTITY_QUERY);
            if (rs != null && rs.next()) {
                result = rs.getInt(1);
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'duplicate profile' failed");
        }
        return result;
    }

    private void resetDosboxVersionDefault() throws SQLException {
        Statement stmt = this.con.createStatement();
        stmt.executeQuery(UPDATE_DOSBOXVERSION_NODEFAULT);
    }

    private void resetTemplateDefault() throws SQLException {
        Statement stmt = this.con.createStatement();
        stmt.executeQuery(UPDATE_TEMPLATE_NODEFAULT);
    }

    public int addOrEditDosboxVersion(String title, String path, boolean multiConfig, boolean defaultVersion, String parameters, int dbversionId) throws SQLException {
        int result = -1;
        try {
            if (defaultVersion) {
                this.resetDosboxVersionDefault();
            }
            if (dbversionId == -1) {
                PreparedStatement pstmt = this.con.prepareStatement(ADD_DOSBOXVERSION_QUERY);
                pstmt.setString(1, title);
                pstmt.setString(2, path);
                pstmt.setBoolean(3, multiConfig);
                pstmt.setBoolean(4, defaultVersion);
                pstmt.setString(5, parameters);
                pstmt.executeUpdate();
                pstmt.close();
                Statement stmt = this.con.createStatement();
                ResultSet rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    result = rs.getInt(1);
                }
                stmt.close();
            } else {
                PreparedStatement pstmt = this.con.prepareStatement(UPDATE_DOSBOXVERSION_QUERY);
                pstmt.setString(1, title);
                pstmt.setString(2, path);
                pstmt.setBoolean(3, multiConfig);
                pstmt.setBoolean(4, defaultVersion);
                pstmt.setString(5, parameters);
                pstmt.setInt(6, dbversionId);
                pstmt.executeUpdate();
                pstmt.close();
                result = dbversionId;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'add/edit dosboxversion' failed");
        }
        return result;
    }

    public int addOrEditTemplate(String title, int dbversionId, boolean defaultVersion, int templateId) throws SQLException {
        int result = -1;
        try {
            if (defaultVersion) {
                this.resetTemplateDefault();
            }
            if (templateId == -1) {
                PreparedStatement pstmt = this.con.prepareStatement(ADD_TEMPLATE_QUERY);
                pstmt.setString(1, title);
                pstmt.setInt(2, dbversionId);
                pstmt.setBoolean(3, defaultVersion);
                pstmt.executeUpdate();
                pstmt.close();
                Statement stmt = this.con.createStatement();
                ResultSet rs = stmt.executeQuery(GET_IDENTITY_QUERY);
                if (rs != null && rs.next()) {
                    result = rs.getInt(1);
                }
                stmt.close();
            } else {
                PreparedStatement pstmt = this.con.prepareStatement(UPDATE_TEMPLATE_QUERY);
                pstmt.setString(1, title);
                pstmt.setInt(2, dbversionId);
                pstmt.setBoolean(3, defaultVersion);
                pstmt.setInt(4, templateId);
                pstmt.executeUpdate();
                pstmt.close();
                result = templateId;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLException("Database query 'add/edit template' failed");
        }
        return result;
    }

    /* synthetic */ Database(Database database) {
        this();
    }

    private static class DatabaseHolder {
        private static Database instance = new Database(null);

        private DatabaseHolder() {
        }
    }
}

