/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public final class AutoSelectCombo {
    private Combo combo;
    private boolean programmaticallyChanging;
    private int currentLength;

    public AutoSelectCombo(Composite composite, int style) {
        this.combo = new Combo(composite, style);
        this.programmaticallyChanging = false;
        this.currentLength = 0;
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!AutoSelectCombo.this.programmaticallyChanging) {
                    int index = AutoSelectCombo.this.indexOfClosestMatch(AutoSelectCombo.this.combo.getText());
                    int newLength = AutoSelectCombo.this.combo.getText().length();
                    if (newLength > AutoSelectCombo.this.currentLength && index != -1) {
                        AutoSelectCombo.this.programmaticallyChanging = true;
                        AutoSelectCombo.this.combo.setText(String.valueOf(AutoSelectCombo.this.combo.getText()) + AutoSelectCombo.this.combo.getItem(index).substring(newLength));
                        AutoSelectCombo.this.combo.setSelection(new Point(newLength, AutoSelectCombo.this.combo.getText().length()));
                        AutoSelectCombo.this.programmaticallyChanging = false;
                    }
                    AutoSelectCombo.this.currentLength = newLength;
                }
            }
        });
    }

    public void setLayoutData(Object arg0) {
        this.combo.setLayoutData(arg0);
    }

    public void setVisibleItemCount(int arg0) {
        this.combo.setVisibleItemCount(arg0);
    }

    public void add(String arg0) {
        this.combo.add(arg0);
    }

    public String getText() {
        return this.combo.getText();
    }

    public void select(int arg0) {
        this.combo.select(arg0);
    }

    public void setText(String arg0) {
        this.combo.setText(arg0);
        this.currentLength = this.combo.getText().length();
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public int indexOf(String arg0) {
        return this.combo.indexOf(arg0);
    }

    public int indexOfClosestMatch(String text) {
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).toLowerCase().startsWith(text.toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

