/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.BrowseButton;
import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import com.util.DFendImportThread;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class DFendImportDialog
extends Dialog {
    private Text location;
    private Text logText;
    private DosboxVersion defaultDosboxVersion;
    private DFendImportThread importThread;
    private Button cancelButton;
    private Label profileLabel;
    private Shell shell;

    public DFendImportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public DFendImportDialog(Shell parent) {
        this(parent, 0);
    }

    public void setDefaultDosboxVersion(DosboxVersion dbversion) {
        this.defaultDosboxVersion = dbversion;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.importThread != null && !this.importThread.isAlive() && !this.cancelButton.getText().equals("Close")) {
                GeneralPurposeDialogs.infoMessage(this.shell, "D-Fend profiles import completed successfully.");
                this.profileLabel.setText("Please review the log below for possible problems");
                this.profileLabel.pack();
                this.cancelButton.setText("Close");
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.importThread;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setSize(500, 375);
        this.shell.setText("Import D-Fend Profiles");
        Group optionsGroup = new Group((Composite)this.shell, 0);
        optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        optionsGroup.setText("Options");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        optionsGroup.setLayout((Layout)gridLayout);
        Label dfendLocationLabel = new Label((Composite)optionsGroup, 0);
        dfendLocationLabel.setText("D-Fend Location");
        this.location = new Text((Composite)optionsGroup, 2048);
        this.location.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.location.setText("C:\\Program Files\\D-Fend\\Profiles.dat");
        final BrowseButton browseButton = new BrowseButton((Composite)optionsGroup, 0);
        browseButton.connect(this.shell, this.location, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DFEND, null);
        Label cleanUpLabel = new Label((Composite)optionsGroup, 0);
        cleanUpLabel.setText("Clean Up");
        final Button cleanup = new Button((Composite)optionsGroup, 32);
        cleanup.setText("(remove sections directserial, modem, ipx and sdl)");
        cleanup.setSelection(true);
        new Label((Composite)optionsGroup, 0);
        final Button startImportButton = new Button((Composite)optionsGroup, 0);
        this.shell.setDefaultButton(startImportButton);
        startImportButton.setLayoutData((Object)new GridData(80, -1));
        startImportButton.setText("Start Import");
        this.cancelButton = new Button((Composite)optionsGroup, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DFendImportDialog.this.shell.close();
            }
        });
        this.cancelButton.setLayoutData((Object)new GridData(80, -1));
        this.cancelButton.setText("Cancel");
        new Label((Composite)optionsGroup, 0);
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        progressGroup.setText("Progress");
        progressGroup.setLayout((Layout)new GridLayout());
        final ProgressBar progressBar = new ProgressBar((Composite)progressGroup, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        startImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DFendImportDialog.this.importThread = new DFendImportThread(new File(DFendImportDialog.this.location.getText()), cleanup.getSelection(), DFendImportDialog.this.defaultDosboxVersion, DFendImportDialog.this.logText, progressBar, DFendImportDialog.this.profileLabel);
                    DFendImportDialog.this.location.setEnabled(false);
                    browseButton.setEnabled(false);
                    cleanup.setEnabled(false);
                    startImportButton.setEnabled(false);
                    DFendImportDialog.this.importThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(DFendImportDialog.this.shell, ex.getMessage());
                    DFendImportDialog.this.importThread = null;
                }
            }
        });
    }
}

