/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.util.FileUtils;
import com.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mount {
    private MountingType mountingType;
    private String mountAs;
    private char driveletter;
    private String label;
    private File[] path;
    private File write;
    private boolean ioctl;
    private String freesize;

    public Mount(MountingType mountingType, String mountAs, String driveletter, String[] paths, String label, boolean ioctl, String write, String freesize) {
        this.mountingType = mountingType;
        this.mountAs = mountAs.toLowerCase();
        this.driveletter = Character.toUpperCase(driveletter.charAt(0));
        this.path = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.path[i] = new File(paths[i]);
            ++i;
        }
        this.write = new File(write);
        this.label = label;
        this.ioctl = ioctl;
        this.freesize = freesize;
    }

    private void init() {
        this.mountingType = MountingType.DIR;
        this.mountAs = "";
        this.driveletter = '\u0000';
        this.label = "";
        this.path = null;
        this.write = null;
        this.ioctl = false;
        this.freesize = "";
    }

    private void initForPhysFS(String physFSPath) {
        this.mountingType = MountingType.PHYSFS;
        int colonIndex1 = physFSPath.indexOf(":");
        if (colonIndex1 == 1) {
            colonIndex1 = physFSPath.indexOf(":", colonIndex1 + 1);
        }
        int colonIndex2 = physFSPath.lastIndexOf(":");
        this.path = new File[1];
        if (colonIndex1 != colonIndex2) {
            this.write = new File(physFSPath.substring(0, colonIndex1));
            this.path[0] = new File(physFSPath.substring(colonIndex1 + 1, colonIndex2));
        } else {
            this.path[0] = new File(physFSPath.substring(0, colonIndex2));
        }
    }

    public Mount(boolean floppy, String hostFileLocation, String[] existingMounts) {
        this.init();
        if (hostFileLocation.equals("")) {
            return;
        }
        List<Character> freeDriveletters = Mount.getFreeDriveletters(floppy, existingMounts);
        if (freeDriveletters.size() < 1) {
            return;
        }
        this.driveletter = freeDriveletters.get(0).charValue();
        if (FileUtils.containsPhysFS(hostFileLocation)) {
            this.initForPhysFS(hostFileLocation);
        } else {
            File file = new File(hostFileLocation);
            this.path = new File[1];
            this.path[0] = file.getParentFile();
            if (this.path[0] == null) {
                this.path[0] = new File(".");
            }
        }
    }

    public Mount(String mount) {
        this.init();
        if (mount.equals("")) {
            return;
        }
        int spaceIndex = mount.indexOf(32);
        this.driveletter = Character.toUpperCase(mount.charAt(spaceIndex + 1));
        int firstQuoteIndex = mount.indexOf(34);
        int secondQuoteIndex = mount.lastIndexOf(34);
        if (firstQuoteIndex == -1 && secondQuoteIndex == -1 && (secondQuoteIndex = mount.indexOf(32, (firstQuoteIndex = mount.indexOf(32, spaceIndex + 1)) + 1)) == -1) {
            secondQuoteIndex = mount.length();
        }
        String mountLocation = mount.substring(firstQuoteIndex + 1, secondQuoteIndex);
        String[] paths = StringUtils.mountToStringArray(mountLocation);
        this.path = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.path[i] = FileUtils.makeRelativeToDosroot(new File(paths[i]));
            ++i;
        }
        if (mount.toLowerCase().startsWith("mount ")) {
            int freesizeIndex;
            int labelIndex;
            int typeIndex;
            if (FileUtils.isPhysFS(mountLocation)) {
                this.initForPhysFS(mountLocation);
            }
            if ((typeIndex = mount.indexOf("-t ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", typeIndex + 3);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.mountAs = mount.substring(typeIndex + 3, spaceIndex2);
            }
            if ((labelIndex = mount.indexOf("-label ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", labelIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.label = mount.substring(labelIndex + 7, spaceIndex2);
            }
            if (mount.indexOf("-ioctl") != -1) {
                this.ioctl = true;
            }
            if ((freesizeIndex = mount.indexOf("-freesize ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", freesizeIndex + 10);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.freesize = mount.substring(freesizeIndex + 10, spaceIndex2);
            }
        } else if (mount.toLowerCase().startsWith("imgmount ")) {
            this.mountingType = MountingType.IMAGE;
            this.mountAs = "iso";
        }
    }

    public static List<Character> getFreeDriveletters(boolean floppy, String[] existingMounts) {
        int start;
        Mount[] mnts = new Mount[existingMounts.length];
        int i = 0;
        while (i < mnts.length) {
            mnts[i] = new Mount(existingMounts[i]);
            ++i;
        }
        ArrayList<Character> freeDriveletters = new ArrayList<Character>();
        int i2 = start = floppy ? 65 : 67;
        while (i2 < 90) {
            freeDriveletters.add(Character.valueOf((char)i2));
            i2 = (char)(i2 + '\u0001');
        }
        if (!floppy) {
            freeDriveletters.add(Character.valueOf('A'));
            freeDriveletters.add(Character.valueOf('B'));
        }
        i2 = 0;
        while (i2 < mnts.length) {
            freeDriveletters.remove(new Character(mnts[i2].getDriveletter()));
            ++i2;
        }
        return freeDriveletters;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        switch (this.mountingType) {
            case DIR: {
                result.append("mount " + this.driveletter + " \"" + this.getPathAsString() + "\"");
                if (!this.ioctl) break;
                result.append(" -ioctl");
                break;
            }
            case PHYSFS: {
                result.append("mount " + this.driveletter + " \"");
                if (!this.getWriteAsString().equals("")) {
                    result.append(String.valueOf(this.getWriteAsString()) + "\\:");
                }
                result.append(String.valueOf(this.path[0].getPath()) + ":\\\"");
                break;
            }
            case IMAGE: {
                result.append("imgmount " + this.driveletter);
                int i = 0;
                while (i < this.path.length) {
                    result.append(" \"" + this.path[i].getPath() + "\"");
                    ++i;
                }
                break;
            }
        }
        if (!this.label.equals("")) {
            result.append(" -label " + this.label);
        }
        if (!this.mountAs.equals("")) {
            result.append(" -t " + this.mountAs);
        }
        if (!this.freesize.equals("")) {
            result.append(" -freesize " + this.freesize);
        }
        return result.toString();
    }

    public char getDriveletter() {
        return this.driveletter;
    }

    public String getDriveletterString() {
        return String.valueOf(this.driveletter);
    }

    public boolean isIoctl() {
        return this.ioctl;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPathAsString() {
        if (this.path.length <= 0) {
            return "";
        }
        return this.path[0].getPath();
    }

    public char getDriveletterFromPath() {
        return Character.toUpperCase(this.path[0].getAbsolutePath().charAt(0));
    }

    public String getImgMountAsString() {
        String[] paths = new String[this.path.length];
        int i = 0;
        while (i < this.path.length) {
            paths[i] = this.path[i].getPath();
            ++i;
        }
        return StringUtils.StringArrayToString(paths);
    }

    public String getHostPathAsString() {
        return this.mountingType == MountingType.PHYSFS ? String.valueOf(this.getPathAsString()) + ':' : this.getPathAsString();
    }

    public MountingType getMountingType() {
        return this.mountingType;
    }

    public String getMountAs() {
        return this.mountAs;
    }

    public String getWriteAsString() {
        if (this.write == null) {
            return "";
        }
        return this.write.getPath();
    }

    public String getFreesize() {
        return this.freesize;
    }

    public File canBeUsedFor(File hostFile) {
        hostFile = FileUtils.canonicalToDosroot(hostFile.getPath());
        if (FileUtils.areRelated(FileUtils.canonicalToDosroot(this.getHostPathAsString()), hostFile)) {
            return FileUtils.makeRelativeTo(hostFile, FileUtils.canonicalToDosroot(this.getHostPathAsString()));
        }
        return null;
    }

    public void makeRelative(File basePath) {
        int i = 0;
        while (i < this.path.length) {
            this.path[i] = FileUtils.makeRelativeTo(this.path[i], basePath);
            ++i;
        }
        if (this.write != null) {
            this.write = FileUtils.makeRelativeTo(this.write, basePath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MountingType {
        DIR,
        IMAGE,
        PHYSFS;

    }
}

