/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.BrowseArchiveDialog;
import com.util.FileUtils;
import com.util.StringUtils;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class BrowseButton {
    public static final String DFEND_PATH = "C:\\Program Files\\D-Fend\\";
    public static final String DFEND_PROFILES = "Profiles.dat";
    private Button button;

    public BrowseButton(Composite composite, int style) {
        this.button = new Button(composite, style);
        this.button.setText("Browse..");
    }

    public void connect(Shell shell, Text control, Text altControl, BrowseType bt, CanonicalType ct, Combo combo) {
        this.button.addSelectionListener((SelectionListener)new Sa(shell, control, altControl, bt, ct, combo));
    }

    public void setLayoutData(Object arg0) {
        this.button.setLayoutData(arg0);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowseType {
        DIR,
        FILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CanonicalType {
        DOSROOT,
        DFEND,
        CDIMAGE,
        ZIP,
        DOSBOX,
        DOC,
        BOOTER,
        EXE,
        NONE;

    }

    private class Sa
    extends SelectionAdapter {
        private Text field;
        private Text alt;
        private BrowseType browse;
        private CanonicalType canon;
        private Combo combo;
        private Shell shell;

        public Sa(Shell s, Text control, Text altControl, BrowseType bt, CanonicalType ct, Combo c) {
            this.shell = s;
            this.field = control;
            this.alt = altControl;
            this.browse = bt;
            this.canon = ct;
            this.combo = c;
        }

        private String filterPath() {
            String path = this.field.getText();
            CanonicalType fileType = this.canon;
            if (path.equals("") && this.alt != null) {
                path = this.alt.getText();
                fileType = CanonicalType.DOSROOT;
            }
            switch (fileType) {
                case DOC: {
                    return FileUtils.canonicalToData(path).getPath();
                }
                case DOSROOT: 
                case ZIP: 
                case BOOTER: 
                case EXE: {
                    return FileUtils.canonicalToDosroot(path).getPath();
                }
                case DOSBOX: {
                    return FileUtils.canonicalToDosbox(path).getPath();
                }
                case DFEND: {
                    return BrowseButton.DFEND_PATH;
                }
                case CDIMAGE: {
                    String[] fPaths = StringUtils.textAreaToStringArray(this.field.getText(), this.field.getLineDelimiter());
                    if (fPaths.length <= 0) break;
                    return fPaths[0];
                }
            }
            return "";
        }

        private String getResult(String result, File fp, String[] filenames) {
            switch (this.canon) {
                case DOC: {
                    return FileUtils.makeRelativeToData(new File(result)).getPath();
                }
                case EXE: {
                    if (FileUtils.isArchive(result)) {
                        BrowseArchiveDialog dialog = new BrowseArchiveDialog(this.shell, 4096);
                        dialog.setArchive(result);
                        return (String)dialog.open();
                    }
                }
                case DOSROOT: 
                case ZIP: 
                case BOOTER: {
                    return FileUtils.makeRelativeToDosroot(new File(result)).getPath();
                }
                case DOSBOX: {
                    return FileUtils.makeRelativeToDosbox(new File(result)).getPath();
                }
                case CDIMAGE: {
                    File path = FileUtils.makeRelativeToDosroot(fp);
                    String images = "";
                    String[] stringArray = filenames;
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String file = stringArray[n];
                        images = String.valueOf(images) + new File(path, file) + "\n";
                        ++n;
                    }
                    return images;
                }
            }
            return result;
        }

        public void widgetSelected(SelectionEvent e) {
            String result = null;
            File fp = null;
            String[] filenames = null;
            if (this.browse == BrowseType.DIR) {
                DirectoryDialog dialog = new DirectoryDialog(this.shell);
                dialog.setFilterPath(this.filterPath());
                result = dialog.open();
            } else if (this.browse == BrowseType.FILE && this.canon == CanonicalType.EXE && FileUtils.isArchive(this.filterPath())) {
                result = this.filterPath();
            } else if (this.browse == BrowseType.FILE) {
                int style = this.canon == CanonicalType.CDIMAGE ? 4098 : 4096;
                FileDialog dialog = new FileDialog(this.shell, style);
                String[] fn = null;
                String[] fe = null;
                switch (this.canon) {
                    case DOC: {
                        fn = new String[]{"*"};
                        fe = new String[]{"*"};
                        break;
                    }
                    case EXE: {
                        String defaultFilterTitle = "Executables";
                        String defaultFilter = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
                        if (this.combo.isEnabled()) {
                            defaultFilterTitle = String.valueOf(defaultFilterTitle) + ", (7-)Zip files";
                            defaultFilter = String.valueOf(defaultFilter) + ";*.zip;*.ZIP;*.7z;*.7Z";
                        }
                        fn = new String[]{defaultFilterTitle, "CD Images", "(7-)Zip files"};
                        fe = new String[]{defaultFilter, "*.iso;*.ISO;*.cue;*.CUE", "*.zip;*.ZIP;*.7z;*.7Z"};
                        break;
                    }
                    case ZIP: {
                        fn = new String[]{"(7-)Zip files", "*"};
                        fe = new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*"};
                        break;
                    }
                    case BOOTER: {
                        fn = new String[]{"Booter Disk Images", "*"};
                        fe = new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"};
                        break;
                    }
                    case DFEND: {
                        fn = new String[]{"D-Fend Profiles"};
                        fe = new String[]{BrowseButton.DFEND_PROFILES};
                        break;
                    }
                    case CDIMAGE: {
                        fn = new String[]{"CD Images", "*"};
                        fe = new String[]{"*.iso;*.ISO;*.cue;*.CUE", "*"};
                    }
                }
                if (fn != null) {
                    dialog.setFilterNames(fn);
                }
                if (fe != null) {
                    dialog.setFilterExtensions(fe);
                }
                if (this.canon == CanonicalType.DFEND) {
                    dialog.setFileName(BrowseButton.DFEND_PROFILES);
                }
                dialog.setFilterPath(this.filterPath());
                result = dialog.open();
                if (this.canon == CanonicalType.CDIMAGE) {
                    fp = new File(dialog.getFilterPath());
                    filenames = dialog.getFileNames();
                }
            }
            if (result != null && (result = this.getResult(result, fp, filenames)) != null) {
                this.field.setText(result);
            }
        }
    }
}

