/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    public static final String AUTOEXEC = "autoexec";
    private HashMap<String, Section> sections;
    private StringBuffer parsingProblems = new StringBuffer();

    public Configuration() {
        this.sections = new HashMap();
    }

    public Configuration(Configuration conf) {
        this();
        for (String key : conf.sections.keySet()) {
            this.sections.put(key, new Section(conf.sections.get(key)));
        }
    }

    public Configuration(File file) throws IOException {
        this(file, true);
    }

    public Configuration(File file, boolean toLowerCase) throws IOException {
        this();
        this.parseConfigurationFile(file, toLowerCase);
    }

    public Configuration emergencyProfileInit() {
        this.createSection("dosbox");
        this.createSection(AUTOEXEC);
        return this;
    }

    public Set<String> getSectionKeys() {
        return this.sections.keySet();
    }

    public void saveToFile(File file) throws IOException {
        this.saveToFile(file, false);
    }

    protected void saveToFile(File file, boolean ordered) throws IOException {
        try {
            BufferedWriter configData = new BufferedWriter(new FileWriter(file));
            configData.write(this.toString(ordered));
            configData.flush();
            configData.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Something went wrong while trying to save " + file);
        }
    }

    public void parseConfigurationFile(File file) throws IOException {
        this.parseConfigurationFile(file, true);
    }

    public void parseConfigurationFile(File file, boolean toLowerCase) throws IOException {
        try {
            String orgTextLine;
            BufferedReader configData = new BufferedReader(new FileReader(file));
            String currentSectionTitle = null;
            Section currentSection = null;
            while ((orgTextLine = configData.readLine()) != null) {
                String textLine;
                orgTextLine = orgTextLine.trim();
                String string = textLine = toLowerCase ? orgTextLine.toLowerCase() : new String(orgTextLine);
                if (textLine.length() <= 0 || textLine.startsWith("#")) continue;
                if (textLine.startsWith("[")) {
                    int start = textLine.indexOf("[");
                    int end = textLine.lastIndexOf("]");
                    if (end == -1) {
                        this.parsingProblems.append("Parsing error in " + file + ", line: " + textLine + "\n");
                        continue;
                    }
                    currentSectionTitle = textLine.substring(start + 1, end);
                    if (this.sections.containsKey(currentSectionTitle)) {
                        currentSection = this.sections.get(currentSectionTitle);
                        continue;
                    }
                    currentSection = new Section(null, null, null);
                    this.sections.put(currentSectionTitle, currentSection);
                    continue;
                }
                if (currentSectionTitle != null) {
                    if (currentSectionTitle.equals(AUTOEXEC)) {
                        currentSection.addAutoexecItem(orgTextLine);
                        continue;
                    }
                    int end = textLine.indexOf("=");
                    if (end == -1) {
                        this.parsingProblems.append("Parsing error in " + file + ", line: " + textLine + "\n");
                        continue;
                    }
                    String name = textLine.substring(0, end).trim();
                    String value = textLine.substring(end + 1).trim();
                    if (currentSectionTitle.equals("gui") || currentSectionTitle.equals("database") || currentSectionTitle.equals("directory")) {
                        value = orgTextLine.substring(end + 1).trim();
                    }
                    currentSection.items.put(name, value);
                    continue;
                }
                this.parsingProblems.append("Parsing error (no section) in " + file + ", line: " + textLine + "\n");
            }
            configData.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IOException("Could not read " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            String msg = "Something went wrong while trying to read " + file;
            if (this.parsingProblems.length() > 0) {
                msg = String.valueOf(msg) + "\n" + this.getParsingProblems();
            }
            throw new IOException(msg);
        }
    }

    public boolean hasValue(String sectionTitle, String sectionItem) {
        return this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).items.containsKey(sectionItem);
    }

    public String getValue(String sectionTitle, String sectionItem) {
        String result = null;
        if (this.sections.containsKey(sectionTitle)) {
            result = this.sections.get((Object)sectionTitle).items.get(sectionItem);
        }
        if (result == null) {
            return "";
        }
        return result;
    }

    public int getIntValue(String sectionTitle, String sectionItem) {
        try {
            return Integer.parseInt(this.getValue(sectionTitle, sectionItem));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean getBooleanValue(String sectionTitle, String sectionItem) {
        return Boolean.valueOf(this.getValue(sectionTitle, sectionItem));
    }

    public void createSection(String sectionTitle) {
        if (!this.sections.containsKey(sectionTitle)) {
            this.sections.put(sectionTitle, new Section(null, null, null));
        }
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        if (this.sections.containsKey(sectionTitle)) {
            this.sections.get((Object)sectionTitle).items.put(sectionItem, value);
        }
    }

    public void setIntValue(String sectionTitle, String sectionItem, int value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setBooleanValue(String sectionTitle, String sectionItem, boolean value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void updateValue(String sectionTitle, String sectionItem, String value) {
        if (this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).items.containsKey(sectionItem)) {
            this.sections.get((Object)sectionTitle).items.put(sectionItem, value);
        }
    }

    public void removeSection(String title) {
        this.sections.remove(title);
    }

    public void removeValue(String sectionTitle, String sectionItem) {
        if (this.sections.containsKey(sectionTitle)) {
            Section sec = this.sections.get(sectionTitle);
            sec.items.remove(sectionItem);
            if (sec.items.isEmpty()) {
                this.sections.remove(sectionTitle);
            }
        }
    }

    public void substract(Configuration conf) {
        for (String key : conf.sections.keySet()) {
            if (!this.sections.containsKey(key)) continue;
            Section mysec = this.sections.get(key);
            mysec.substract(conf.sections.get(key));
            if (!mysec.items.isEmpty()) continue;
            this.sections.remove(key);
        }
    }

    public String[] getItems(String section) {
        return new TreeMap<String, String>(this.sections.get((Object)section).items).keySet().toArray(new String[0]);
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        String val = this.getValue(sectionTitle, sectionItem);
        if (val.length() <= 0) {
            return new String[0];
        }
        String[] res = val.split(" ");
        int i = 0;
        while (i < res.length) {
            res[i] = res[i].replaceAll("<space>", " ");
            ++i;
        }
        return res;
    }

    public String getMultilineValues(String sectionTitle, String sectionItem) {
        return StringUtils.StringArrayToString(this.getValues(sectionTitle, sectionItem));
    }

    public void setMultilineValues(String sectionTitle, String sectionItem, String values, String delimiter) {
        this.setValue(sectionTitle, sectionItem, values.replaceAll(" ", "<space>").replace(delimiter, " ").trim());
    }

    public int[] getIntValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToIntArray(this.getValue(sectionTitle, sectionItem));
    }

    public void setIntValues(String sectionTitle, String sectionItem, int[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.intArrayToString(values));
    }

    public boolean[] getBooleanValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToBooleanArray(this.getValue(sectionTitle, sectionItem));
    }

    public void setBooleanValues(String sectionTitle, String sectionItem, boolean[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.booleanArrayToString(values));
    }

    public void updateWithValuesFrom(Configuration conf) {
        for (String sectionTitle : conf.sections.keySet()) {
            String[] stringArray = conf.getItems(sectionTitle);
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String sectionItem = stringArray[n];
                this.setValue(sectionTitle, sectionItem, conf.getValue(sectionTitle, sectionItem));
                ++n;
            }
        }
    }

    public String toString(boolean ordered) {
        StringBuffer result = new StringBuffer();
        StringBuffer autoexec = new StringBuffer();
        for (String key : this.sections.keySet()) {
            if (!key.equals(AUTOEXEC)) {
                result.append("[" + key + "]\n");
                result.append(String.valueOf(this.sections.get(key).toString(ordered)) + "\n");
                continue;
            }
            autoexec.append("[" + key + "]\n");
            autoexec.append(this.sections.get(key).toString(false));
        }
        return String.valueOf(result.toString()) + autoexec.toString();
    }

    public boolean hasParsingProblems() {
        return this.parsingProblems.length() > 0;
    }

    public String getParsingProblems() {
        String result = this.parsingProblems.toString();
        this.parsingProblems = new StringBuffer();
        return result;
    }

    private final class Section {
        protected HashMap<String, String> items = new HashMap();

        private Section() {
        }

        private Section(Section sec) {
            this();
            for (String key : sec.items.keySet()) {
                this.items.put(new String(key), new String(sec.items.get(key)));
            }
        }

        private void addAutoexecItem(String value) {
            if (this.items.containsKey(Configuration.AUTOEXEC)) {
                this.items.put(Configuration.AUTOEXEC, String.valueOf(this.items.get(Configuration.AUTOEXEC)) + "\n" + value);
            } else {
                this.items.put(Configuration.AUTOEXEC, value);
            }
        }

        private void substract(Section sec) {
            for (String key : sec.items.keySet()) {
                if (!this.items.containsKey(key)) continue;
                String value = sec.items.get(key);
                String thisvalue = this.items.get(key);
                if (!thisvalue.equals(value)) continue;
                this.items.remove(key);
            }
        }

        private String toString(boolean ordered) {
            StringBuffer result = new StringBuffer();
            for (String key : ordered ? new TreeMap<String, String>(this.items).keySet() : this.items.keySet()) {
                if (!key.equals(Configuration.AUTOEXEC)) {
                    result.append(String.valueOf(key) + "=");
                }
                result.append(String.valueOf(this.items.get(key)) + "\n");
            }
            return result.toString();
        }

        /* synthetic */ Section(Section section, Section section2, Section section3) {
            this();
        }
    }
}

