/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class SWTImageManager {
    private static final HashMap<String, Image> imageMap = new HashMap();

    public static void dispose() {
        for (Image image : imageMap.values()) {
            image.dispose();
        }
        imageMap.clear();
    }

    public static Image getImage(String path) {
        Display display = Display.getCurrent();
        try {
            return new Image((Device)display, path);
        }
        catch (Exception e) {
            Image image = new Image((Device)display, 100, 100);
            GC gc = new GC((Drawable)image);
            gc.setBackground(display.getSystemColor(3));
            gc.fillRectangle(0, 0, 100, 100);
            gc.dispose();
            return image;
        }
    }

    public static Image getResizedImage(int height, String path) {
        Image image = imageMap.get(path);
        if (image == null) {
            Display display = Display.getCurrent();
            Image orgImage = SWTImageManager.getImage(path);
            int w = orgImage.getBounds().width;
            int h = orgImage.getBounds().height;
            double factor = (double)height / (double)h;
            int wf = (int)((double)w * factor);
            int hf = (int)((double)h * factor);
            image = new Image((Device)display, wf, hf);
            GC gc = new GC((Drawable)image);
            gc.setAntialias(1);
            gc.drawImage(orgImage, 0, 0, w, h, 0, 0, wf, hf);
            gc.dispose();
            imageMap.put(path, image);
        }
        return image;
    }
}

