/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.Autoexec;
import com.model.Configuration;
import com.model.Profile;
import com.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class MigrateThread
extends Thread {
    private String title;
    private File from;
    private int profileNumber;
    private StringBuffer messageLog;
    private Display display;
    private Text log;
    private ProgressBar progressBar;
    private Label profileLabel;
    private List<Profile> profilesList;

    public MigrateThread(File from, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.from = from;
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profileNumber = 0;
        try {
            Database db = Database.getInstance();
            this.profilesList = db.readProfilesList("GAM.TITLE");
            this.progressBar.setMaximum(this.profilesList.size());
        }
        catch (SQLException e) {
            this.profilesList = new ArrayList<Profile>();
            GeneralPurposeDialogs.warningMessage(log.getShell(), e.getMessage());
        }
    }

    public void run() {
        Database db = Database.getInstance();
        try {
            Iterator<Profile> it = this.profilesList.iterator();
            while (it.hasNext()) {
                this.messageLog = new StringBuffer();
                Profile prof = it.next();
                this.title = prof.getTitle();
                try {
                    File f;
                    File file = prof.getCanonicalConfFile();
                    Configuration profileConf = new Configuration(file);
                    Autoexec autoexec = new Autoexec(profileConf.getValue("autoexec", "autoexec"));
                    autoexec.makeRelative(this.from);
                    profileConf.setValue("autoexec", "autoexec", autoexec.toString(false));
                    profileConf.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(prof.getId()));
                    profileConf.saveToFile(file);
                    String newConfigPath = prof.getConfPathAndFile();
                    if (new File(prof.getConfPathAndFile()).isAbsolute() && !(f = FileUtils.makeRelativeTo(file, this.from)).isAbsolute()) {
                        newConfigPath = String.valueOf(FileUtils.DOSROOT_DIR) + f.getPath();
                    }
                    db.updateProfileConf(newConfigPath, prof.getCaptures(), prof.getId());
                    String setup = prof.getSetup();
                    String[] links = prof.getLinks();
                    if (!setup.equals("")) {
                        setup = FileUtils.makeRelativeTo(new File(setup), this.from).getPath();
                    }
                    int i = 0;
                    while (i < links.length) {
                        File f2;
                        if (links[i].toLowerCase().startsWith("file://")) {
                            links[i] = links[i].substring(7);
                        }
                        if (!(links[i].equals("") || links[i].contains("://") || (f2 = FileUtils.makeRelativeTo(new File(links[i]), this.from)).isAbsolute())) {
                            links[i] = String.valueOf(FileUtils.DOSROOT_DIR) + f2.getPath();
                        }
                        ++i;
                    }
                    db.updateProfileSetupAndLinks(setup, links, prof.getId());
                }
                catch (IOException e) {
                    this.messageLog.append(String.valueOf(e.getMessage()) + "\n");
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            MigrateThread.this.profileLabel.setText("Migrating " + MigrateThread.this.title + "...");
                            MigrateThread.this.profileLabel.pack();
                            MigrateThread.this.log.append(MigrateThread.this.messageLog.toString());
                            ProgressBar progressBar = MigrateThread.this.progressBar;
                            MigrateThread migrateThread = MigrateThread.this;
                            int n = migrateThread.profileNumber;
                            migrateThread.profileNumber = n + 1;
                            progressBar.setSelection(n);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (Exception se) {
            this.messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    MigrateThread.this.log.append(MigrateThread.this.messageLog.toString());
                }
            });
        }
    }
}

