/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditMountDialog;
import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import com.model.Mount;
import com.model.Settings;
import com.model.Template;
import com.model.conf.CompositeConfiguration;
import com.model.conf.Configuration;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    private static final String IPX = "ipx";
    private static final String SERIAL = "serial";
    private static final String SPEAKER = "speaker";
    private static final String MIDI = "midi";
    private static final String MIXER = "mixer";
    private static final String DOS = "dos";
    private static final String GLIDE = "glide";
    private static final String VSYNC = "vsync";
    private static final String VGA = "vga";
    private static final String RENDER = "render";
    private static final String SDL = "sdl";
    private static final String ENABLE = "Enable";
    private static final String SAMPLE_RATE = "Sample Rate";
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button reloadButton;
    protected Combo priority_active;
    protected Combo priority_inactive;
    protected Button waitonerror;
    protected Button exit;
    protected Text language;
    protected Text captures;
    protected Combo output;
    protected Combo frameskip;
    protected Combo scaler;
    protected Combo pixelshader;
    protected Button fulldouble;
    protected Button fullscreen;
    protected Combo fullresolution;
    protected Combo windowresolution;
    protected Button aspect;
    protected Text overscan;
    protected Combo svgachipset;
    protected Combo videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Button glide;
    protected Text glideport;
    protected Combo machine;
    protected Combo cpu_type;
    protected Combo core;
    protected Combo cycles;
    protected Combo cycles_up;
    protected Combo cycles_down;
    protected Button timesynched;
    protected Combo memsize;
    protected Button xms;
    protected Button ems;
    protected Combo umb;
    protected Button nosound;
    protected Combo rate;
    protected Combo blocksize;
    protected Combo prebuffer;
    protected Combo mpu401;
    protected Combo device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo mt32rate;
    protected Combo sbtype;
    protected Combo oplrate;
    protected Combo oplmode;
    protected Combo sbbase;
    protected Combo irq;
    protected Combo dma;
    protected Combo hdma;
    protected Button mixer;
    protected Button gus;
    protected Combo gusrate;
    protected Combo gusbase;
    protected Combo dma1;
    protected Combo dma2;
    protected Combo irq1;
    protected Combo irq2;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy;
    protected Combo tandyrate;
    protected Button disney;
    protected Button usescancodes;
    protected Text mapperfile;
    protected Text keyboard_layout;
    protected Text keyb;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed;
    protected Button autofire;
    protected Button swap34;
    protected Button buttonwrap;
    protected Text serial1;
    protected Text serial2;
    protected Text serial3;
    protected Text serial4;
    protected Button ipx;
    protected org.eclipse.swt.widgets.List mountingpoints;
    protected Button booterButton;
    protected Button dosButton;
    protected Group memoryGroup;
    protected Group associationGroup;
    protected Group miscGroup;
    protected Group executeGroup;
    protected TabItem infoTabItem;
    protected TabItem mountingTabItem;
    protected int dbversionIndex = -1;
    protected Shell shell;
    protected List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected CompositeConfiguration compConf;
    protected Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell parent) {
        super(parent, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e.getMessage());
            return false;
        }
        if (this.result == null) {
            this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
            this.compConf = new CompositeConfiguration(this.dbversionsList.get(this.dbversionIndex), true, this.getParent());
        } else {
            this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, ((Template)this.result).getdbversionId());
            this.compConf = new CompositeConfiguration(this.dbversionsList.get(this.dbversionIndex), (Template)this.result, true, this.getParent());
        }
        return true;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(610, 475);
        if (this.result == null) {
            this.shell.setText("Add Template");
        } else {
            this.shell.setText("Edit Template " + ((Template)this.result).getTitle() + " (" + ((Template)this.result).getId() + ")");
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        Button okButton = this.createOkCancelButtons();
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    if (EditTemplateDialog.this.setButton.isEnabled()) {
                        EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, true, false);
                    }
                    int templateId = EditTemplateDialog.this.dbase.addOrEditTemplate(EditTemplateDialog.this.title.getText(), EditTemplateDialog.this.compConf.getDbversionId(), EditTemplateDialog.this.defaultButton.getSelection(), EditTemplateDialog.this.result == null ? -1 : ((Template)EditTemplateDialog.this.result).getId());
                    EditTemplateDialog.this.compConf.setCompositeConf(EditTemplateDialog.this.getConfigurationBySettings());
                    EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), EditTemplateDialog.this.compConf.getDbversionId(), EditTemplateDialog.this.defaultButton.getSelection());
                    EditTemplateDialog.this.compConf.save((Template)EditTemplateDialog.this.result, EditTemplateDialog.this.shell);
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, e1.getMessage());
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result == null) {
            this.title.setFocus();
        } else {
            this.title.setText(((Template)this.result).getTitle());
            this.defaultButton.setSelection(((Template)this.result).isDefault());
        }
        this.enableSettingsByConfiguration();
        this.selectSettingsByConfiguration();
    }

    protected Button createOkCancelButtons() {
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new RowLayout());
        composite_7.setLayoutData((Object)"South");
        Button okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData((Object)rowData);
        okButton.setText("OK");
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData((Object)rowData_1);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.result = null;
                EditTemplateDialog.this.shell.close();
            }
        });
        return okButton;
    }

    protected void createMountingTab(TabFolder tabFolder) {
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText("Mounting");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.mountingTabItem.setControl((Control)composite);
        this.createMountingGroup(composite);
        this.createExecuteGroup(composite);
    }

    protected void createExecuteGroup(Composite composite) {
        this.executeGroup = new Group(composite, 0);
        this.executeGroup.setLayoutData((Object)new GridData());
        this.executeGroup.setText("Execute");
        GridLayout gridLayout_18 = new GridLayout();
        this.executeGroup.setLayout((Layout)gridLayout_18);
        this.dosButton = new Button((Composite)this.executeGroup, 16);
        this.dosButton.setText("DOS");
        Label label_1 = new Label((Composite)this.executeGroup, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.booterButton = new Button((Composite)this.executeGroup, 16);
        this.booterButton.setText("Booter");
    }

    protected void createMountingGroup(Composite composite) {
        Group mountGroup = new Group(composite, 0);
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mountGroup.setText("Mounting Overview");
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout((Layout)gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)mountGroup, 2560);
        GridData gridData_2 = new GridData(4, 4, true, false, 1, 3);
        this.mountingpoints.setLayoutData((Object)gridData_2);
        this.mountingpoints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddMount();
                } else {
                    EditTemplateDialog.this.doEditMount();
                }
            }
        });
        Button addButton = new Button((Composite)mountGroup, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.setText("Add");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doAddMount();
            }
        });
        Button editButton = new Button((Composite)mountGroup, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText("Edit");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doEditMount();
            }
        });
        Button removeButton = new Button((Composite)mountGroup, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doRemoveMount();
            }
        });
    }

    protected void createIOTab(TabFolder tabFolder) {
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText("I/O");
        Composite composite_5 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout((Layout)gridLayout_17);
        inputTabItem.setControl((Control)composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mouseGroup.setText("Mouse");
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout((Layout)gridLayout_13);
        Label autolockLabel = new Label((Composite)mouseGroup, 0);
        autolockLabel.setText("Autolock");
        this.autolock = new Button((Composite)mouseGroup, 32);
        Label sensitivityLabel = new Label((Composite)mouseGroup, 0);
        sensitivityLabel.setText("Sensitivity");
        this.sensitivity = new Combo((Composite)mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        keyboardGroup.setText("Keyboard");
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout((Layout)gridLayout_14);
        Label useScancodesLabel = new Label((Composite)keyboardGroup, 0);
        useScancodesLabel.setText("Use Scancodes");
        this.usescancodes = new Button((Composite)keyboardGroup, 32);
        Label mapperFileLabel = new Label((Composite)keyboardGroup, 0);
        mapperFileLabel.setText("Mapper File");
        this.mapperfile = new Text((Composite)keyboardGroup, 2048);
        this.mapperfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label layoutLabel = new Label((Composite)keyboardGroup, 0);
        layoutLabel.setText("Layout");
        this.keyboard_layout = new Text((Composite)keyboardGroup, 2048);
        this.keyboard_layout.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label keybLabel = new Label((Composite)keyboardGroup, 0);
        keybLabel.setText("Keyb command");
        this.keyb = new Text((Composite)keyboardGroup, 2048);
        this.keyb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        joystickGroup.setText("joystick");
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout((Layout)gridLayout_15);
        Label typeLabel_1 = new Label((Composite)joystickGroup, 0);
        typeLabel_1.setText("Type");
        this.joysticktype = new Combo((Composite)joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label timedLabel = new Label((Composite)joystickGroup, 0);
        timedLabel.setText("Timed emulation");
        this.timed = new Button((Composite)joystickGroup, 32);
        Label autofireLabel = new Label((Composite)joystickGroup, 0);
        autofireLabel.setText("Autofire");
        this.autofire = new Button((Composite)joystickGroup, 32);
        Label swapAxes3Label = new Label((Composite)joystickGroup, 0);
        swapAxes3Label.setText("Swap axes 3&&4");
        this.swap34 = new Button((Composite)joystickGroup, 32);
        Label buttonWrapLabel = new Label((Composite)joystickGroup, 0);
        buttonWrapLabel.setText("Button wrapping");
        this.buttonwrap = new Button((Composite)joystickGroup, 32);
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText("Modem");
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout((Layout)gridLayout_16);
        Label serial1Label = new Label((Composite)modemGroup, 0);
        serial1Label.setText("Serial 1");
        this.serial1 = new Text((Composite)modemGroup, 2048);
        this.serial1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial2Label = new Label((Composite)modemGroup, 0);
        serial2Label.setText("Serial 2");
        this.serial2 = new Text((Composite)modemGroup, 2048);
        this.serial2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial3Label = new Label((Composite)modemGroup, 0);
        serial3Label.setText("Serial 3");
        this.serial3 = new Text((Composite)modemGroup, 2048);
        this.serial3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label serial4Label = new Label((Composite)modemGroup, 0);
        serial4Label.setText("Serial 4");
        this.serial4 = new Text((Composite)modemGroup, 2048);
        this.serial4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        networkGroup.setText("Network");
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout((Layout)gridLayout_20);
        Label ipxLabel = new Label((Composite)networkGroup, 0);
        ipxLabel.setText("Enable IPX");
        this.ipx = new Button((Composite)networkGroup, 32);
        new Label(composite_5, 0);
    }

    protected void createAudioTab(TabFolder tabFolder) {
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText("Audio");
        Composite composite_4 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_9);
        audioTabItem.setControl((Control)composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout((Layout)gridLayout_6);
        generalGroup.setText("General");
        Label silentModeLabel = new Label((Composite)generalGroup, 0);
        silentModeLabel.setText("Silent Mode");
        this.nosound = new Button((Composite)generalGroup, 32);
        Label sampleRateLabel = new Label((Composite)generalGroup, 0);
        sampleRateLabel.setText(SAMPLE_RATE);
        this.rate = new Combo((Composite)generalGroup, 8);
        this.rate.setItems(this.settings.getValues("profile", "rate"));
        this.rate.setLayoutData((Object)new GridData());
        Label blockSizeLabel = new Label((Composite)generalGroup, 0);
        blockSizeLabel.setText("Block Size");
        this.blocksize = new Combo((Composite)generalGroup, 8);
        this.blocksize.setItems(this.settings.getValues("profile", "blocksize"));
        this.blocksize.setLayoutData((Object)new GridData());
        Label prebufferLabel = new Label((Composite)generalGroup, 0);
        prebufferLabel.setText("Prebuffer");
        this.prebuffer = new Combo((Composite)generalGroup, 0);
        this.prebuffer.setItems(this.settings.getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData((Object)new GridData(70, -1));
        Label mpu401Label = new Label((Composite)generalGroup, 0);
        mpu401Label.setText("MPU-401");
        this.mpu401 = new Combo((Composite)generalGroup, 8);
        this.mpu401.setItems(this.settings.getValues("profile", "mpu401"));
        this.mpu401.setLayoutData((Object)new GridData());
        Label midiDeviceLabel = new Label((Composite)generalGroup, 0);
        midiDeviceLabel.setText("Midi Device");
        this.device = new Combo((Composite)generalGroup, 8);
        this.device.setItems(this.settings.getValues("profile", "device"));
        this.device.setLayoutData((Object)new GridData());
        Label configLabel = new Label((Composite)generalGroup, 0);
        configLabel.setText("Config");
        this.midi_config = new Text((Composite)generalGroup, 2048);
        this.midi_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label mixerConfigLabel = new Label((Composite)generalGroup, 0);
        mixerConfigLabel.setText("Mixer command");
        this.mixer_config = new Text((Composite)generalGroup, 2048);
        this.mixer_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        soundblasterGroup.setText("Soundblaster");
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout((Layout)gridLayout_7);
        Label typeLabel = new Label((Composite)soundblasterGroup, 0);
        typeLabel.setText("Type");
        this.sbtype = new Combo((Composite)soundblasterGroup, 8);
        this.sbtype.setItems(this.settings.getValues("profile", "sbtype"));
        this.sbtype.setLayoutData((Object)new GridData());
        Label oplRateLabel = new Label((Composite)soundblasterGroup, 0);
        oplRateLabel.setText("OPL Rate");
        this.oplrate = new Combo((Composite)soundblasterGroup, 8);
        this.oplrate.setItems(this.settings.getValues("profile", "oplrate"));
        this.oplrate.setLayoutData((Object)new GridData());
        Label oplModeLabel = new Label((Composite)soundblasterGroup, 0);
        oplModeLabel.setLayoutData((Object)new GridData());
        oplModeLabel.setText("OPL Mode");
        this.oplmode = new Combo((Composite)soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getValues("profile", "oplmode"));
        this.oplmode.setLayoutData((Object)new GridData());
        Label addressLabel = new Label((Composite)soundblasterGroup, 0);
        addressLabel.setText("Address");
        this.sbbase = new Combo((Composite)soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getValues("profile", "sbbase"));
        this.sbbase.setLayoutData((Object)new GridData());
        Label irqLabel = new Label((Composite)soundblasterGroup, 0);
        irqLabel.setText("IRQ");
        this.irq = new Combo((Composite)soundblasterGroup, 8);
        this.irq.setItems(this.settings.getValues("profile", "irq"));
        this.irq.setLayoutData((Object)new GridData());
        Label dmaLabel = new Label((Composite)soundblasterGroup, 0);
        dmaLabel.setText("DMA");
        this.dma = new Combo((Composite)soundblasterGroup, 8);
        this.dma.setItems(this.settings.getValues("profile", "dma"));
        this.dma.setLayoutData((Object)new GridData());
        Label hdmaLabel = new Label((Composite)soundblasterGroup, 0);
        hdmaLabel.setLayoutData((Object)new GridData());
        hdmaLabel.setText("HDMA");
        this.hdma = new Combo((Composite)soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getValues("profile", "hdma"));
        this.hdma.setLayoutData((Object)new GridData());
        Label mixerLabel = new Label((Composite)soundblasterGroup, 0);
        mixerLabel.setText("Mixer");
        this.mixer = new Button((Composite)soundblasterGroup, 32);
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        gusGroup.setText("Gravis Ultrasound");
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout((Layout)gridLayout_8);
        Label enableLabel_1 = new Label((Composite)gusGroup, 0);
        enableLabel_1.setLayoutData((Object)new GridData());
        enableLabel_1.setText(ENABLE);
        this.gus = new Button((Composite)gusGroup, 32);
        this.gus.setLayoutData((Object)new GridData());
        Label sampleRateLabel_2 = new Label((Composite)gusGroup, 0);
        sampleRateLabel_2.setText(SAMPLE_RATE);
        this.gusrate = new Combo((Composite)gusGroup, 8);
        this.gusrate.setItems(this.settings.getValues("profile", "gusrate"));
        this.gusrate.setLayoutData((Object)new GridData());
        Label addressLabel_1 = new Label((Composite)gusGroup, 0);
        addressLabel_1.setText("Address");
        this.gusbase = new Combo((Composite)gusGroup, 8);
        this.gusbase.setItems(this.settings.getValues("profile", "gusbase"));
        this.gusbase.setLayoutData((Object)new GridData());
        Label irqLabel_1 = new Label((Composite)gusGroup, 0);
        irqLabel_1.setText("IRQ1");
        this.irq1 = new Combo((Composite)gusGroup, 8);
        this.irq1.setItems(this.settings.getValues("profile", "irq1"));
        this.irq1.setLayoutData((Object)new GridData());
        Label irq2Label = new Label((Composite)gusGroup, 0);
        irq2Label.setText("IRQ2");
        this.irq2 = new Combo((Composite)gusGroup, 8);
        this.irq2.setItems(this.settings.getValues("profile", "irq2"));
        this.irq2.setLayoutData((Object)new GridData());
        Label dmaLabel_1 = new Label((Composite)gusGroup, 0);
        dmaLabel_1.setText("DMA1");
        this.dma1 = new Combo((Composite)gusGroup, 8);
        this.dma1.setItems(this.settings.getValues("profile", "dma1"));
        this.dma1.setLayoutData((Object)new GridData());
        Label hdmaLabel_1 = new Label((Composite)gusGroup, 0);
        hdmaLabel_1.setLayoutData((Object)new GridData());
        hdmaLabel_1.setText("DMA2");
        this.dma2 = new Combo((Composite)gusGroup, 8);
        this.dma2.setItems(this.settings.getValues("profile", "dma2"));
        this.dma2.setLayoutData((Object)new GridData());
        Label ultradirLabel = new Label((Composite)gusGroup, 0);
        ultradirLabel.setText("Ultradir");
        this.ultradir = new Text((Composite)gusGroup, 2048);
        this.ultradir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        speakerGroup.setText("PC Speaker");
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout((Layout)gridLayout_10);
        Label enableLabel = new Label((Composite)speakerGroup, 0);
        enableLabel.setText(ENABLE);
        this.pcspeaker = new Button((Composite)speakerGroup, 32);
        Label sampleRateLabel_1 = new Label((Composite)speakerGroup, 0);
        sampleRateLabel_1.setText(SAMPLE_RATE);
        this.pcrate = new Combo((Composite)speakerGroup, 8);
        this.pcrate.setItems(this.settings.getValues("profile", "pcrate"));
        this.pcrate.setLayoutData((Object)new GridData());
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        tandyGroup.setText("Tandy");
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout((Layout)gridLayout_11);
        Label enableLabel_2 = new Label((Composite)tandyGroup, 0);
        enableLabel_2.setText(ENABLE);
        this.tandy = new Combo((Composite)tandyGroup, 8);
        this.tandy.setItems(this.settings.getValues("profile", "tandy"));
        this.tandy.setLayoutData((Object)new GridData());
        Label sampleLabel2 = new Label((Composite)tandyGroup, 0);
        sampleLabel2.setText(SAMPLE_RATE);
        this.tandyrate = new Combo((Composite)tandyGroup, 8);
        this.tandyrate.setItems(this.settings.getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData((Object)new GridData());
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        disneyGroup.setText("Miscellaneous");
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout((Layout)gridLayout_12);
        Label enableLabel_3 = new Label((Composite)disneyGroup, 0);
        enableLabel_3.setText("Enable Disney Sound Source");
        this.disney = new Button((Composite)disneyGroup, 32);
        Label mt32RateLabel = new Label((Composite)disneyGroup, 0);
        mt32RateLabel.setText("MT-32 Rate");
        this.mt32rate = new Combo((Composite)disneyGroup, 8);
        this.mt32rate.setItems(this.settings.getValues("profile", "mt32rate"));
        this.mt32rate.setLayoutData((Object)new GridData());
    }

    protected void createMachineTab(TabFolder tabFolder) {
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText("Machine");
        Composite composite_3 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout((Layout)gridLayout_2);
        machineTabItem.setControl((Control)composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText("cpu");
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout((Layout)gridLayout_3);
        Label machineLabel = new Label((Composite)cpuGroup, 0);
        machineLabel.setText("machine");
        this.machine = new Combo((Composite)cpuGroup, 8);
        this.machine.setItems(this.settings.getValues("profile", "machine"));
        this.machine.setLayoutData((Object)new GridData());
        this.machine.setVisibleItemCount(10);
        Label cputypeLabel = new Label((Composite)cpuGroup, 0);
        cputypeLabel.setText("CPU Type");
        this.cpu_type = new Combo((Composite)cpuGroup, 8);
        this.cpu_type.setItems(this.settings.getValues("profile", "cputype"));
        this.cpu_type.setLayoutData((Object)new GridData());
        this.cpu_type.setVisibleItemCount(10);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label coreLabel = new Label((Composite)cpuGroup, 0);
        coreLabel.setText("Core");
        this.core = new Combo((Composite)cpuGroup, 8);
        this.core.setItems(this.settings.getValues("profile", "core"));
        this.core.setLayoutData((Object)new GridData());
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label cyclesLabel = new Label((Composite)cpuGroup, 0);
        cyclesLabel.setText("Cycles");
        this.cycles = new Combo((Composite)cpuGroup, 0);
        this.cycles.setItems(this.settings.getValues("profile", "cycles"));
        this.cycles.setLayoutData((Object)new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        Label upLabel = new Label((Composite)cpuGroup, 0);
        upLabel.setLayoutData((Object)new GridData());
        upLabel.setText("Up");
        this.cycles_up = new Combo((Composite)cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData((Object)new GridData(75, -1));
        Label downLabel = new Label((Composite)cpuGroup, 0);
        downLabel.setLayoutData((Object)new GridData());
        downLabel.setText("Down");
        this.cycles_down = new Combo((Composite)cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData((Object)new GridData(75, -1));
        Label timesynchedLabel = new Label((Composite)cpuGroup, 0);
        timesynchedLabel.setText("Timesynched");
        this.timesynched = new Button((Composite)cpuGroup, 32);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        this.memoryGroup = new Group(composite_3, 0);
        this.memoryGroup.setText("Memory");
        this.memoryGroup.setLayoutData((Object)new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.memoryGroup.setLayout((Layout)gridLayout_4);
        Label sizeLabel = new Label((Composite)this.memoryGroup, 0);
        sizeLabel.setText("Size");
        this.memsize = new Combo((Composite)this.memoryGroup, 8);
        this.memsize.setItems(this.settings.getValues("profile", "memsize"));
        this.memsize.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label xmsLabel = new Label((Composite)this.memoryGroup, 0);
        xmsLabel.setText("XMS");
        this.xms = new Button((Composite)this.memoryGroup, 32);
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label emsLabel = new Label((Composite)this.memoryGroup, 0);
        emsLabel.setText("EMS");
        this.ems = new Button((Composite)this.memoryGroup, 32);
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label umbLabel = new Label((Composite)this.memoryGroup, 0);
        umbLabel.setText("UMB");
        this.umb = new Combo((Composite)this.memoryGroup, 8);
        this.umb.setItems(this.settings.getValues("profile", "umb"));
        this.umb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
    }

    protected void createDisplayTab(TabFolder tabFolder) {
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText("Display");
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_5);
        displayTabItem.setControl((Control)composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText("Output");
        this.output = new Combo(composite_2, 8);
        this.output.setItems(this.settings.getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText("Frameskip");
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(this.settings.getValues("profile", "frameskip"));
        this.frameskip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText("Scaler");
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(this.settings.getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label pixelshaderLabel = new Label(composite_2, 0);
        pixelshaderLabel.setLayoutData((Object)new GridData());
        pixelshaderLabel.setText("pixelshader");
        this.pixelshader = new Combo(composite_2, 8);
        this.pixelshader.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(15);
        this.pixelshader.setItems(this.settings.getValues("profile", "pixelshader"));
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText("Fullscreen");
        this.fullscreen = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBuffLabel = new Label(composite_2, 0);
        doubleBuffLabel.setText("Double Buffering");
        this.fulldouble = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText("Fullscreen Resolution");
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(this.settings.getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        Label windowResLabel = new Label(composite_2, 0);
        windowResLabel.setText("Window Resolution");
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(this.settings.getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        Label aspectLabel = new Label(composite_2, 0);
        aspectLabel.setText("Aspect Correction");
        this.aspect = new Button(composite_2, 32);
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label overscanLabel = new Label(composite_2, 0);
        overscanLabel.setText("Overscan");
        this.overscan = new Text(composite_2, 2048);
        this.overscan.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label svgaChipsetLabel = new Label(composite_2, 0);
        svgaChipsetLabel.setText("SVGA Chipset");
        this.svgachipset = new Combo(composite_2, 8);
        this.svgachipset.setItems(this.settings.getValues("profile", "svgachipset"));
        this.svgachipset.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label videoRamLabel = new Label(composite_2, 0);
        videoRamLabel.setText("Video RAM in KB");
        this.videoram = new Combo(composite_2, 8);
        this.videoram.setItems(this.settings.getValues("profile", "videoram"));
        this.videoram.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label vsyncModeLabel = new Label(composite_2, 0);
        vsyncModeLabel.setText("Vsync Mode");
        this.vsyncmode = new Combo(composite_2, 8);
        this.vsyncmode.setItems(this.settings.getValues("profile", "vsyncmode"));
        this.vsyncmode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label vsyncRateLabel = new Label(composite_2, 0);
        vsyncRateLabel.setLayoutData((Object)new GridData());
        vsyncRateLabel.setText("Vsync Rate");
        this.vsyncrate = new Text(composite_2, 2048);
        this.vsyncrate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label glideLabel = new Label(composite_2, 0);
        glideLabel.setText("Glide");
        this.glide = new Button(composite_2, 32);
        this.glide.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.glideport.setEnabled(EditTemplateDialog.this.glide.getSelection());
            }
        });
        Label glidePortLabel = new Label(composite_2, 0);
        glidePortLabel.setText("Glide port");
        this.glideport = new Text(composite_2, 2048);
        this.glideport.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createGeneralTab(TabFolder tabFolder) {
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText("General");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout((Layout)gridLayout_1);
        generalTabItem.setControl((Control)composite_1);
        this.associationGroup = new Group(composite_1, 0);
        this.associationGroup.setText("Association");
        this.associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.associationGroup.setLayout((Layout)gridLayout_4);
        Label dbversionLabel = new Label((Composite)this.associationGroup, 0);
        dbversionLabel.setText("Dosbox version");
        this.dbversion = new Combo((Composite)this.associationGroup, 8);
        this.dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(10);
        this.setButton = new Button((Composite)this.associationGroup, 0);
        this.setButton.setText("Set");
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, true, false);
            }
        });
        this.setButton.setEnabled(false);
        this.dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.setButton.setEnabled(true);
            }
        });
        this.reloadButton = new Button((Composite)this.associationGroup, 0);
        this.reloadButton.setText("Reload Settings");
        this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, false, false);
            }
        });
        this.miscGroup = new Group(composite_1, 0);
        this.miscGroup.setText("Miscellaneous");
        this.miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 3;
        this.miscGroup.setLayout((Layout)gridLayout_5);
        new Label((Composite)this.miscGroup, 0);
        Label activeLabel = new Label((Composite)this.miscGroup, 0);
        activeLabel.setText("Active");
        Label inactiveLabel = new Label((Composite)this.miscGroup, 0);
        inactiveLabel.setText("Inactive");
        Label priorityLabel = new Label((Composite)this.miscGroup, 0);
        priorityLabel.setText("Priority");
        this.priority_active = new Combo((Composite)this.miscGroup, 8);
        this.priority_active.setItems(this.settings.getValues("profile", "priority_active"));
        this.priority_active.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_inactive = new Combo((Composite)this.miscGroup, 8);
        this.priority_inactive.setItems(this.settings.getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label waitOnErrorLabel = new Label((Composite)this.miscGroup, 0);
        waitOnErrorLabel.setText("Wait On Error");
        this.waitonerror = new Button((Composite)this.miscGroup, 32);
        new Label((Composite)this.miscGroup, 0);
        Label exitLabel = new Label((Composite)this.miscGroup, 0);
        exitLabel.setText("Exit afterwards");
        this.exit = new Button((Composite)this.miscGroup, 32);
        new Label((Composite)this.miscGroup, 0);
        Label languageFileLabel = new Label((Composite)this.miscGroup, 0);
        languageFileLabel.setLayoutData((Object)new GridData());
        languageFileLabel.setText("Language File");
        this.language = new Text((Composite)this.miscGroup, 2048);
        this.language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label capturesLabel = new Label((Composite)this.miscGroup, 0);
        capturesLabel.setLayoutData((Object)new GridData());
        capturesLabel.setText("Captures");
        this.captures = new Text((Composite)this.miscGroup, 2048);
        this.captures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
    }

    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText("Info");
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText("Title");
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText("Default");
        this.defaultButton = new Button(composite, 32);
    }

    protected void selectSettingsByConfiguration() {
        Configuration conf = this.compConf.getCompositeConf();
        String priority = conf.getValue(SDL, "priority");
        String[] priorities = priority.split(",");
        if (priorities != null && priorities.length >= 2) {
            this.priority_active.setText(priorities[0]);
            this.priority_inactive.setText(priorities[1]);
        }
        EditTemplateDialog.setIfEnabled(conf, SDL, "waitonerror", (Control)this.waitonerror);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "language", (Control)this.language);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "captures", (Control)this.captures);
        EditTemplateDialog.setIfEnabled(conf, SDL, "output", (Control)this.output);
        EditTemplateDialog.setIfEnabled(conf, RENDER, "frameskip", (Control)this.frameskip);
        EditTemplateDialog.setIfEnabled(conf, RENDER, "scaler", (Control)this.scaler);
        EditTemplateDialog.setIfEnabled(conf, SDL, "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.setIfEnabled(conf, SDL, "fullscreen", (Control)this.fullscreen);
        EditTemplateDialog.setIfEnabled(conf, SDL, "fulldouble", (Control)this.fulldouble);
        EditTemplateDialog.setIfEnabled(conf, SDL, "fullresolution", (Control)this.fullresolution);
        EditTemplateDialog.setIfEnabled(conf, SDL, "windowresolution", (Control)this.windowresolution);
        EditTemplateDialog.setIfEnabled(conf, RENDER, "aspect", (Control)this.aspect);
        EditTemplateDialog.setIfEnabled(conf, SDL, "overscan", (Control)this.overscan);
        EditTemplateDialog.setIfEnabled(conf, VGA, "svgachipset", (Control)this.svgachipset);
        EditTemplateDialog.setIfEnabled(conf, VGA, "videoram", (Control)this.videoram);
        EditTemplateDialog.setIfEnabled(conf, VSYNC, "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.setIfEnabled(conf, VSYNC, "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.setIfEnabled(conf, GLIDE, GLIDE, (Control)this.glide);
        EditTemplateDialog.setIfEnabled(conf, GLIDE, "port", (Control)this.glideport);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "machine", (Control)this.machine);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "core", (Control)this.core);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycles", (Control)this.cycles);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycleup", (Control)this.cycles_up);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycledown", (Control)this.cycles_down);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "timesynched", (Control)this.timesynched);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "memsize", (Control)this.memsize);
        EditTemplateDialog.setIfEnabled(conf, DOS, "xms", (Control)this.xms);
        EditTemplateDialog.setIfEnabled(conf, DOS, "ems", (Control)this.ems);
        EditTemplateDialog.setIfEnabled(conf, DOS, "umb", (Control)this.umb);
        EditTemplateDialog.setIfEnabled(conf, MIXER, "nosound", (Control)this.nosound);
        EditTemplateDialog.setIfEnabled(conf, MIXER, "rate", (Control)this.rate);
        EditTemplateDialog.setIfEnabled(conf, MIDI, "mt32rate", (Control)this.mt32rate);
        EditTemplateDialog.setIfEnabled(conf, MIXER, "blocksize", (Control)this.blocksize);
        EditTemplateDialog.setIfEnabled(conf, MIXER, "prebuffer", (Control)this.prebuffer);
        EditTemplateDialog.setIfEnabled(conf, MIDI, "mpu401", (Control)this.mpu401);
        EditTemplateDialog.setIfEnabled(conf, MIDI, "device", (Control)this.device);
        EditTemplateDialog.setIfEnabled(conf, MIDI, "config", (Control)this.midi_config);
        if (conf.hasValue("sblaster", "sbtype")) {
            EditTemplateDialog.setIfEnabled(conf, "sblaster", "sbtype", (Control)this.sbtype);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "sblaster", "type", (Control)this.sbtype);
        }
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplmode", (Control)this.oplmode);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplrate", (Control)this.oplrate);
        if (conf.hasValue("sblaster", "sbbase")) {
            EditTemplateDialog.setIfEnabled(conf, "sblaster", "sbbase", (Control)this.sbbase);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "sblaster", "base", (Control)this.sbbase);
        }
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "irq", (Control)this.irq);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "dma", (Control)this.dma);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "hdma", (Control)this.hdma);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", MIXER, (Control)this.mixer);
        EditTemplateDialog.setIfEnabled(conf, "gus", "gus", (Control)this.gus);
        if (conf.hasValue("gus", "gusrate")) {
            EditTemplateDialog.setIfEnabled(conf, "gus", "gusrate", (Control)this.gusrate);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "gus", "rate", (Control)this.gusrate);
        }
        if (conf.hasValue("gus", "gusbase")) {
            EditTemplateDialog.setIfEnabled(conf, "gus", "gusbase", (Control)this.gusbase);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "gus", "base", (Control)this.gusbase);
        }
        EditTemplateDialog.setIfEnabled(conf, "gus", "irq1", (Control)this.irq1);
        EditTemplateDialog.setIfEnabled(conf, "gus", "irq2", (Control)this.irq2);
        EditTemplateDialog.setIfEnabled(conf, "gus", "dma1", (Control)this.dma1);
        EditTemplateDialog.setIfEnabled(conf, "gus", "dma2", (Control)this.dma2);
        EditTemplateDialog.setIfEnabled(conf, "gus", "ultradir", (Control)this.ultradir);
        EditTemplateDialog.setIfEnabled(conf, SPEAKER, "pcspeaker", (Control)this.pcspeaker);
        EditTemplateDialog.setIfEnabled(conf, SPEAKER, "pcrate", (Control)this.pcrate);
        EditTemplateDialog.setIfEnabled(conf, SPEAKER, "tandy", (Control)this.tandy);
        EditTemplateDialog.setIfEnabled(conf, SPEAKER, "tandyrate", (Control)this.tandyrate);
        EditTemplateDialog.setIfEnabled(conf, SPEAKER, "disney", (Control)this.disney);
        EditTemplateDialog.setIfEnabled(conf, SDL, "autolock", (Control)this.autolock);
        EditTemplateDialog.setIfEnabled(conf, SDL, "sensitivity", (Control)this.sensitivity);
        EditTemplateDialog.setIfEnabled(conf, SDL, "usescancodes", (Control)this.usescancodes);
        EditTemplateDialog.setIfEnabled(conf, SDL, "mapperfile", (Control)this.mapperfile);
        EditTemplateDialog.setIfEnabled(conf, DOS, "keyboardlayout", (Control)this.keyboard_layout);
        if (conf.hasValue("joystick", "joysticktype")) {
            EditTemplateDialog.setIfEnabled(conf, "joystick", "joysticktype", (Control)this.joysticktype);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "timed", (Control)this.timed);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "autofire", (Control)this.autofire);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "swap34", (Control)this.swap34);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "buttonwrap", (Control)this.buttonwrap);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "bios", "joysticktype", (Control)this.joysticktype);
        }
        EditTemplateDialog.setIfEnabled(conf, SERIAL, "serial1", (Control)this.serial1);
        EditTemplateDialog.setIfEnabled(conf, SERIAL, "serial2", (Control)this.serial2);
        EditTemplateDialog.setIfEnabled(conf, SERIAL, "serial3", (Control)this.serial3);
        EditTemplateDialog.setIfEnabled(conf, SERIAL, "serial4", (Control)this.serial4);
        EditTemplateDialog.setIfEnabled(conf, IPX, IPX, (Control)this.ipx);
        this.exit.setSelection(conf.isExit());
        this.mixer_config.setText(conf.getMixer());
        this.keyb.setText(conf.getKeyb());
        this.mountingpoints.setItems(conf.getMountingpoints());
        this.dosButton.setSelection(!conf.isBooter());
        this.booterButton.setSelection(conf.isBooter());
    }

    protected Configuration getConfigurationBySettings() {
        Configuration base = this.compConf.getBaseConf();
        Configuration conf = new Configuration(this.compConf.getCompositeConf(), false, null, false);
        conf.updateValue(SDL, "priority", String.valueOf(this.priority_active.getText()) + "," + this.priority_inactive.getText());
        conf.updateValue(SDL, "waitonerror", String.valueOf(this.waitonerror.getSelection()));
        conf.updateValue("dosbox", "language", this.language.getText());
        conf.updateValue("dosbox", "captures", this.captures.getText());
        conf.updateValue(SDL, "output", this.output.getText());
        conf.updateValue(RENDER, "frameskip", this.frameskip.getText());
        conf.updateValue(RENDER, "scaler", this.scaler.getText());
        conf.updateValue(SDL, "pixelshader", this.pixelshader.getText());
        conf.updateValue(SDL, "fullscreen", String.valueOf(this.fullscreen.getSelection()));
        conf.updateValue(SDL, "fulldouble", String.valueOf(this.fulldouble.getSelection()));
        conf.updateValue(SDL, "fullresolution", this.fullresolution.getText());
        conf.updateValue(SDL, "windowresolution", this.windowresolution.getText());
        conf.updateValue(RENDER, "aspect", String.valueOf(this.aspect.getSelection()));
        conf.updateValue(SDL, "overscan", this.overscan.getText());
        conf.updateValue(VGA, "svgachipset", this.svgachipset.getText());
        conf.updateValue(VGA, "videoram", this.videoram.getText());
        conf.updateValue(VSYNC, "vsyncmode", this.vsyncmode.getText());
        conf.updateValue(VSYNC, "vsyncrate", this.vsyncrate.getText());
        conf.updateValue(GLIDE, GLIDE, String.valueOf(this.glide.getSelection()));
        conf.updateValue(GLIDE, "port", this.glideport.getText());
        conf.updateValue("dosbox", "machine", this.machine.getText());
        conf.updateValue("cpu", "cputype", this.cpu_type.getText());
        conf.updateValue("cpu", "core", this.core.getText());
        conf.updateValue("cpu", "cycles", this.cycles.getText());
        conf.updateValue("cpu", "cycleup", this.cycles_up.getText());
        conf.updateValue("cpu", "cycledown", this.cycles_down.getText());
        conf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()));
        conf.updateValue("dosbox", "memsize", this.memsize.getText());
        conf.updateValue(DOS, "xms", String.valueOf(this.xms.getSelection()));
        conf.updateValue(DOS, "ems", String.valueOf(this.ems.getSelection()));
        conf.updateValue(DOS, "umb", this.umb.getText());
        conf.updateValue(MIXER, "nosound", String.valueOf(this.nosound.getSelection()));
        conf.updateValue(MIXER, "rate", this.rate.getText());
        conf.updateValue(MIDI, "mt32rate", this.mt32rate.getText());
        conf.updateValue(MIXER, "blocksize", this.blocksize.getText());
        conf.updateValue(MIXER, "prebuffer", this.prebuffer.getText());
        conf.updateValue(MIDI, "mpu401", this.mpu401.getText());
        conf.updateValue(MIDI, "device", this.device.getText());
        conf.updateValue(MIDI, "config", this.midi_config.getText());
        if (base.hasValue("sblaster", "sbtype")) {
            conf.updateValue("sblaster", "sbtype", this.sbtype.getText());
        } else {
            conf.updateValue("sblaster", "type", this.sbtype.getText());
        }
        conf.updateValue("sblaster", "oplmode", this.oplmode.getText());
        conf.updateValue("sblaster", "oplrate", this.oplrate.getText());
        if (base.hasValue("sblaster", "sbbase")) {
            conf.updateValue("sblaster", "sbbase", this.sbbase.getText());
        } else {
            conf.updateValue("sblaster", "base", this.sbbase.getText());
        }
        conf.updateValue("sblaster", "sbbase", this.sbbase.getText());
        conf.updateValue("sblaster", "irq", this.irq.getText());
        conf.updateValue("sblaster", "dma", this.dma.getText());
        conf.updateValue("sblaster", "hdma", this.hdma.getText());
        conf.updateValue("sblaster", MIXER, String.valueOf(this.mixer.getSelection()));
        conf.updateValue("gus", "gus", String.valueOf(this.gus.getSelection()));
        if (base.hasValue("gus", "gusrate")) {
            conf.updateValue("gus", "gusrate", this.gusrate.getText());
        } else {
            conf.updateValue("gus", "rate", this.gusrate.getText());
        }
        if (base.hasValue("gus", "gusbase")) {
            conf.updateValue("gus", "gusbase", this.gusbase.getText());
        } else {
            conf.updateValue("gus", "base", this.gusbase.getText());
        }
        conf.updateValue("gus", "irq1", this.irq1.getText());
        conf.updateValue("gus", "irq2", this.irq2.getText());
        conf.updateValue("gus", "dma1", this.dma1.getText());
        conf.updateValue("gus", "dma2", this.dma2.getText());
        conf.updateValue("gus", "ultradir", this.ultradir.getText());
        conf.updateValue(SPEAKER, "pcspeaker", String.valueOf(this.pcspeaker.getSelection()));
        conf.updateValue(SPEAKER, "pcrate", this.pcrate.getText());
        conf.updateValue(SPEAKER, "tandy", this.tandy.getText());
        conf.updateValue(SPEAKER, "tandyrate", this.tandyrate.getText());
        conf.updateValue(SPEAKER, "disney", String.valueOf(this.disney.getSelection()));
        conf.updateValue(SDL, "autolock", String.valueOf(this.autolock.getSelection()));
        conf.updateValue(SDL, "sensitivity", this.sensitivity.getText());
        conf.updateValue(SDL, "usescancodes", String.valueOf(this.usescancodes.getSelection()));
        conf.updateValue(SDL, "mapperfile", this.mapperfile.getText());
        conf.updateValue(DOS, "keyboardlayout", this.keyboard_layout.getText());
        if (base.hasValue("joystick", "joysticktype")) {
            conf.updateValue("joystick", "joysticktype", this.joysticktype.getText());
            conf.updateValue("joystick", "timed", String.valueOf(this.timed.getSelection()));
            conf.updateValue("joystick", "autofire", String.valueOf(this.autofire.getSelection()));
            conf.updateValue("joystick", "swap34", String.valueOf(this.swap34.getSelection()));
            conf.updateValue("joystick", "buttonwrap", String.valueOf(this.buttonwrap.getSelection()));
        } else {
            conf.updateValue("bios", "joysticktype", this.joysticktype.getText());
        }
        conf.updateValue(SERIAL, "serial1", this.serial1.getText());
        conf.updateValue(SERIAL, "serial2", this.serial2.getText());
        conf.updateValue(SERIAL, "serial3", this.serial3.getText());
        conf.updateValue(SERIAL, "serial4", this.serial4.getText());
        conf.updateValue(IPX, IPX, String.valueOf(this.ipx.getSelection()));
        conf.setAutoexecSettings(this.exit.getSelection(), this.mixer_config.getText(), this.keyb.getText(), this.booterButton.getSelection());
        return conf;
    }

    protected void doAddMount() {
        EditMountDialog addMountDialog = new EditMountDialog(this.shell);
        try {
            addMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(this.booterButton.getSelection(), this.mountingpoints.getItems()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            this.mountingpoints.setItems(this.compConf.addMount(mount));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(sel));
            String mount = (String)editMountDialog.open();
            if (mount != null) {
                this.mountingpoints.setItems(this.compConf.editMount(sel, mount));
                if (this.mountingpoints.getItemCount() == mounts) {
                    this.mountingpoints.select(sel);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            this.mountingpoints.select(sel);
        }
        if (sel != -1) {
            this.mountingpoints.setItems(this.compConf.removeMount(sel));
            if (this.mountingpoints.getItemCount() == mounts) {
                this.mountingpoints.select(sel);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void enableSettingsByConfiguration() {
        Configuration conf = this.compConf.getBaseConf();
        if (conf.hasValue("cpu", "cputype")) {
            this.machine.setItems(this.settings.getValues("profile", "machine073"));
        } else {
            this.machine.setItems(this.settings.getValues("profile", "machine"));
        }
        EditTemplateDialog.enableDisableControl(conf, "cpu", "cputype", (Control)this.cpu_type, true);
        EditTemplateDialog.enableDisableControl(conf, SDL, "pixelshader", (Control)this.pixelshader, true);
        EditTemplateDialog.enableDisableControl(conf, SDL, "overscan", (Control)this.overscan, true);
        EditTemplateDialog.enableDisableControl(conf, VGA, "svgachipset", (Control)this.svgachipset, true);
        EditTemplateDialog.enableDisableControl(conf, VGA, "videoram", (Control)this.videoram, true);
        EditTemplateDialog.enableDisableControl(conf, VSYNC, "vsyncmode", (Control)this.vsyncmode, true);
        EditTemplateDialog.enableDisableControl(conf, VSYNC, "vsyncrate", (Control)this.vsyncrate, true);
        EditTemplateDialog.enableDisableControl(conf, GLIDE, GLIDE, (Control)this.glide, true);
        EditTemplateDialog.enableDisableControl(conf, GLIDE, "port", (Control)this.glideport, this.glide.getSelection());
        EditTemplateDialog.enableDisableControl(conf, "cpu", "timesynched", (Control)this.timesynched, true);
        EditTemplateDialog.enableDisableControl(conf, MIDI, "mt32rate", (Control)this.mt32rate, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "timed", (Control)this.timed, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "autofire", (Control)this.autofire, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "swap34", (Control)this.swap34, true);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "buttonwrap", (Control)this.buttonwrap, true);
        EditTemplateDialog.enableDisableControl(conf, DOS, "keyboardlayout", (Control)this.keyboard_layout, true);
    }

    protected void doLoadTemplateConf(Button setButton, boolean keepValues, boolean isTemplate) {
        this.compConf.setCompositeConf(this.getConfigurationBySettings());
        CompositeConfiguration newCompConf = this.obtainNewConf(keepValues, isTemplate);
        if (newCompConf.getCompositeConf() == null) {
            GeneralPurposeDialogs.infoMessage(this.shell, "Could not load settings, so nothing was changed.");
        } else {
            this.compConf = newCompConf;
            this.enableSettingsByConfiguration();
            this.selectSettingsByConfiguration();
            setButton.setEnabled(false);
        }
    }

    protected CompositeConfiguration obtainNewConf(boolean keepValues, boolean isTemplate) {
        return new CompositeConfiguration(this.compConf, this.dbversionsList.get(this.dbversion.getSelectionIndex()), keepValues, true, this.shell);
    }

    protected static void enableDisableControl(Configuration dbConf, String section, String item, Control control, boolean extraCondition) {
        control.setEnabled(dbConf.hasValue(section, item) && extraCondition);
    }

    protected static void setIfEnabled(Configuration conf, String section, String item, Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                ((Text)control).setText(conf.getValue(section, item));
            } else if (control instanceof Combo) {
                ((Combo)control).setText(conf.getValue(section, item));
            } else if (control instanceof Button) {
                ((Button)control).setSelection(conf.getBooleanValue(section, item));
            }
        }
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError("You must enter a template title", (Control)this.title, this.infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

