/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.connect.Messaging;
import com.db.Database;
import com.gui.DFendImportDialog;
import com.gui.EditDosboxVersionDialog;
import com.gui.EditProfileDialog;
import com.gui.EditTemplateDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.MigrateDialog;
import com.gui.SettingsDialog;
import com.gui.Thumb;
import com.model.DosboxVersion;
import com.model.OrderingVector;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.swtdesigner.SWTImageManager;
import com.util.FileUtils;
import com.util.PlatformUtils;
import com.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

public final class MainWindow {
    public static final String PROGRAM_NAME = "DOSBox Game Launcher v0.63";
    private static final String REMOVE = "Remove";
    public static final int RO_COLUMN_NAMES = 10;
    public static final int EDIT_COLUMN_NAMES = 10;
    public static String[] columnNames;
    private Display display;
    private Shell shell;
    private OrderingVector orderingVector = null;
    private List<Profile> profilesList;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private Database dbase = null;
    private Settings settings = null;
    private File currentThumbFile = null;
    private int thumbHeight;
    private int[] columnIds;
    private Table template_table;
    private Table dbversion_table;
    private Table profile_table;
    private Text notesField;
    private ToolBar thumbsToolBar;
    private Link[] link;
    private Menu runWithSubMenu;
    private Menu setupWithSubMenu;

    public static void main(String[] args) {
        try {
            MainWindow window = new MainWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.dbase = Database.getInstance();
        this.settings = Settings.getInstance();
        this.display = Display.getDefault();
        this.createContents();
        Messaging mess = null;
        if (this.settings.getBooleanValue("communication", "port_enabled")) {
            mess = new Messaging(this.settings.getIntValue("communication", "port"), this);
            mess.start();
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        SWTImageManager.dispose();
        this.display.dispose();
        if (mess != null) {
            mess.close();
        }
        try {
            this.settings.save();
        }
        catch (IOException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        try {
            this.dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createContents() {
        this.initColumnIds();
        this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
        this.shell = new Shell();
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                boolean isMaximized = MainWindow.this.shell.getMaximized();
                if (!isMaximized) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "width", rec.width);
                    MainWindow.this.settings.setIntValue("gui", "height", rec.height);
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
                MainWindow.this.settings.setBooleanValue("gui", "maximized", isMaximized);
            }
        });
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent event) {
                if (!MainWindow.this.shell.getMaximized()) {
                    Rectangle rec = MainWindow.this.shell.getBounds();
                    MainWindow.this.settings.setIntValue("gui", "x", rec.x);
                    MainWindow.this.settings.setIntValue("gui", "y", rec.y);
                }
            }
        });
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setMaximized(this.settings.getBooleanValue("gui", "maximized"));
        this.shell.setLocation(this.settings.getIntValue("gui", "x"), this.settings.getIntValue("gui", "y"));
        this.shell.setSize(this.settings.getIntValue("gui", "width"), this.settings.getIntValue("gui", "height"));
        this.shell.setText(PROGRAM_NAME);
        Menu menu = new Menu((Decorations)this.shell, 2);
        this.shell.setMenuBar(menu);
        MenuItem fileMenuItem = new MenuItem(menu, 64);
        fileMenuItem.setText("File");
        Menu menu_1 = new Menu(fileMenuItem);
        fileMenuItem.setMenu(menu_1);
        if (PlatformUtils.IS_WINDOWS) {
            MenuItem dfendImportItem = new MenuItem(menu_1, 0);
            dfendImportItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MainWindow.this.doDFendImport();
                }
            });
            dfendImportItem.setText("Import D-Fend Profiles");
            new MenuItem(menu_1, 2);
        }
        MenuItem migrateMenuItem = new MenuItem(menu_1, 0);
        migrateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doMigrate();
            }
        });
        migrateMenuItem.setText("Migrate Profiles");
        MenuItem confImportItem = new MenuItem(menu_1, 0);
        confImportItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doImportConfigfile();
            }
        });
        confImportItem.setText("Import Profile");
        new MenuItem(menu_1, 2);
        MenuItem settingsMenuItem = new MenuItem(menu_1, 0);
        settingsMenuItem.setText("Adjust Settings");
        settingsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doOpenSettingsDialog();
            }
        });
        MenuItem exitMenuItem = new MenuItem(menu_1, 0);
        exitMenuItem.setText("Exit");
        exitMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.shell.close();
            }
        });
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem profilesTabItem = new TabItem(tabFolder, 0);
        profilesTabItem.setText("Profiles");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new BorderLayout(0, 0));
        profilesTabItem.setControl((Control)composite);
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData((Object)"North");
        SelectionAdapter addProfileAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddProfile();
            }
        };
        SelectionAdapter editProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditProfile();
            }
        };
        SelectionAdapter removeProfAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveProfile();
            }
        };
        ToolItem newItemToolItem = new ToolItem(toolBar, 8);
        newItemToolItem.setText("Add profile");
        newItemToolItem.addSelectionListener((SelectionListener)addProfileAdapter);
        ToolItem newItemToolItem_2 = new ToolItem(toolBar, 8);
        newItemToolItem_2.setText("Edit Profile");
        newItemToolItem_2.addSelectionListener((SelectionListener)editProfAdapter);
        ToolItem newItemToolItem_1 = new ToolItem(toolBar, 8);
        newItemToolItem_1.setText("Remove profile");
        newItemToolItem_1.addSelectionListener((SelectionListener)removeProfAdapter);
        final SashForm sashForm = new SashForm(composite, 0);
        this.profile_table = new Table((Composite)sashForm, 67584);
        Composite informationGroup = new Composite((Composite)sashForm, 0);
        informationGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValues("gui", "sashweights", sashForm.getWeights());
            }
        });
        informationGroup.setLayout((Layout)new BorderLayout(0, 0));
        this.notesField = new Text(informationGroup, 2634);
        Composite composite_2 = new Composite(informationGroup, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 1;
        composite_2.setLayout((Layout)gridLayout);
        composite_2.setLayoutData((Object)"South");
        this.link = new Link[4];
        int i = 0;
        while (i < this.link.length) {
            this.link[i] = new Link(composite_2, 0);
            this.link[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.link[i].setText(" ");
            this.link[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PlatformUtils.openForBrowsing(event.text);
                }
            });
            ++i;
        }
        this.thumbHeight = this.settings.getIntValue("gui", "screenshotsheight");
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2304);
        scrolledComposite.setMinHeight(this.thumbHeight + 20);
        scrolledComposite.setLayoutData((Object)"South");
        this.thumbsToolBar = new ToolBar((Composite)scrolledComposite, 0);
        this.thumbsToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                MainWindow.this.currentThumbFile = new File(MainWindow.this.thumbsToolBar.getItem(new Point(event.x, event.y)).getToolTipText());
            }
        });
        scrolledComposite.setContent((Control)this.thumbsToolBar);
        Menu menu_thumb = new Menu((Control)this.thumbsToolBar);
        this.thumbsToolBar.setMenu(menu_thumb);
        MenuItem thumbMenuItem1 = new MenuItem(menu_thumb, 0);
        thumbMenuItem1.setText(REMOVE);
        thumbMenuItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveThumb();
            }
        });
        new MenuItem(menu_thumb, 2);
        MenuItem thumbMenuItem2 = new MenuItem(menu_thumb, 0);
        thumbMenuItem2.setText("Open folder");
        thumbMenuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUtils.openDirForViewing(MainWindow.this.currentThumbFile.getParentFile());
            }
        });
        MenuItem thumbMenuItem3 = new MenuItem(menu_thumb, 0);
        thumbMenuItem3.setText("Refresh");
        thumbMenuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTImageManager.dispose();
                MainWindow.this.displayProfileInformation();
            }
        });
        this.profile_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveProfile();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddProfile();
                } else if (event.keyCode == 0x100000B) {
                    MainWindow.this.doEditProfile(true);
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleFavoriteProfile();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 100) {
                    MainWindow.this.doDuplicateProfile();
                }
            }
        });
        this.profile_table.setLayoutData((Object)"West");
        this.profile_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditProfile();
                } else if (event.stateMask == 131072 && event.detail == 4) {
                    MainWindow.this.doRunProfile(true);
                } else if (event.detail == 4) {
                    MainWindow.this.doRunProfile(false);
                }
            }
        });
        this.profile_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunProfile(false);
            }
        });
        this.profile_table.setLinesVisible(true);
        this.profile_table.setHeaderVisible(true);
        int i2 = 0;
        while (i2 < this.columnIds.length) {
            this.addProfileColumn(columnNames[this.columnIds[i2]], i2);
            ++i2;
        }
        this.profile_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.displayProfileInformation();
            }
        });
        Menu menu_2 = new Menu((Control)this.profile_table);
        this.profile_table.setMenu(menu_2);
        MenuItem runMenuItem = new MenuItem(menu_2, 0);
        runMenuItem.setText("Run");
        runMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunProfile(false);
            }
        });
        MenuItem runWithMenuItem = new MenuItem(menu_2, 64);
        runWithMenuItem.setText("Run with");
        this.runWithSubMenu = new Menu(runWithMenuItem);
        runWithMenuItem.setMenu(this.runWithSubMenu);
        this.updateProfileDbversionsSubmenu();
        final MenuItem setupMenuItem = new MenuItem(menu_2, 0);
        setupMenuItem.setText("Setup");
        setupMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunProfile(true);
            }
        });
        final MenuItem setupWithMenuItem = new MenuItem(menu_2, 64);
        setupWithMenuItem.setText("Setup with");
        this.setupWithSubMenu = new Menu(setupWithMenuItem);
        setupWithMenuItem.setMenu(this.setupWithSubMenu);
        this.updateSetupDbversionsSubmenu();
        new MenuItem(menu_2, 2);
        MenuItem addMenuItem = new MenuItem(menu_2, 0);
        addMenuItem.setText("Add");
        addMenuItem.addSelectionListener((SelectionListener)addProfileAdapter);
        MenuItem editMenuItem = new MenuItem(menu_2, 0);
        editMenuItem.setText("Edit");
        editMenuItem.addSelectionListener((SelectionListener)editProfAdapter);
        MenuItem duplicateMenuItem = new MenuItem(menu_2, 0);
        duplicateMenuItem.setText("Duplicate");
        duplicateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doDuplicateProfile();
            }
        });
        MenuItem removeMenuItem = new MenuItem(menu_2, 0);
        removeMenuItem.setText(REMOVE);
        removeMenuItem.addSelectionListener((SelectionListener)removeProfAdapter);
        new MenuItem(menu_2, 2);
        MenuItem toggleMenuItem = new MenuItem(menu_2, 0);
        toggleMenuItem.setText("Toggle favorite");
        toggleMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleFavoriteProfile();
            }
        });
        if (PlatformUtils.IS_WINDOWS) {
            new MenuItem(menu_2, 2);
            MenuItem shortcutMenuItem = new MenuItem(menu_2, 0);
            shortcutMenuItem.setText("Create shortcut");
            shortcutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MainWindow.this.doCreateShortcut();
                }
            });
        }
        menu_2.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                if (MainWindow.this.profile_table.getSelectionIndex() != -1) {
                    boolean hasSetup = ((Profile)MainWindow.this.profilesList.get(MainWindow.this.profile_table.getSelectionIndex())).hasSetup();
                    setupMenuItem.setEnabled(hasSetup);
                    setupWithMenuItem.setEnabled(hasSetup);
                }
            }
        });
        sashForm.setWeights(this.settings.getIntValues("gui", "sashweights"));
        TabItem dosboxTabItem = new TabItem(tabFolder, 0);
        dosboxTabItem.setText("DOSBox versions");
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        dosboxTabItem.setControl((Control)composite_1);
        ToolBar toolBar_1 = new ToolBar(composite_1, 0);
        toolBar_1.setLayoutData((Object)"North");
        SelectionAdapter addDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddDosboxVersion();
            }
        };
        SelectionAdapter editDosboxAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditDosboxVersion();
            }
        };
        SelectionAdapter removeDbAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveDosboxVersion();
            }
        };
        ToolItem newItemToolItem_3 = new ToolItem(toolBar_1, 8);
        newItemToolItem_3.addSelectionListener((SelectionListener)addDosboxAdapter);
        newItemToolItem_3.setText("Add version");
        ToolItem newItemToolItem_4 = new ToolItem(toolBar_1, 8);
        newItemToolItem_4.addSelectionListener((SelectionListener)editDosboxAdapter);
        newItemToolItem_4.setText("Edit version");
        ToolItem newItemToolItem_5 = new ToolItem(toolBar_1, 8);
        newItemToolItem_5.addSelectionListener((SelectionListener)removeDbAdapter);
        newItemToolItem_5.setText("Remove version");
        this.dbversion_table = new Table(composite_1, 67584);
        this.dbversion_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveDosboxVersion();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddDosboxVersion();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultVersion();
                }
            }
        });
        this.dbversion_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditDosboxVersion();
                } else if (event.detail == 4) {
                    MainWindow.this.doRunDosbox();
                }
            }
        });
        this.dbversion_table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MainWindow.this.doRunDosbox();
            }
        });
        this.dbversion_table.setLinesVisible(true);
        this.dbversion_table.setHeaderVisible(true);
        this.addDBColumn("Title", 0);
        this.addDBColumn("Version", 1);
        this.addDBColumn("Path", 2);
        this.addDBColumn("Default", 3);
        this.addDBColumn("ID", 4);
        Menu menu_4 = new Menu((Control)this.dbversion_table);
        this.dbversion_table.setMenu(menu_4);
        MenuItem runDBMenuItem = new MenuItem(menu_4, 0);
        runDBMenuItem.setText("Run");
        runDBMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRunDosbox();
            }
        });
        new MenuItem(menu_4, 2);
        MenuItem addDBMenuItem = new MenuItem(menu_4, 0);
        addDBMenuItem.setText("Add");
        addDBMenuItem.addSelectionListener((SelectionListener)addDosboxAdapter);
        MenuItem editDBMenuItem = new MenuItem(menu_4, 0);
        editDBMenuItem.setText("Edit");
        editDBMenuItem.addSelectionListener((SelectionListener)editDosboxAdapter);
        MenuItem removeDBMenuItem = new MenuItem(menu_4, 0);
        removeDBMenuItem.setText(REMOVE);
        removeDBMenuItem.addSelectionListener((SelectionListener)removeDbAdapter);
        new MenuItem(menu_4, 2);
        MenuItem toggleDefaultItem = new MenuItem(menu_4, 0);
        toggleDefaultItem.setText("Toggle default");
        toggleDefaultItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultVersion();
            }
        });
        new MenuItem(menu_4, 2);
        MenuItem openFolderItem = new MenuItem(menu_4, 0);
        openFolderItem.setText("Open folder");
        openFolderItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = MainWindow.this.dbversion_table.getSelectionIndex();
                if (index != -1) {
                    PlatformUtils.openDirForViewing(((DosboxVersion)MainWindow.this.dbversionsList.get(index)).getCanonicalConfFile().getParentFile());
                }
            }
        });
        TabItem templatesTabItem = new TabItem(tabFolder, 0);
        templatesTabItem.setText("Templates");
        Composite composite_1_1 = new Composite((Composite)tabFolder, 0);
        composite_1_1.setLayout((Layout)new BorderLayout(0, 0));
        templatesTabItem.setControl((Control)composite_1_1);
        ToolBar toolBar_1_1 = new ToolBar(composite_1_1, 0);
        toolBar_1_1.setLayoutData((Object)"North");
        SelectionAdapter addTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doAddTemplate();
            }
        };
        SelectionAdapter editTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doEditTemplate();
            }
        };
        SelectionAdapter remTemplAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doRemoveTemplate();
            }
        };
        ToolItem newItemToolItem_6 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_6.setText("Add template");
        newItemToolItem_6.addSelectionListener((SelectionListener)addTemplAdapter);
        ToolItem newItemToolItem_7 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_7.setText("Edit template");
        newItemToolItem_7.addSelectionListener((SelectionListener)editTemplAdapter);
        ToolItem newItemToolItem_8 = new ToolItem(toolBar_1_1, 8);
        newItemToolItem_8.setText("Remove template");
        newItemToolItem_8.addSelectionListener((SelectionListener)remTemplAdapter);
        this.template_table = new Table(composite_1_1, 67584);
        this.template_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MainWindow.this.doRemoveTemplate();
                } else if (event.keyCode == 0x1000009) {
                    MainWindow.this.doAddTemplate();
                } else if (event.stateMask == 262144 && Character.toLowerCase(event.keyCode) == 109) {
                    MainWindow.this.doToggleDefaultTemplate();
                }
            }
        });
        this.template_table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.stateMask == 262144 && event.detail == 4) {
                    MainWindow.this.doEditTemplate();
                }
            }
        });
        this.template_table.setLinesVisible(true);
        this.template_table.setHeaderVisible(true);
        this.addTemplateColumn("Title", 0);
        this.addTemplateColumn("Default", 1);
        Menu menu_3 = new Menu((Control)this.template_table);
        this.template_table.setMenu(menu_3);
        MenuItem addTemplItem = new MenuItem(menu_3, 0);
        addTemplItem.setText("Add");
        addTemplItem.addSelectionListener((SelectionListener)addTemplAdapter);
        MenuItem editTemplItem = new MenuItem(menu_3, 0);
        editTemplItem.setText("Edit");
        editTemplItem.addSelectionListener((SelectionListener)editTemplAdapter);
        MenuItem removeTemplItem = new MenuItem(menu_3, 0);
        removeTemplItem.setText(REMOVE);
        removeTemplItem.addSelectionListener((SelectionListener)remTemplAdapter);
        new MenuItem(menu_3, 2);
        MenuItem toggleTemplItem = new MenuItem(menu_3, 0);
        toggleTemplItem.setText("Toggle default");
        toggleTemplItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doToggleDefaultTemplate();
            }
        });
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        for (DosboxVersion dbversion : this.dbversionsList) {
            this.addDosboxVersionToTable(dbversion);
        }
        for (Template template : this.templatesList) {
            this.addTemplateToTable(template);
        }
        this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
        this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
        this.profile_table.setColumnOrder(this.settings.getIntValues("gui", "columnorder"));
        this.profile_table.setSelection(this.settings.getIntValue("gui", "selectedprofile"));
        this.profile_table.setFocus();
        this.displayProfileInformation();
    }

    private void doReorderProfiles(int columnId, SelectionEvent event) {
        TableColumn sortColumn = this.profile_table.getSortColumn();
        TableColumn currentColumn = (TableColumn)event.widget;
        int dir = this.profile_table.getSortDirection();
        if (sortColumn.equals(currentColumn)) {
            dir = dir == 128 ? 1024 : 128;
        } else {
            this.profile_table.setSortColumn(currentColumn);
            dir = 128;
        }
        int currentProfileId = -1;
        if (this.profile_table.getSelectionIndex() != -1) {
            currentProfileId = this.profilesList.get(this.profile_table.getSelectionIndex()).getId();
        }
        try {
            this.orderingVector.addOrdering(this.columnIds[columnId], dir == 128);
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
        }
        catch (SQLException ex) {
            GeneralPurposeDialogs.warningMessage(this.shell, ex.getMessage());
        }
        int i = 0;
        while (i < this.profilesList.size()) {
            this.setTableItem(this.profile_table.getItem(i), this.profilesList.get(i));
            ++i;
        }
        this.profile_table.setSortDirection(dir);
        if (currentProfileId != -1) {
            this.profile_table.setSelection(Profile.findById(this.profilesList, currentProfileId));
        }
        this.settings.setIntValues("gui", "sortcolumn", this.orderingVector.getColumns());
        this.settings.setBooleanValues("gui", "sortascending", this.orderingVector.getAscendings());
    }

    private void displayNotes(String notes) {
        this.notesField.setText(notes);
    }

    private void displayLinks(String[] p_link) {
        int i = 0;
        while (i < this.link.length) {
            if (p_link[i] == null || "".equals(p_link[i])) {
                this.link[i].setText(" ");
                this.link[i].setToolTipText(null);
            } else {
                String url = p_link[i];
                String tag = p_link[i];
                if (url.indexOf("://") == -1) {
                    url = "file://" + FileUtils.canonicalToData(url).getPath();
                    tag = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(tag)).getPath();
                }
                StringBuffer text = new StringBuffer("<a href=\"").append(url).append("\">").append(tag).append("</a>");
                this.link[i].setText(text.toString());
                this.link[i].setToolTipText(url);
            }
            ++i;
        }
    }

    private void displayScreenshots(Profile prof) {
        File path;
        File[] files;
        ToolItem[] toolItems = this.thumbsToolBar.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
        if (prof != null && (files = (path = prof.getCanonicalCaptures()).listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(".png")) {
                    final ToolItem toolItem = new ToolItem(this.thumbsToolBar, 8);
                    toolItem.setToolTipText(file.getPath());
                    toolItem.setText(file.getName());
                    toolItem.setImage(SWTImageManager.getResizedImage(this.display, this.thumbHeight, file.getPath()));
                    toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            Thumb thumbDialog = new Thumb(MainWindow.this.shell);
                            thumbDialog.setThumb(toolItem.getToolTipText());
                            thumbDialog.open();
                        }
                    });
                }
                ++n2;
            }
        }
        this.thumbsToolBar.setVisible(this.thumbsToolBar.getItemCount() != 0);
        this.thumbsToolBar.pack();
    }

    private void doAddProfile() {
        this.doAddProfile(null);
    }

    private void doAddProfile(String file) {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditProfileDialog addProfileDialog = new EditProfileDialog(this.shell);
        if (file != null) {
            addProfileDialog.sendToProfile(file);
        }
        this.updateWithAddedProfile((Profile)addProfileDialog.open());
    }

    public void addProfile(final String file) {
        this.display.syncExec(new Runnable(){

            public void run() {
                MainWindow.this.doAddProfile(file);
            }
        });
    }

    private void doAddDosboxVersion() {
        EditDosboxVersionDialog addVersionDialog = new EditDosboxVersionDialog(this.shell);
        DosboxVersion dbversion = (DosboxVersion)addVersionDialog.open();
        if (dbversion != null) {
            this.updateDosboxVersionList(dbversion);
        }
    }

    private void doAddTemplate() {
        if (this.checkDefaultDBVersion() == null) {
            return;
        }
        EditTemplateDialog addTemplateDialog = new EditTemplateDialog(this.shell);
        Template template = (Template)addTemplateDialog.open();
        if (template != null) {
            this.updateTemplateList(template);
        }
    }

    private void doToggleFavoriteProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile = this.profilesList.get(index);
            try {
                this.dbase.toggleFavorite(profile.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            profile.toggleDefault();
            this.profilesList.set(index, profile);
            this.setTableItem(this.profile_table.getItem(index), profile);
        }
    }

    private void doToggleDefaultVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            DosboxVersion ver = this.dbversionsList.get(index);
            ver.toggleDefault();
            try {
                this.dbase.addOrEditDosboxVersion(ver.getTitle(), ver.getPath(), ver.isMultiConfig(), ver.isDefault(), ver.getParameters(), ver.getVersion(), ver.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateDosboxVersionList(ver);
        }
    }

    private void doToggleDefaultTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            Template temp = this.templatesList.get(index);
            temp.toggleDefault();
            try {
                this.dbase.addOrEditTemplate(temp.getTitle(), temp.getdbversionId(), temp.isDefault(), temp.getId());
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
            this.updateTemplateList(temp);
        }
    }

    private void doEditProfile() {
        this.doEditProfile(false);
    }

    private void doEditProfile(boolean focusTitle) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile profile;
            EditProfileDialog editProfileDialog = new EditProfileDialog(this.shell);
            editProfileDialog.setProfile(this.profilesList.get(index));
            if (focusTitle) {
                editProfileDialog.focusTitle();
            }
            if ((profile = (Profile)editProfileDialog.open()) != null) {
                boolean quickUpdate = true;
                if (this.settings.getBooleanValue("gui", "autosortonupdate")) {
                    try {
                        this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
                        if (index != Profile.findById(this.profilesList, profile.getId())) {
                            quickUpdate = false;
                        }
                    }
                    catch (SQLException e) {
                        GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                    }
                }
                if (quickUpdate) {
                    this.profilesList.set(index, profile);
                    this.setTableItem(this.profile_table.getItem(index), profile);
                } else {
                    this.updateProfilesList(profile);
                }
                this.displayProfileInformation();
            }
        }
    }

    private void doDuplicateProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile orgProf = this.profilesList.get(index);
            this.updateWithAddedProfile(EditProfileDialog.duplicateProfile(orgProf, this.dbase, this.shell));
        }
    }

    private void updateWithAddedProfile(Profile profile) {
        if (profile != null) {
            if (this.settings.getBooleanValue("gui", "autosortonupdate")) {
                this.updateProfilesList(profile);
            } else {
                this.profilesList.add(profile);
                this.addProfileToTable(profile);
                this.profile_table.setSelection(this.profile_table.getItemCount() - 1);
                this.profile_table.setFocus();
            }
            this.displayProfileInformation();
        }
    }

    private void doEditDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            EditDosboxVersionDialog editVersionDialog = new EditDosboxVersionDialog(this.shell);
            editVersionDialog.setDosboxVersion(this.dbversionsList.get(index));
            DosboxVersion dbversion = (DosboxVersion)editVersionDialog.open();
            if (dbversion != null) {
                this.updateDosboxVersionList(dbversion);
            }
        }
    }

    private void updateProfilesList(Profile profile) {
        try {
            this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.profile_table.setRedraw(false);
        this.profile_table.removeAll();
        for (Profile prof : this.profilesList) {
            this.addProfileToTable(prof);
        }
        if (profile != null) {
            this.profile_table.setSelection(Profile.findById(this.profilesList, profile.getId()));
        }
        this.profile_table.setRedraw(true);
        this.profile_table.setFocus();
    }

    private void updateDosboxVersionList(DosboxVersion dbversion) {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.dbversion_table.removeAll();
        for (DosboxVersion version : this.dbversionsList) {
            this.addDosboxVersionToTable(version);
        }
        this.dbversion_table.setSelection(DosboxVersion.findById(this.dbversionsList, dbversion.getId()));
        this.dbversion_table.setFocus();
        this.updateProfileDbversionsSubmenu();
        this.updateSetupDbversionsSubmenu();
    }

    private void updateTemplateList(Template template) {
        try {
            this.templatesList = this.dbase.readTemplatesList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
        }
        this.template_table.removeAll();
        for (Template temp : this.templatesList) {
            this.addTemplateToTable(temp);
        }
        this.template_table.setSelection(Template.findById(this.templatesList, template.getId()));
        this.template_table.setFocus();
    }

    private void doEditTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1) {
            EditTemplateDialog editTemplDialog = new EditTemplateDialog(this.shell);
            editTemplDialog.setTemplate(this.templatesList.get(index));
            Template template = (Template)editTemplDialog.open();
            if (template != null) {
                this.updateTemplateList(template);
            }
        }
    }

    private void doRemoveProfile() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected profile?")) {
            Profile prof = this.profilesList.get(index);
            try {
                this.dbase.removeProfile(prof.getId());
                this.profile_table.remove(index);
                this.profilesList.remove(index);
                this.displayProfileInformation();
                SWTImageManager.dispose();
                if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated conf file " + prof.getConfPathAndFile() + " ?")) {
                    FileUtils.removeFile(prof.getCanonicalConfFile());
                }
                if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated captures directory " + prof.getCaptures() + " including its files?")) {
                    FileUtils.removeFilesInDirAndDir(prof.getCanonicalCaptures());
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveDosboxVersion() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected DOSBox version?")) {
            try {
                this.dbase.removeDosboxVersion(this.dbversionsList.get(index).getId());
                this.dbversion_table.remove(index);
                this.dbversionsList.remove(index);
                this.updateProfileDbversionsSubmenu();
                this.updateSetupDbversionsSubmenu();
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doRemoveTemplate() {
        int index = this.template_table.getSelectionIndex();
        if (index != -1 && GeneralPurposeDialogs.confirmMessage(this.shell, "Do you want to remove the selected template?")) {
            int templateId = this.templatesList.get(index).getId();
            try {
                this.dbase.removeTemplate(templateId);
                this.template_table.remove(index);
                this.templatesList.remove(index);
                File conffile = FileUtils.constructCanonicalTemplateFileLocation(templateId);
                if (GeneralPurposeDialogs.confirmMessage(this.shell, "Do you also want to remove the associated conf file " + conffile + " ?")) {
                    FileUtils.removeFile(conffile);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void addProfileToTable(Profile prof) {
        TableItem newItemTableItem = new TableItem(this.profile_table, 2048);
        this.setTableItem(newItemTableItem, prof);
    }

    private void addDosboxVersionToTable(DosboxVersion dbversion) {
        TableItem newItemTableItem = new TableItem(this.dbversion_table, 2048);
        this.setTableItem(newItemTableItem, dbversion);
    }

    private void addTemplateToTable(Template template) {
        TableItem newItemTableItem = new TableItem(this.template_table, 2048);
        this.setTableItem(newItemTableItem, template);
    }

    private void setTableItem(TableItem newItemTableItem, Profile prof) {
        int i = 0;
        while (i < this.columnIds.length) {
            String value;
            switch (this.columnIds[i]) {
                case 0: {
                    value = prof.getTitle();
                    break;
                }
                case 1: {
                    value = prof.hasSetupString();
                    break;
                }
                case 2: {
                    value = prof.getDeveloperName();
                    break;
                }
                case 3: {
                    value = prof.getPublisherName();
                    break;
                }
                case 4: {
                    value = prof.getGenre();
                    break;
                }
                case 5: {
                    value = prof.getYear();
                    break;
                }
                case 6: {
                    value = prof.getStatus();
                    break;
                }
                case 7: {
                    value = prof.isDefaultString();
                    break;
                }
                case 8: {
                    value = String.valueOf(prof.getId());
                    break;
                }
                case 9: {
                    value = String.valueOf(prof.getDbversionId());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    value = prof.getCustomString(this.columnIds[i] - 10);
                    break;
                }
                case 18: {
                    value = String.valueOf(prof.getCustomInt(0)) + " %";
                    break;
                }
                case 19: {
                    value = String.valueOf(prof.getCustomInt(1));
                    break;
                }
                default: {
                    value = "";
                }
            }
            newItemTableItem.setText(i, value);
            ++i;
        }
    }

    private void setTableItem(TableItem newItemTableItem, DosboxVersion dbversion) {
        newItemTableItem.setText(0, dbversion.getTitle());
        newItemTableItem.setText(1, dbversion.getVersion());
        newItemTableItem.setText(2, dbversion.getPath());
        newItemTableItem.setText(3, dbversion.isDefaultString());
        newItemTableItem.setText(4, String.valueOf(dbversion.getId()));
    }

    private void setTableItem(TableItem newItemTableItem, Template template) {
        newItemTableItem.setText(0, template.getTitle());
        newItemTableItem.setText(1, template.isDefaultString());
    }

    private void doRunProfile(boolean setup) {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            Profile prof = this.profilesList.get(index);
            if (!setup || prof.hasSetup()) {
                try {
                    FileUtils.doRunProfile(prof, this.dbversionsList, setup);
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
                }
            }
        }
    }

    private void doRunDosbox() {
        int index = this.dbversion_table.getSelectionIndex();
        if (index != -1) {
            try {
                FileUtils.doRunDosbox(this.dbversionsList.get(index));
            }
            catch (IOException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private DosboxVersion checkDefaultDBVersion() {
        int defaultVersionIdx = DosboxVersion.findDefault(this.dbversionsList);
        if (defaultVersionIdx == -1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "You must first define a default DOSBox version!");
            return null;
        }
        return this.dbversionsList.get(defaultVersionIdx);
    }

    private void doDFendImport() {
        DosboxVersion defaultDbversion = this.checkDefaultDBVersion();
        if (defaultDbversion == null) {
            return;
        }
        if (this.settings.getIntValue("profiledefaults", "confpath") == 1) {
            GeneralPurposeDialogs.infoMessage(this.shell, "Please realize that you have currently configured DBGL to store profile configuration files in the game directory. Therefore, if you continue and perform the import, all configuration files are saved to the various game directories configured in D-Fend.\n\nIf you'd rather have those DOSBox config files stored in a central place, please open the Settings dialog first and change the default configuration-file location to '" + SettingsDialog.confLocations[0] + "'!");
        }
        DFendImportDialog importDialog = new DFendImportDialog(this.shell);
        importDialog.setDefaultDosboxVersion(defaultDbversion);
        if (importDialog.open() != null) {
            try {
                this.profilesList = this.dbase.readProfilesList(this.orderingVector.toClause());
                this.profile_table.removeAll();
                for (Profile prof : this.profilesList) {
                    this.addProfileToTable(prof);
                }
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell, e.getMessage());
            }
        }
    }

    private void doMigrate() {
        GeneralPurposeDialogs.infoMessage(this.shell, "Please realize that you are about to alter all your profile data.\n\nDBGL will change all absolute profile location information inside the .conf files to relative paths. Therefore, please make sure that you have made a backup of your DBGL directory!\n\nYou will have to manually move your games, afterwards.");
        String from = (String)new MigrateDialog(this.shell).open();
        if (from != null) {
            GeneralPurposeDialogs.infoMessage(this.shell, "Now close DBGL, move your game-related files and directories inside " + from + "\n" + "to the new location " + FileUtils.getDosRoot() + "\n" + "and restart DBGL to complete the migration.");
        }
    }

    private void displayProfileInformation() {
        int index = this.profile_table.getSelectionIndex();
        if (index == -1) {
            this.displayScreenshots(null);
            this.displayNotes("");
            this.displayLinks(new String[4]);
        } else {
            this.settings.setIntValue("gui", "selectedprofile", index);
            Profile prof = this.profilesList.get(index);
            this.displayScreenshots(prof);
            this.displayNotes(prof.getNotes());
            this.displayLinks(prof.getLinks());
        }
    }

    private void doRemoveThumb() {
        if (GeneralPurposeDialogs.confirmMessage(this.shell, "Would you like to remove the selected screenshot \"" + this.currentThumbFile + "\"?")) {
            FileUtils.removeFile(this.currentThumbFile);
            this.displayProfileInformation();
        }
        this.currentThumbFile = null;
    }

    private void doCreateShortcut() {
        int index = this.profile_table.getSelectionIndex();
        if (index != -1) {
            PlatformUtils.createShortcut(this.profilesList.get(index), this.dbversionsList);
        }
    }

    private void addProfileColumn(String title, final int colIndex) {
        final String width = "column" + (this.columnIds[colIndex] + 1) + "width";
        final TableColumn column = new TableColumn(this.profile_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setMoveable(true);
        column.setText(title);
        if (this.columnIds[colIndex] == 8 || this.columnIds[colIndex] == 9 || this.columnIds[colIndex] == 18 || this.columnIds[colIndex] == 19) {
            column.setAlignment(131072);
        }
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainWindow.this.doReorderProfiles(colIndex, event);
            }
        });
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }

            public void controlMoved(ControlEvent event) {
                MainWindow.this.settings.setIntValues("gui", "columnorder", MainWindow.this.profile_table.getColumnOrder());
            }
        });
    }

    private void addDBColumn(String title, int colIndex) {
        final String width = "column2_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.dbversion_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void addTemplateColumn(String title, int colIndex) {
        final String width = "column3_" + (colIndex + 1) + "width";
        final TableColumn column = new TableColumn(this.template_table, 0);
        column.setWidth(this.settings.getIntValue("gui", width));
        column.setText(title);
        column.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                MainWindow.this.settings.setIntValue("gui", width, column.getWidth());
            }
        });
    }

    private void doOpenSettingsDialog() {
        SettingsDialog sDialog = new SettingsDialog(this.shell);
        if (((Boolean)sDialog.open()).booleanValue()) {
            int index = this.profile_table.getSelectionIndex();
            int nrColumns = this.profile_table.getColumnCount();
            String order = this.settings.getValue("gui", "columnorder");
            this.profile_table.removeAll();
            StringBuffer cols = new StringBuffer();
            int i = 0;
            while (i < nrColumns) {
                cols.append(i).append(' ');
                ++i;
            }
            this.profile_table.setColumnOrder(StringUtils.stringToIntArray(cols.toString()));
            i = nrColumns - 1;
            while (i >= 0) {
                this.profile_table.getColumn(i).dispose();
                --i;
            }
            this.initColumnIds();
            i = 0;
            while (i < this.columnIds.length) {
                this.addProfileColumn(columnNames[this.columnIds[i]], i);
                ++i;
            }
            this.profile_table.setSortColumn(this.profile_table.getColumn(this.findColumnById(this.settings.getIntValues("gui", "sortcolumn")[0])));
            this.profile_table.setSortDirection(this.settings.getBooleanValues("gui", "sortascending")[0] ? 128 : 1024);
            this.settings.setValue("gui", "columnorder", order);
            this.orderingVector = new OrderingVector(this.settings.getIntValues("gui", "sortcolumn"), this.settings.getBooleanValues("gui", "sortascending"));
            Profile prof = index == -1 ? null : this.profilesList.get(index);
            this.updateProfilesList(prof);
        }
    }

    private void doImportConfigfile() {
        FileDialog dialog = new FileDialog(this.shell, 4096);
        dialog.setFilterNames(new String[]{"DOSBox configuration files", "Executables, Booter Disk Images", "*"});
        dialog.setFilterExtensions(new String[]{"*.conf;*.CONF", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"});
        String result = dialog.open();
        if (result != null) {
            this.doAddProfile(result);
        }
    }

    private void initColumnIds() {
        columnNames = new String[20];
        MainWindow.columnNames[0] = "Title";
        MainWindow.columnNames[1] = "Setup";
        MainWindow.columnNames[2] = "Developer";
        MainWindow.columnNames[3] = "Publisher";
        MainWindow.columnNames[4] = "Genre";
        MainWindow.columnNames[5] = "Year";
        MainWindow.columnNames[6] = "Status";
        MainWindow.columnNames[7] = "Favorite";
        MainWindow.columnNames[8] = "ID";
        MainWindow.columnNames[9] = "DB ID";
        int i = 0;
        while (i < 10) {
            MainWindow.columnNames[i + 10] = this.settings.getValue("gui", "custom" + (i + 1));
            ++i;
        }
        int amount = 0;
        int i2 = 0;
        while (i2 < columnNames.length) {
            if (this.settings.getBooleanValue("gui", "column" + (i2 + 1) + "visible")) {
                ++amount;
            }
            ++i2;
        }
        int cNr = 0;
        this.columnIds = new int[amount];
        int i3 = 0;
        while (i3 < columnNames.length) {
            if (this.settings.getBooleanValue("gui", "column" + (i3 + 1) + "visible")) {
                this.columnIds[cNr++] = i3;
            }
            ++i3;
        }
    }

    private int findColumnById(int id) {
        int i = 0;
        while (i < this.columnIds.length) {
            if (this.columnIds[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateProfileDbversionsSubmenu() {
        MenuItem parent = this.runWithSubMenu.getParentItem();
        this.runWithSubMenu.dispose();
        this.runWithSubMenu = new Menu(parent);
        parent.setMenu(this.runWithSubMenu);
        int i = 0;
        while (i < this.dbversionsList.size()) {
            final MenuItem runWithMenuItem = new MenuItem(this.runWithSubMenu, 0);
            runWithMenuItem.setText(this.dbversionsList.get(i).getTitle());
            runWithMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(MainWindow.this.runWithSubMenu.indexOf(runWithMenuItem));
                        try {
                            FileUtils.doRunProfile(prof, dbversion, false);
                        }
                        catch (IOException exc) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exc.getMessage());
                        }
                    }
                }
            });
            ++i;
        }
    }

    private void updateSetupDbversionsSubmenu() {
        MenuItem parent = this.setupWithSubMenu.getParentItem();
        this.setupWithSubMenu.dispose();
        this.setupWithSubMenu = new Menu(parent);
        parent.setMenu(this.setupWithSubMenu);
        int i = 0;
        while (i < this.dbversionsList.size()) {
            final MenuItem setupWithMenuItem = new MenuItem(this.setupWithSubMenu, 0);
            setupWithMenuItem.setText(this.dbversionsList.get(i).getTitle());
            setupWithMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index = MainWindow.this.profile_table.getSelectionIndex();
                    if (index != -1) {
                        Profile prof = (Profile)MainWindow.this.profilesList.get(index);
                        DosboxVersion dbversion = (DosboxVersion)MainWindow.this.dbversionsList.get(MainWindow.this.setupWithSubMenu.indexOf(setupWithMenuItem));
                        try {
                            FileUtils.doRunProfile(prof, dbversion, true);
                        }
                        catch (IOException exc) {
                            GeneralPurposeDialogs.warningMessage(MainWindow.this.shell, exc.getMessage());
                        }
                    }
                }
            });
            ++i;
        }
    }
}

