/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.EditProfileDialog;
import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import com.model.Settings;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public final class SendToProfile
extends Shell {
    private static final String LOCALHOST = "localhost";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: add.bat <dos-executable>|<booter image>|<config-file>");
            System.exit(1);
        }
        try {
            Settings settings = Settings.getInstance();
            Socket socket = new Socket(LOCALHOST, settings.getIntValue("communication", "port"));
            new PrintWriter(socket.getOutputStream(), true).println("sendtoprofile " + args[0]);
            socket.close();
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown host: localhost");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Could not make socket connection, DBGL is probably not running");
            SendToProfile.openDialogMyself(args[0]);
        }
    }

    private static void openDialogMyself(String file) {
        Database dbase = Database.getInstance();
        Shell shell = new Shell();
        shell.setMinimized(true);
        shell.open();
        shell.setText("Send to profile");
        try {
            List<DosboxVersion> dbversionsList = dbase.readDosboxVersionsList();
            if (DosboxVersion.findDefault(dbversionsList) == -1) {
                GeneralPurposeDialogs.infoMessage(shell, "You must first define a default DOSBox version!");
                try {
                    dbase.shutdown();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return;
            }
            EditProfileDialog editProfDialog = new EditProfileDialog(shell);
            editProfDialog.sendToProfile(file);
            editProfDialog.open();
        }
        catch (SQLException e1) {
            GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
        }
        try {
            dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

