/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.exception.DrivelettersExhaustedException;
import com.exception.InvalidHostfileException;
import com.exception.InvalidMountstringException;
import com.model.Settings;
import com.util.FileUtils;
import com.util.StringUtils;
import java.io.File;
import java.util.ArrayList;

public class Mount {
    private MountingType mountingType;
    private String mountAs;
    private char driveletter;
    private String label;
    private File[] path;
    private File write;
    private String lowlevelCD;
    private String useCD;
    private String freesize;
    private boolean unmounted;

    public Mount(MountingType mountingType, String mountAs, String driveletter, String[] paths, String label, String low, String usecd, String write, String freesize) {
        this.mountingType = mountingType;
        this.mountAs = mountAs.toLowerCase();
        this.driveletter = Character.toUpperCase(driveletter.charAt(0));
        this.path = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.path[i] = new File(paths[i]);
            ++i;
        }
        this.write = new File(write);
        this.label = label;
        this.lowlevelCD = low;
        this.useCD = usecd;
        this.freesize = freesize;
        this.unmounted = false;
    }

    public Mount(Mount otherMount) {
        this.mountingType = otherMount.mountingType;
        this.mountAs = otherMount.mountAs;
        this.driveletter = otherMount.driveletter;
        this.label = otherMount.label;
        this.path = (File[])otherMount.path.clone();
        this.write = otherMount.write;
        this.lowlevelCD = otherMount.lowlevelCD;
        this.useCD = otherMount.useCD;
        this.freesize = otherMount.freesize;
        this.unmounted = otherMount.unmounted;
    }

    private void init() {
        this.mountingType = MountingType.DIR;
        this.mountAs = "";
        this.driveletter = '\u0000';
        this.label = "";
        this.path = new File[0];
        this.write = null;
        this.lowlevelCD = "";
        this.useCD = "";
        this.freesize = "";
        this.unmounted = false;
    }

    private void initForPhysFS(String physFSPath) {
        this.mountingType = MountingType.PHYSFS;
        int colonIndex1 = physFSPath.indexOf(58);
        if (colonIndex1 == 1) {
            colonIndex1 = physFSPath.indexOf(":", colonIndex1 + 1);
        }
        int colonIndex2 = physFSPath.lastIndexOf(":");
        this.path = new File[1];
        if (colonIndex1 == colonIndex2) {
            this.path[0] = new File(physFSPath.substring(0, colonIndex2));
        } else {
            this.write = new File(physFSPath.substring(0, colonIndex1));
            this.path[0] = new File(physFSPath.substring(colonIndex1 + 1, colonIndex2));
        }
    }

    public Mount(boolean floppy, String hostFileLocation, String[] existingMounts) throws InvalidHostfileException, InvalidMountstringException, DrivelettersExhaustedException {
        this.init();
        if ("".equals(hostFileLocation)) {
            throw new InvalidHostfileException();
        }
        this.driveletter = Mount.getFreeDriveletter(floppy, existingMounts);
        if (FileUtils.containsPhysFS(hostFileLocation)) {
            this.initForPhysFS(hostFileLocation);
        } else {
            File file = new File(hostFileLocation);
            this.path = new File[1];
            this.path[0] = file.getParentFile();
            if (this.path[0] == null) {
                this.path[0] = new File(".");
            }
        }
    }

    public Mount(String mount) throws InvalidMountstringException {
        this.init();
        if ("".equals(mount)) {
            throw new InvalidMountstringException();
        }
        int spaceIndex = mount.indexOf(32);
        this.driveletter = Character.toUpperCase(mount.charAt(spaceIndex + 1));
        int firstQuoteIndex = mount.indexOf(34);
        int secondQuoteIndex = mount.lastIndexOf(34);
        if (firstQuoteIndex == -1 && secondQuoteIndex == -1 && (secondQuoteIndex = mount.indexOf(32, (firstQuoteIndex = mount.indexOf(32, spaceIndex + 1)) + 1)) == -1) {
            secondQuoteIndex = mount.length();
        }
        String mountLocation = mount.substring(firstQuoteIndex + 1, secondQuoteIndex);
        String[] paths = StringUtils.mountToStringArray(mountLocation);
        this.path = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.path[i] = FileUtils.makeRelativeToDosroot(new File(paths[i]));
            ++i;
        }
        if (mount.toLowerCase().startsWith("mount ")) {
            int freesizeIndex;
            String[] lowlevel_types;
            int labelIndex;
            int unmountIndex;
            if (FileUtils.isPhysFS(mountLocation)) {
                this.initForPhysFS(mountLocation);
            }
            if ((unmountIndex = mount.indexOf("-u ")) != -1) {
                this.unmounted = true;
                this.driveletter = Character.toUpperCase(mount.charAt(unmountIndex + 3));
                return;
            }
            int typeIndex = mount.indexOf("-t ");
            if (typeIndex != -1) {
                int spaceIndex2 = mount.indexOf(" ", typeIndex + 3);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.mountAs = mount.substring(typeIndex + 3, spaceIndex2);
            }
            if ((labelIndex = mount.indexOf("-label ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", labelIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.label = mount.substring(labelIndex + 7, spaceIndex2);
            }
            String[] stringArray = lowlevel_types = Settings.getInstance().getValues("profile", "lowlevelcd_type");
            int n = lowlevel_types.length;
            int n2 = 0;
            while (n2 < n) {
                String ll_type = stringArray[n2];
                if (mount.indexOf(" -" + ll_type) != -1) {
                    this.lowlevelCD = ll_type;
                }
                ++n2;
            }
            int usecdIndex = mount.indexOf("-usecd ");
            if (usecdIndex != -1) {
                int spaceIndex2 = mount.indexOf(" ", usecdIndex + 7);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.useCD = mount.substring(usecdIndex + 7, spaceIndex2);
            }
            if ((freesizeIndex = mount.indexOf("-freesize ")) != -1) {
                int spaceIndex2 = mount.indexOf(" ", freesizeIndex + 10);
                if (spaceIndex2 == -1) {
                    spaceIndex2 = mount.length();
                }
                this.freesize = mount.substring(freesizeIndex + 10, spaceIndex2);
            }
        } else if (mount.toLowerCase().startsWith("imgmount ")) {
            this.mountingType = MountingType.IMAGE;
            this.mountAs = "iso";
        }
    }

    public static char getFreeDriveletter(boolean floppy, String[] existingMounts) throws InvalidMountstringException, DrivelettersExhaustedException {
        int start;
        Mount[] mnts = new Mount[existingMounts.length];
        int i = 0;
        while (i < mnts.length) {
            mnts[i] = new Mount(existingMounts[i]);
            ++i;
        }
        ArrayList<Character> freeDriveletters = new ArrayList<Character>();
        int i2 = start = floppy ? 65 : 67;
        while (i2 < 90) {
            freeDriveletters.add(Character.valueOf((char)i2));
            i2 = (char)(i2 + '\u0001');
        }
        if (!floppy) {
            freeDriveletters.add(Character.valueOf('A'));
            freeDriveletters.add(Character.valueOf('B'));
        }
        i2 = 0;
        while (i2 < mnts.length) {
            freeDriveletters.remove(new Character(mnts[i2].getDriveletter()));
            ++i2;
        }
        if (freeDriveletters.isEmpty()) {
            throw new DrivelettersExhaustedException();
        }
        return ((Character)freeDriveletters.get(0)).charValue();
    }

    public String toString(boolean forList) {
        StringBuffer result = new StringBuffer();
        switch (this.mountingType) {
            case DIR: {
                result.append("mount ").append(this.driveletter).append(" \"").append(this.getPathAsString()).append('\"');
                if (this.lowlevelCD.length() > 0) {
                    result.append(" -").append(this.lowlevelCD);
                }
                if (this.useCD.length() <= 0) break;
                result.append(" -usecd ").append(this.useCD);
                break;
            }
            case PHYSFS: {
                result.append("mount ").append(this.driveletter).append(" \"");
                if (!this.getWriteAsString().equals("")) {
                    result.append(this.getWriteAsString()).append("\\:");
                }
                result.append(this.path[0].getPath()).append(":\\\"");
                break;
            }
            case IMAGE: {
                result.append("imgmount ").append(this.driveletter);
                int i = 0;
                while (i < this.path.length) {
                    result.append(" \"").append(this.path[i].getPath()).append('\"');
                    ++i;
                }
                break;
            }
        }
        if (!"".equals(this.label)) {
            result.append(" -label ").append(this.label);
        }
        if (!"".equals(this.mountAs)) {
            result.append(" -t ").append(this.mountAs);
        }
        if (!"".equals(this.freesize)) {
            result.append(" -freesize ").append(this.freesize);
        }
        if (this.unmounted) {
            if (forList) {
                result.append(" (UNMOUNTED)");
            } else {
                result = new StringBuffer("mount -u ").append(this.driveletter);
            }
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public void toggleMount() {
        this.unmounted = !this.unmounted;
    }

    public char getDriveletter() {
        return this.driveletter;
    }

    public String getDriveletterString() {
        return String.valueOf(this.driveletter);
    }

    public String getLowlevelCD() {
        return this.lowlevelCD;
    }

    public String getUseCD() {
        return this.useCD;
    }

    public boolean isUnmounted() {
        return this.unmounted;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPathAsString() {
        if (this.path.length <= 0) {
            return "";
        }
        return this.path[0].getPath();
    }

    public char getDriveletterFromPath() {
        return Character.toUpperCase(this.path[0].getAbsolutePath().charAt(0));
    }

    public String getImgMountAsString(String delimiter) {
        String[] paths = new String[this.path.length];
        int i = 0;
        while (i < this.path.length) {
            paths[i] = this.path[i].getPath();
            ++i;
        }
        return StringUtils.stringArrayToString(paths, delimiter);
    }

    public String getHostPathAsString() {
        return this.mountingType == MountingType.PHYSFS ? String.valueOf(this.getPathAsString()) + ':' : this.getPathAsString();
    }

    public MountingType getMountingType() {
        return this.mountingType;
    }

    public String getMountAs() {
        return this.mountAs;
    }

    public String getWriteAsString() {
        if (this.write == null) {
            return "";
        }
        return this.write.getPath();
    }

    public String getFreesize() {
        return this.freesize;
    }

    public File canBeUsedFor(File hostFile) {
        File canHostFile = FileUtils.canonicalToDosroot(hostFile.getPath());
        if (!this.unmounted && FileUtils.areRelated(FileUtils.canonicalToDosroot(this.getHostPathAsString()), canHostFile)) {
            return FileUtils.makeRelativeTo(canHostFile, FileUtils.canonicalToDosroot(this.getHostPathAsString()));
        }
        return null;
    }

    public void makeRelative(File basePath) {
        int i = 0;
        while (i < this.path.length) {
            this.path[i] = FileUtils.makeRelativeTo(this.path[i], basePath);
            ++i;
        }
        if (this.write != null) {
            this.write = FileUtils.makeRelativeTo(this.write, basePath);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mount otherMount = (Mount)obj;
        return this.driveletter == otherMount.driveletter && this.unmounted == otherMount.unmounted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MountingType {
        DIR,
        IMAGE,
        PHYSFS;

    }
}

