/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.KeyTitleDefault;
import com.util.FileUtils;
import java.io.File;

public class Profile
extends KeyTitleDefault {
    private String developerName;
    private String publisherName;
    private String genre;
    private String year;
    private int dbversionId;
    private String setup;
    private String setupParams;
    private String notes;
    private String[] link;
    private String status;
    private String confPathAndFile;
    private String captures;
    private String[] customString;
    private int[] customInt;

    public Profile(int id, String title, String devName, String publName, String genre, String year, int dbversionId, String setup, String setupParams, String notes, String link1, String link2, boolean favorite, String status, String confPathAndFile, String captures, String link3, String link4, String cust1, String cust2, String cust3, String cust4, String cust5, String cust6, String cust7, String cust8, int cust9, int cust10) {
        super(id, title, favorite);
        this.developerName = devName;
        this.publisherName = publName;
        this.genre = genre;
        this.year = year;
        this.dbversionId = dbversionId;
        this.setup = setup;
        this.setupParams = setupParams;
        this.notes = notes;
        this.status = status;
        this.confPathAndFile = confPathAndFile;
        this.captures = captures;
        this.link = new String[]{link1, link2, link3, link4};
        this.customString = new String[]{cust1, cust2, cust3, cust4, cust5, cust6, cust7, cust8};
        this.customInt = new int[]{cust9, cust10};
    }

    public Profile(int id, String confFile, String captures, Profile prof) {
        this(id, prof.getTitle(), prof.getDeveloperName(), prof.getPublisherName(), prof.getGenre(), prof.getYear(), prof.getDbversionId(), prof.getSetup(), prof.getSetupParameters(), prof.getNotes(), prof.getLink(0), prof.getLink(1), prof.isDefault(), prof.getStatus(), confFile, captures, prof.getLink(2), prof.getLink(3), prof.getCustomString(0), prof.getCustomString(1), prof.getCustomString(2), prof.getCustomString(3), prof.getCustomString(4), prof.getCustomString(5), prof.getCustomString(6), prof.getCustomString(7), prof.getCustomInt(0), prof.getCustomInt(1));
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getYear() {
        return this.year;
    }

    public int getDbversionId() {
        return this.dbversionId;
    }

    public boolean hasSetup() {
        return !"".equals(this.setup);
    }

    public String hasSetupString() {
        return this.hasSetup() ? "Yes" : "No";
    }

    public String[] getLinks() {
        return (String[])this.link.clone();
    }

    public String getLink(int index) {
        return this.link[index];
    }

    public String getNotes() {
        return this.notes;
    }

    public String getSetup() {
        return this.setup;
    }

    public String getSetupParameters() {
        return this.setupParams;
    }

    public String getStatus() {
        return this.status;
    }

    public String getConfPathAndFile() {
        return this.confPathAndFile;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToData(this.confPathAndFile);
    }

    public String getCaptures() {
        return this.captures;
    }

    public File getCanonicalCaptures() {
        return FileUtils.canonicalToData(this.captures);
    }

    public String getCustomString(int index) {
        return this.customString[index];
    }

    public int getCustomInt(int index) {
        return this.customInt[index];
    }
}

