/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.conf.Configuration;
import java.io.File;
import java.io.IOException;

public final class Settings
extends Configuration {
    public static final String COLUMNORDER = "columnorder";
    public static final String WIDTH = "width";
    public static final String SORTASCENDING = "sortascending";
    public static final String SORTCOLUMN = "sortcolumn";
    public static final String VSYNCMODE = "vsyncmode";
    public static final String PIXELSHADER = "pixelshader";
    public static final String VIDEORAM = "videoram";
    public static final String SVGACHIPSET = "svgachipset";
    public static final String MT32RATE = "mt32rate";
    public static final String RATE = "rate";
    public static final String PROFILEDEFAULTS = "profiledefaults";
    public static final String COMMUNICATION = "communication";
    public static final String PROFILE = "profile";
    public static final String GUI = "gui";
    private static final String SAMPLE_RATES = "11025 22050 44100";
    private static final File SETTINGS_CONF = new File("settings.conf");

    private Settings() {
        this.init();
        try {
            if (SETTINGS_CONF.isFile() && SETTINGS_CONF.canRead()) {
                this.parseConfigurationFile(SETTINGS_CONF, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Settings getInstance() {
        return SettingsHolder.instance;
    }

    public void save() throws IOException {
        this.saveToFile(SETTINGS_CONF, true, null);
    }

    private void init() {
        this.setGuiDefaults();
        this.setIntValue(PROFILEDEFAULTS, "confpath", 0);
        this.setIntValue(PROFILEDEFAULTS, "conffile", 0);
        this.setBooleanValue("dosbox", "hideconsole", false);
        this.setBooleanValue(COMMUNICATION, "port_enabled", true);
        this.setValue(COMMUNICATION, "port", "4740");
        this.setValue("database", "connectionstring", "jdbc:hsqldb:file:./db/database");
        this.setValue("database", "username", "sa");
        this.setValue("database", "pasword", "");
        this.setValue("directory", "data", ".");
        this.setValue("directory", "dosbox", ".");
        this.setProfileDefaults();
    }

    private void setProfileDefaults() {
        this.setValue(PROFILE, "priority_active", "lowest lower normal higher highest");
        this.setValue(PROFILE, "priority_inactive", "lowest lower normal higher highest pause");
        this.setValue(PROFILE, "output", "ddraw direct3d overlay opengl openglhq openglnb surface");
        this.setValue(PROFILE, "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
        this.setValue(PROFILE, "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x tv2x tv3x rgb2x rgb3x scan2x scan3x supereagle super2xsai 2xsai hq2x hq3x hardware2x hardware3x tv tvadvmame2x normal4x");
        this.setValue(PROFILE, PIXELSHADER, "none 2xsai.fx 2xsai_srgb.fx bilinear.fx cartoon.fx gs2x.fx gs4x.fx gs4xcolor.fx gs4xcolorfilter.fx gs4xcolorscale.fx gs4xfilter.fx gs4xscale.fx matrix.fx mcgreen.fx mcorange.fx point.fx scale2x.fx scale2x_ps14.fx sketch.fx");
        this.setValue(PROFILE, "fullresolution", "original 0x0 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.setValue(PROFILE, "windowresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.setValue(PROFILE, SVGACHIPSET, "none et3000 et4000 et4000new pvga1a s3");
        this.setValue(PROFILE, VIDEORAM, "256 512 1024 2048 3072 4096");
        this.setValue(PROFILE, VSYNCMODE, "off on force");
        this.setValue(PROFILE, "machine", "cga hercules pcjr tandy vga");
        this.setValue(PROFILE, "machine073", "cga hercules pcjr tandy ega vgaonly svga_s3 svga_et3000 svga_et4000 svga_paradise vesa_nolfb vesa_oldvbe");
        this.setValue(PROFILE, "cputype", "auto 386 386_slow 486_slow pentium_slow 386_prefetch");
        this.setValue(PROFILE, "core", "dynamic full normal simple auto");
        this.setValue(PROFILE, "cycles", "350 500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max<space>50% max<space>80% max<space>90% max");
        this.setValue(PROFILE, "cycles_up", "20 50 100 500 1000 2000 5000 10000");
        this.setValue(PROFILE, "cycles_down", "20 50 100 500 1000 2000 5000 10000");
        this.setValue(PROFILE, "memsize", "0 1 2 4 8 16 32 63");
        this.setValue(PROFILE, "umb", "false true max");
        this.setValue(PROFILE, "loadfix_value", "1 63 127");
        this.setValue(PROFILE, RATE, SAMPLE_RATES);
        this.setValue(PROFILE, "blocksize", "512 1024 2048 3072 4096 8192");
        this.setValue(PROFILE, "prebuffer", "10");
        this.setValue(PROFILE, "mpu401", "none intelligent uart");
        this.setValue(PROFILE, "device", "alsa default coreaudio mt32 none oss win32");
        this.setValue(PROFILE, MT32RATE, SAMPLE_RATES);
        this.setValue(PROFILE, "sbtype", "none sb1 sb2 sbpro1 sbpro2 sb16");
        this.setValue(PROFILE, "oplrate", SAMPLE_RATES);
        this.setValue(PROFILE, "oplmode", "auto cms opl2 dualopl2 opl3");
        this.setValue(PROFILE, "sbbase", "210 220 240 260 280");
        this.setValue(PROFILE, "irq", "3 5 7 10 11");
        this.setValue(PROFILE, "dma", "0 1 3");
        this.setValue(PROFILE, "hdma", "5 6 7");
        this.setValue(PROFILE, "gusrate", SAMPLE_RATES);
        this.setValue(PROFILE, "gusbase", "210 220 240 260 280");
        this.setValue(PROFILE, "irq1", "3 5 7 10 11");
        this.setValue(PROFILE, "irq2", "3 5 7 10 11");
        this.setValue(PROFILE, "dma1", "0 1 3");
        this.setValue(PROFILE, "dma2", "0 1 3");
        this.setValue(PROFILE, "pcrate", SAMPLE_RATES);
        this.setValue(PROFILE, "tandy", "auto off on");
        this.setValue(PROFILE, "tandyrate", SAMPLE_RATES);
        this.setValue(PROFILE, "sensitivity", "10 20 30 40 50 60 70 80 90 100 125 150 175 200 250 300 350 400 450 500 550 600 700 800 900 1000");
        this.setValue(PROFILE, "joysticktype", "auto none 2axis 4axis 4axis_2 ch fcs");
        this.setValue(PROFILE, "mount_type", "cdrom dir floppy");
        this.setValue(PROFILE, "zipmount_type", "cdrom dir floppy");
        this.setValue(PROFILE, "freesize", "1 10 100 200 500 1000");
        this.setValue(PROFILE, "lowlevelcd_type", "aspi ioctl noioctl");
    }

    private void setGuiDefaults() {
        this.setValue(GUI, WIDTH, "904");
        this.setValue(GUI, "height", "475");
        this.setValue(GUI, "x", "10");
        this.setValue(GUI, "y", "10");
        this.setBooleanValue(GUI, "maximized", false);
        this.setValue(GUI, "column1width", "150");
        this.setValue(GUI, "column2width", "48");
        this.setValue(GUI, "column3width", "100");
        this.setValue(GUI, "column4width", "100");
        this.setValue(GUI, "column5width", "70");
        this.setValue(GUI, "column6width", "40");
        this.setValue(GUI, "column7width", "60");
        this.setValue(GUI, "column8width", "60");
        this.setValue(GUI, "column9width", "38");
        this.setValue(GUI, "column10width", "40");
        this.setValue(GUI, "column11width", "70");
        this.setValue(GUI, "column12width", "70");
        this.setValue(GUI, "column13width", "70");
        this.setValue(GUI, "column14width", "70");
        this.setValue(GUI, "column15width", "70");
        this.setValue(GUI, "column16width", "70");
        this.setValue(GUI, "column17width", "70");
        this.setValue(GUI, "column18width", "70");
        this.setValue(GUI, "column19width", "44");
        this.setValue(GUI, "column20width", "44");
        this.setBooleanValue(GUI, "column1visible", true);
        this.setBooleanValue(GUI, "column2visible", true);
        this.setBooleanValue(GUI, "column3visible", true);
        this.setBooleanValue(GUI, "column4visible", true);
        this.setBooleanValue(GUI, "column5visible", true);
        this.setBooleanValue(GUI, "column6visible", true);
        this.setBooleanValue(GUI, "column7visible", true);
        this.setBooleanValue(GUI, "column8visible", true);
        this.setBooleanValue(GUI, "column9visible", true);
        this.setBooleanValue(GUI, "column10visible", false);
        this.setBooleanValue(GUI, "column11visible", false);
        this.setBooleanValue(GUI, "column12visible", false);
        this.setBooleanValue(GUI, "column13visible", false);
        this.setBooleanValue(GUI, "column14visible", false);
        this.setBooleanValue(GUI, "column15visible", false);
        this.setBooleanValue(GUI, "column16visible", false);
        this.setBooleanValue(GUI, "column17visible", false);
        this.setBooleanValue(GUI, "column18visible", false);
        this.setBooleanValue(GUI, "column19visible", false);
        this.setBooleanValue(GUI, "column20visible", false);
        this.setValue(GUI, "column2_1width", "300");
        this.setValue(GUI, "column2_2width", "250");
        this.setValue(GUI, "column2_3width", "50");
        this.setValue(GUI, "column2_4width", "38");
        this.setValue(GUI, "column3_1width", "500");
        this.setValue(GUI, "column3_2width", "50");
        this.setValue(GUI, SORTCOLUMN, "0 8");
        this.setValue(GUI, SORTASCENDING, "true true");
        this.setValue(GUI, COLUMNORDER, "0 1 2 3 4 5 6 7 8");
        this.setValue(GUI, "sashweights", "777 222");
        this.setValue(GUI, "screenshotsheight", "100");
        this.setBooleanValue(GUI, "autosortonupdate", false);
        this.setValue(GUI, "custom1", "Custom1");
        this.setValue(GUI, "custom2", "Custom2");
        this.setValue(GUI, "custom3", "Custom3");
        this.setValue(GUI, "custom4", "Custom4");
        this.setValue(GUI, "custom5", "Custom5");
        this.setValue(GUI, "custom6", "Custom6");
        this.setValue(GUI, "custom7", "Custom7");
        this.setValue(GUI, "custom8", "Custom8");
        this.setValue(GUI, "custom9", "Custom9");
        this.setValue(GUI, "custom10", "Custom10");
    }

    /* synthetic */ Settings(Settings settings) {
        this();
    }

    private static class SettingsHolder {
        private static Settings instance = new Settings(null);

        private SettingsHolder() {
        }
    }
}

