/*
 * Decompiled with CFR 0.152.
 */
package com.model.conf;

import com.gui.GeneralPurposeDialogs;
import com.model.DosboxVersion;
import com.model.Profile;
import com.model.Template;
import com.model.conf.Configuration;
import com.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;

public class CompositeConfiguration {
    private Configuration baseConf;
    private Configuration compositeConf;
    private DosboxVersion dbversion;

    public CompositeConfiguration(DosboxVersion dbversion, boolean force, Shell shell) {
        this.processConfiguration(dbversion.getCanonicalConfFile(), true, force, shell);
        this.dbversion = dbversion;
    }

    public CompositeConfiguration(DosboxVersion dbversion, Profile profile, boolean force, Shell shell) {
        this(dbversion, profile.getCanonicalConfFile(), force, shell);
    }

    public CompositeConfiguration(DosboxVersion dbversion, Template template, boolean force, Shell shell) {
        this(dbversion, FileUtils.constructCanonicalTemplateFileLocation(template.getId()), force, shell);
    }

    public CompositeConfiguration(DosboxVersion dbversion, File file, boolean force, Shell shell) {
        this(dbversion, force, shell);
        if (file != null) {
            this.processConfiguration(file, false, force, shell);
        }
    }

    public CompositeConfiguration(Profile profile, boolean force, Shell shell) {
        this.init();
        this.baseConf = new Configuration();
        this.compositeConf = new Configuration();
        this.processConfiguration(profile.getCanonicalConfFile(), false, force, shell);
        this.baseConf = this.compositeConf;
    }

    public CompositeConfiguration(CompositeConfiguration comp, DosboxVersion dbversion, Template template, boolean force, Shell shell) {
        this(dbversion, FileUtils.constructCanonicalTemplateFileLocation(template.getId()), force, shell);
        if (this.baseConf != null && this.compositeConf != null) {
            Configuration otherAutoSettings = new Configuration(comp.compositeConf, false);
            this.compositeConf.setAutoexecSettings(otherAutoSettings.isLoadfix(), otherAutoSettings.getLoadfixValue(), otherAutoSettings.getMain(), otherAutoSettings.getMainParameters(), otherAutoSettings.getImg1(), otherAutoSettings.getImg2());
        }
    }

    public CompositeConfiguration(CompositeConfiguration comp, DosboxVersion dbversion, boolean keepValues, boolean isTemplate, Shell shell) {
        this.baseConf = comp.baseConf;
        this.compositeConf = comp.compositeConf;
        this.dbversion = comp.dbversion;
        Configuration uniqueMountPoints = null;
        Configuration otherAutoSettings = null;
        if (this.baseConf != null && this.compositeConf != null) {
            uniqueMountPoints = new Configuration(this.compositeConf, true, this.baseConf, this.dbversion != dbversion);
            otherAutoSettings = new Configuration(this.compositeConf, keepValues);
        }
        if (keepValues) {
            if (!this.update(dbversion, shell, isTemplate ? "template" : "profile")) {
                this.compositeConf = null;
            }
        } else {
            this.processConfiguration(dbversion.getCanonicalConfFile(), true, false, shell);
            this.dbversion = dbversion;
        }
        if (this.compositeConf != null && otherAutoSettings != null) {
            if (keepValues) {
                this.compositeConf.setAutoexecSettings(otherAutoSettings.isExit(), otherAutoSettings.getMixer(), otherAutoSettings.getKeyb(), otherAutoSettings.isBooter());
            } else {
                this.compositeConf.setAutoexecSettings(otherAutoSettings.isExit(), otherAutoSettings.isBooter());
            }
            this.compositeConf.setAutoexecSettings(otherAutoSettings.isLoadfix(), otherAutoSettings.getLoadfixValue(), otherAutoSettings.getMain(), otherAutoSettings.getMainParameters(), otherAutoSettings.getImg1(), otherAutoSettings.getImg2());
        }
        if (!(this.compositeConf == null || uniqueMountPoints == null || this.dbversion == comp.dbversion && keepValues)) {
            this.compositeConf.addMounts(uniqueMountPoints);
        }
    }

    private boolean update(DosboxVersion dbversion, Shell shell, String compType) {
        Configuration org = new Configuration(this.compositeConf, false, null, false);
        this.processConfiguration(dbversion.getCanonicalConfFile(), true, false, shell);
        if (this.baseConf == null) {
            if (GeneralPurposeDialogs.confirmMessage(shell, "There was a problem loading the associated DOSBox configuration file.\nSaving this " + compType + " may result in a broken " + compType + " configuration file.\n\n" + "Continue with the " + compType + " anyway (not recommended)?")) {
                this.processConfiguration(dbversion.getCanonicalConfFile(), true, true, shell);
            } else {
                return false;
            }
        }
        this.compositeConf.updateAndExtendWithValuesFrom(org);
        this.dbversion = dbversion;
        return true;
    }

    public void setCompositeConf(Configuration configuration) {
        this.compositeConf = configuration;
    }

    private void save(boolean substract, File target, Shell shell) {
        Configuration toSave = new Configuration(this.compositeConf, false, null, false);
        toSave.strip(this.baseConf);
        toSave.setFixedCycles();
        if (substract) {
            toSave.substract(this.baseConf);
        }
        try {
            toSave.saveToFile(target, false, this.baseConf);
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
        }
    }

    public void save(Template template, Shell shell) {
        this.save(true, FileUtils.constructCanonicalTemplateFileLocation(template.getId()), shell);
    }

    public void save(Profile profile, Shell shell) {
        this.compositeConf.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(profile.getId()));
        this.save(this.dbversion != null && this.dbversion.isMultiConfig(), profile.getCanonicalConfFile(), shell);
    }

    public Configuration getBaseConf() {
        return this.baseConf;
    }

    public Configuration getCompositeConf() {
        return this.compositeConf;
    }

    public int getDbversionId() {
        return this.dbversion.getId();
    }

    private void init() {
        this.baseConf = null;
        this.compositeConf = null;
        this.dbversion = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConfiguration(File file, boolean base, boolean force, Shell shell) {
        if (base) {
            try {
                try {
                    this.init();
                    this.baseConf = new Configuration(file, true);
                    if (!this.baseConf.hasParsingProblems()) return;
                    GeneralPurposeDialogs.warningMessage(shell, this.baseConf.getParsingProblems());
                    return;
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
                    if (force) {
                        this.baseConf = new Configuration();
                    }
                    if (this.baseConf == null) return;
                    this.compositeConf = new Configuration(this.baseConf, true, null, false);
                    this.compositeConf.unsetFixedCycles();
                }
                return;
            }
            finally {
                if (this.baseConf != null) {
                    this.compositeConf = new Configuration(this.baseConf, true, null, false);
                    this.compositeConf.unsetFixedCycles();
                }
            }
        }
        try {
            this.compositeConf.setAutoexecSettings(false);
            this.compositeConf.parseConfigurationFile(file, true);
            this.compositeConf.unsetFixedCycles();
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
        }
        if (!this.compositeConf.hasParsingProblems()) return;
        GeneralPurposeDialogs.warningMessage(shell, this.compositeConf.getParsingProblems());
    }

    public String[] addMount(String mount) {
        return this.compositeConf.addMount(mount);
    }

    public String[] removeMount(int index) {
        if (index < this.baseConf.getNrOfMounts()) {
            return this.compositeConf.toggleMount(index);
        }
        return this.compositeConf.removeMount(index);
    }

    public String[] editMount(int index, String mount) {
        if (index < this.baseConf.getNrOfMounts()) {
            this.compositeConf.unMount(index);
            return this.compositeConf.addMount(mount);
        }
        return this.compositeConf.replaceMount(index, mount);
    }

    public String getRequiredMount(boolean booter, String exe) {
        return this.compositeConf.getRequiredMount(booter, exe);
    }

    public String[] addRequiredMount(boolean booter, String exe) {
        return this.compositeConf.addRequiredMount(booter, exe);
    }
}

