/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.db.Database;
import com.model.DosboxVersion;
import com.model.KeyValuePair;
import com.model.conf.Configuration;
import com.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class DFendImportThread
extends Thread {
    private static final String EXTRAINFO = "ExtraInfo";
    private static final String MIDI = "midi";
    private static final String MPU401 = "mpu401";
    private static final String INTELLIGENT = "intelligent";
    private static final String[] LINKS = new String[]{"", "", "", ""};
    private static final String[] CUST_STRINGS = new String[]{"", "", "", "", "", "", "", ""};
    private static final int[] CUST_INTS = new int[2];
    private static final int[] CUST_IDS = new int[4];
    private final DosboxVersion defaultDBVersion;
    private final Configuration standardProfile;
    private final Configuration profiles;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private final boolean performCleanup;
    private final Display display;
    private String title;
    private int profileNumber;
    private StringBuffer messageLog;

    public DFendImportThread(File dfendProfilesFile, boolean performCleanup, DosboxVersion defaultDBVersion, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.performCleanup = performCleanup;
        this.defaultDBVersion = defaultDBVersion;
        this.standardProfile = new Configuration(defaultDBVersion.getCanonicalConfFile(), true);
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profiles = new Configuration(dfendProfilesFile, false);
        this.progressBar.setMaximum(this.profiles.getSectionKeys().size());
        this.profileNumber = 0;
    }

    public void run() {
        Database dbase = Database.getInstance();
        try {
            for (String titleLoop : this.profiles.getSectionKeys()) {
                this.messageLog = new StringBuffer();
                this.title = titleLoop;
                String profFile = this.profiles.getValue(this.title, "prof");
                String confFile = this.profiles.getValue(this.title, "conf");
                boolean favorite = this.profiles.getValue(this.title, "fav").equals("1");
                try {
                    Configuration dfendExtra = new Configuration(new File(profFile), false);
                    String setup = dfendExtra.getValue("Extra", "Setup");
                    String setupParams = dfendExtra.getValue("Extra", "SetupParameters");
                    String notes = dfendExtra.getValue(EXTRAINFO, "Notes");
                    String dev = dfendExtra.getValue(EXTRAINFO, "Developer");
                    String pub = dfendExtra.getValue(EXTRAINFO, "Publisher");
                    String gen = dfendExtra.getValue(EXTRAINFO, "Genre");
                    String year = dfendExtra.getValue(EXTRAINFO, "Year");
                    String status = "Unknown";
                    String cap = dfendExtra.getValue("dosbox", "captures");
                    int devId = KeyValuePair.findIdByValue(dbase.readDevelopersList(), dev);
                    int publId = KeyValuePair.findIdByValue(dbase.readPublishersList(), pub);
                    int genId = KeyValuePair.findIdByValue(dbase.readGenresList(), gen);
                    int yrId = KeyValuePair.findIdByValue(dbase.readYearsList(), year);
                    int statId = KeyValuePair.findIdByValue(dbase.readStatusList(), status);
                    try {
                        int profileId = dbase.addOrEditProfile(this.title, dev, pub, gen, year, status, setup, setupParams, notes, favorite, devId, publId, genId, yrId, statId, this.defaultDBVersion.getId(), LINKS, CUST_STRINGS, CUST_INTS, CUST_IDS, -1);
                        Configuration dfendProfile = new Configuration(new File(confFile), true);
                        String dstCap = FileUtils.constructCapturesDir(profileId);
                        String dstCapRelative = FileUtils.constructRelativeCapturesDir(profileId);
                        File dstCapAbsolute = FileUtils.canonicalToData(dstCap);
                        FileUtils.createDir(dstCapAbsolute);
                        FileUtils.copyFiles(new File(cap), dstCapAbsolute);
                        dfendProfile.setValue("dosbox", "captures", dstCapRelative);
                        this.cleanUp(dfendProfile);
                        if (this.defaultDBVersion.isMultiConfig()) {
                            dfendProfile.substract(this.standardProfile);
                        }
                        String newConfFile = FileUtils.constructUniqueConfigFileString(profileId, this.title, dfendProfile);
                        dfendProfile.saveToFile(FileUtils.canonicalToData(newConfFile), false, null);
                        dbase.updateProfileConf(newConfFile, dstCap, profileId);
                        this.messageLog.append(dfendExtra.getParsingProblems());
                        this.messageLog.append(dfendProfile.getParsingProblems());
                    }
                    catch (SQLException se) {
                        this.messageLog.append(se.getMessage()).append('\n');
                    }
                }
                catch (IOException e) {
                    this.messageLog.append(e.getMessage()).append('\n');
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            DFendImportThread.this.profileLabel.setText("Importing " + DFendImportThread.this.title + "...");
                            DFendImportThread.this.profileLabel.pack();
                            DFendImportThread.this.log.append(DFendImportThread.this.messageLog.toString());
                            ProgressBar progressBar = DFendImportThread.this.progressBar;
                            DFendImportThread dFendImportThread = DFendImportThread.this;
                            int n = dFendImportThread.profileNumber;
                            dFendImportThread.profileNumber = n + 1;
                            progressBar.setSelection(n);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            this.messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    DFendImportThread.this.log.append(DFendImportThread.this.messageLog.toString());
                }
            });
        }
    }

    private void cleanUp(Configuration dfendProfile) {
        if (this.performCleanup) {
            dfendProfile.removeSection("directserial");
            dfendProfile.removeSection("modem");
            dfendProfile.removeSection("ipx");
            dfendProfile.removeSection("sdl");
        }
        dfendProfile.removeValue("gus", "base");
        dfendProfile.removeValue("gus", "rate");
        dfendProfile.removeValue("sblaster", "base");
        dfendProfile.removeValue("sblaster", "type");
        if (dfendProfile.getValue(MIDI, MPU401).equals("true")) {
            if (dfendProfile.getValue(MIDI, INTELLIGENT).equals("true")) {
                dfendProfile.setValue(MIDI, MPU401, INTELLIGENT);
            } else if (dfendProfile.getValue(MIDI, INTELLIGENT).equals("false")) {
                dfendProfile.setValue(MIDI, MPU401, "uart");
            }
        } else if (dfendProfile.getValue(MIDI, MPU401).equals("false")) {
            dfendProfile.setValue(MIDI, MPU401, "none");
        }
        dfendProfile.removeValue(MIDI, INTELLIGENT);
    }
}

