/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.Profile;
import com.model.conf.Configuration;
import com.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class MigrateThread
extends Thread {
    private final File from;
    private final Display display;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private String title;
    private int profileNumber;
    private List<Profile> profilesList;
    private StringBuffer messageLog;

    public MigrateThread(File from, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.from = from;
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profileNumber = 0;
        try {
            Database dbase = Database.getInstance();
            this.profilesList = dbase.readProfilesList("GAM.TITLE");
            this.progressBar.setMaximum(this.profilesList.size());
        }
        catch (SQLException e) {
            this.profilesList = new ArrayList<Profile>();
            GeneralPurposeDialogs.warningMessage(log.getShell(), e.getMessage());
        }
    }

    public void run() {
        Database dbase = Database.getInstance();
        try {
            for (Profile prof : this.profilesList) {
                this.messageLog = new StringBuffer();
                this.title = prof.getTitle();
                try {
                    File newFile;
                    File file = prof.getCanonicalConfFile();
                    Configuration profileConf = new Configuration(file, true);
                    profileConf.makeRelative(this.from);
                    profileConf.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(prof.getId()));
                    profileConf.saveToFile(file, false, null);
                    String newConfigPath = prof.getConfPathAndFile();
                    if (new File(prof.getConfPathAndFile()).isAbsolute() && !(newFile = FileUtils.makeRelativeTo(file, this.from)).isAbsolute()) {
                        newConfigPath = String.valueOf(FileUtils.DOSROOT_DIR) + newFile.getPath();
                    }
                    dbase.updateProfileConf(newConfigPath, prof.getCaptures(), prof.getId());
                    String setup = prof.getSetup();
                    if (setup.length() > 0) {
                        setup = FileUtils.makeRelativeTo(new File(setup), this.from).getPath();
                    }
                    String[] links = prof.getLinks();
                    int i = 0;
                    while (i < links.length) {
                        File newFile2;
                        if (links[i].toLowerCase().startsWith("file://")) {
                            links[i] = links[i].substring(7);
                        }
                        if (!(links[i].equals("") || links[i].contains("://") || (newFile2 = FileUtils.makeRelativeTo(new File(links[i]), this.from)).isAbsolute())) {
                            links[i] = String.valueOf(FileUtils.DOSROOT_DIR) + newFile2.getPath();
                        }
                        ++i;
                    }
                    dbase.updateProfileSetupAndLinks(setup, links, prof.getId());
                }
                catch (IOException e) {
                    this.messageLog.append(e.getMessage()).append('\n');
                }
                if (!(this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed())) {
                    this.display.asyncExec(new Runnable(){

                        public void run() {
                            MigrateThread.this.profileLabel.setText("Migrating " + MigrateThread.this.title + "...");
                            MigrateThread.this.profileLabel.pack();
                            MigrateThread.this.log.append(MigrateThread.this.messageLog.toString());
                            ProgressBar progressBar = MigrateThread.this.progressBar;
                            MigrateThread migrateThread = MigrateThread.this;
                            int n = migrateThread.profileNumber;
                            migrateThread.profileNumber = n + 1;
                            progressBar.setSelection(n);
                        }
                    });
                    continue;
                }
                break;
            }
        }
        catch (Exception se) {
            this.messageLog.append(se.getMessage());
            this.display.asyncExec(new Runnable(){

                public void run() {
                    MigrateThread.this.log.append(MigrateThread.this.messageLog.toString());
                }
            });
        }
    }
}

