/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.BrowseArchiveDialog;
import com.model.Settings;
import com.util.FileUtils;
import com.util.StringUtils;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class BrowseButton {
    public static final String DFEND_PATH = "C:\\Program Files\\D-Fend\\";
    public static final String DFEND_PROFILES = "Profiles.dat";
    private final Button button;
    private Settings settings = Settings.getInstance();

    public BrowseButton(Composite composite, int style) {
        this.button = new Button(composite, style);
        this.button.setText(this.settings.msg("button.browse"));
    }

    public void connect(Shell shell, Text control, Text altControl, BrowseType browse, CanonicalType canon, Combo combo) {
        this.button.addSelectionListener((SelectionListener)new Sa(shell, control, altControl, browse, canon, combo));
    }

    public void setLayoutData(Object arg0) {
        this.button.setLayoutData(arg0);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowseType {
        DIR,
        FILE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CanonicalType {
        DOSROOT,
        DFEND,
        CDIMAGE,
        ZIP,
        DOSBOX,
        DOC,
        BOOTER,
        EXE,
        NONE;

    }

    private class Sa
    extends SelectionAdapter {
        private final Text field;
        private final Text alt;
        private final BrowseType browse;
        private final CanonicalType canon;
        private final Combo combo;
        private final Shell shell;

        public Sa(Shell shell, Text control, Text altControl, BrowseType browse, CanonicalType canon, Combo combo) {
            this.shell = shell;
            this.field = control;
            this.alt = altControl;
            this.browse = browse;
            this.canon = canon;
            this.combo = combo;
        }

        private String filterPath() {
            String path = this.field.getText();
            CanonicalType fileType = this.canon;
            if (path.equals("") && this.alt != null) {
                path = this.alt.getText();
                fileType = CanonicalType.DOSROOT;
            }
            switch (fileType) {
                case DOC: {
                    return FileUtils.canonicalToData(path).getPath();
                }
                case DOSROOT: 
                case ZIP: 
                case BOOTER: 
                case EXE: {
                    return FileUtils.canonicalToDosroot(path).getPath();
                }
                case DOSBOX: {
                    return FileUtils.canonicalToDosbox(path).getPath();
                }
                case DFEND: {
                    return BrowseButton.DFEND_PATH;
                }
                case CDIMAGE: {
                    String[] fPaths = StringUtils.textAreaToStringArray(this.field.getText(), this.field.getLineDelimiter());
                    if (fPaths.length <= 0) break;
                    return fPaths[0];
                }
            }
            return "";
        }

        private String getResult(String result, File filterPath, String[] filenames) {
            switch (this.canon) {
                case DOC: {
                    return FileUtils.makeRelativeToData(new File(result)).getPath();
                }
                case EXE: {
                    if (FileUtils.isArchive(result) || FileUtils.isIsoFile(result)) {
                        BrowseArchiveDialog dialog = new BrowseArchiveDialog(this.shell, 4096);
                        dialog.setFileToBrowse(result);
                        return (String)dialog.open();
                    }
                }
                case DOSROOT: 
                case ZIP: 
                case BOOTER: {
                    return FileUtils.makeRelativeToDosroot(new File(result)).getPath();
                }
                case DOSBOX: {
                    return FileUtils.makeRelativeToDosbox(new File(result)).getPath();
                }
                case CDIMAGE: {
                    File path = FileUtils.makeRelativeToDosroot(filterPath);
                    StringBuffer images = new StringBuffer();
                    String[] stringArray = filenames;
                    int n = filenames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        images.append(new File(path, file)).append(this.field.getLineDelimiter());
                        ++n2;
                    }
                    return images.toString();
                }
            }
            return result;
        }

        public void widgetSelected(SelectionEvent event) {
            String result = null;
            File filterPath = null;
            String[] filenames = null;
            if (this.browse == BrowseType.DIR) {
                DirectoryDialog dialog = new DirectoryDialog(this.shell);
                dialog.setFilterPath(this.filterPath());
                result = dialog.open();
            } else if (this.browse == BrowseType.FILE && this.canon == CanonicalType.EXE && (FileUtils.isArchive(this.filterPath()) || FileUtils.isIsoFile(this.filterPath()))) {
                result = this.filterPath();
            } else if (this.browse == BrowseType.FILE) {
                int style = this.canon == CanonicalType.CDIMAGE ? 4098 : 4096;
                FileDialog dialog = new FileDialog(this.shell, style);
                String[] filterNames = null;
                String[] filterExts = null;
                switch (this.canon) {
                    case DOC: {
                        filterNames = new String[]{"*"};
                        filterExts = new String[]{"*"};
                        break;
                    }
                    case EXE: {
                        String defFilterTitle = BrowseButton.this.settings.msg("filetype.exe");
                        String defaultFilter = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
                        if (this.combo.isEnabled()) {
                            defFilterTitle = String.valueOf(defFilterTitle) + ", " + BrowseButton.this.settings.msg("filetype.archive");
                            defaultFilter = String.valueOf(defaultFilter) + ";*.zip;*.ZIP;*.7z;*.7Z";
                        }
                        filterNames = new String[]{defFilterTitle, BrowseButton.this.settings.msg("filetype.cdimage"), BrowseButton.this.settings.msg("filetype.archive")};
                        filterExts = new String[]{defaultFilter, "*.iso;*.ISO;*.cue;*.CUE", "*.zip;*.ZIP;*.7z;*.7Z"};
                        break;
                    }
                    case ZIP: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.archive"), "*"};
                        filterExts = new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*"};
                        break;
                    }
                    case BOOTER: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.booterimage"), "*"};
                        filterExts = new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0", "*"};
                        break;
                    }
                    case DFEND: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.dfendprofile")};
                        filterExts = new String[]{BrowseButton.DFEND_PROFILES};
                        break;
                    }
                    case CDIMAGE: {
                        filterNames = new String[]{BrowseButton.this.settings.msg("filetype.cdimage"), "*"};
                        filterExts = new String[]{"*.iso;*.ISO;*.cue;*.CUE", "*"};
                    }
                }
                if (filterNames != null) {
                    dialog.setFilterNames(filterNames);
                }
                if (filterExts != null) {
                    dialog.setFilterExtensions(filterExts);
                }
                if (this.canon == CanonicalType.DFEND) {
                    dialog.setFileName(BrowseButton.DFEND_PROFILES);
                }
                dialog.setFilterPath(this.filterPath());
                result = dialog.open();
                if (this.canon == CanonicalType.CDIMAGE) {
                    filterPath = new File(dialog.getFilterPath());
                    filenames = dialog.getFileNames();
                }
            }
            if (result != null && (result = this.getResult(result, filterPath, filenames)) != null) {
                this.field.setText(result);
            }
        }
    }
}

