/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.db.Database;
import com.gui.AutoSelectCombo;
import com.gui.BrowseButton;
import com.gui.EditTemplateDialog;
import com.gui.GeneralPurposeDialogs;
import com.gui.GrabButton;
import com.gui.SettingsDialog;
import com.model.DosboxVersion;
import com.model.KeyValuePair;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.model.conf.CompositeConfiguration;
import com.model.conf.Configuration;
import com.util.FileUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProfileDialog
extends EditTemplateDialog {
    private boolean focusOnTitle = false;
    private List<KeyValuePair> developersList;
    private List<KeyValuePair> publishersList;
    private List<KeyValuePair> genresList;
    private List<KeyValuePair> yearsList;
    private List<Template> templatesList;
    private List<KeyValuePair> statusList;
    private List<KeyValuePair> custom1List;
    private List<KeyValuePair> custom2List;
    private List<KeyValuePair> custom3List;
    private List<KeyValuePair> custom4List;
    private AutoSelectCombo developer;
    private AutoSelectCombo publisher;
    private AutoSelectCombo genre;
    private AutoSelectCombo year;
    private AutoSelectCombo status;
    private Text link1;
    private Text link2;
    private Text link3;
    private Text link4;
    private BrowseButton link3BrowseButton;
    private BrowseButton link4BrowseButton;
    private Button favorite;
    private Text notes;
    private AutoSelectCombo custom1;
    private AutoSelectCombo custom2;
    private AutoSelectCombo custom3;
    private AutoSelectCombo custom4;
    private Text custom5;
    private Text custom6;
    private Text custom7;
    private Text custom8;
    private Scale custom9;
    private Spinner custom10;
    private Combo template;
    private Button loadfix;
    private Combo loadfix_value;
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text img1;
    private Text img2;
    private int templateIndex = -1;

    public EditProfileDialog(Shell parent) {
        super(parent);
    }

    public void setProfile(Profile prof) {
        this.result = prof;
    }

    public void sendToProfile(String file) {
        this.result = FileUtils.makeRelativeToDosroot(new File(file)).getPath();
    }

    public void focusTitle() {
        this.focusOnTitle = true;
    }

    @Override
    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.developersList = this.dbase.readDevelopersList();
            this.publishersList = this.dbase.readPublishersList();
            this.genresList = this.dbase.readGenresList();
            this.yearsList = this.dbase.readYearsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.statusList = this.dbase.readStatusList();
            this.custom1List = this.dbase.readCustomList(0);
            this.custom2List = this.dbase.readCustomList(1);
            this.custom3List = this.dbase.readCustomList(2);
            this.custom4List = this.dbase.readCustomList(3);
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e.getMessage());
            return false;
        }
        if (this.result instanceof Profile) {
            this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, ((Profile)this.result).getDbversionId());
            DosboxVersion dbversion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
            this.compConf = new CompositeConfiguration(dbversion, (Profile)this.result, true, this.getParent());
            if (this.compConf.getCompositeConf().isIncomplete() && !GeneralPurposeDialogs.confirmMessage(this.getParent(), this.settings.msg("dialog.profile.confirm.profileincomplete", new Object[]{"dosbox.conf", dbversion.getCanonicalConfFile()}))) {
                return false;
            }
        } else {
            this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
            DosboxVersion dbversion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
            this.templateIndex = Template.findDefault(this.templatesList);
            this.compConf = this.result instanceof String && FileUtils.isConfFile((String)this.result) ? new CompositeConfiguration(dbversion, FileUtils.canonicalToDosroot((String)this.result), true, this.getParent()) : (this.templateIndex != -1 ? new CompositeConfiguration(dbversion, this.templatesList.get(this.templateIndex), true, this.getParent()) : new CompositeConfiguration(dbversion, true, this.getParent()));
        }
        return true;
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(610, 475);
        if (this.result instanceof Profile) {
            this.shell.setText(this.settings.msg("dialog.profile.title.edit", new Object[]{((Profile)this.result).getTitle(), ((Profile)this.result).getId()}));
        } else if (this.result instanceof String) {
            this.shell.setText(this.settings.msg("dialog.profile.title.send", new Object[]{(String)this.result}));
        } else {
            this.shell.setText(this.settings.msg("dialog.profile.title.add"));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createCustomTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        Button okButton = this.createOkCancelButtons();
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditProfileDialog.this.isValid()) {
                    return;
                }
                try {
                    String capturesString;
                    if (EditProfileDialog.this.setButton.isEnabled()) {
                        EditProfileDialog.this.doLoadTemplateConf(EditProfileDialog.this.setButton, true, false);
                    }
                    int profileId = EditProfileDialog.this.dbase.addOrEditProfile(EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.status.getText(), EditProfileDialog.this.setup.getText(), EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.favorite.getSelection(), EditProfileDialog.this.developer.getKey(), EditProfileDialog.this.publisher.getKey(), EditProfileDialog.this.genre.getKey(), EditProfileDialog.this.year.getKey(), EditProfileDialog.this.status.getKey(), EditProfileDialog.this.compConf.getDbversionId(), new String[]{EditProfileDialog.this.link1.getText(), EditProfileDialog.this.link2.getText(), EditProfileDialog.this.link3.getText(), EditProfileDialog.this.link4.getText()}, new String[]{EditProfileDialog.this.custom1.getText(), EditProfileDialog.this.custom2.getText(), EditProfileDialog.this.custom3.getText(), EditProfileDialog.this.custom4.getText(), EditProfileDialog.this.custom5.getText(), EditProfileDialog.this.custom6.getText(), EditProfileDialog.this.custom7.getText(), EditProfileDialog.this.custom8.getText()}, new int[]{EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection()}, new int[]{EditProfileDialog.this.custom1.getKey(), EditProfileDialog.this.custom2.getKey(), EditProfileDialog.this.custom3.getKey(), EditProfileDialog.this.custom4.getKey()}, EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getId() : -1);
                    EditProfileDialog.this.compConf.setCompositeConf(EditProfileDialog.this.getConfigurationBySettings());
                    String confString = EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getConfPathAndFile() : FileUtils.constructUniqueConfigFileString(profileId, EditProfileDialog.this.title.getText(), EditProfileDialog.this.compConf.getCompositeConf());
                    if (EditProfileDialog.this.result instanceof Profile) {
                        capturesString = ((Profile)EditProfileDialog.this.result).getCaptures();
                    } else {
                        capturesString = FileUtils.constructCapturesDir(profileId);
                        FileUtils.createDir(FileUtils.canonicalToData(capturesString));
                    }
                    if (!(EditProfileDialog.this.result instanceof Profile)) {
                        EditProfileDialog.this.dbase.updateProfileConf(confString, capturesString, profileId);
                    }
                    EditProfileDialog.this.result = new Profile(profileId, EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.compConf.getDbversionId(), EditProfileDialog.this.setup.getText(), EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.link1.getText(), EditProfileDialog.this.link2.getText(), EditProfileDialog.this.favorite.getSelection(), EditProfileDialog.this.status.getText(), confString, capturesString, EditProfileDialog.this.link3.getText(), EditProfileDialog.this.link4.getText(), EditProfileDialog.this.custom1.getText(), EditProfileDialog.this.custom2.getText(), EditProfileDialog.this.custom3.getText(), EditProfileDialog.this.custom4.getText(), EditProfileDialog.this.custom5.getText(), EditProfileDialog.this.custom6.getText(), EditProfileDialog.this.custom7.getText(), EditProfileDialog.this.custom8.getText(), EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection());
                    EditProfileDialog.this.compConf.save((Profile)EditProfileDialog.this.result, EditProfileDialog.this.shell);
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, e1.getMessage());
                }
                EditProfileDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        for (Template templ : this.templatesList) {
            this.template.add(templ.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result instanceof Profile) {
            this.title.setText(((Profile)this.result).getTitle());
            this.developer.setText(((Profile)this.result).getDeveloperName());
            this.publisher.setText(((Profile)this.result).getPublisherName());
            this.genre.setText(((Profile)this.result).getGenre());
            this.year.setText(((Profile)this.result).getYear());
            this.link1.setText(((Profile)this.result).getLink(0));
            this.link2.setText(((Profile)this.result).getLink(1));
            this.link3.setText(((Profile)this.result).getLink(2));
            this.link4.setText(((Profile)this.result).getLink(3));
            this.status.setText(((Profile)this.result).getStatus());
            this.favorite.setSelection(((Profile)this.result).isDefault());
            this.notes.setText(((Profile)this.result).getNotes());
            this.setup.setText(((Profile)this.result).getSetup());
            this.setup_params.setText(((Profile)this.result).getSetupParameters());
            this.custom1.setText(((Profile)this.result).getCustomString(0));
            this.custom2.setText(((Profile)this.result).getCustomString(1));
            this.custom3.setText(((Profile)this.result).getCustomString(2));
            this.custom4.setText(((Profile)this.result).getCustomString(3));
            this.custom5.setText(((Profile)this.result).getCustomString(4));
            this.custom6.setText(((Profile)this.result).getCustomString(5));
            this.custom7.setText(((Profile)this.result).getCustomString(6));
            this.custom8.setText(((Profile)this.result).getCustomString(7));
            this.custom9.setSelection(((Profile)this.result).getCustomInt(0));
            this.custom10.setSelection(((Profile)this.result).getCustomInt(1));
            if (this.focusOnTitle) {
                this.title.selectAll();
                this.title.setFocus();
            }
        } else {
            this.title.setFocus();
            if (this.templateIndex != -1) {
                this.template.select(this.templateIndex);
            }
            if (this.result instanceof String) {
                if (FileUtils.isExecutable((String)this.result)) {
                    this.main.setText((String)this.result);
                } else if (FileUtils.isBooterImage((String)this.result)) {
                    this.img1.setText((String)this.result);
                }
            }
        }
        this.enableSettingsByConfiguration();
        this.selectSettingsByConfiguration();
        this.startListeners();
    }

    @Override
    protected void createMachineTab(TabFolder tabFolder) {
        super.createMachineTab(tabFolder);
        Label loadfixLabel = new Label((Composite)this.memoryGroup, 0);
        loadfixLabel.setText(this.settings.msg("dialog.profile.loadfix"));
        this.loadfix = new Button((Composite)this.memoryGroup, 32);
        this.loadfix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditProfileDialog.this.loadfix_value.setEnabled(EditProfileDialog.this.loadfix.getSelection());
            }
        });
        this.loadfix_value = new Combo((Composite)this.memoryGroup, 0);
        this.loadfix_value.setItems(this.settings.getValues("profile", "loadfix_value"));
        this.loadfix_value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label kbLabel = new Label((Composite)this.memoryGroup, 0);
        kbLabel.setText(this.settings.msg("dialog.profile.kb"));
    }

    @Override
    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.profile.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite.setLayout((Layout)gridLayout);
        this.infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.profile.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        Label developerLabel = new Label(composite, 0);
        developerLabel.setText(this.settings.msg("dialog.profile.developer"));
        this.developer = new AutoSelectCombo(composite, 0, this.developersList);
        this.developer.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.developer.setVisibleItemCount(15);
        Label publisherLabel = new Label(composite, 0);
        publisherLabel.setLayoutData((Object)new GridData());
        publisherLabel.setText(this.settings.msg("dialog.profile.publisher"));
        this.publisher = new AutoSelectCombo(composite, 0, this.publishersList);
        this.publisher.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.publisher.setVisibleItemCount(15);
        Label genreLabel = new Label(composite, 0);
        genreLabel.setText(this.settings.msg("dialog.profile.genre"));
        this.genre = new AutoSelectCombo(composite, 0, this.genresList);
        this.genre.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.genre.setVisibleItemCount(15);
        Label yearLabel = new Label(composite, 0);
        yearLabel.setLayoutData((Object)new GridData());
        yearLabel.setText(this.settings.msg("dialog.profile.year"));
        this.year = new AutoSelectCombo(composite, 0, this.yearsList);
        this.year.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.year.setVisibleItemCount(15);
        Label link1Label = new Label(composite, 0);
        link1Label.setText(this.settings.msg("dialog.profile.link1"));
        this.link1 = new Text(composite, 2048);
        this.link1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label link2Label = new Label(composite, 0);
        link2Label.setLayoutData((Object)new GridData());
        link2Label.setText(this.settings.msg("dialog.profile.link2"));
        this.link2 = new Text(composite, 2048);
        this.link2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label link3Label = new Label(composite, 0);
        link3Label.setText(this.settings.msg("dialog.profile.link3"));
        this.link3 = new Text(composite, 2048);
        this.link3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.link3BrowseButton = new BrowseButton(composite, 0);
        Label link4Label = new Label(composite, 0);
        link4Label.setText(this.settings.msg("dialog.profile.link4"));
        this.link4 = new Text(composite, 2048);
        this.link4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.link4BrowseButton = new BrowseButton(composite, 0);
        Label statusLabel = new Label(composite, 0);
        statusLabel.setText(this.settings.msg("dialog.profile.status"));
        this.status = new AutoSelectCombo(composite, 0, this.statusList);
        this.status.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.status.setVisibleItemCount(10);
        new Label(composite, 0);
        Label favoriteLabel = new Label(composite, 0);
        favoriteLabel.setText(this.settings.msg("dialog.profile.favorite"));
        this.favorite = new Button(composite, 32);
        new Label(composite, 0);
        Label notesLabel = new Label(composite, 0);
        notesLabel.setText(this.settings.msg("dialog.profile.notes"));
        this.notes = new Text(composite, 2626);
        GridData gridData = new GridData(4, 4, true, true, 5, 1);
        this.notes.setLayoutData((Object)gridData);
    }

    private void createCustomTab(TabFolder tabFolder) {
        TabItem customTabItem = new TabItem(tabFolder, 0);
        customTabItem.setText(this.settings.msg("dialog.profile.tab.custominfo"));
        Composite composite_8 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_21 = new GridLayout();
        gridLayout_21.numColumns = 2;
        composite_8.setLayout((Layout)gridLayout_21);
        customTabItem.setControl((Control)composite_8);
        Label custom1Label = new Label(composite_8, 0);
        custom1Label.setText(this.settings.getValue("gui", "custom1"));
        this.custom1 = new AutoSelectCombo(composite_8, 0, this.custom1List);
        this.custom1.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label custom2Label = new Label(composite_8, 0);
        custom2Label.setText(this.settings.getValue("gui", "custom2"));
        this.custom2 = new AutoSelectCombo(composite_8, 0, this.custom2List);
        this.custom2.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label custom3Label = new Label(composite_8, 0);
        custom3Label.setText(this.settings.getValue("gui", "custom3"));
        this.custom3 = new AutoSelectCombo(composite_8, 0, this.custom3List);
        this.custom3.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label custom4Label = new Label(composite_8, 0);
        custom4Label.setText(this.settings.getValue("gui", "custom4"));
        this.custom4 = new AutoSelectCombo(composite_8, 0, this.custom4List);
        this.custom4.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label custom5Label = new Label(composite_8, 0);
        custom5Label.setText(this.settings.getValue("gui", "custom5"));
        this.custom5 = new Text(composite_8, 2048);
        this.custom5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label custom6Label = new Label(composite_8, 0);
        custom6Label.setText(this.settings.getValue("gui", "custom6"));
        this.custom6 = new Text(composite_8, 2048);
        this.custom6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label custom7Label = new Label(composite_8, 0);
        custom7Label.setText(this.settings.getValue("gui", "custom7"));
        this.custom7 = new Text(composite_8, 2048);
        this.custom7.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label custom8Label = new Label(composite_8, 0);
        custom8Label.setText(this.settings.getValue("gui", "custom8"));
        this.custom8 = new Text(composite_8, 2048);
        this.custom8.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label custom9Label = new Label(composite_8, 0);
        custom9Label.setText(this.settings.getValue("gui", "custom9"));
        this.custom9 = new Scale(composite_8, 0);
        this.custom9.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label custom10Label = new Label(composite_8, 0);
        custom10Label.setText(this.settings.getValue("gui", "custom10"));
        this.custom10 = new Spinner(composite_8, 2048);
        this.custom10.setLayoutData((Object)new GridData(100, -1));
        this.custom10.setMinimum(Integer.MIN_VALUE);
        this.custom10.setMaximum(Integer.MAX_VALUE);
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        super.createGeneralTab(tabFolder);
        Label templateLabel = new Label((Composite)this.associationGroup, 0);
        templateLabel.setText(this.settings.msg("dialog.profile.template"));
        this.template = new Combo((Composite)this.associationGroup, 8);
        GridData gridData_6 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.template.setLayoutData((Object)gridData_6);
        Button reloadButton2 = new Button((Composite)this.associationGroup, 0);
        reloadButton2.setText(this.settings.msg("dialog.profile.reloadsettings"));
        reloadButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.template.getSelectionIndex() != -1) {
                    EditProfileDialog.this.doLoadTemplateConf(EditProfileDialog.this.setButton, false, true);
                }
            }
        });
        Label configFileLabel = new Label((Composite)this.miscGroup, 0);
        configFileLabel.setText(this.settings.msg("dialog.profile.configfile"));
        Text config_file = new Text((Composite)this.miscGroup, 2048);
        config_file.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        config_file.setEditable(false);
        config_file.setText(this.result instanceof Profile ? ((Profile)this.result).getConfPathAndFile() : String.valueOf(SettingsDialog.confLocations[this.settings.getIntValue("profiledefaults", "confpath")]) + ", " + SettingsDialog.confFilenames[this.settings.getIntValue("profiledefaults", "conffile")]);
    }

    @Override
    protected void createExecuteGroup(Composite composite) {
        Group executeGroup = new Group(composite, 0);
        executeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        executeGroup.setText(this.settings.msg("dialog.profile.execute"));
        GridLayout gridLayout_18 = new GridLayout();
        gridLayout_18.numColumns = 6;
        executeGroup.setLayout((Layout)gridLayout_18);
        this.dosButton = new Button((Composite)executeGroup, 16);
        this.dosButton.setText(this.settings.msg("dialog.template.dos"));
        Label mainExeLabel = new Label((Composite)executeGroup, 0);
        mainExeLabel.setText(this.settings.msg("dialog.profile.mainexe"));
        this.main = new Text((Composite)executeGroup, 2048);
        GridData gridData_1 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.main.setLayoutData((Object)gridData_1);
        this.link3BrowseButton.connect(this.shell, this.link3, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, null);
        this.link4BrowseButton.connect(this.shell, this.link4, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, null);
        BrowseButton mainBrowseButton = new BrowseButton((Composite)executeGroup, 0);
        mainBrowseButton.connect(this.shell, this.main, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, this.pixelshader);
        GrabButton grab1 = new GrabButton((Composite)executeGroup, 0);
        grab1.connect(this.main, this.mountingpoints);
        new Label((Composite)executeGroup, 0);
        new Label((Composite)executeGroup, 0);
        Label parametersLabel = new Label((Composite)executeGroup, 0);
        parametersLabel.setLayoutData((Object)new GridData());
        parametersLabel.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.main_params = new Text((Composite)executeGroup, 2048);
        this.main_params.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)executeGroup, 0);
        new Label((Composite)executeGroup, 0);
        new Label((Composite)executeGroup, 0);
        Label setupLabel = new Label((Composite)executeGroup, 0);
        setupLabel.setLayoutData((Object)new GridData());
        setupLabel.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setup = new Text((Composite)executeGroup, 2048);
        this.setup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton setupBrowseButton = new BrowseButton((Composite)executeGroup, 0);
        setupBrowseButton.connect(this.shell, this.setup, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, this.pixelshader);
        GrabButton grab2 = new GrabButton((Composite)executeGroup, 0);
        grab2.connect(this.setup, this.mountingpoints);
        new Label((Composite)executeGroup, 0);
        new Label((Composite)executeGroup, 0);
        Label parametersLabel_1 = new Label((Composite)executeGroup, 0);
        parametersLabel_1.setLayoutData((Object)new GridData());
        parametersLabel_1.setText(this.settings.msg("dialog.profile.setupparameters"));
        this.setup_params = new Text((Composite)executeGroup, 2048);
        this.setup_params.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)executeGroup, 0);
        new Label((Composite)executeGroup, 0);
        Label label_1 = new Label((Composite)executeGroup, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 6, 1));
        this.booterButton = new Button((Composite)executeGroup, 16);
        this.booterButton.setText(this.settings.msg("dialog.template.booter"));
        Label image1Label = new Label((Composite)executeGroup, 0);
        image1Label.setText(this.settings.msg("dialog.profile.booterimage1"));
        this.img1 = new Text((Composite)executeGroup, 2048);
        this.img1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton img1BrowseButton = new BrowseButton((Composite)executeGroup, 0);
        img1BrowseButton.connect(this.shell, this.img1, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, null);
        GrabButton grab3 = new GrabButton((Composite)executeGroup, 0);
        grab3.connect(this.img1, this.mountingpoints);
        new Label((Composite)executeGroup, 0);
        Label image2Label = new Label((Composite)executeGroup, 0);
        image2Label.setText(this.settings.msg("dialog.profile.booterimage2"));
        this.img2 = new Text((Composite)executeGroup, 2048);
        this.img2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        BrowseButton img2BrowseButton = new BrowseButton((Composite)executeGroup, 0);
        img2BrowseButton.connect(this.shell, this.img2, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, null);
        GrabButton grab4 = new GrabButton((Composite)executeGroup, 0);
        grab4.connect(this.img2, this.mountingpoints);
    }

    private void startListeners() {
        VerifyListener addMountListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (event.text.length() > 1) {
                    boolean booter = event.widget == EditProfileDialog.this.img1 || event.widget == EditProfileDialog.this.img2;
                    EditProfileDialog.this.addMountIfNoMounts(event.text, booter);
                }
            }
        };
        ModifyListener exeListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                boolean booter = event.widget == EditProfileDialog.this.img1 || event.widget == EditProfileDialog.this.img2;
                EditProfileDialog.this.dosButton.setSelection(!booter);
                EditProfileDialog.this.booterButton.setSelection(booter);
            }
        };
        this.main.addVerifyListener(addMountListener);
        this.setup.addVerifyListener(addMountListener);
        this.img1.addVerifyListener(addMountListener);
        this.img2.addVerifyListener(addMountListener);
        this.main.addModifyListener(exeListener);
        this.main_params.addModifyListener(exeListener);
        this.setup.addModifyListener(exeListener);
        this.setup_params.addModifyListener(exeListener);
        this.img1.addModifyListener(exeListener);
        this.img2.addModifyListener(exeListener);
    }

    private void addMountIfNoMounts(String hostFileLocation, boolean booter) {
        if (this.mountingpoints.getItemCount() == 0) {
            try {
                this.mountingpoints.setItems(this.compConf.addRequiredMount(booter, hostFileLocation));
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Profile duplicateProfile(Profile prof, List<DosboxVersion> dbversionsList, Database dbase, Shell shell) {
        try {
            int dbversionIndex = DosboxVersion.findById(dbversionsList, prof.getDbversionId());
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            CompositeConfiguration newCompositeConf = new CompositeConfiguration(dbversion, prof, true, shell);
            int newProfileId = dbase.duplicateProfile(prof.getId());
            String newCapturesString = FileUtils.constructCapturesDir(newProfileId);
            File newCaptures = FileUtils.canonicalToData(newCapturesString);
            FileUtils.createDir(newCaptures);
            String newConfFile = FileUtils.constructUniqueConfigFileString(newProfileId, prof.getTitle(), newCompositeConf.getCompositeConf());
            Profile newProfile = new Profile(newProfileId, newConfFile, newCapturesString, prof);
            newCompositeConf.save(newProfile, shell);
            dbase.updateProfileConf(newConfFile, newCapturesString, newProfileId);
            if (GeneralPurposeDialogs.confirmMessage(shell, Settings.getInstance().msg("dialog.profile.confirm.capturesduplication"))) {
                FileUtils.copyFiles(prof.getCanonicalCaptures(), newCaptures);
            }
            return newProfile;
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
            return null;
        }
    }

    @Override
    protected CompositeConfiguration obtainNewConf(boolean keepValues, boolean isTemplate) {
        if (isTemplate) {
            return new CompositeConfiguration(this.compConf, (DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), this.templatesList.get(this.template.getSelectionIndex()), false, this.shell);
        }
        return new CompositeConfiguration(this.compConf, (DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), keepValues, isTemplate, this.shell);
    }

    @Override
    protected void selectSettingsByConfiguration() {
        super.selectSettingsByConfiguration();
        Configuration conf = this.compConf.getCompositeConf();
        this.captures.setText(this.result instanceof Profile ? ((Profile)this.result).getCaptures() : this.settings.msg("dialog.profile.automatic"));
        this.loadfix.setSelection(conf.isLoadfix());
        this.loadfix_value.setText(conf.getLoadfixValue());
        this.loadfix_value.setEnabled(conf.isLoadfix());
        if (conf.isBooter()) {
            this.img1.setText(conf.getImg1());
            this.img2.setText(conf.getImg2());
        } else {
            this.main.setText(conf.getMain());
            this.main_params.setText(conf.getMainParameters());
        }
    }

    @Override
    protected Configuration getConfigurationBySettings() {
        Configuration conf = super.getConfigurationBySettings();
        conf.setAutoexecSettings(this.loadfix.getSelection(), this.loadfix_value.getText(), this.main.getText(), this.main_params.getText(), this.img1.getText(), this.img2.getText());
        return conf;
    }

    @Override
    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String requiredMount = null;
        if (this.title.getText().length() == 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.title"), (Control)this.title, this.infoTabItem);
        }
        if (this.dosButton.getSelection()) {
            if (FileUtils.isExecutable(this.main.getText())) {
                requiredMount = this.dealWithField(false, this.main.getText());
            } else {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), (Control)this.main, this.mountingTabItem);
            }
            if (FileUtils.isExecutable(this.setup.getText())) {
                requiredMount = this.dealWithField(false, this.setup.getText());
            }
        } else if (this.booterButton.getSelection()) {
            if (this.img1.getText().length() == 0) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.booterimage"), (Control)this.img1, this.mountingTabItem);
            } else {
                requiredMount = this.dealWithField(true, this.img1.getText());
            }
            if (this.img2.getText().length() > 0) {
                requiredMount = this.dealWithField(true, this.img2.getText());
            }
        }
        if (requiredMount != null) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mountlocation"), (Control)this.mountingpoints, this.mountingTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private String dealWithField(boolean booter, String loc) {
        String requiredMount = this.compConf.getRequiredMount(booter, loc);
        if (requiredMount != null && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.profile.confirm.addmountlocation", new Object[]{requiredMount}))) {
            this.mountingpoints.setItems(this.compConf.addRequiredMount(booter, loc));
        }
        return this.compConf.getRequiredMount(booter, loc);
    }
}

