/*
 * Decompiled with CFR 0.152.
 */
package com.loopy.impl;

import com.loopy.exception.LoopyException;
import com.loopy.iface.FileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractFileSystem
implements FileSystem {
    private File file;
    private RandomAccessFile channel;

    protected AbstractFileSystem(File file) throws LoopyException {
        this.file = file;
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + this.file);
            }
            this.channel = new RandomAccessFile(this.file, "r");
        }
        catch (IOException ex) {
            throw new LoopyException("Error opening the file", ex);
        }
    }

    public synchronized void close() throws LoopyException {
        if (this.isClosed()) {
            return;
        }
        try {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                throw new LoopyException("Error closing file system", ex);
            }
        }
        finally {
            this.channel = null;
        }
    }

    public boolean isClosed() {
        return this.channel == null;
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }

    protected void seek(long pos) throws IOException {
        this.ensureOpen();
        this.channel.seek(pos);
    }

    protected int read(byte[] buffer, int bufferOffset, int len) throws IOException {
        this.ensureOpen();
        return this.channel.read(buffer, bufferOffset, len);
    }
}

