/*
 * Decompiled with CFR 0.152.
 */
package com.loopy.iso9660;

import com.loopy.iface.FileEntry;
import com.loopy.iso9660.ISO9660FileEntry;
import com.loopy.iso9660.ISO9660FileSystem;
import com.loopy.util.LittleEndian;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryEnumeration
implements Enumeration<FileEntry> {
    private final ISO9660FileSystem fileSystem;
    private final List<ISO9660FileEntry> queue;

    public EntryEnumeration(ISO9660FileSystem fileSystem, ISO9660FileEntry rootEntry) {
        this.fileSystem = fileSystem;
        this.queue = new LinkedList<ISO9660FileEntry>();
        this.queue.add(rootEntry);
    }

    @Override
    public boolean hasMoreElements() {
        return !this.queue.isEmpty();
    }

    @Override
    public FileEntry nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ISO9660FileEntry entry = this.queue.remove(0);
        if (entry.isDirectory()) {
            byte[] content;
            try {
                content = this.fileSystem.getBytes(entry);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            int offset = 0;
            boolean paddingMode = false;
            while (offset < content.length) {
                if (LittleEndian.getUInt8(content, offset) <= 0) {
                    paddingMode = true;
                    offset += 2;
                    continue;
                }
                ISO9660FileEntry child = new ISO9660FileEntry(this.fileSystem, entry.getPath(), content, offset + 1);
                if (paddingMode && child.getSize() < 0) continue;
                offset += child.getEntryLength();
                if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                this.queue.add(child);
            }
        }
        return entry;
    }
}

