/*
 * Decompiled with CFR 0.152.
 */
package com.loopy.iso9660;

import com.loopy.iface.FileEntry;
import com.loopy.iface.VolumeDescriptorSet;
import com.loopy.impl.AbstractBlockFileSystem;
import com.loopy.iso9660.EntryEnumeration;
import com.loopy.iso9660.ISO9660FileEntry;
import com.loopy.iso9660.ISO9660VolumeDescriptorSet;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISO9660FileSystem
extends AbstractBlockFileSystem {
    public ISO9660FileSystem(File file) throws IOException {
        super(file, 2048, 16);
    }

    public String getEncoding() {
        return ((ISO9660VolumeDescriptorSet)this.getVolumeDescriptorSet()).getEncoding();
    }

    byte[] getBytes(ISO9660FileEntry entry) throws IOException {
        int size = entry.getSize();
        byte[] buf = new byte[size];
        this.readBytes(entry, 0, buf, 0, size);
        return buf;
    }

    private int readBytes(ISO9660FileEntry entry, int entryOffset, byte[] buffer, int bufferOffset, int len) throws IOException {
        long startPos = entry.getStartBlock() * 2048L + (long)entryOffset;
        return this.readData(startPos, buffer, bufferOffset, len);
    }

    @Override
    protected Enumeration<FileEntry> enumerate(FileEntry rootEntry) {
        return new EntryEnumeration(this, (ISO9660FileEntry)rootEntry);
    }

    @Override
    protected VolumeDescriptorSet createVolumeDescriptorSet() {
        return new ISO9660VolumeDescriptorSet(this);
    }
}

