/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.model.KeyValuePair;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoSelectCombo {
    private final Combo combo;
    private final List<KeyValuePair> possibleValues;
    private int currentLength;
    private boolean mutex;

    public AutoSelectCombo(Composite composite, int style, List<KeyValuePair> possibleValues) {
        this.combo = new Combo(composite, style);
        this.possibleValues = possibleValues;
        for (KeyValuePair val : this.possibleValues) {
            this.add(val.getValue());
        }
        this.combo.pack();
        this.currentLength = 0;
        this.mutex = false;
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!AutoSelectCombo.this.mutex) {
                    int index = AutoSelectCombo.this.indexOfClosestMatch(AutoSelectCombo.this.combo.getText());
                    int newLength = AutoSelectCombo.this.combo.getText().length();
                    if (newLength > AutoSelectCombo.this.currentLength && index != -1) {
                        AutoSelectCombo.this.mutex = true;
                        AutoSelectCombo.this.combo.setText(String.valueOf(AutoSelectCombo.this.combo.getText()) + AutoSelectCombo.this.combo.getItem(index).substring(newLength));
                        AutoSelectCombo.this.combo.setSelection(new Point(newLength, AutoSelectCombo.this.combo.getText().length()));
                        AutoSelectCombo.this.mutex = false;
                    }
                    AutoSelectCombo.this.currentLength = newLength;
                }
            }
        });
    }

    public void setLayoutData(Object arg0) {
        this.combo.setLayoutData(arg0);
    }

    public void setVisibleItemCount(int arg0) {
        this.combo.setVisibleItemCount(arg0);
    }

    public void add(String arg0) {
        this.combo.add(arg0);
    }

    public String getText() {
        return this.combo.getText();
    }

    public void select(int arg0) {
        this.combo.select(arg0);
    }

    public void setText(String arg0) {
        this.combo.setText(arg0);
        this.currentLength = this.combo.getText().length();
    }

    public int getKey() {
        int index = this.combo.indexOf(this.combo.getText());
        return index == -1 ? index : this.possibleValues.get(index).getId();
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public int indexOf(String arg0) {
        return this.combo.indexOf(arg0);
    }

    public int indexOfClosestMatch(String text) {
        int i = 0;
        while (i < this.combo.getItemCount()) {
            if (this.combo.getItem(i).toLowerCase().startsWith(text.toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

