/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.model.Settings;
import com.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public final class GeneralPurposeDialogs {
    private static List<String> errorMessages;
    private static Control wgt;
    private static TabItem tab;

    public static void fatalMessage(Shell shell, String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65569);
            messageBox.setText(Settings.getInstance().msg("general.fatalerror"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        } else {
            System.out.println(String.valueOf(Settings.getInstance().msg("general.fatalerror")) + ": " + theMessage);
        }
    }

    public static void warningMessage(Shell shell, String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65576);
            messageBox.setText(Settings.getInstance().msg("general.warning"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        } else {
            System.out.println(String.valueOf(Settings.getInstance().msg("general.warning")) + ": " + theMessage);
        }
    }

    public static void infoMessage(Shell shell, String theMessage) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65570);
            messageBox.setText(Settings.getInstance().msg("general.information"));
            messageBox.setMessage(theMessage);
            messageBox.open();
        } else {
            System.out.println(String.valueOf(Settings.getInstance().msg("general.information")) + ": " + theMessage);
        }
    }

    public static boolean confirmMessage(Shell shell, String theMessage) {
        MessageBox messageBox = new MessageBox(shell, 65736);
        messageBox.setText(Settings.getInstance().msg("general.confirmation"));
        messageBox.setMessage(theMessage);
        return messageBox.open() == 64;
    }

    public static void initErrorDialog() {
        errorMessages = new ArrayList<String>();
        wgt = null;
        tab = null;
    }

    public static void addError(String msg, Control widget) {
        GeneralPurposeDialogs.addError(msg, widget, null);
    }

    public static void addError(String msg, Control widget, TabItem tabItem) {
        if (errorMessages.isEmpty()) {
            wgt = widget;
            tab = tabItem;
        }
        errorMessages.add(msg);
    }

    public static boolean displayErrorDialog(Shell shell) {
        boolean errors;
        boolean bl = errors = !errorMessages.isEmpty();
        if (errors) {
            if (tab != null) {
                TabFolder folder = tab.getParent();
                folder.setSelection(tab);
            }
            GeneralPurposeDialogs.infoMessage(shell, StringUtils.stringArrayToString(errorMessages.toArray(new String[errorMessages.size()]), "\n"));
            wgt.setFocus();
        }
        return errors;
    }
}

