/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.GeneralPurposeDialogs;
import com.gui.MainWindow;
import com.gui.SizeControlAdapter;
import com.model.Settings;
import com.model.conf.Configuration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class SettingsDialog
extends Dialog {
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("da", "de", "en", "es", "nl", "zh", "zh_TW");
    private static final int EDITABLE_COLUMN = 0;
    public static final String[] confLocations = new String[]{Settings.getInstance().msg("dialog.settings.confindbgldir"), Settings.getInstance().msg("dialog.settings.confingamedir")};
    public static final String[] confFilenames = new String[]{Settings.getInstance().msg("dialog.settings.conffilebyid"), Settings.getInstance().msg("dialog.settings.conffilebytitle")};
    private Table visible_columns;
    private boolean changedVisColumns = false;
    private TableItem[] visibleColumns;
    private TabItem columnsTabItem;
    private Combo confFilename;
    private Combo confLocation;
    private Combo localeCombo;
    private Text port;
    private Label heightValue;
    private Scale screenshotsHeight;
    private int previousSelection = -1;
    private Text values;
    private Configuration conf;
    private org.eclipse.swt.widgets.List options;
    protected Object result;
    protected Shell shell;
    private Settings settings;

    public SettingsDialog(Shell parent, int style) {
        super(parent, style);
    }

    public SettingsDialog(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.conf = new Configuration(this.settings, false, null, false);
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.result = this.changedVisColumns;
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "settingsdialog"));
        this.shell.setText(this.settings.msg("dialog.settings.title"));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.settings.tab.general"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        generalTabItem.setControl((Control)composite);
        Group dosboxGroup = new Group(composite, 0);
        dosboxGroup.setText(this.settings.msg("dialog.settings.dosbox"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dosboxGroup.setLayout((Layout)gridLayout);
        Label showConsoleLabel = new Label((Composite)dosboxGroup, 0);
        showConsoleLabel.setText(this.settings.msg("dialog.settings.hidestatuswindow"));
        final Button console = new Button((Composite)dosboxGroup, 32);
        console.setSelection(this.conf.getBooleanValue("dosbox", "hideconsole"));
        Group sendToGroup = new Group(composite, 0);
        sendToGroup.setText(this.settings.msg("dialog.settings.sendto"));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        sendToGroup.setLayout((Layout)gridLayout_2);
        Label enableCommLabel = new Label((Composite)sendToGroup, 0);
        enableCommLabel.setText(this.settings.msg("dialog.settings.enableport"));
        final Button portEnabled = new Button((Composite)sendToGroup, 32);
        portEnabled.setSelection(this.conf.getBooleanValue("communication", "port_enabled"));
        portEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.port.setEnabled(portEnabled.getSelection());
            }
        });
        Label portnumberLabel = new Label((Composite)sendToGroup, 0);
        portnumberLabel.setText(this.settings.msg("dialog.settings.port"));
        this.port = new Text((Composite)sendToGroup, 2048);
        this.port.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.port.setText(this.conf.getValue("communication", "port"));
        this.port.setEnabled(portEnabled.getSelection());
        Group profileDefGroup = new Group(composite, 0);
        profileDefGroup.setText(this.settings.msg("dialog.settings.profiledefaults"));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        profileDefGroup.setLayout((Layout)gridLayout_3);
        Label configFileLabel = new Label((Composite)profileDefGroup, 0);
        configFileLabel.setText(this.settings.msg("dialog.settings.configfile"));
        this.confLocation = new Combo((Composite)profileDefGroup, 8);
        this.confLocation.setItems(confLocations);
        this.confLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.confLocation.select(this.conf.getIntValue("profiledefaults", "confpath"));
        this.confFilename = new Combo((Composite)profileDefGroup, 8);
        this.confFilename.setItems(confFilenames);
        this.confFilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.confFilename.select(this.conf.getIntValue("profiledefaults", "conffile"));
        Group i18nGroup = new Group(composite, 0);
        i18nGroup.setText(this.settings.msg("dialog.settings.i18n"));
        GridLayout gridLayout_30 = new GridLayout();
        gridLayout_30.numColumns = 2;
        i18nGroup.setLayout((Layout)gridLayout_30);
        Label languageLabel = new Label((Composite)i18nGroup, 0);
        languageLabel.setText(this.settings.msg("dialog.settings.languagecountry"));
        this.localeCombo = new Combo((Composite)i18nGroup, 8);
        Locale locale = new Locale(this.settings.getValue("locale", "language"), this.settings.getValue("locale", "country"));
        final TreeMap<String, Locale> locales = new TreeMap<String, Locale>();
        String locString = "";
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale loc = localeArray[n2];
            if (SUPPORTED_LANGUAGES.isEmpty() || SUPPORTED_LANGUAGES.contains(loc.toString())) {
                StringBuffer s = new StringBuffer(loc.getDisplayLanguage(Locale.getDefault()));
                if (loc.getCountry().length() > 0) {
                    s.append(" - ").append(loc.getDisplayCountry(Locale.getDefault()));
                }
                locales.put(s.toString(), loc);
                if (loc.equals(locale)) {
                    locString = s.toString();
                }
            }
            ++n2;
        }
        for (String sloc : locales.keySet()) {
            this.localeCombo.add(sloc);
        }
        this.localeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.localeCombo.setText(locString);
        this.columnsTabItem = new TabItem(tabFolder, 0);
        this.columnsTabItem.setText(this.settings.msg("dialog.settings.tab.profiletable"));
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        composite2.setLayout((Layout)new BorderLayout(0, 0));
        this.columnsTabItem.setControl((Control)composite2);
        Group visColumnsGroup = new Group(composite2, 0);
        visColumnsGroup.setLayout((Layout)new FillLayout());
        visColumnsGroup.setText(this.settings.msg("dialog.settings.visiblecolunms"));
        this.visible_columns = new Table((Composite)visColumnsGroup, 67616);
        this.visible_columns.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.visible_columns, 0);
        column1.setWidth(350);
        this.visibleColumns = new TableItem[MainWindow.columnNames.length];
        int i = 0;
        while (i < MainWindow.columnNames.length) {
            this.visibleColumns[i] = new TableItem(this.visible_columns, 2048);
            this.visibleColumns[i].setText(MainWindow.columnNames[i]);
            this.visibleColumns[i].setChecked(this.conf.getBooleanValue("gui", "column" + (i + 1) + "visible"));
            ++i;
        }
        final TableEditor editor = new TableEditor(this.visible_columns);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        this.visible_columns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)event.item) == null) {
                    return;
                }
                if (item.getParent().getSelectionIndex() < 10) {
                    return;
                }
                Text newEditor = new Text((Composite)SettingsDialog.this.visible_columns, 0);
                newEditor.setText(item.getText(0));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent mEvent) {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(0, text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 0);
            }
        });
        Group addProfGroup = new Group(composite2, 0);
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 2;
        addProfGroup.setLayout((Layout)gridLayout_4);
        addProfGroup.setText(this.settings.msg("dialog.settings.addeditduplicateprofile"));
        addProfGroup.setLayoutData((Object)"South");
        Label autoSortLabel = new Label((Composite)addProfGroup, 0);
        autoSortLabel.setText(this.settings.msg("dialog.settings.autosort"));
        final Button autosort = new Button((Composite)addProfGroup, 32);
        autosort.setSelection(this.conf.getBooleanValue("gui", "autosortonupdate"));
        TabItem dynTabItem = new TabItem(tabFolder, 0);
        dynTabItem.setText(this.settings.msg("dialog.settings.tab.dynamicoptions"));
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        composite_1.setLayout((Layout)new FillLayout());
        dynTabItem.setControl((Control)composite_1);
        Group dynOptionsGroup = new Group(composite_1, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        dynOptionsGroup.setLayout((Layout)gridLayout_1);
        dynOptionsGroup.setText(this.settings.msg("dialog.settings.dynamicoptions"));
        Label optionsLabel = new Label((Composite)dynOptionsGroup, 0);
        optionsLabel.setText(this.settings.msg("dialog.settings.options"));
        Label valuesLabel = new Label((Composite)dynOptionsGroup, 0);
        valuesLabel.setText(this.settings.msg("dialog.settings.values"));
        this.options = new org.eclipse.swt.widgets.List((Composite)dynOptionsGroup, 2560);
        this.options.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.storeValues();
                SettingsDialog.this.previousSelection = SettingsDialog.this.options.getSelectionIndex();
                SettingsDialog.this.values.setText(SettingsDialog.this.conf.getMultilineValues("profile", SettingsDialog.this.options.getItem(SettingsDialog.this.previousSelection), SettingsDialog.this.values.getLineDelimiter()));
            }
        });
        this.options.setLayoutData((Object)new GridData(4, 4, true, true));
        String[] stringArray = this.conf.getItems("profile");
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray[n4];
            this.options.add(s);
            ++n4;
        }
        this.values = new Text((Composite)dynOptionsGroup, 2818);
        this.values.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new RowLayout());
        composite_7.setLayoutData((Object)"South");
        TabItem guiTabItem = new TabItem(tabFolder, 0);
        guiTabItem.setText(this.settings.msg("dialog.settings.tab.gui"));
        Composite composite1 = new Composite((Composite)tabFolder, 0);
        GridLayout composite1Layout = new GridLayout();
        composite1Layout.makeColumnsEqualWidth = true;
        composite1.setLayout((Layout)composite1Layout);
        guiTabItem.setControl((Control)composite1);
        Group screenshots = new Group(composite1, 0);
        GridLayout screenshotsLayout = new GridLayout();
        screenshotsLayout.numColumns = 3;
        screenshots.setLayout((Layout)screenshotsLayout);
        GridData screenshotsLData = new GridData();
        screenshotsLData.grabExcessHorizontalSpace = true;
        screenshotsLData.horizontalAlignment = 4;
        screenshots.setLayoutData((Object)screenshotsLData);
        screenshots.setText(this.settings.msg("dialog.settings.screenshots"));
        Label heightLabel = new Label((Composite)screenshots, 0);
        heightLabel.setText(this.settings.msg("dialog.settings.height"));
        this.screenshotsHeight = new Scale((Composite)screenshots, 0);
        this.screenshotsHeight.setMaximum(750);
        this.screenshotsHeight.setMinimum(50);
        GridData sshotsHeightData = new GridData();
        sshotsHeightData.grabExcessHorizontalSpace = true;
        sshotsHeightData.horizontalAlignment = 4;
        this.screenshotsHeight.setLayoutData((Object)sshotsHeightData);
        this.screenshotsHeight.setIncrement(25);
        this.screenshotsHeight.setPageIncrement(100);
        this.screenshotsHeight.setSelection(this.conf.getIntValue("gui", "screenshotsheight"));
        this.screenshotsHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SettingsDialog.this.heightValue.setText(String.valueOf(SettingsDialog.this.screenshotsHeight.getSelection()) + SettingsDialog.this.settings.msg("dialog.settings.px"));
                SettingsDialog.this.heightValue.pack();
            }
        });
        this.heightValue = new Label((Composite)screenshots, 0);
        this.heightValue.setText(String.valueOf(this.screenshotsHeight.getSelection()) + this.settings.msg("dialog.settings.px"));
        Button okButton = new Button(composite_7, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!SettingsDialog.this.isValid()) {
                    return;
                }
                int i = 0;
                while (i < MainWindow.columnNames.length) {
                    if (SettingsDialog.this.conf.getBooleanValue("gui", "column" + (i + 1) + "visible") != SettingsDialog.this.visibleColumns[i].getChecked()) {
                        SettingsDialog.this.changedVisColumns = true;
                    }
                    ++i;
                }
                i = 0;
                while (i < 10) {
                    if (!MainWindow.columnNames[i + 10].equals(SettingsDialog.this.visibleColumns[i + 10].getText())) {
                        SettingsDialog.this.changedVisColumns = true;
                    }
                    ++i;
                }
                if (SettingsDialog.this.changedVisColumns) {
                    SettingsDialog.this.resetColumnSettings();
                }
                SettingsDialog.this.conf.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                SettingsDialog.this.conf.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                SettingsDialog.this.conf.setValue("communication", "port", SettingsDialog.this.port.getText());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "confpath", SettingsDialog.this.confLocation.getSelectionIndex());
                SettingsDialog.this.conf.setIntValue("profiledefaults", "conffile", SettingsDialog.this.confFilename.getSelectionIndex());
                SettingsDialog.this.conf.setValue("locale", "language", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getLanguage());
                SettingsDialog.this.conf.setValue("locale", "country", ((Locale)locales.get(SettingsDialog.this.localeCombo.getText())).getCountry());
                i = 0;
                while (i < MainWindow.columnNames.length) {
                    SettingsDialog.this.conf.setBooleanValue("gui", "column" + (i + 1) + "visible", SettingsDialog.this.visibleColumns[i].getChecked());
                    ++i;
                }
                SettingsDialog.this.conf.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
                i = 0;
                while (i < 10) {
                    SettingsDialog.this.conf.setValue("gui", "custom" + (i + 1), SettingsDialog.this.visibleColumns[i + 10].getText());
                    ++i;
                }
                SettingsDialog.this.conf.setIntValue("gui", "screenshotsheight", SettingsDialog.this.screenshotsHeight.getSelection());
                Rectangle rec = SettingsDialog.this.shell.getBounds();
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_width", rec.width);
                SettingsDialog.this.conf.setIntValue("gui", "settingsdialog_height", rec.height);
                SettingsDialog.this.storeValues();
                SettingsDialog.this.settings.updateAndExtendWithValuesFrom(SettingsDialog.this.conf);
                SettingsDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(okButton);
        RowData rowData = new RowData();
        rowData.width = 80;
        okButton.setLayoutData((Object)rowData);
        okButton.setText(this.settings.msg("button.ok"));
        Button cancelButton = new Button(composite_7, 0);
        RowData rowData_1 = new RowData();
        rowData_1.width = 80;
        cancelButton.setLayoutData((Object)rowData_1);
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.shell.close();
            }
        });
    }

    private void storeValues() {
        if (this.previousSelection != -1) {
            this.conf.setMultilineValues("profile", this.options.getItem(this.previousSelection), this.values.getText(), this.values.getLineDelimiter());
        }
    }

    private int countVisibleColumns() {
        int result = 0;
        int i = 0;
        while (i < MainWindow.columnNames.length) {
            if (this.visibleColumns[i].getChecked()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private int getFirstVisibleColumn() {
        int i = 0;
        while (i < MainWindow.columnNames.length) {
            if (this.visibleColumns[i].getChecked()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void resetColumnSettings() {
        this.conf.setIntValue("gui", "sortcolumn", this.getFirstVisibleColumn());
        this.conf.setBooleanValue("gui", "sortascending", true);
        StringBuffer colOrder = new StringBuffer();
        int i = 0;
        while (i < this.countVisibleColumns()) {
            colOrder.append(i).append(' ');
            ++i;
        }
        this.conf.setValue("gui", "columnorder", colOrder.toString().trim());
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.countVisibleColumns() == 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.settings.required.onevisiblecolumn"), (Control)this.visible_columns, this.columnsTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

