/*
 * Decompiled with CFR 0.152.
 */
package com.loopy.iso9660;

import com.loopy.iso9660.EntryEnumeration;
import com.loopy.iso9660.ISO9660FileEntry;
import com.loopy.iso9660.ISO9660VolumeDescriptorSet;
import com.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISO9660FileSystem {
    public static final int COOKED_SECTOR_SIZE = 2048;
    public static final int VCD_SECTOR_SIZE = 2336;
    public static final int RAW_SECTOR_SIZE = 2352;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final int RESERVED_SECTORS = 16;
    private int blockSize;
    private boolean mode2;
    private ISO9660VolumeDescriptorSet volumeDescriptorSet;
    private RandomAccessFile channel;

    public ISO9660FileSystem(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not found");
        }
        if (file.getName().toLowerCase().endsWith(FileUtils.CDIMAGES[1])) {
            File binFile = this.parseCueSheet(file);
            if (binFile == null) {
                throw new IOException("Couldn't parse cue sheet");
            }
            file = binFile;
        }
        this.channel = new RandomAccessFile(file, "r");
        this.volumeDescriptorSet = new ISO9660VolumeDescriptorSet(this);
        if (!(this.canReadVolumeDescriptors(2048, false) || this.canReadVolumeDescriptors(2352, false) || this.canReadVolumeDescriptors(2336, true) || this.canReadVolumeDescriptors(2352, true))) {
            throw new IOException("Couldn't find volume descriptor, the cd-image doesn't seem to be in ISO9660 file format");
        }
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                throw new IOException("Couldn't close file channel");
            }
        }
        finally {
            this.channel = null;
        }
    }

    public Enumeration<ISO9660FileEntry> getEntries() {
        this.ensureOpen();
        return new EntryEnumeration(this, this.volumeDescriptorSet.getRootEntry());
    }

    public String getEncoding() {
        return this.volumeDescriptorSet.getEncoding();
    }

    byte[] getBytes(ISO9660FileEntry entry) throws IOException {
        int size = entry.getSize();
        byte[] buf = new byte[size];
        int sectorsToRead = size / 2048;
        int i = 0;
        while (i < sectorsToRead) {
            this.readBlock(entry.getStartBlock() + (long)i, buf, i * 2048);
            ++i;
        }
        return buf;
    }

    private File parseCueSheet(File file) throws IOException {
        String orgTextLine;
        File result = null;
        FileReader reader = new FileReader(file);
        BufferedReader configData = new BufferedReader(reader);
        while ((orgTextLine = configData.readLine()) != null) {
            if ((orgTextLine = orgTextLine.trim()).length() <= 0 || !orgTextLine.startsWith("FILE")) continue;
            int idx1 = orgTextLine.indexOf(34, 5);
            int idx2 = orgTextLine.lastIndexOf(34);
            if (idx1 == -1 || idx2 == -1 || idx1 >= idx2) continue;
            String binFilename = orgTextLine.substring(idx1 + 1, idx2);
            result = new File(binFilename).isAbsolute() ? new File(binFilename) : new File(file.getParent(), binFilename);
        }
        ((Reader)reader).close();
        return result;
    }

    private boolean canReadVolumeDescriptors(int sectorSize, boolean mode2) {
        this.blockSize = sectorSize;
        this.mode2 = mode2;
        byte[] buffer = new byte[2048];
        try {
            int block = 16;
            while (this.readBlock(block, buffer, 0) && !this.volumeDescriptorSet.deserialize(buffer)) {
                ++block;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.volumeDescriptorSet.getRootEntry() != null;
    }

    private boolean readBlock(long block, byte[] buffer, int bufOffset) throws IOException {
        int bytesRead = this.readData(block * (long)this.blockSize, buffer, bufOffset, 2048);
        if (bytesRead <= 0) {
            return false;
        }
        if (2048 != bytesRead) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    private synchronized int readData(long startPos, byte[] buffer, int offset, int len) throws IOException {
        this.ensureOpen();
        long pos = startPos;
        if (this.blockSize == 2352 && !this.mode2) {
            pos += 16L;
        }
        if (this.mode2) {
            pos += 24L;
        }
        this.channel.seek(pos);
        return this.channel.read(buffer, offset, len);
    }

    private boolean isClosed() {
        return this.channel == null;
    }

    private void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }
}

