/*
 * Decompiled with CFR 0.152.
 */
package com.model;

import com.model.conf.Configuration;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Settings
extends Configuration {
    private static final String SAMPLE_RATES = "8000 11025 16000 22050 32000 44100 48000 49716";
    private static final String BASE_ADDRS = "220 240 260 280 2a0 2c0 2e0 300";
    private static final String IRQS = "3 5 7 9 10 11 12";
    private static final String DMAS = "0 1 3 5 6 7";
    private static final File SETTINGS_CONF = new File("settings.conf");
    private static Locale locale;
    private static ResourceBundle mes;
    private static MessageFormat formatter;

    private Settings() {
        this.init();
        try {
            if (SETTINGS_CONF.isFile() && SETTINGS_CONF.canRead()) {
                this.parseConfigurationFile(SETTINGS_CONF, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        locale = new Locale(this.getValue("locale", "language"), this.getValue("locale", "country"));
        mes = ResourceBundle.getBundle("i18n/MessagesBundle", locale);
        formatter = new MessageFormat("");
        formatter.setLocale(locale);
    }

    public static Settings getInstance() {
        return SettingsHolder.instance;
    }

    public void save() throws IOException {
        this.saveToFile(SETTINGS_CONF, true, null);
    }

    private void init() {
        this.setGuiDefaults();
        this.setIntValue("profiledefaults", "confpath", 0);
        this.setIntValue("profiledefaults", "conffile", 0);
        this.setBooleanValue("dosbox", "hideconsole", false);
        this.setBooleanValue("communication", "port_enabled", true);
        this.setValue("communication", "port", "4740");
        this.setValue("database", "connectionstring", "jdbc:hsqldb:file:./db/database");
        this.setValue("database", "username", "sa");
        this.setValue("database", "pasword", "");
        this.setValue("directory", "data", ".");
        this.setValue("directory", "dosbox", ".");
        this.setValue("locale", "language", "en");
        this.setValue("locale", "country", "");
        this.setProfileDefaults();
    }

    private void setProfileDefaults() {
        this.setValue("profile", "priority_active", "lowest lower normal higher highest");
        this.setValue("profile", "priority_inactive", "lowest lower normal higher highest pause");
        this.setValue("profile", "output", "ddraw direct3d overlay opengl openglhq openglnb surface");
        this.setValue("profile", "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
        this.setValue("profile", "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x tv2x tv3x rgb2x rgb3x scan2x scan3x supereagle super2xsai 2xsai hq2x hq3x hardware2x hardware3x tv tvadvmame2x normal4x");
        this.setValue("profile", "pixelshader", "none 2xsai.fx 2xsai_srgb.fx bilinear.fx cartoon.fx gs2x.fx gs4x.fx gs4xcolor.fx gs4xcolorfilter.fx gs4xcolorscale.fx gs4xfilter.fx gs4xscale.fx matrix.fx mcgreen.fx mcorange.fx point.fx scale2x.fx scale2x_ps14.fx sketch.fx");
        this.setValue("profile", "fullresolution", "original 0x0 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.setValue("profile", "windowresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        this.setValue("profile", "svgachipset", "none et3000 et4000 et4000new pvga1a s3");
        this.setValue("profile", "videoram", "256 512 1024 2048 3072 4096");
        this.setValue("profile", "vsyncmode", "off on force");
        this.setValue("profile", "machine", "cga hercules pcjr tandy vga");
        this.setValue("profile", "machine073", "cga hercules pcjr tandy ega vgaonly svga_s3 svga_et3000 svga_et4000 svga_paradise vesa_nolfb vesa_oldvbe");
        this.setValue("profile", "cputype", "auto 386 386_slow 486_slow pentium_slow 386_prefetch");
        this.setValue("profile", "core", "dynamic full normal simple auto");
        this.setValue("profile", "cycles", "350 500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max<space>50% max<space>80% max<space>90% max");
        this.setValue("profile", "cycles_up", "20 50 100 500 1000 2000 5000 10000");
        this.setValue("profile", "cycles_down", "20 50 100 500 1000 2000 5000 10000");
        this.setValue("profile", "memsize", "0 1 2 4 8 16 32 63");
        this.setValue("profile", "umb", "false true max");
        this.setValue("profile", "loadfix_value", "1 63 127");
        this.setValue("profile", "rate", SAMPLE_RATES);
        this.setValue("profile", "blocksize", "256 512 1024 2048 4096 8192");
        this.setValue("profile", "prebuffer", "10");
        this.setValue("profile", "mpu401", "none intelligent uart");
        this.setValue("profile", "device", "alsa default coreaudio coremidi mt32 none oss win32");
        this.setValue("profile", "mt32rate", SAMPLE_RATES);
        this.setValue("profile", "sbtype", "none sb1 sb2 sbpro1 sbpro2 sb16");
        this.setValue("profile", "oplrate", SAMPLE_RATES);
        this.setValue("profile", "oplmode", "auto cms opl2 dualopl2 opl3");
        this.setValue("profile", "oplemu", "default compat fast old");
        this.setValue("profile", "sbbase", BASE_ADDRS);
        this.setValue("profile", "irq", IRQS);
        this.setValue("profile", "dma", DMAS);
        this.setValue("profile", "hdma", DMAS);
        this.setValue("profile", "gusrate", SAMPLE_RATES);
        this.setValue("profile", "gusbase", BASE_ADDRS);
        this.setValue("profile", "irq1", IRQS);
        this.setValue("profile", "irq2", IRQS);
        this.setValue("profile", "dma1", DMAS);
        this.setValue("profile", "dma2", DMAS);
        this.setValue("profile", "pcrate", SAMPLE_RATES);
        this.setValue("profile", "tandy", "auto off on");
        this.setValue("profile", "tandyrate", SAMPLE_RATES);
        this.setValue("profile", "sensitivity", "10 20 30 40 50 60 70 80 90 100 125 150 175 200 250 300 350 400 450 500 550 600 700 800 900 1000");
        this.setValue("profile", "joysticktype", "auto none 2axis 4axis 4axis_2 ch fcs");
        this.setValue("profile", "mount_type", "cdrom dir floppy");
        this.setValue("profile", "zipmount_type", "cdrom dir floppy");
        this.setValue("profile", "freesize", "1 10 100 200 500 1000");
        this.setValue("profile", "lowlevelcd_type", "aspi ioctl ioctl_dx ioctl_dio ioctl_mci noioctl");
    }

    private void setGuiDefaults() {
        this.setValue("gui", "width", "904");
        this.setValue("gui", "height", "475");
        this.setValue("gui", "x", "10");
        this.setValue("gui", "y", "10");
        this.setValue("gui", "profiledialog_width", "660");
        this.setValue("gui", "profiledialog_height", "475");
        this.setValue("gui", "dosboxdialog_width", "600");
        this.setValue("gui", "dosboxdialog_height", "325");
        this.setValue("gui", "templatedialog_width", "660");
        this.setValue("gui", "templatedialog_height", "475");
        this.setValue("gui", "mountdialog_width", "640");
        this.setValue("gui", "mountdialog_height", "500");
        this.setValue("gui", "archivebrowser_width", "400");
        this.setValue("gui", "archivebrowser_height", "375");
        this.setValue("gui", "dfendimportdialog_width", "600");
        this.setValue("gui", "dfendimportdialog_height", "375");
        this.setValue("gui", "exportlistdialog_width", "550");
        this.setValue("gui", "exportlistdialog_height", "190");
        this.setValue("gui", "migratedialog_width", "600");
        this.setValue("gui", "migratedialog_height", "375");
        this.setValue("gui", "settingsdialog_width", "600");
        this.setValue("gui", "settingsdialog_height", "375");
        this.setBooleanValue("gui", "maximized", false);
        this.setValue("gui", "column1width", "150");
        this.setValue("gui", "column2width", "48");
        this.setValue("gui", "column3width", "100");
        this.setValue("gui", "column4width", "100");
        this.setValue("gui", "column5width", "70");
        this.setValue("gui", "column6width", "40");
        this.setValue("gui", "column7width", "60");
        this.setValue("gui", "column8width", "60");
        this.setValue("gui", "column9width", "38");
        this.setValue("gui", "column10width", "40");
        this.setValue("gui", "column11width", "70");
        this.setValue("gui", "column12width", "70");
        this.setValue("gui", "column13width", "70");
        this.setValue("gui", "column14width", "70");
        this.setValue("gui", "column15width", "70");
        this.setValue("gui", "column16width", "70");
        this.setValue("gui", "column17width", "70");
        this.setValue("gui", "column18width", "70");
        this.setValue("gui", "column19width", "44");
        this.setValue("gui", "column20width", "44");
        this.setBooleanValue("gui", "column1visible", true);
        this.setBooleanValue("gui", "column2visible", true);
        this.setBooleanValue("gui", "column3visible", true);
        this.setBooleanValue("gui", "column4visible", true);
        this.setBooleanValue("gui", "column5visible", true);
        this.setBooleanValue("gui", "column6visible", true);
        this.setBooleanValue("gui", "column7visible", true);
        this.setBooleanValue("gui", "column8visible", true);
        this.setBooleanValue("gui", "column9visible", true);
        this.setBooleanValue("gui", "column10visible", false);
        this.setBooleanValue("gui", "column11visible", false);
        this.setBooleanValue("gui", "column12visible", false);
        this.setBooleanValue("gui", "column13visible", false);
        this.setBooleanValue("gui", "column14visible", false);
        this.setBooleanValue("gui", "column15visible", false);
        this.setBooleanValue("gui", "column16visible", false);
        this.setBooleanValue("gui", "column17visible", false);
        this.setBooleanValue("gui", "column18visible", false);
        this.setBooleanValue("gui", "column19visible", false);
        this.setBooleanValue("gui", "column20visible", false);
        this.setValue("gui", "column2_1width", "300");
        this.setValue("gui", "column2_2width", "250");
        this.setValue("gui", "column2_3width", "50");
        this.setValue("gui", "column2_4width", "38");
        this.setValue("gui", "column3_1width", "500");
        this.setValue("gui", "column3_2width", "50");
        this.setValue("gui", "sortcolumn", "0 8");
        this.setValue("gui", "sortascending", "true true");
        this.setValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
        this.setValue("gui", "sashweights", "777 222");
        this.setValue("gui", "screenshotsheight", "100");
        this.setBooleanValue("gui", "autosortonupdate", false);
        this.setValue("gui", "custom1", "Custom1");
        this.setValue("gui", "custom2", "Custom2");
        this.setValue("gui", "custom3", "Custom3");
        this.setValue("gui", "custom4", "Custom4");
        this.setValue("gui", "custom5", "Custom5");
        this.setValue("gui", "custom6", "Custom6");
        this.setValue("gui", "custom7", "Custom7");
        this.setValue("gui", "custom8", "Custom8");
        this.setValue("gui", "custom9", "Custom9");
        this.setValue("gui", "custom10", "Custom10");
    }

    public String msg(String key) {
        return mes.getString(key);
    }

    public String msg(String key, Object[] objs) {
        formatter.applyPattern(mes.getString(key));
        return formatter.format(objs);
    }

    /* synthetic */ Settings(Settings settings) {
        this();
    }

    private static class SettingsHolder {
        private static Settings instance = new Settings(null);

        private SettingsHolder() {
        }
    }
}

