/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.EditProfileDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Settings;
import org.eclipse.swt.widgets.Shell;

public final class SendToProfile
extends Shell {
    private static final String LOCALHOST = "localhost";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(Settings.getInstance().msg("external.notice.addcmdusage"));
            System.exit(1);
        }
        try {
            Settings settings = Settings.getInstance();
            Socket socket = new Socket(LOCALHOST, settings.getIntValue("communication", "port"));
            new PrintWriter(socket.getOutputStream(), true).println("sendtoprofile " + args[0]);
            socket.close();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            SendToProfile.openDialogMyself(args[0]);
        }
    }

    private static void openDialogMyself(String file) {
        Database dbase = Database.getInstance();
        Shell shell = new Shell();
        shell.setMinimized(true);
        shell.open();
        try {
            List<DosboxVersion> dbversionsList = dbase.readDosboxVersionsList();
            if (DosboxVersion.findDefault(dbversionsList) == -1) {
                GeneralPurposeDialogs.infoMessage(shell, Settings.getInstance().msg("dialog.main.required.defaultdosboxversion"));
                try {
                    dbase.shutdown();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                return;
            }
            EditProfileDialog editProfDialog = new EditProfileDialog(shell);
            editProfDialog.sendToProfile(file);
            editProfDialog.open();
        }
        catch (SQLException e1) {
            GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
        }
        try {
            dbase.shutdown();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

