/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.List;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DosboxVersion
extends KeyTitleDefault
implements Comparable<DosboxVersion> {
    public static final String[] SUPP_RELEASES = new String[]{"0.63", "0.65", "0.70", "0.71", "0.72", "0.73"};
    private final String path;
    private final boolean multiConfig;
    private final String parameters;
    private final String version;

    public DosboxVersion(int id, String title, String path, boolean multiConfig, boolean isDefault, String parameters, String version) {
        super(id, title, isDefault);
        this.path = path;
        this.multiConfig = multiConfig;
        this.parameters = parameters;
        this.version = version;
    }

    public boolean isMultiConfig() {
        return this.multiConfig;
    }

    public String getPath() {
        return this.path;
    }

    public File getCanonicalExecutable() {
        return FileUtils.constructCanonicalDBExeLocation(this.path);
    }

    public File getCanonicalConfFile() {
        return FileUtils.constructCanonicalDBConfLocation(this.path);
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getVersion() {
        return this.version;
    }

    public int findBestMatchId(List<DosboxVersion> dbversionsList) {
        for (DosboxVersion dbv : dbversionsList) {
            if (this.distance(dbv) != 0 || !this.getTitle().equals(dbv.getTitle())) continue;
            return dbv.getId();
        }
        DosboxVersion theDefault = dbversionsList.get(DosboxVersion.findDefault(dbversionsList));
        if (this.distance(theDefault) == 0) {
            return theDefault.getId();
        }
        int result = dbversionsList.get(1).getId();
        int distance = this.distance(dbversionsList.get(1));
        for (DosboxVersion dbv : dbversionsList) {
            if (this.distance(dbv) >= distance) continue;
            result = dbv.getId();
            distance = this.distance(dbv);
        }
        return result;
    }

    private int getVersionInt() {
        return Integer.valueOf(this.version.substring(2));
    }

    private int distance(DosboxVersion ver) {
        return Math.abs(ver.getVersionInt() - this.getVersionInt());
    }

    @Override
    public int compareTo(DosboxVersion arg0) {
        int ver2;
        DosboxVersion comp = arg0;
        int ver1 = this.getVersionInt();
        if (ver1 != (ver2 = comp.getVersionInt())) {
            return ver1 - ver2;
        }
        return this.getTitle().compareTo(comp.getTitle());
    }
}

