/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.IInStream;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.dbgl.gui.StreamGobbler;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.Settings;
import org.dbgl.model.Template;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.model.conf.Configuration;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int ZIP_BUFFER = 2156;
    private static final File DATA_DIR_FILE;
    private static final File DOSROOT_DIR_FILE;
    private static final File DOSBOX_DIR_FILE;
    private static final String TEMPLATES_DIR;
    private static final String SETUP_CONF = "setup.conf";
    private static final String TEMPLATE_CONF = "template.conf";
    public static final String PROFILES_XML = "profiles.xml";
    public static final String DOSROOT_DIR;
    public static final String CAPTURES_DIR;
    public static final String PROFILES_DIR;
    public static final String EXPORT_DIR;
    public static final String XSL_DIR;
    public static final String XSL_EXT = ".xsl";
    public static final String XML_EXT = ".xml";
    public static final String CONF_EXT = ".conf";
    public static final String[] CDIMAGES;
    public static final String[] EXECUTABLES;
    public static final String[] ARCHIVES;
    public static final String[] BOOTERIMAGES;
    public static final String[] PICTURES;
    public static final String DOSBOX_CONF = "dosbox.conf";
    public static final String CNF_FILTER = "*.conf;*.CONF";
    public static final String EXE_FILTER = "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT";
    public static final String ARC_FILTER = "*.zip;*.ZIP;*.7z;*.7Z";
    public static final String BTR_FILTER = "*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0";
    public static final String CDI_FILTER = "*.iso;*.ISO;*.cue;*.CUE";
    public static final String ALL_FILTER = "*";

    public static String getCanonicalPath(String path) {
        String canPath = path;
        if ((PlatformUtils.IS_LINUX || PlatformUtils.IS_OSX) && (canPath.startsWith("~/") || canPath.length() == 1 && canPath.charAt(0) == '~')) {
            canPath = canPath.replaceAll("^~", System.getProperty("user.home"));
        }
        try {
            return new File(canPath).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(canPath).getAbsolutePath();
        }
    }

    public static boolean isExistingFile(File file) {
        return file.isFile() && file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void copy(File source, File dest) {
        block22: {
            AbstractInterruptibleChannel outStream;
            FileChannel inStream;
            block20: {
                inStream = null;
                outStream = null;
                inStream = new FileInputStream(source).getChannel();
                outStream = new FileOutputStream(dest).getChannel();
                inStream.transferTo(0L, inStream.size(), (WritableByteChannel)((Object)outStream));
                if (inStream == null) break block20;
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException ex) {
                    System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                }
            }
            break block22;
            catch (IOException e) {
                block21: {
                    try {
                        System.err.println(Settings.getInstance().msg("general.error.copyfile", new Object[]{source, dest}));
                        if (inStream == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException ex) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                            }
                        }
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (IOException ex) {
                                System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileinputstream", new Object[]{source}));
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException ex) {
                        System.err.println(Settings.getInstance().msg("general.error.closefileoutputstream", new Object[]{source}));
                    }
                }
            }
        }
    }

    private static void executeCommand(List<String> execCommands, File cwd, boolean waitFor) throws IOException {
        StringBuffer cmd = new StringBuffer();
        try {
            if (Settings.getInstance().getBooleanValue("dosbox", "hideconsole")) {
                execCommands.add("-noconsole");
            }
            String[] rtCmds = new String[execCommands.size()];
            for (int i = 0; i < execCommands.size(); ++i) {
                rtCmds[i] = execCommands.get(i);
                cmd.append(rtCmds[i]).append(' ');
            }
            System.out.println(cmd);
            File dir = cwd == null ? DOSROOT_DIR_FILE : cwd;
            Process proc = Runtime.getRuntime().exec(rtCmds, null, dir);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "DOSBox stderr");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "DOSBox stdout");
            outputGobbler.start();
            errorGobbler.start();
            if (waitFor) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(Settings.getInstance().msg("general.error.startdosbox", new Object[]{cmd}));
        }
    }

    private static void doRunDosbox(DosboxVersion dbversion, List<String> parameters, File cwd, boolean waitFor) throws IOException {
        ArrayList<String> commandItems = new ArrayList<String>();
        commandItems.add(dbversion.getCanonicalExecutable().getPath());
        commandItems.addAll(parameters);
        if (dbversion.getParameters().length() > 0) {
            for (String p : dbversion.getParameters().split(" ")) {
                commandItems.add(p);
            }
        }
        FileUtils.executeCommand(commandItems, cwd, waitFor);
    }

    private static File canonicalTo(File base, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        try {
            return new File(base, file.getPath()).getCanonicalFile();
        }
        catch (IOException e) {
            return new File(base, file.getPath()).getAbsoluteFile();
        }
    }

    public static boolean areRelated(File parent, File child) {
        for (File remainder = child.getParentFile(); remainder != null; remainder = remainder.getParentFile()) {
            if (!parent.equals(remainder)) continue;
            return true;
        }
        return false;
    }

    public static String getDosRoot() {
        return DOSROOT_DIR_FILE.getPath();
    }

    public static File makeRelativeTo(File file, File basePath) {
        if (!file.isAbsolute()) {
            return file;
        }
        if (file.equals(basePath)) {
            return new File(".");
        }
        File remainder = new File(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(basePath)) {
                return remainder;
            }
            remainder = new File(parent.getName(), remainder.getPath());
        }
        return file;
    }

    public static File makeRelativeToData(File file) {
        return FileUtils.makeRelativeTo(file, DATA_DIR_FILE);
    }

    public static File makeRelativeToDosroot(File file) {
        return FileUtils.makeRelativeTo(file, DOSROOT_DIR_FILE);
    }

    public static File makeRelativeToDosbox(File file) {
        return FileUtils.makeRelativeTo(file, DOSBOX_DIR_FILE);
    }

    public static File canonicalToData(String path) {
        return FileUtils.canonicalTo(DATA_DIR_FILE, path);
    }

    public static File canonicalToDosbox(String path) {
        return FileUtils.canonicalTo(DOSBOX_DIR_FILE, path);
    }

    public static File canonicalToDosroot(String path) {
        return FileUtils.canonicalTo(DOSROOT_DIR_FILE, path);
    }

    public static String sanitizeToDosroot(String path) {
        return FileUtils.makeRelativeToDosroot(FileUtils.canonicalToDosroot(path)).getPath();
    }

    public static File constructCanonicalDBConfLocation(String path) {
        return FileUtils.canonicalToDosbox(new File(path, DOSBOX_CONF).getPath());
    }

    public static File constructCanonicalDBExeLocation(String path) {
        return FileUtils.canonicalToDosbox(new File(path, PlatformUtils.DB_EXECUTABLE).getPath());
    }

    public static String constructCapturesDir(int profileId) {
        return CAPTURES_DIR + profileId;
    }

    public static String constructRelativeCapturesDir(int profileId) {
        return ".." + File.separatorChar + FileUtils.constructCapturesDir(profileId);
    }

    public static File constructCanonicalTemplateFileLocation(int templateId) {
        return FileUtils.canonicalToData(TEMPLATES_DIR + templateId + CONF_EXT);
    }

    public static String constructUniqueConfigFileString(int profileId, String profileTitle, Configuration gameConf) {
        Settings set = Settings.getInstance();
        File candidate = null;
        int candidateNr = 1;
        boolean unique = false;
        while (!unique) {
            String candidateFile;
            File candidatePath = set.getIntValue("profiledefaults", "confpath") == 1 ? gameConf.getCanonicalMainDir() : new File(PROFILES_DIR);
            if (set.getIntValue("profiledefaults", "conffile") == 1) {
                String candidateTitle = profileTitle;
                if (candidateNr > 1) {
                    candidateTitle = candidateTitle + "(" + candidateNr + ")";
                }
                candidateFile = candidateTitle.replaceAll("[^a-zA-Z_0-9()]", "") + CONF_EXT;
            } else {
                if (candidateNr > 1) {
                    return null;
                }
                candidateFile = profileId + CONF_EXT;
            }
            ++candidateNr;
            candidate = new File(candidatePath, candidateFile);
            unique = !FileUtils.isExistingFile(candidate);
        }
        return candidate.getPath();
    }

    public static void doRunDosbox(DosboxVersion dbversion) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-conf");
        parameters.add(dbversion.getCanonicalConfFile().getPath());
        FileUtils.doRunDosbox(dbversion, parameters, null, false);
    }

    public static void doCreateDosboxConf(DosboxVersion dbversion) throws IOException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-c");
        parameters.add("config -writeconf dosbox.conf");
        parameters.add("-c");
        parameters.add("exit");
        FileUtils.doRunDosbox(dbversion, parameters, dbversion.getCanonicalExecutable().getParentFile(), true);
    }

    public static void doRunProfile(Profile prof, List<DosboxVersion> dbversions, boolean setup) throws IOException {
        DosboxVersion dbv = dbversions.get(DosboxVersion.findById(dbversions, prof.getDbversionId()));
        FileUtils.doRunProfile(prof, dbv, setup);
    }

    public static void doRunTemplate(Template template, List<DosboxVersion> dbversions) throws IOException {
        DosboxVersion dbv = dbversions.get(DosboxVersion.findById(dbversions, template.getDbversionId()));
        FileUtils.doRunTemplate(template, dbv);
    }

    public static void doRunProfile(Profile prof, DosboxVersion dbversion, boolean setup) throws IOException {
        ArrayList<String> confs = new ArrayList<String>();
        confs.add(dbversion.getCanonicalExecutable().getPath());
        if (dbversion.isMultiConfig()) {
            confs.add("-conf");
            confs.add(dbversion.getCanonicalConfFile().getPath());
        }
        File file = prof.getCanonicalConfFile();
        if (setup && prof.hasSetup()) {
            CompositeConfiguration cconf = new CompositeConfiguration(dbversion, prof, false, null, System.out);
            Configuration conf = cconf.getCompositeConf();
            conf.setAutoexecSettings(prof.getSetup(), prof.getSetupParameters());
            file = FileUtils.canonicalToData(PROFILES_DIR + SETUP_CONF);
            cconf.save(file, null, System.out);
        }
        confs.add("-conf");
        confs.add(file.getPath());
        if (dbversion.getParameters().length() > 0) {
            for (String p : dbversion.getParameters().split(" ")) {
                confs.add(p);
            }
        }
        FileUtils.executeCommand(confs, null, false);
    }

    public static void doRunTemplate(Template template, DosboxVersion dbversion) throws IOException {
        ArrayList<String> confs = new ArrayList<String>();
        confs.add(dbversion.getCanonicalExecutable().getPath());
        if (dbversion.isMultiConfig()) {
            confs.add("-conf");
            confs.add(dbversion.getCanonicalConfFile().getPath());
        }
        File file = FileUtils.constructCanonicalTemplateFileLocation(template.getId());
        CompositeConfiguration cconf = new CompositeConfiguration(dbversion, template, false, null, System.out);
        Configuration conf = cconf.getCompositeConf();
        conf.setAutoexecSettings(false, "", "", "", "", "");
        conf.setAutoexecSettings(false);
        file = FileUtils.canonicalToData(PROFILES_DIR + TEMPLATE_CONF);
        cconf.save(file, null, System.out);
        confs.add("-conf");
        confs.add(file.getPath());
        if (dbversion.getParameters().length() > 0) {
            for (String p : dbversion.getParameters().split(" ")) {
                confs.add(p);
            }
        }
        FileUtils.executeCommand(confs, null, false);
    }

    public static void createDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{dir}));
        }
    }

    public static void copyFiles(File srcDir, File dstDir) {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles != null) {
            for (File src : srcFiles) {
                if (!src.isFile()) continue;
                File dst = new File(dstDir, src.getName());
                FileUtils.copy(src, dst);
                dst.setLastModified(src.lastModified());
            }
        }
    }

    public static void removeFile(File file) {
        if (!file.isFile() || !file.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file.getPath()}));
        }
    }

    public static void removeFilesInDirAndDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                System.err.println(Settings.getInstance().msg("general.error.dirtobedeletedcontainsdir", new Object[]{dir.getPath()}));
                return;
            }
            for (File file : files) {
                if (file.delete()) continue;
                System.err.println(Settings.getInstance().msg("general.error.deletefile", new Object[]{file}));
            }
        }
        if (!dir.isDirectory() || !dir.delete()) {
            System.err.println(Settings.getInstance().msg("general.error.deletedir", new Object[]{dir.getPath()}));
        }
    }

    public static boolean isReadableFile(File file) {
        return file.isFile() && file.canRead();
    }

    public static void createDosrootIfNecessary() {
        if (!DOSROOT_DIR_FILE.isDirectory()) {
            System.out.println(Settings.getInstance().msg("general.notice.createdir", new Object[]{DOSROOT_DIR_FILE.getPath()}));
            if (!DOSROOT_DIR_FILE.mkdirs()) {
                System.err.println(Settings.getInstance().msg("general.error.createdir", new Object[]{DOSROOT_DIR_FILE.getPath()}));
            }
        }
    }

    public static boolean isExecutable(String filename) {
        for (String ext : EXECUTABLES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchive(String filename) {
        for (String ext : ARCHIVES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhysFS(String mountPath) {
        for (String ext : ARCHIVES) {
            if (!mountPath.toLowerCase().endsWith(ext + ':' + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    public static int containsPhysFS(String mountPath) {
        for (String ext : ARCHIVES) {
            int idx = mountPath.toLowerCase().indexOf(ext + ':' + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isBooterImage(String filename) {
        for (String ext : BOOTERIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfFile(String filename) {
        return filename.toLowerCase().endsWith(CONF_EXT);
    }

    public static boolean isIsoFile(String filename) {
        for (String ext : CDIMAGES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static int containsIso(String mountPath) {
        for (String ext : CDIMAGES) {
            int idx = mountPath.toLowerCase().indexOf(ext + File.separatorChar);
            if (idx == -1) continue;
            return idx + ext.length();
        }
        return -1;
    }

    public static boolean isPicture(String filename) {
        for (String ext : PICTURES) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static File getCanMainFile(File file) {
        String f = file.getPath();
        int isoIdx = FileUtils.containsIso(f);
        int pfsIdx = FileUtils.containsPhysFS(f);
        if (isoIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, isoIdx));
        }
        if (pfsIdx != -1) {
            return FileUtils.canonicalToDosroot(f.substring(0, pfsIdx));
        }
        return FileUtils.canonicalToDosroot(file.getPath());
    }

    public static String[] getExecutablesInZipOrIso(String archive) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File arcFile = new File(archive);
        if (archive.toLowerCase().endsWith(ARCHIVES[0])) {
            ZipFile zfile = new ZipFile(arcFile);
            Enumeration<? extends ZipEntry> entries = zfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            zfile.close();
        } else if (archive.toLowerCase().endsWith(ARCHIVES[1])) {
            Handler zArchive = new Handler();
            MyRandomAccessFile istream = new MyRandomAccessFile(archive, "r");
            if (zArchive.Open((IInStream)istream) != 0) {
                throw new IOException(Settings.getInstance().msg("general.error.opensevenzip", new Object[]{archive}));
            }
            for (int i = 0; i < zArchive.size(); ++i) {
                SevenZipEntry entry = zArchive.getEntry(i);
                String name = entry.getName();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            zArchive.close();
        } else if (FileUtils.isIsoFile(archive)) {
            ISO9660FileSystem iso = new ISO9660FileSystem(new File(archive));
            Enumeration<ISO9660FileEntry> entries = iso.getEntries();
            while (entries.hasMoreElements()) {
                ISO9660FileEntry entry = entries.nextElement();
                String name = entry.getPath();
                if (entry.isDirectory() || !FileUtils.isExecutable(name)) continue;
                result.add(PlatformUtils.archiveToNativePath(name));
            }
            iso.close();
        }
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String string1, String string2) {
                int count2;
                int count1 = StringUtils.countCharacters(string1, '\\');
                if (count1 == (count2 = StringUtils.countCharacters(string2, '\\'))) {
                    return string1.compareTo(string2);
                }
                return count1 - count2;
            }
        });
        return result.toArray(new String[result.size()]);
    }

    public static void zipEntry(File fileEntry, ZipOutputStream zos, InputStream is) throws IOException {
        byte[] readBuffer = new byte[2156];
        int bytes = 0;
        ZipEntry anEntry = new ZipEntry(fileEntry.getPath());
        zos.putNextEntry(anEntry);
        while ((bytes = is.read(readBuffer)) != -1) {
            zos.write(readBuffer, 0, bytes);
        }
    }

    public static String getUrlFromFile(File file) throws MalformedURLException {
        return file.toURI().toURL().toString();
    }

    static {
        TEMPLATES_DIR = "templates" + File.separatorChar;
        DOSROOT_DIR = "dosroot" + File.separatorChar;
        CAPTURES_DIR = "captures" + File.separatorChar;
        PROFILES_DIR = "profiles" + File.separatorChar;
        EXPORT_DIR = "export" + File.separatorChar;
        XSL_DIR = "xsl" + File.separatorChar;
        CDIMAGES = new String[]{".iso", ".cue", ".bin"};
        EXECUTABLES = new String[]{".exe", ".com", ".bat"};
        ARCHIVES = new String[]{".zip", ".7z"};
        BOOTERIMAGES = new String[]{".cp2", ".dcf", ".img", ".jrc", ".td0"};
        PICTURES = new String[]{".png", ".gif", ".jpg", ".tif", ".tiff", ".ico", ".bmp"};
        Settings settings = Settings.getInstance();
        String DATADIR = FileUtils.getCanonicalPath(settings.getValue("directory", "data"));
        DATA_DIR_FILE = new File(DATADIR);
        DOSROOT_DIR_FILE = new File(DATADIR, DOSROOT_DIR);
        String DOSBOXDIR = FileUtils.getCanonicalPath(settings.getValue("directory", "dosbox"));
        DOSBOX_DIR_FILE = new File(DOSBOXDIR);
        FileUtils.createDosrootIfNecessary();
    }
}

