/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.dbgl.model.MobyProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyGamesUtils {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTML_QUOTE = "\"";
    private static final String HTML_TD_OPEN = "<td>";
    private static final String HTML_TD_CLOSE = "</td>";
    private static final String HTML_IMG_OPEN = "<img ";
    private static final String HTML_ANCHOR_OPEN = "<a ";
    private static final String HTML_ANCHOR_CLOSE = "</a>";
    private static final String HTML_DIV_OPEN = "<div";
    private static final String HTML_DIV_CLOSE = "</div>";
    private static final String HTML_I_OPEN = "<i>";
    private static final String HTML_I_CLOSE = "</i>";
    private static final String HTML_UL_OPEN = "<ul>";
    private static final String HTML_UL_CLOSE = "</ul>";
    private static final String HTML_LI_OPEN = "<li>";
    private static final String HTML_LI_CLOSE = "</li>";
    private static final String HTML_B_OPEN = "<b>";
    private static final String HTML_B_CLOSE = "</b>";
    private static final String HTML_P_OPEN = "<p>";
    private static final String HTML_P_CLOSE = "</p>";
    private static final String HTML_BR_UNCLOSED = "<br>";
    private static final String HTML_BR_CLOSED = "<br/>";
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<table SUMMARY=\"Game Match\"";
    private static final String HTML_GAME_MATCH_ENTRY_URL_START = "<a href=\"";
    private static final String HTML_PUBL_YEAR_START = "by ";
    private static final String HTML_PUBL_YEAR_SPLIT_START = " -- ";
    private static final String HTML_YEAR_START = "Year: ";
    private static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";

    public static List<MobyProfile> getEntries(String title, String[] platforms) throws IOException {
        String titleNoSlashes = title.replaceAll("/", " ");
        String searchPageURL = "http://www.mobygames.com/search/quick/p,-1/q," + URLEncoder.encode(titleNoSlashes, "UTF-8") + "/showOnly,9/";
        return MobyGamesUtils.extractEntries(MobyGamesUtils.getResponseContent(searchPageURL), platforms);
    }

    private static List<MobyProfile> extractEntries(String mobyGamesHttpResponse, String[] platforms) {
        ArrayList<MobyProfile> entries = new ArrayList<MobyProfile>();
        ArrayList<MobyProfile> allEntries = new ArrayList<MobyProfile>();
        int gameMatchEntryIndex = mobyGamesHttpResponse.indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        while (gameMatchEntryIndex != -1) {
            String url;
            MobyProfile gameEntry = new MobyProfile();
            String tDContent = MobyGamesUtils.extractNextTDContent(mobyGamesHttpResponse, gameMatchEntryIndex);
            int imgIndex = tDContent.indexOf(HTML_IMG_OPEN);
            if (imgIndex != -1) {
                tDContent = MobyGamesUtils.extractNextTDContent(mobyGamesHttpResponse, gameMatchEntryIndex + imgIndex);
            }
            if ((url = MobyGamesUtils.extractNextAnchorURL(tDContent)).startsWith(HTTP_PROTOCOL)) {
                gameEntry.setUrl(url);
            } else {
                gameEntry.setUrl("http://www.mobygames.com" + url);
            }
            String title = MobyGamesUtils.unescapeHtml(MobyGamesUtils.extractNextAnchorContent(tDContent));
            gameEntry.setTitle(title);
            int publisherYearStartIndex = tDContent.indexOf(HTML_BR_UNCLOSED) + HTML_BR_UNCLOSED.length();
            int publisherYearEndIndex = tDContent.indexOf(HTML_BR_UNCLOSED, publisherYearStartIndex);
            String publisherYear = MobyGamesUtils.unescapeHtml(MobyGamesUtils.removeBreaks(tDContent.substring(publisherYearStartIndex, publisherYearEndIndex)));
            int idxStripes = publisherYear.indexOf(HTML_PUBL_YEAR_SPLIT_START);
            if (idxStripes != -1) {
                gameEntry.setPublisherName(publisherYear.substring(HTML_PUBL_YEAR_START.length(), idxStripes));
                gameEntry.setYear(publisherYear.substring(idxStripes + HTML_PUBL_YEAR_SPLIT_START.length()));
            } else {
                gameEntry.setPublisherName("");
                int idxYear = publisherYear.indexOf(HTML_YEAR_START);
                if (idxYear != -1) {
                    gameEntry.setYear(publisherYear.substring(idxYear + HTML_YEAR_START.length()));
                }
            }
            int platformStartIndex = tDContent.indexOf(HTML_BR_UNCLOSED, publisherYearEndIndex) + HTML_BR_UNCLOSED.length();
            int platformEndIndex = tDContent.indexOf(HTML_BR_UNCLOSED, platformStartIndex);
            String platform = tDContent.substring(platformStartIndex, platformEndIndex);
            gameEntry.setPlatform(MobyGamesUtils.removeBreaks(platform));
            boolean allowed = platforms.length == 0;
            for (String p : platforms) {
                if (!platform.equalsIgnoreCase(p)) continue;
                allowed = true;
            }
            if (allowed) {
                entries.add(gameEntry);
            }
            allEntries.add(gameEntry);
            gameMatchEntryIndex = mobyGamesHttpResponse.indexOf(HTML_MULTIPLE_RESULT_MARKER_START, gameMatchEntryIndex + tDContent.length());
        }
        if (entries.isEmpty()) {
            entries = allEntries;
        }
        Collections.sort(entries);
        return entries;
    }

    public static MobyProfile getEntry(MobyProfile entry) throws UnknownHostException, IOException {
        MobyProfile result = new MobyProfile();
        result.setTitle(entry.getTitle());
        result.setPublisherName(entry.getPublisherName());
        result.setYear(entry.getYear());
        result.setUrl(entry.getUrl());
        String responseEntry = MobyGamesUtils.getResponseContent(entry.getUrl());
        result.setDeveloperName(MobyGamesUtils.extractCategory(responseEntry, ">Developed by</div>"));
        result.setGenre(MobyGamesUtils.extractCategory(responseEntry, ">Genre</div>"));
        result.setNotes(MobyGamesUtils.extractDescription(responseEntry));
        result.setRank(MobyGamesUtils.extractRank(responseEntry));
        return result;
    }

    private static String getResponseContent(String url) throws IOException {
        try {
            String str;
            URL urlConnection = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.openStream(), "UTF-8"));
            StringBuffer result = new StringBuffer(8192);
            while ((str = in.readLine()) != null) {
                result.append(str);
            }
            in.close();
            return result.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String extractNextTDContent(String htmlChunk, int startIndex) {
        int tdStartIndex = htmlChunk.indexOf(HTML_TD_OPEN, startIndex + HTML_TD_OPEN.length());
        int tdEndIndex = htmlChunk.indexOf(HTML_TD_CLOSE, tdStartIndex);
        return htmlChunk.substring(tdStartIndex, tdEndIndex);
    }

    private static String extractNextAnchorURL(String htmlChunk) {
        int aStartIndex = htmlChunk.indexOf(HTML_GAME_MATCH_ENTRY_URL_START) + HTML_GAME_MATCH_ENTRY_URL_START.length();
        int aEndIndex = htmlChunk.indexOf(HTML_QUOTE, aStartIndex);
        return htmlChunk.substring(aStartIndex, aEndIndex);
    }

    private static String extractNextAnchorContent(String htmlChunk) {
        int aStartIndex = htmlChunk.indexOf(HTML_ANCHOR_OPEN);
        aStartIndex = htmlChunk.indexOf(">", aStartIndex) + 1;
        int aEndIndex = htmlChunk.indexOf("<", aStartIndex);
        return htmlChunk.substring(aStartIndex, aEndIndex);
    }

    private static String extractCategory(String htmlChunk, String marker) {
        int startIndex = htmlChunk.indexOf(marker);
        if (startIndex != -1) {
            int endIndex = htmlChunk.indexOf(HTML_DIV_CLOSE, startIndex + marker.length());
            return MobyGamesUtils.unescapeHtml(MobyGamesUtils.removeAllTags(htmlChunk.substring(startIndex + marker.length(), endIndex + HTML_DIV_CLOSE.length())));
        }
        return "";
    }

    private static String extractDescription(String htmlChunk) {
        String marker = "<h2 class=\"m5\">Description</h2>";
        int startIndex = htmlChunk.indexOf(marker) + marker.length();
        int endIndex = htmlChunk.indexOf(HTML_DIV_OPEN, startIndex);
        return MobyGamesUtils.unescapeHtml(MobyGamesUtils.removeAllTags(htmlChunk.substring(startIndex, endIndex)));
    }

    private static Integer extractRank(String htmlChunk) {
        String header = "scoreBoxBig";
        int startIndex = htmlChunk.indexOf(">", htmlChunk.indexOf(header) + header.length()) + 1;
        int endIndex = htmlChunk.indexOf("<", startIndex);
        try {
            return new Integer(htmlChunk.substring(startIndex, endIndex));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static String removeBreaks(String htmlChunk) {
        return htmlChunk.replace(HTML_BR_UNCLOSED, "").replace(HTML_BR_CLOSED, "");
    }

    private static String removeAllTags(String htmlChunk) {
        String result = MobyGamesUtils.removeSpecificTag(HTML_DIV_OPEN, HTML_DIV_CLOSE, htmlChunk);
        result = MobyGamesUtils.removeSpecificTag(HTML_ANCHOR_OPEN, HTML_ANCHOR_CLOSE, result);
        result = result.replace(HTML_I_OPEN, "").replace(HTML_I_CLOSE, "");
        result = result.replace(HTML_B_OPEN, "").replace(HTML_B_CLOSE, "");
        result = result.replace(HTML_LI_OPEN, "").replace(HTML_LI_CLOSE, "\n");
        result = result.replace(HTML_UL_OPEN, "\n\n").replace(HTML_UL_CLOSE, "\n");
        result = result.replace(HTML_P_OPEN, "\n").replace(HTML_P_CLOSE, "");
        return result;
    }

    private static String removeSpecificTag(String openTag, String closeTag, String htmlChunk) {
        StringBuffer result = new StringBuffer(htmlChunk);
        int divOpenIndex = result.indexOf(openTag);
        while (divOpenIndex != -1) {
            result.delete(divOpenIndex, result.indexOf(">", divOpenIndex + openTag.length()) + 1);
            int endIndex = result.indexOf(closeTag);
            result.delete(endIndex, endIndex + closeTag.length());
            divOpenIndex = result.indexOf(openTag);
        }
        return result.toString();
    }

    private static String unescapeHtml(String htmlChunk) {
        return StringEscapeUtils.unescapeHtml((String)htmlChunk.replace(HTML_BR_UNCLOSED, "\n").replace(HTML_BR_CLOSED, "\n").replace("&nbsp;", " "));
    }
}

