/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.connect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import org.dbgl.gui.MainWindow;
import org.dbgl.model.Settings;

public final class Messaging
extends Thread {
    private final transient int port;
    private final transient Object obj;
    private transient ServerSocket server = null;
    private transient boolean cont = true;
    private Settings settings;

    public Messaging(int port, Object obj) {
        this.port = port;
        this.obj = obj;
        this.settings = Settings.getInstance();
    }

    public void close() {
        this.cont = false;
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException e) {
            System.err.println(this.settings.msg("communication.error.closesocket"));
        }
    }

    public void run() {
        try {
            this.server = new ServerSocket(this.port);
            System.out.println(this.settings.msg("communication.notice.listening", new Object[]{this.port}));
        }
        catch (IOException e) {
            this.cont = false;
            System.err.println(this.settings.msg("communication.error.createsocket", new Object[]{this.port}));
        }
        while (this.cont) {
            try {
                Socket client = this.server.accept();
                BufferedReader bufferedIStream = new BufferedReader(new InputStreamReader(client.getInputStream()));
                System.out.print(this.settings.msg("communication.notice.receivingmessage"));
                String line = bufferedIStream.readLine();
                System.out.println(' ' + line);
                client.close();
                if (!line.startsWith("sendtoprofile ")) continue;
                ((MainWindow)this.obj).addProfile(line.substring(14));
            }
            catch (IOException e) {
                if (!this.cont) continue;
                System.err.println(this.settings.msg("communication.error.io"));
            }
        }
    }
}

