/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.EditMountDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Mount;
import org.dbgl.model.Settings;
import org.dbgl.model.Template;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.model.conf.Configuration;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button reloadButton;
    protected Combo priority_active;
    protected Combo priority_inactive;
    protected Button waitonerror;
    protected Button exit;
    protected Text language;
    protected Text captures;
    protected Combo output;
    protected Combo frameskip;
    protected Combo scaler;
    protected Combo pixelshader;
    protected Button fulldouble;
    protected Button fullscreen;
    protected Combo fullresolution;
    protected Combo windowresolution;
    protected Button aspect;
    protected Text overscan;
    protected Combo svgachipset;
    protected Combo videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Button glide;
    protected Text glideport;
    protected Combo lfbGlide;
    protected Combo machine;
    protected Combo cpu_type;
    protected Combo core;
    protected Combo cycles;
    protected Combo cycles_up;
    protected Combo cycles_down;
    protected Button timesynched;
    protected Combo memsize;
    protected Button xms;
    protected Button ems;
    protected Combo umb;
    protected Button nosound;
    protected Combo rate;
    protected Combo blocksize;
    protected Combo prebuffer;
    protected Combo mpu401;
    protected Combo midi_device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo mt32rate;
    protected Combo sbtype;
    protected Combo oplrate;
    protected Combo oplmode;
    protected Combo oplemu;
    protected Combo sbbase;
    protected Combo irq;
    protected Combo dma;
    protected Combo hdma;
    protected Button sbmixer;
    protected Button gus;
    protected Combo gusrate;
    protected Combo gusbase;
    protected Combo gusdma1;
    protected Combo gusdma2;
    protected Combo gusirq1;
    protected Combo gusirq2;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy;
    protected Combo tandyrate;
    protected Button disney;
    protected Button usescancodes;
    protected Text mapperfile;
    protected Text keyboard_layout;
    protected Text keyb;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed;
    protected Button autofire;
    protected Button swap34;
    protected Button buttonwrap;
    protected Text serial1;
    protected Text serial2;
    protected Text serial3;
    protected Text serial4;
    protected Button ipx;
    protected Text ipxnet;
    protected org.eclipse.swt.widgets.List mountingpoints;
    protected Button booterButton;
    protected Button dosButton;
    protected Group memoryGroup;
    protected Group associationGroup;
    protected Group miscGroup;
    protected Group executeGroup;
    protected TabItem infoTabItem;
    protected TabItem mountingTabItem;
    protected Button okButton;
    protected Button cancelButton;
    protected int dbversionIndex = -1;
    protected Shell shell;
    protected List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected CompositeConfiguration compConf;
    protected Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell parent) {
        super(parent, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e.getMessage());
            return false;
        }
        if (this.result == null) {
            this.dbversionIndex = DosboxVersion.findDefault(this.dbversionsList);
            this.compConf = new CompositeConfiguration(this.dbversionsList.get(this.dbversionIndex), true, this.getParent(), System.out);
        } else {
            this.dbversionIndex = DosboxVersion.findById(this.dbversionsList, ((Template)this.result).getDbversionId());
            this.compConf = new CompositeConfiguration(this.dbversionsList.get(this.dbversionIndex), (Template)this.result, true, this.getParent(), System.out);
        }
        return true;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "templatedialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.template.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.template.title.edit", new Object[]{((Template)this.result).getTitle(), ((Template)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createMountingTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    if (EditTemplateDialog.this.setButton.isEnabled()) {
                        EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, true, false);
                    }
                    int templateId = EditTemplateDialog.this.dbase.addOrEditTemplate(EditTemplateDialog.this.title.getText(), EditTemplateDialog.this.compConf.getDbversionId(), EditTemplateDialog.this.defaultButton.getSelection(), EditTemplateDialog.this.result == null ? -1 : ((Template)EditTemplateDialog.this.result).getId());
                    EditTemplateDialog.this.compConf.setCompositeConf(EditTemplateDialog.this.getConfigurationBySettings());
                    EditTemplateDialog.this.result = new Template(templateId, EditTemplateDialog.this.title.getText(), EditTemplateDialog.this.compConf.getDbversionId(), EditTemplateDialog.this.defaultButton.getSelection());
                    EditTemplateDialog.this.compConf.save((Template)EditTemplateDialog.this.result, EditTemplateDialog.this.shell, System.out);
                }
                catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, e1.getMessage());
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dbv : this.dbversionsList) {
            this.dbversion.add(dbv.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result == null) {
            this.title.setFocus();
        } else {
            this.title.setText(((Template)this.result).getTitle());
            this.defaultButton.setSelection(((Template)this.result).isDefault());
        }
        this.enableSettingsByConfiguration();
        this.selectSettingsByConfiguration();
    }

    protected void createOkCancelButtons() {
        Composite composite_7 = new Composite((Composite)this.shell, 0);
        composite_7.setLayout((Layout)new GridLayout(2, true));
        composite_7.setLayoutData((Object)"South");
        this.okButton = new Button(composite_7, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.cancelButton = new Button(composite_7, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = 4;
        this.cancelButton.setLayoutData((Object)gridData_1);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditTemplateDialog.this.cancelButton.getText().equals(EditTemplateDialog.this.settings.msg("button.cancel"))) {
                    EditTemplateDialog.this.result = null;
                }
                EditTemplateDialog.this.shell.close();
            }
        });
    }

    protected void createMountingTab(TabFolder tabFolder) {
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText(this.settings.msg("dialog.template.tab.mounting"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.mountingTabItem.setControl((Control)composite);
        this.createMountingGroup(composite);
        this.createExecuteGroup(composite);
    }

    protected void createExecuteGroup(Composite composite) {
        this.executeGroup = new Group(composite, 0);
        this.executeGroup.setLayoutData((Object)new GridData());
        this.executeGroup.setText(this.settings.msg("dialog.template.execute"));
        GridLayout gridLayout_18 = new GridLayout();
        this.executeGroup.setLayout((Layout)gridLayout_18);
        this.dosButton = new Button((Composite)this.executeGroup, 16);
        this.dosButton.setText(this.settings.msg("dialog.template.dos"));
        Label label_1 = new Label((Composite)this.executeGroup, 258);
        label_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.booterButton = new Button((Composite)this.executeGroup, 16);
        this.booterButton.setText(this.settings.msg("dialog.template.booter"));
    }

    protected void createMountingGroup(Composite composite) {
        Group mountGroup = new Group(composite, 0);
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mountGroup.setText(this.settings.msg("dialog.template.mountingoverview"));
        GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout((Layout)gridLayout_19);
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)mountGroup, 2560);
        GridData gridData_2 = new GridData(4, 4, true, false, 1, 3);
        this.mountingpoints.setLayoutData((Object)gridData_2);
        this.mountingpoints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddMount();
                } else {
                    EditTemplateDialog.this.doEditMount();
                }
            }
        });
        Button addButton = new Button((Composite)mountGroup, 0);
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.setText(this.settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doAddMount();
            }
        });
        Button editButton = new Button((Composite)mountGroup, 0);
        editButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editButton.setText(this.settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doEditMount();
            }
        });
        Button removeButton = new Button((Composite)mountGroup, 0);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.setText(this.settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doRemoveMount();
            }
        });
    }

    protected void createIOTab(TabFolder tabFolder) {
        TabItem inputTabItem = new TabItem(tabFolder, 0);
        inputTabItem.setText(this.settings.msg("dialog.template.tab.io"));
        Composite composite_5 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout((Layout)gridLayout_17);
        inputTabItem.setControl((Control)composite_5);
        Group mouseGroup = new Group(composite_5, 0);
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        mouseGroup.setText(this.settings.msg("dialog.template.mouse"));
        GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout((Layout)gridLayout_13);
        Label autolockLabel = new Label((Composite)mouseGroup, 0);
        autolockLabel.setText(this.settings.msg("dialog.template.autolock"));
        this.autolock = new Button((Composite)mouseGroup, 32);
        this.autolock.setToolTipText(this.settings.msg("dialog.template.autolock.tooltip"));
        Label sensitivityLabel = new Label((Composite)mouseGroup, 0);
        sensitivityLabel.setText(this.settings.msg("dialog.template.sensitivity"));
        this.sensitivity = new Combo((Composite)mouseGroup, 8);
        this.sensitivity.setItems(this.settings.getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        this.sensitivity.setToolTipText(this.settings.msg("dialog.template.sensitivity.tooltip"));
        Group keyboardGroup = new Group(composite_5, 0);
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        keyboardGroup.setText(this.settings.msg("dialog.template.keyboard"));
        GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout((Layout)gridLayout_14);
        Label useScancodesLabel = new Label((Composite)keyboardGroup, 0);
        useScancodesLabel.setText(this.settings.msg("dialog.template.usescancodes"));
        this.usescancodes = new Button((Composite)keyboardGroup, 32);
        this.usescancodes.setToolTipText(this.settings.msg("dialog.template.usescancodes.tooltip"));
        Label mapperFileLabel = new Label((Composite)keyboardGroup, 0);
        mapperFileLabel.setText(this.settings.msg("dialog.template.mapperfile"));
        this.mapperfile = new Text((Composite)keyboardGroup, 2048);
        this.mapperfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mapperfile.setToolTipText(this.settings.msg("dialog.template.mapperfile.tooltip"));
        Label layoutLabel = new Label((Composite)keyboardGroup, 0);
        layoutLabel.setText(this.settings.msg("dialog.template.keyboardlayout"));
        this.keyboard_layout = new Text((Composite)keyboardGroup, 2048);
        this.keyboard_layout.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keyboard_layout.setToolTipText(this.settings.msg("dialog.template.keyboardlayout.tooltip"));
        Label keybLabel = new Label((Composite)keyboardGroup, 0);
        keybLabel.setText(this.settings.msg("dialog.template.keybcommand"));
        this.keyb = new Text((Composite)keyboardGroup, 2048);
        this.keyb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group joystickGroup = new Group(composite_5, 0);
        joystickGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        joystickGroup.setText(this.settings.msg("dialog.template.joystick"));
        GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout((Layout)gridLayout_15);
        Label typeLabel_1 = new Label((Composite)joystickGroup, 0);
        typeLabel_1.setText(this.settings.msg("dialog.template.joysticktype"));
        this.joysticktype = new Combo((Composite)joystickGroup, 8);
        this.joysticktype.setItems(this.settings.getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.joysticktype.setToolTipText(this.settings.msg("dialog.template.joysticktype.tooltip"));
        Label timedLabel = new Label((Composite)joystickGroup, 0);
        timedLabel.setText(this.settings.msg("dialog.template.timedemulation"));
        this.timed = new Button((Composite)joystickGroup, 32);
        this.timed.setToolTipText(this.settings.msg("dialog.template.timedemulation.tooltip"));
        Label autofireLabel = new Label((Composite)joystickGroup, 0);
        autofireLabel.setText(this.settings.msg("dialog.template.autofire"));
        this.autofire = new Button((Composite)joystickGroup, 32);
        this.autofire.setToolTipText(this.settings.msg("dialog.template.autofire.tooltip"));
        Label swapAxes3Label = new Label((Composite)joystickGroup, 0);
        swapAxes3Label.setText(this.settings.msg("dialog.template.swap34"));
        this.swap34 = new Button((Composite)joystickGroup, 32);
        this.swap34.setToolTipText(this.settings.msg("dialog.template.swap34.tooltip"));
        Label buttonWrapLabel = new Label((Composite)joystickGroup, 0);
        buttonWrapLabel.setText(this.settings.msg("dialog.template.buttonwrapping"));
        this.buttonwrap = new Button((Composite)joystickGroup, 32);
        this.buttonwrap.setToolTipText(this.settings.msg("dialog.template.buttonwrapping.tooltip"));
        Group modemGroup = new Group(composite_5, 0);
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        modemGroup.setText(this.settings.msg("dialog.template.modem"));
        GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout((Layout)gridLayout_16);
        Label serial1Label = new Label((Composite)modemGroup, 0);
        serial1Label.setText(this.settings.msg("dialog.template.serial1"));
        this.serial1 = new Text((Composite)modemGroup, 2048);
        this.serial1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial1.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial2Label = new Label((Composite)modemGroup, 0);
        serial2Label.setText(this.settings.msg("dialog.template.serial2"));
        this.serial2 = new Text((Composite)modemGroup, 2048);
        this.serial2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial2.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial3Label = new Label((Composite)modemGroup, 0);
        serial3Label.setText(this.settings.msg("dialog.template.serial3"));
        this.serial3 = new Text((Composite)modemGroup, 2048);
        this.serial3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial3.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label serial4Label = new Label((Composite)modemGroup, 0);
        serial4Label.setText(this.settings.msg("dialog.template.serial4"));
        this.serial4 = new Text((Composite)modemGroup, 2048);
        this.serial4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial4.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Group networkGroup = new Group(composite_5, 0);
        networkGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        networkGroup.setText(this.settings.msg("dialog.template.network"));
        GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout((Layout)gridLayout_20);
        Label ipxLabel = new Label((Composite)networkGroup, 0);
        ipxLabel.setText(this.settings.msg("dialog.template.enableipx"));
        this.ipx = new Button((Composite)networkGroup, 32);
        this.ipx.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.ipxnet.setEnabled(EditTemplateDialog.this.ipx.getSelection());
            }
        });
        this.ipx.setToolTipText(this.settings.msg("dialog.template.enableipx.tooltip"));
        Label ipxnetCommandLabel = new Label((Composite)networkGroup, 0);
        ipxnetCommandLabel.setText(this.settings.msg("dialog.template.ipxnetcommand"));
        new Label((Composite)networkGroup, 0);
        this.ipxnet = new Text((Composite)networkGroup, 2048);
        this.ipxnet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    protected void createAudioTab(TabFolder tabFolder) {
        TabItem audioTabItem = new TabItem(tabFolder, 0);
        audioTabItem.setText(this.settings.msg("dialog.template.tab.audio"));
        Composite composite_4 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_9);
        audioTabItem.setControl((Control)composite_4);
        Group generalGroup = new Group(composite_4, 0);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout((Layout)gridLayout_6);
        generalGroup.setText(this.settings.msg("dialog.template.general"));
        Label silentModeLabel = new Label((Composite)generalGroup, 0);
        silentModeLabel.setText(this.settings.msg("dialog.template.silentmode"));
        this.nosound = new Button((Composite)generalGroup, 32);
        this.nosound.setToolTipText(this.settings.msg("dialog.template.silentmode.tooltip"));
        Label sampleRateLabel = new Label((Composite)generalGroup, 0);
        sampleRateLabel.setText(this.settings.msg("dialog.template.samplerate"));
        this.rate = new Combo((Composite)generalGroup, 8);
        this.rate.setVisibleItemCount(10);
        this.rate.setItems(this.settings.getValues("profile", "rate"));
        this.rate.setLayoutData((Object)new GridData());
        this.rate.setToolTipText(this.settings.msg("dialog.template.samplerate.tooltip"));
        Label blockSizeLabel = new Label((Composite)generalGroup, 0);
        blockSizeLabel.setText(this.settings.msg("dialog.template.blocksize"));
        this.blocksize = new Combo((Composite)generalGroup, 8);
        this.blocksize.setItems(this.settings.getValues("profile", "blocksize"));
        this.blocksize.setLayoutData((Object)new GridData());
        this.blocksize.setToolTipText(this.settings.msg("dialog.template.blocksize.tooltip"));
        Label prebufferLabel = new Label((Composite)generalGroup, 0);
        prebufferLabel.setText(this.settings.msg("dialog.template.prebuffer"));
        this.prebuffer = new Combo((Composite)generalGroup, 0);
        this.prebuffer.setItems(this.settings.getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData((Object)new GridData(70, -1));
        this.prebuffer.setToolTipText(this.settings.msg("dialog.template.prebuffer.tooltip"));
        Label mpu401Label = new Label((Composite)generalGroup, 0);
        mpu401Label.setText(this.settings.msg("dialog.template.mpu401"));
        this.mpu401 = new Combo((Composite)generalGroup, 8);
        this.mpu401.setItems(this.settings.getValues("profile", "mpu401"));
        this.mpu401.setLayoutData((Object)new GridData());
        this.mpu401.setToolTipText(this.settings.msg("dialog.template.mpu401.tooltip"));
        Label midiDeviceLabel = new Label((Composite)generalGroup, 0);
        midiDeviceLabel.setText(this.settings.msg("dialog.template.mididevice"));
        this.midi_device = new Combo((Composite)generalGroup, 8);
        this.midi_device.setVisibleItemCount(10);
        this.midi_device.setItems(this.settings.getValues("profile", "device"));
        this.midi_device.setLayoutData((Object)new GridData());
        this.midi_device.setToolTipText(this.settings.msg("dialog.template.mididevice.tooltip"));
        Label configLabel = new Label((Composite)generalGroup, 0);
        configLabel.setText(this.settings.msg("dialog.template.midiconfig"));
        this.midi_config = new Text((Composite)generalGroup, 2048);
        this.midi_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.midi_config.setToolTipText(this.settings.msg("dialog.template.midiconfig.tooltip"));
        Label mixerConfigLabel = new Label((Composite)generalGroup, 0);
        mixerConfigLabel.setText(this.settings.msg("dialog.template.mixercommand"));
        this.mixer_config = new Text((Composite)generalGroup, 2048);
        this.mixer_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group soundblasterGroup = new Group(composite_4, 0);
        soundblasterGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        soundblasterGroup.setText(this.settings.msg("dialog.template.soundblaster"));
        GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout((Layout)gridLayout_7);
        Label typeLabel = new Label((Composite)soundblasterGroup, 0);
        typeLabel.setText(this.settings.msg("dialog.template.sbtype"));
        this.sbtype = new Combo((Composite)soundblasterGroup, 8);
        this.sbtype.setVisibleItemCount(10);
        this.sbtype.setItems(this.settings.getValues("profile", "sbtype"));
        this.sbtype.setLayoutData((Object)new GridData());
        this.sbtype.setToolTipText(this.settings.msg("dialog.template.sbtype.tooltip"));
        Label oplRateLabel = new Label((Composite)soundblasterGroup, 0);
        oplRateLabel.setText(this.settings.msg("dialog.template.sboplrate"));
        this.oplrate = new Combo((Composite)soundblasterGroup, 8);
        this.oplrate.setVisibleItemCount(10);
        this.oplrate.setItems(this.settings.getValues("profile", "oplrate"));
        this.oplrate.setLayoutData((Object)new GridData());
        this.oplrate.setToolTipText(this.settings.msg("dialog.template.sboplrate.tooltip"));
        Label oplModeLabel = new Label((Composite)soundblasterGroup, 0);
        oplModeLabel.setLayoutData((Object)new GridData());
        oplModeLabel.setText(this.settings.msg("dialog.template.sboplmode"));
        this.oplmode = new Combo((Composite)soundblasterGroup, 8);
        this.oplmode.setItems(this.settings.getValues("profile", "oplmode"));
        this.oplmode.setLayoutData((Object)new GridData());
        this.oplmode.setToolTipText(this.settings.msg("dialog.template.sboplmode.tooltip"));
        Label oplEmuLabel = new Label((Composite)soundblasterGroup, 0);
        oplEmuLabel.setLayoutData((Object)new GridData());
        oplEmuLabel.setText(this.settings.msg("dialog.template.sboplemu"));
        this.oplemu = new Combo((Composite)soundblasterGroup, 8);
        this.oplemu.setItems(this.settings.getValues("profile", "oplemu"));
        this.oplemu.setLayoutData((Object)new GridData());
        this.oplemu.setToolTipText(this.settings.msg("dialog.template.sboplemu.tooltip"));
        Label addressLabel = new Label((Composite)soundblasterGroup, 0);
        addressLabel.setText(this.settings.msg("dialog.template.sbaddress"));
        this.sbbase = new Combo((Composite)soundblasterGroup, 8);
        this.sbbase.setItems(this.settings.getValues("profile", "sbbase"));
        this.sbbase.setLayoutData((Object)new GridData());
        this.sbbase.setToolTipText(this.settings.msg("dialog.template.sbaddress.tooltip"));
        Label irqLabel = new Label((Composite)soundblasterGroup, 0);
        irqLabel.setText(this.settings.msg("dialog.template.sbirq"));
        this.irq = new Combo((Composite)soundblasterGroup, 8);
        this.irq.setItems(this.settings.getValues("profile", "irq"));
        this.irq.setLayoutData((Object)new GridData());
        this.irq.setToolTipText(this.settings.msg("dialog.template.sbirq.tooltip"));
        Label dmaLabel = new Label((Composite)soundblasterGroup, 0);
        dmaLabel.setText(this.settings.msg("dialog.template.sbdma"));
        this.dma = new Combo((Composite)soundblasterGroup, 8);
        this.dma.setItems(this.settings.getValues("profile", "dma"));
        this.dma.setLayoutData((Object)new GridData());
        this.dma.setToolTipText(this.settings.msg("dialog.template.sbdma.tooltip"));
        Label hdmaLabel = new Label((Composite)soundblasterGroup, 0);
        hdmaLabel.setLayoutData((Object)new GridData());
        hdmaLabel.setText(this.settings.msg("dialog.template.sbhdma"));
        this.hdma = new Combo((Composite)soundblasterGroup, 8);
        this.hdma.setItems(this.settings.getValues("profile", "hdma"));
        this.hdma.setLayoutData((Object)new GridData());
        this.hdma.setToolTipText(this.settings.msg("dialog.template.sbhdma.tooltip"));
        Label mixerLabel = new Label((Composite)soundblasterGroup, 0);
        mixerLabel.setText(this.settings.msg("dialog.template.mixer"));
        this.sbmixer = new Button((Composite)soundblasterGroup, 32);
        this.sbmixer.setToolTipText(this.settings.msg("dialog.template.mixer.tooltip"));
        Group gusGroup = new Group(composite_4, 0);
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        gusGroup.setText(this.settings.msg("dialog.template.gravisultrasound"));
        GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout((Layout)gridLayout_8);
        Label enableLabel_1 = new Label((Composite)gusGroup, 0);
        enableLabel_1.setLayoutData((Object)new GridData());
        enableLabel_1.setText(this.settings.msg("dialog.template.enablegus"));
        this.gus = new Button((Composite)gusGroup, 32);
        this.gus.setLayoutData((Object)new GridData());
        this.gus.setToolTipText(this.settings.msg("dialog.template.enablegus.tooltip"));
        Label sampleRateLabel_2 = new Label((Composite)gusGroup, 0);
        sampleRateLabel_2.setText(this.settings.msg("dialog.template.gusrate"));
        this.gusrate = new Combo((Composite)gusGroup, 8);
        this.gusrate.setVisibleItemCount(10);
        this.gusrate.setItems(this.settings.getValues("profile", "gusrate"));
        this.gusrate.setLayoutData((Object)new GridData());
        this.gusrate.setToolTipText(this.settings.msg("dialog.template.gusrate.tooltip"));
        Label addressLabel_1 = new Label((Composite)gusGroup, 0);
        addressLabel_1.setText(this.settings.msg("dialog.template.gusaddress"));
        this.gusbase = new Combo((Composite)gusGroup, 8);
        this.gusbase.setItems(this.settings.getValues("profile", "gusbase"));
        this.gusbase.setLayoutData((Object)new GridData());
        this.gusbase.setToolTipText(this.settings.msg("dialog.template.gusaddress.tooltip"));
        Label irqLabel_1 = new Label((Composite)gusGroup, 0);
        irqLabel_1.setText(this.settings.msg("dialog.template.gusirq1"));
        this.gusirq1 = new Combo((Composite)gusGroup, 8);
        this.gusirq1.setItems(this.settings.getValues("profile", "irq1"));
        this.gusirq1.setLayoutData((Object)new GridData());
        this.gusirq1.setToolTipText(this.settings.msg("dialog.template.gusirq1.tooltip"));
        Label irq2Label = new Label((Composite)gusGroup, 0);
        irq2Label.setText(this.settings.msg("dialog.template.gusirq2"));
        this.gusirq2 = new Combo((Composite)gusGroup, 8);
        this.gusirq2.setItems(this.settings.getValues("profile", "irq2"));
        this.gusirq2.setLayoutData((Object)new GridData());
        Label dmaLabel_1 = new Label((Composite)gusGroup, 0);
        dmaLabel_1.setText(this.settings.msg("dialog.template.gusdma1"));
        this.gusdma1 = new Combo((Composite)gusGroup, 8);
        this.gusdma1.setItems(this.settings.getValues("profile", "dma1"));
        this.gusdma1.setLayoutData((Object)new GridData());
        this.gusdma1.setToolTipText(this.settings.msg("dialog.template.gusdma1.tooltip"));
        Label hdmaLabel_1 = new Label((Composite)gusGroup, 0);
        hdmaLabel_1.setLayoutData((Object)new GridData());
        hdmaLabel_1.setText(this.settings.msg("dialog.template.gusdma2"));
        this.gusdma2 = new Combo((Composite)gusGroup, 8);
        this.gusdma2.setItems(this.settings.getValues("profile", "dma2"));
        this.gusdma2.setLayoutData((Object)new GridData());
        Label ultradirLabel = new Label((Composite)gusGroup, 0);
        ultradirLabel.setText(this.settings.msg("dialog.template.ultradir"));
        this.ultradir = new Text((Composite)gusGroup, 2048);
        this.ultradir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ultradir.setToolTipText(this.settings.msg("dialog.template.ultradir.tooltip"));
        Group speakerGroup = new Group(composite_4, 0);
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        speakerGroup.setText(this.settings.msg("dialog.template.pcspeaker"));
        GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout((Layout)gridLayout_10);
        Label enableLabel = new Label((Composite)speakerGroup, 0);
        enableLabel.setText(this.settings.msg("dialog.template.enablepcspeaker"));
        this.pcspeaker = new Button((Composite)speakerGroup, 32);
        this.pcspeaker.setToolTipText(this.settings.msg("dialog.template.enablepcspeaker.tooltip"));
        Label sampleRateLabel_1 = new Label((Composite)speakerGroup, 0);
        sampleRateLabel_1.setText(this.settings.msg("dialog.template.pcrate"));
        this.pcrate = new Combo((Composite)speakerGroup, 8);
        this.pcrate.setVisibleItemCount(10);
        this.pcrate.setItems(this.settings.getValues("profile", "pcrate"));
        this.pcrate.setLayoutData((Object)new GridData());
        this.pcrate.setToolTipText(this.settings.msg("dialog.template.pcrate.tooltip"));
        Group tandyGroup = new Group(composite_4, 0);
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        tandyGroup.setText(this.settings.msg("dialog.template.tandy"));
        GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout((Layout)gridLayout_11);
        Label enableLabel_2 = new Label((Composite)tandyGroup, 0);
        enableLabel_2.setText(this.settings.msg("dialog.template.enabletandy"));
        this.tandy = new Combo((Composite)tandyGroup, 8);
        this.tandy.setItems(this.settings.getValues("profile", "tandy"));
        this.tandy.setLayoutData((Object)new GridData());
        this.tandy.setToolTipText(this.settings.msg("dialog.template.enabletandy.tooltip"));
        Label sampleLabel2 = new Label((Composite)tandyGroup, 0);
        sampleLabel2.setText(this.settings.msg("dialog.template.tandyrate"));
        this.tandyrate = new Combo((Composite)tandyGroup, 8);
        this.tandyrate.setVisibleItemCount(10);
        this.tandyrate.setItems(this.settings.getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData((Object)new GridData());
        this.tandyrate.setToolTipText(this.settings.msg("dialog.template.tandyrate.tooltip"));
        Group disneyGroup = new Group(composite_4, 0);
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        disneyGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout((Layout)gridLayout_12);
        Label enableLabel_3 = new Label((Composite)disneyGroup, 0);
        enableLabel_3.setText(this.settings.msg("dialog.template.enablesoundsource"));
        this.disney = new Button((Composite)disneyGroup, 32);
        this.disney.setToolTipText(this.settings.msg("dialog.template.enablesoundsource.tooltip"));
        Composite composite2 = new Composite((Composite)disneyGroup, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite2.setLayout((Layout)gridLayout2);
        Label mt32RateLabel = new Label(composite2, 0);
        mt32RateLabel.setText(this.settings.msg("dialog.template.mt32rate"));
        this.mt32rate = new Combo(composite2, 8);
        this.mt32rate.setVisibleItemCount(10);
        this.mt32rate.setItems(this.settings.getValues("profile", "mt32rate"));
    }

    protected void createMachineTab(TabFolder tabFolder) {
        TabItem machineTabItem = new TabItem(tabFolder, 0);
        machineTabItem.setText(this.settings.msg("dialog.template.tab.machine"));
        Composite composite_3 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout((Layout)gridLayout_2);
        machineTabItem.setControl((Control)composite_3);
        Group cpuGroup = new Group(composite_3, 0);
        cpuGroup.setText(this.settings.msg("dialog.template.cpu"));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout((Layout)gridLayout_3);
        Label machineLabel = new Label((Composite)cpuGroup, 0);
        machineLabel.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo((Composite)cpuGroup, 8);
        this.machine.setItems(this.settings.getValues("profile", "machine"));
        this.machine.setLayoutData((Object)new GridData());
        this.machine.setVisibleItemCount(10);
        this.machine.setToolTipText(this.settings.msg("dialog.template.machine.tooltip"));
        Label cputypeLabel = new Label((Composite)cpuGroup, 0);
        cputypeLabel.setText(this.settings.msg("dialog.template.cputype"));
        this.cpu_type = new Combo((Composite)cpuGroup, 8);
        this.cpu_type.setItems(this.settings.getValues("profile", "cputype"));
        this.cpu_type.setLayoutData((Object)new GridData());
        this.cpu_type.setVisibleItemCount(10);
        this.cpu_type.setToolTipText(this.settings.msg("dialog.template.cputype.tooltip"));
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label coreLabel = new Label((Composite)cpuGroup, 0);
        coreLabel.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo((Composite)cpuGroup, 8);
        this.core.setItems(this.settings.getValues("profile", "core"));
        this.core.setLayoutData((Object)new GridData());
        this.core.setToolTipText(this.settings.msg("dialog.template.core.tooltip"));
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        Label cyclesLabel = new Label((Composite)cpuGroup, 0);
        cyclesLabel.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo((Composite)cpuGroup, 0);
        this.cycles.setItems(this.settings.getValues("profile", "cycles"));
        this.cycles.setLayoutData((Object)new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        this.cycles.setToolTipText(this.settings.msg("dialog.template.cycles.tooltip"));
        Label upLabel = new Label((Composite)cpuGroup, 0);
        upLabel.setLayoutData((Object)new GridData());
        upLabel.setText(this.settings.msg("dialog.template.up"));
        this.cycles_up = new Combo((Composite)cpuGroup, 0);
        this.cycles_up.setItems(this.settings.getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData((Object)new GridData(75, -1));
        this.cycles_up.setToolTipText(this.settings.msg("dialog.template.up.tooltip"));
        Label downLabel = new Label((Composite)cpuGroup, 0);
        downLabel.setLayoutData((Object)new GridData());
        downLabel.setText(this.settings.msg("dialog.template.down"));
        this.cycles_down = new Combo((Composite)cpuGroup, 0);
        this.cycles_down.setItems(this.settings.getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData((Object)new GridData(75, -1));
        this.cycles_down.setToolTipText(this.settings.msg("dialog.template.down.tooltip"));
        Label timesynchedLabel = new Label((Composite)cpuGroup, 0);
        timesynchedLabel.setText(this.settings.msg("dialog.template.timesynched"));
        this.timesynched = new Button((Composite)cpuGroup, 32);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        new Label((Composite)cpuGroup, 0);
        this.memoryGroup = new Group(composite_3, 0);
        this.memoryGroup.setText(this.settings.msg("dialog.template.memory"));
        this.memoryGroup.setLayoutData((Object)new GridData());
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.memoryGroup.setLayout((Layout)gridLayout_4);
        Label sizeLabel = new Label((Composite)this.memoryGroup, 0);
        sizeLabel.setText(this.settings.msg("dialog.template.memorysize"));
        this.memsize = new Combo((Composite)this.memoryGroup, 8);
        this.memsize.setItems(this.settings.getValues("profile", "memsize"));
        this.memsize.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.memsize.setToolTipText(this.settings.msg("dialog.template.memorysize.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label xmsLabel = new Label((Composite)this.memoryGroup, 0);
        xmsLabel.setText(this.settings.msg("dialog.template.xms"));
        this.xms = new Button((Composite)this.memoryGroup, 32);
        this.xms.setToolTipText(this.settings.msg("dialog.template.xms.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label emsLabel = new Label((Composite)this.memoryGroup, 0);
        emsLabel.setText(this.settings.msg("dialog.template.ems"));
        this.ems = new Button((Composite)this.memoryGroup, 32);
        this.ems.setToolTipText(this.settings.msg("dialog.template.ems.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label umbLabel = new Label((Composite)this.memoryGroup, 0);
        umbLabel.setText(this.settings.msg("dialog.template.umb"));
        this.umb = new Combo((Composite)this.memoryGroup, 8);
        this.umb.setItems(this.settings.getValues("profile", "umb"));
        this.umb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.umb.setToolTipText(this.settings.msg("dialog.template.umb.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
    }

    protected void createDisplayTab(TabFolder tabFolder) {
        TabItem displayTabItem = new TabItem(tabFolder, 0);
        displayTabItem.setText(this.settings.msg("dialog.template.tab.display"));
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_5);
        displayTabItem.setControl((Control)composite_2);
        Label outputLabel = new Label(composite_2, 0);
        outputLabel.setText(this.settings.msg("dialog.template.output"));
        this.output = new Combo(composite_2, 8);
        this.output.setItems(this.settings.getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.output.setToolTipText(this.settings.msg("dialog.template.output.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label frameskipLabel = new Label(composite_2, 0);
        frameskipLabel.setText(this.settings.msg("dialog.template.frameskip"));
        this.frameskip = new Combo(composite_2, 8);
        this.frameskip.setItems(this.settings.getValues("profile", "frameskip"));
        this.frameskip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.frameskip.setToolTipText(this.settings.msg("dialog.template.frameskip.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label scalerLabel = new Label(composite_2, 0);
        scalerLabel.setText(this.settings.msg("dialog.template.scaler"));
        this.scaler = new Combo(composite_2, 8);
        this.scaler.setItems(this.settings.getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scaler.setToolTipText(this.settings.msg("dialog.template.scaler.tooltip"));
        Label pixelshaderLabel = new Label(composite_2, 0);
        pixelshaderLabel.setLayoutData((Object)new GridData());
        pixelshaderLabel.setText(this.settings.msg("dialog.template.pixelshader"));
        this.pixelshader = new Combo(composite_2, 8);
        this.pixelshader.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(15);
        this.pixelshader.setItems(this.settings.getValues("profile", "pixelshader"));
        Label fullscreenLabel = new Label(composite_2, 0);
        fullscreenLabel.setText(this.settings.msg("dialog.template.fullscreen"));
        this.fullscreen = new Button(composite_2, 32);
        this.fullscreen.setToolTipText(this.settings.msg("dialog.template.fullscreen.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label doubleBuffLabel = new Label(composite_2, 0);
        doubleBuffLabel.setText(this.settings.msg("dialog.template.doublebuffering"));
        this.fulldouble = new Button(composite_2, 32);
        this.fulldouble.setToolTipText(this.settings.msg("dialog.template.doublebuffering.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label resolutionLabel = new Label(composite_2, 0);
        resolutionLabel.setText(this.settings.msg("dialog.template.fullscreenresolution"));
        this.fullresolution = new Combo(composite_2, 8);
        this.fullresolution.setItems(this.settings.getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        this.fullresolution.setToolTipText(this.settings.msg("dialog.template.fullscreenresolution.tooltip"));
        Label windowResLabel = new Label(composite_2, 0);
        windowResLabel.setText(this.settings.msg("dialog.template.windowresolution"));
        this.windowresolution = new Combo(composite_2, 8);
        this.windowresolution.setItems(this.settings.getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        this.windowresolution.setToolTipText(this.settings.msg("dialog.template.windowresolution.tooltip"));
        Label aspectLabel = new Label(composite_2, 0);
        aspectLabel.setText(this.settings.msg("dialog.template.aspectcorrection"));
        this.aspect = new Button(composite_2, 32);
        this.aspect.setToolTipText(this.settings.msg("dialog.template.aspectcorrection.tooltip"));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label overscanLabel = new Label(composite_2, 0);
        overscanLabel.setText(this.settings.msg("dialog.template.overscan"));
        this.overscan = new Text(composite_2, 2048);
        this.overscan.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label svgaChipsetLabel = new Label(composite_2, 0);
        svgaChipsetLabel.setText(this.settings.msg("dialog.template.svgachipset"));
        this.svgachipset = new Combo(composite_2, 8);
        this.svgachipset.setItems(this.settings.getValues("profile", "svgachipset"));
        this.svgachipset.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label videoRamLabel = new Label(composite_2, 0);
        videoRamLabel.setText(this.settings.msg("dialog.template.videoram"));
        this.videoram = new Combo(composite_2, 8);
        this.videoram.setItems(this.settings.getValues("profile", "videoram"));
        this.videoram.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label vsyncModeLabel = new Label(composite_2, 0);
        vsyncModeLabel.setText(this.settings.msg("dialog.template.vsyncmode"));
        this.vsyncmode = new Combo(composite_2, 8);
        this.vsyncmode.setItems(this.settings.getValues("profile", "vsyncmode"));
        this.vsyncmode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label vsyncRateLabel = new Label(composite_2, 0);
        vsyncRateLabel.setLayoutData((Object)new GridData());
        vsyncRateLabel.setText(this.settings.msg("dialog.template.vsyncrate"));
        this.vsyncrate = new Text(composite_2, 2048);
        this.vsyncrate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label glideLabel = new Label(composite_2, 0);
        glideLabel.setText(this.settings.msg("dialog.template.glide"));
        this.glide = new Button(composite_2, 32);
        Label glidePortLabel = new Label(composite_2, 0);
        glidePortLabel.setText(this.settings.msg("dialog.template.glideport"));
        this.glideport = new Text(composite_2, 2048);
        this.glideport.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        Label lfbGlideLabel = new Label(composite_2, 0);
        lfbGlideLabel.setText(this.settings.msg("dialog.template.lfbglide"));
        this.lfbGlide = new Combo(composite_2, 8);
        this.lfbGlide.setItems(this.settings.getValues("profile", "lfbglide"));
        this.lfbGlide.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createGeneralTab(TabFolder tabFolder) {
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout((Layout)gridLayout_1);
        generalTabItem.setControl((Control)composite_1);
        this.associationGroup = new Group(composite_1, 0);
        this.associationGroup.setText(this.settings.msg("dialog.template.association"));
        this.associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        this.associationGroup.setLayout((Layout)gridLayout_4);
        Label dbversionLabel = new Label((Composite)this.associationGroup, 0);
        dbversionLabel.setText(this.settings.msg("dialog.template.dosboxversion"));
        this.dbversion = new Combo((Composite)this.associationGroup, 8);
        this.dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(20);
        this.setButton = new Button((Composite)this.associationGroup, 0);
        this.setButton.setText(this.settings.msg("dialog.template.set"));
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, true, false);
            }
        });
        this.setButton.setEnabled(false);
        this.dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.setButton.setEnabled(true);
            }
        });
        this.reloadButton = new Button((Composite)this.associationGroup, 0);
        this.reloadButton.setText(this.settings.msg("dialog.template.reloadsettings"));
        this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditTemplateDialog.this.doLoadTemplateConf(EditTemplateDialog.this.setButton, false, false);
            }
        });
        this.miscGroup = new Group(composite_1, 0);
        this.miscGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        this.miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 3;
        this.miscGroup.setLayout((Layout)gridLayout_5);
        new Label((Composite)this.miscGroup, 0);
        Label activeLabel = new Label((Composite)this.miscGroup, 0);
        activeLabel.setText(this.settings.msg("dialog.template.active"));
        Label inactiveLabel = new Label((Composite)this.miscGroup, 0);
        inactiveLabel.setText(this.settings.msg("dialog.template.inactive"));
        Label priorityLabel = new Label((Composite)this.miscGroup, 0);
        priorityLabel.setText(this.settings.msg("dialog.template.priority"));
        this.priority_active = new Combo((Composite)this.miscGroup, 8);
        this.priority_active.setItems(this.settings.getValues("profile", "priority_active"));
        this.priority_active.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_active.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        this.priority_inactive = new Combo((Composite)this.miscGroup, 8);
        this.priority_inactive.setItems(this.settings.getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_inactive.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        Label waitOnErrorLabel = new Label((Composite)this.miscGroup, 0);
        waitOnErrorLabel.setText(this.settings.msg("dialog.template.waitonerror"));
        this.waitonerror = new Button((Composite)this.miscGroup, 32);
        this.waitonerror.setToolTipText(this.settings.msg("dialog.template.waitonerror.tooltip"));
        new Label((Composite)this.miscGroup, 0);
        Label exitLabel = new Label((Composite)this.miscGroup, 0);
        exitLabel.setText(this.settings.msg("dialog.template.exitafterwards"));
        this.exit = new Button((Composite)this.miscGroup, 32);
        new Label((Composite)this.miscGroup, 0);
        Label languageFileLabel = new Label((Composite)this.miscGroup, 0);
        languageFileLabel.setLayoutData((Object)new GridData());
        languageFileLabel.setText(this.settings.msg("dialog.template.languagefile"));
        this.language = new Text((Composite)this.miscGroup, 2048);
        this.language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.language.setToolTipText(this.settings.msg("dialog.template.languagefile.tooltip"));
        Label capturesLabel = new Label((Composite)this.miscGroup, 0);
        capturesLabel.setLayoutData((Object)new GridData());
        capturesLabel.setText(this.settings.msg("dialog.template.captures"));
        this.captures = new Text((Composite)this.miscGroup, 2048);
        this.captures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
        this.captures.setToolTipText(this.settings.msg("dialog.template.captures.tooltip"));
    }

    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.template.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.infoTabItem.setControl((Control)composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(this.settings.msg("dialog.template.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(this.settings.msg("dialog.template.default"));
        this.defaultButton = new Button(composite, 32);
    }

    protected void selectSettingsByConfiguration() {
        Configuration conf = this.compConf.getCompositeConf();
        String priority = conf.getValue("sdl", "priority");
        String[] priorities = priority.split(",");
        if (priorities != null && priorities.length >= 2) {
            this.priority_active.setText(priorities[0]);
            this.priority_inactive.setText(priorities[1]);
        }
        EditTemplateDialog.setIfEnabled(conf, "sdl", "waitonerror", (Control)this.waitonerror);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "language", (Control)this.language);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "captures", (Control)this.captures);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "output", (Control)this.output);
        EditTemplateDialog.setIfEnabled(conf, "render", "frameskip", (Control)this.frameskip);
        EditTemplateDialog.setIfEnabled(conf, "render", "scaler", (Control)this.scaler);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "fullscreen", (Control)this.fullscreen);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "fulldouble", (Control)this.fulldouble);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "fullresolution", (Control)this.fullresolution);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "windowresolution", (Control)this.windowresolution);
        EditTemplateDialog.setIfEnabled(conf, "render", "aspect", (Control)this.aspect);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "overscan", (Control)this.overscan);
        EditTemplateDialog.setIfEnabled(conf, "vga", "svgachipset", (Control)this.svgachipset);
        EditTemplateDialog.setIfEnabled(conf, "vga", "videoram", (Control)this.videoram);
        EditTemplateDialog.setIfEnabled(conf, "vsync", "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.setIfEnabled(conf, "vsync", "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.setIfEnabled(conf, "glide", "glide", (Control)this.glide);
        EditTemplateDialog.setIfEnabled(conf, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.setIfEnabled(conf, "glide", "lfb", (Control)this.lfbGlide);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "machine", (Control)this.machine);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "core", (Control)this.core);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycles", (Control)this.cycles);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycleup", (Control)this.cycles_up);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "cycledown", (Control)this.cycles_down);
        EditTemplateDialog.setIfEnabled(conf, "cpu", "timesynched", (Control)this.timesynched);
        EditTemplateDialog.setIfEnabled(conf, "dosbox", "memsize", (Control)this.memsize);
        EditTemplateDialog.setIfEnabled(conf, "dos", "xms", (Control)this.xms);
        EditTemplateDialog.setIfEnabled(conf, "dos", "ems", (Control)this.ems);
        EditTemplateDialog.setIfEnabled(conf, "dos", "umb", (Control)this.umb);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "nosound", (Control)this.nosound);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "rate", (Control)this.rate);
        EditTemplateDialog.setIfEnabled(conf, "midi", "mt32rate", (Control)this.mt32rate);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "blocksize", (Control)this.blocksize);
        EditTemplateDialog.setIfEnabled(conf, "mixer", "prebuffer", (Control)this.prebuffer);
        EditTemplateDialog.setIfEnabled(conf, "midi", "mpu401", (Control)this.mpu401);
        EditTemplateDialog.setIfEnabled(conf, "midi", "device", "mididevice", (Control)this.midi_device);
        EditTemplateDialog.setIfEnabled(conf, "midi", "config", "midiconfig", (Control)this.midi_config);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "type", "sbtype", (Control)this.sbtype);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplmode", (Control)this.oplmode);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplrate", (Control)this.oplrate);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "oplemu", (Control)this.oplemu);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "base", "sbbase", (Control)this.sbbase);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "irq", (Control)this.irq);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "dma", (Control)this.dma);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "hdma", (Control)this.hdma);
        EditTemplateDialog.setIfEnabled(conf, "sblaster", "mixer", "sbmixer", (Control)this.sbmixer);
        EditTemplateDialog.setIfEnabled(conf, "gus", "gus", (Control)this.gus);
        EditTemplateDialog.setIfEnabled(conf, "gus", "rate", "gusrate", (Control)this.gusrate);
        EditTemplateDialog.setIfEnabled(conf, "gus", "base", "gusbase", (Control)this.gusbase);
        EditTemplateDialog.setIfEnabled(conf, "gus", "irq1", "gusirq", (Control)this.gusirq1);
        EditTemplateDialog.setIfEnabled(conf, "gus", "irq2", "gusirq", (Control)this.gusirq2);
        EditTemplateDialog.setIfEnabled(conf, "gus", "dma1", "gusdma", (Control)this.gusdma1);
        EditTemplateDialog.setIfEnabled(conf, "gus", "dma2", "gusdma", (Control)this.gusdma2);
        EditTemplateDialog.setIfEnabled(conf, "gus", "ultradir", (Control)this.ultradir);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "pcspeaker", (Control)this.pcspeaker);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "pcrate", (Control)this.pcrate);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "tandy", (Control)this.tandy);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "tandyrate", (Control)this.tandyrate);
        EditTemplateDialog.setIfEnabled(conf, "speaker", "disney", (Control)this.disney);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "autolock", (Control)this.autolock);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "sensitivity", (Control)this.sensitivity);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "usescancodes", (Control)this.usescancodes);
        EditTemplateDialog.setIfEnabled(conf, "sdl", "mapperfile", (Control)this.mapperfile);
        EditTemplateDialog.setIfEnabled(conf, "dos", "keyboardlayout", (Control)this.keyboard_layout);
        if (conf.hasValue("joystick", "joysticktype")) {
            EditTemplateDialog.setIfEnabled(conf, "joystick", "joysticktype", (Control)this.joysticktype);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "timed", (Control)this.timed);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "autofire", (Control)this.autofire);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "swap34", (Control)this.swap34);
            EditTemplateDialog.setIfEnabled(conf, "joystick", "buttonwrap", (Control)this.buttonwrap);
        } else {
            EditTemplateDialog.setIfEnabled(conf, "bios", "joysticktype", (Control)this.joysticktype);
        }
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial1", (Control)this.serial1);
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial2", (Control)this.serial2);
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial3", (Control)this.serial3);
        EditTemplateDialog.setIfEnabled(conf, "serial", "serial4", (Control)this.serial4);
        EditTemplateDialog.setIfEnabled(conf, "ipx", "ipx", (Control)this.ipx);
        this.exit.setSelection(conf.isExit());
        this.mixer_config.setText(conf.getMixer());
        this.keyb.setText(conf.getKeyb());
        this.ipxnet.setEnabled(this.ipx.getSelection());
        this.ipxnet.setText(conf.getIpxnet());
        this.mountingpoints.setItems(conf.getMountingpoints());
        this.dosButton.setSelection(!conf.isBooter());
        this.booterButton.setSelection(conf.isBooter());
    }

    protected Configuration getConfigurationBySettings() {
        Configuration base = this.compConf.getBaseConf();
        Configuration conf = new Configuration(this.compConf.getCompositeConf(), false, null, false);
        conf.updateValue("sdl", "priority", this.priority_active.getText() + "," + this.priority_inactive.getText());
        conf.updateValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()));
        conf.updateValue("dosbox", "language", this.language.getText());
        conf.updateValue("dosbox", "captures", this.captures.getText());
        conf.updateValue("sdl", "output", this.output.getText());
        conf.updateValue("render", "frameskip", this.frameskip.getText());
        conf.updateValue("render", "scaler", this.scaler.getText());
        conf.updateValue("sdl", "pixelshader", this.pixelshader.getText());
        conf.updateValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()));
        conf.updateValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()));
        conf.updateValue("sdl", "fullresolution", this.fullresolution.getText());
        conf.updateValue("sdl", "windowresolution", this.windowresolution.getText());
        conf.updateValue("render", "aspect", String.valueOf(this.aspect.getSelection()));
        conf.updateValue("sdl", "overscan", this.overscan.getText());
        conf.updateValue("vga", "svgachipset", this.svgachipset.getText());
        conf.updateValue("vga", "videoram", this.videoram.getText());
        conf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText());
        conf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText());
        conf.updateValue("glide", "glide", String.valueOf(this.glide.getSelection()));
        conf.updateValue("glide", "port", "grport", this.glideport.getText(), base);
        conf.updateValue("glide", "lfb", this.lfbGlide.getText());
        conf.updateValue("dosbox", "machine", this.machine.getText());
        conf.updateValue("cpu", "cputype", this.cpu_type.getText());
        conf.updateValue("cpu", "core", this.core.getText());
        conf.updateValue("cpu", "cycles", this.cycles.getText());
        conf.updateValue("cpu", "cycleup", this.cycles_up.getText());
        conf.updateValue("cpu", "cycledown", this.cycles_down.getText());
        conf.updateValue("cpu", "timesynched", String.valueOf(this.timesynched.getSelection()));
        conf.updateValue("dosbox", "memsize", this.memsize.getText());
        conf.updateValue("dos", "xms", String.valueOf(this.xms.getSelection()));
        conf.updateValue("dos", "ems", String.valueOf(this.ems.getSelection()));
        conf.updateValue("dos", "umb", this.umb.getText());
        conf.updateValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()));
        conf.updateValue("mixer", "rate", this.rate.getText());
        conf.updateValue("midi", "mt32rate", this.mt32rate.getText());
        conf.updateValue("mixer", "blocksize", this.blocksize.getText());
        conf.updateValue("mixer", "prebuffer", this.prebuffer.getText());
        conf.updateValue("midi", "mpu401", this.mpu401.getText());
        conf.updateValue("midi", "device", "mididevice", this.midi_device.getText(), base);
        conf.updateValue("midi", "config", "midiconfig", this.midi_config.getText(), base);
        conf.updateValue("sblaster", "type", "sbtype", this.sbtype.getText(), base);
        conf.updateValue("sblaster", "oplmode", this.oplmode.getText());
        conf.updateValue("sblaster", "oplrate", this.oplrate.getText());
        conf.updateValue("sblaster", "oplemu", this.oplemu.getText());
        conf.updateValue("sblaster", "base", "sbbase", this.sbbase.getText(), base);
        conf.updateValue("sblaster", "sbbase", this.sbbase.getText());
        conf.updateValue("sblaster", "irq", this.irq.getText());
        conf.updateValue("sblaster", "dma", this.dma.getText());
        conf.updateValue("sblaster", "hdma", this.hdma.getText());
        conf.updateValue("sblaster", "mixer", "sbmixer", String.valueOf(this.sbmixer.getSelection()), base);
        conf.updateValue("gus", "gus", String.valueOf(this.gus.getSelection()));
        conf.updateValue("gus", "rate", "gusrate", this.gusrate.getText(), base);
        conf.updateValue("gus", "base", "gusbase", this.gusbase.getText(), base);
        conf.updateValue("gus", "irq1", "gusirq", this.gusirq1.getText(), base);
        conf.updateValue("gus", "irq2", this.gusirq2.getText());
        conf.updateValue("gus", "dma1", "gusdma", this.gusdma1.getText(), base);
        conf.updateValue("gus", "dma2", this.gusdma2.getText());
        conf.updateValue("gus", "ultradir", this.ultradir.getText());
        conf.updateValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()));
        conf.updateValue("speaker", "pcrate", this.pcrate.getText());
        conf.updateValue("speaker", "tandy", this.tandy.getText());
        conf.updateValue("speaker", "tandyrate", this.tandyrate.getText());
        conf.updateValue("speaker", "disney", String.valueOf(this.disney.getSelection()));
        conf.updateValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()));
        conf.updateValue("sdl", "sensitivity", this.sensitivity.getText());
        conf.updateValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()));
        conf.updateValue("sdl", "mapperfile", this.mapperfile.getText());
        conf.updateValue("dos", "keyboardlayout", this.keyboard_layout.getText());
        if (base.hasValue("joystick", "joysticktype")) {
            conf.updateValue("joystick", "joysticktype", this.joysticktype.getText());
            conf.updateValue("joystick", "timed", String.valueOf(this.timed.getSelection()));
            conf.updateValue("joystick", "autofire", String.valueOf(this.autofire.getSelection()));
            conf.updateValue("joystick", "swap34", String.valueOf(this.swap34.getSelection()));
            conf.updateValue("joystick", "buttonwrap", String.valueOf(this.buttonwrap.getSelection()));
        } else {
            conf.updateValue("bios", "joysticktype", this.joysticktype.getText());
        }
        conf.updateValue("serial", "serial1", this.serial1.getText());
        conf.updateValue("serial", "serial2", this.serial2.getText());
        conf.updateValue("serial", "serial3", this.serial3.getText());
        conf.updateValue("serial", "serial4", this.serial4.getText());
        conf.updateValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()));
        conf.setAutoexecSettings(this.exit.getSelection(), this.mixer_config.getText(), this.keyb.getText(), this.ipx.getSelection() ? this.ipxnet.getText() : "", this.booterButton.getSelection());
        return conf;
    }

    protected void doAddMount() {
        EditMountDialog addMountDialog = new EditMountDialog(this.shell);
        try {
            addMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(this.booterButton.getSelection(), this.mountingpoints.getItems()));
        }
        catch (Exception e) {
            // empty catch block
        }
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            this.mountingpoints.setItems(this.compConf.addMount(mount));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(sel));
            String mount = (String)editMountDialog.open();
            if (mount != null) {
                this.mountingpoints.setItems(this.compConf.editMount(sel, mount));
                if (this.mountingpoints.getItemCount() == mounts) {
                    this.mountingpoints.select(sel);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int mounts = this.mountingpoints.getItemCount();
        int sel = this.mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            this.mountingpoints.select(sel);
        }
        if (sel != -1) {
            this.mountingpoints.setItems(this.compConf.removeMount(sel));
            if (this.mountingpoints.getItemCount() == mounts) {
                this.mountingpoints.select(sel);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void enableSettingsByConfiguration() {
        Configuration conf = this.compConf.getBaseConf();
        if (conf.hasValue("cpu", "cputype")) {
            this.machine.setItems(this.settings.getValues("profile", "machine073"));
        } else {
            this.machine.setItems(this.settings.getValues("profile", "machine"));
        }
        EditTemplateDialog.enableDisableControl(conf, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.enableDisableControl(conf, "sdl", "overscan", (Control)this.overscan);
        EditTemplateDialog.enableDisableControl(conf, "vga", "svgachipset", (Control)this.svgachipset);
        EditTemplateDialog.enableDisableControl(conf, "vga", "videoram", (Control)this.videoram);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.enableDisableControl(conf, "vsync", "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.enableDisableControl(conf, "glide", "glide", (Control)this.glide);
        EditTemplateDialog.enableDisableControl(conf, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.enableDisableControl(conf, "glide", "lfb", (Control)this.lfbGlide);
        EditTemplateDialog.enableDisableControl(conf, "cpu", "timesynched", (Control)this.timesynched);
        EditTemplateDialog.enableDisableControl(conf, "sblaster", "oplemu", (Control)this.oplemu);
        EditTemplateDialog.enableDisableControl(conf, "gus", "irq2", (Control)this.gusirq2);
        EditTemplateDialog.enableDisableControl(conf, "gus", "dma2", (Control)this.gusdma2);
        EditTemplateDialog.enableDisableControl(conf, "midi", "mt32rate", (Control)this.mt32rate);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "timed", (Control)this.timed);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "autofire", (Control)this.autofire);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "swap34", (Control)this.swap34);
        EditTemplateDialog.enableDisableControl(conf, "joystick", "buttonwrap", (Control)this.buttonwrap);
        EditTemplateDialog.enableDisableControl(conf, "dos", "keyboardlayout", (Control)this.keyboard_layout);
    }

    protected void doLoadTemplateConf(Button setButton, boolean keepValues, boolean isTemplate) {
        this.compConf.setCompositeConf(this.getConfigurationBySettings());
        CompositeConfiguration newCompConf = this.obtainNewConf(keepValues, isTemplate);
        if (newCompConf.getCompositeConf() == null) {
            GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("dialog.template.notice.noloadnochanges"));
        } else {
            this.compConf = newCompConf;
            this.enableSettingsByConfiguration();
            this.selectSettingsByConfiguration();
            setButton.setEnabled(false);
        }
    }

    protected CompositeConfiguration obtainNewConf(boolean keepValues, boolean isTemplate) {
        return new CompositeConfiguration(this.compConf, this.dbversionsList.get(this.dbversion.getSelectionIndex()), keepValues, true, this.shell, System.out);
    }

    protected static void enableDisableControl(Configuration dbConf, String section, String oldItem, String newItem, Control control) {
        control.setEnabled(dbConf.hasValue(section, newItem) || dbConf.hasValue(section, oldItem));
    }

    protected static void enableDisableControl(Configuration dbConf, String section, String item, Control control) {
        control.setEnabled(dbConf.hasValue(section, item));
    }

    protected static void setIfEnabled(Configuration conf, String section, String item, Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                ((Text)control).setText(conf.getValue(section, item));
            } else if (control instanceof Combo) {
                ((Combo)control).setText(conf.getValue(section, item));
            } else if (control instanceof Button) {
                ((Button)control).setSelection(conf.getBooleanValue(section, item));
            }
        }
    }

    protected static void setIfEnabled(Configuration conf, String section, String oldItem, String newItem, Control control) {
        if (conf.hasValue(section, newItem)) {
            EditTemplateDialog.setIfEnabled(conf, section, newItem, control);
        } else {
            EditTemplateDialog.setIfEnabled(conf, section, oldItem, control);
        }
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.title"), (Control)this.title, this.infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

