/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.util.ExportThread;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDialog
extends Dialog {
    private Text logText;
    private Text filename;
    private Label profileLabel;
    private Button cancelButton;
    protected Shell shell;
    private ExportThread exportThread;
    private Profile[] profs;
    private List<DosboxVersion> dbversionsList;

    public ExportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ExportDialog(Shell parent, List<DosboxVersion> dbList, Profile[] p) {
        this(parent, 0);
        this.dbversionsList = dbList;
        this.profs = p;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.exportThread != null && !this.exportThread.isAlive() && !this.cancelButton.getText().equals("Close")) {
                GeneralPurposeDialogs.infoMessage(this.shell, "Export completed successfully.");
                this.profileLabel.setText("Please review the log below for possible problems");
                this.profileLabel.pack();
                this.cancelButton.setText("Close");
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.exportThread;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(500, 375);
        String titleString = "Export " + this.profs.length + " profile" + (this.profs.length > 1 ? "s" : "");
        this.shell.setText(titleString);
        Group settingsGroup = new Group((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        settingsGroup.setLayout((Layout)gridLayout);
        settingsGroup.setText("Options");
        settingsGroup.setLayoutData((Object)"North");
        Label titleLabel = new Label((Composite)settingsGroup, 0);
        titleLabel.setText("Title");
        final Text title = new Text((Composite)settingsGroup, 2048);
        title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label notesLabel = new Label((Composite)settingsGroup, 0);
        notesLabel.setText("Notes");
        final Text notes = new Text((Composite)settingsGroup, 2882);
        GridData gridData = new GridData(4, 4, true, true, 2, 2);
        gridData.heightHint = 40;
        notes.setLayoutData((Object)gridData);
        new Label((Composite)settingsGroup, 0);
        Label fileLabel = new Label((Composite)settingsGroup, 0);
        fileLabel.setText("File to export to");
        this.filename = new Text((Composite)settingsGroup, 2048);
        this.filename.setText("GAMEPACK_EXPORT");
        this.filename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final BrowseButton browseButton = new BrowseButton((Composite)settingsGroup, 0);
        browseButton.connect(this.shell, this.filename, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.ZIP, false, null);
        final Button exportCapturesButton = new Button((Composite)settingsGroup, 32);
        exportCapturesButton.setText("Also Export Captures");
        new Label((Composite)settingsGroup, 0);
        new Label((Composite)settingsGroup, 0);
        final Button exportGameDataButton = new Button((Composite)settingsGroup, 32);
        exportGameDataButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        exportGameDataButton.setText("Also Export Game Data");
        new Label((Composite)settingsGroup, 0);
        final Button startButton = new Button((Composite)settingsGroup, 0);
        this.shell.setDefaultButton(startButton);
        startButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        startButton.setText("Start Export");
        this.cancelButton = new Button((Composite)settingsGroup, 0);
        this.cancelButton.setLayoutData((Object)new GridData(80, -1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportDialog.this.shell.close();
            }
        });
        new Label((Composite)settingsGroup, 0);
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setLayout((Layout)new GridLayout());
        progressGroup.setText("Progress");
        final ProgressBar progressBar = new ProgressBar((Composite)progressGroup, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        this.logText.setLayoutData((Object)new GridData(4, 4, true, true));
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExportDialog.this.isValid()) {
                    return;
                }
                try {
                    ExportDialog.this.exportThread = new ExportThread(ExportDialog.this.profs, ExportDialog.this.dbversionsList, title.getText(), notes.getText(), exportCapturesButton.getSelection(), exportGameDataButton.getSelection(), FileUtils.canonicalToData(ExportDialog.this.filename.getText()), ExportDialog.this.logText, progressBar, ExportDialog.this.profileLabel);
                    browseButton.setEnabled(false);
                    startButton.setEnabled(false);
                    ExportDialog.this.exportThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(ExportDialog.this.shell, ex.getMessage());
                    ExportDialog.this.exportThread = null;
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String f = this.filename.getText();
        if (f.equals("")) {
            GeneralPurposeDialogs.addError("You must enter a filename for export.", (Control)this.filename);
        } else if (FileUtils.isExistingFile(FileUtils.canonicalToData(f))) {
            GeneralPurposeDialogs.addError(FileUtils.canonicalToData(f) + " already exists. You must enter another filename for export.", (Control)this.filename);
        } else {
            File dir = FileUtils.canonicalToData(f).getParentFile();
            if (dir == null || !dir.exists()) {
                GeneralPurposeDialogs.addError("This directory does not exist. Create it first, or enter another filename for export.", (Control)this.filename);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

