/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportListDialog
extends Dialog {
    private Text filename;
    private File[] files;
    private List<Profile> profs;
    private List<DosboxVersion> dbversionsList;
    private Shell shell;
    private Settings settings;

    public ExportListDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ExportListDialog(Shell parent, List<DosboxVersion> dbversionsList, List<Profile> profs) {
        this(parent, 0);
        this.dbversionsList = dbversionsList;
        this.profs = profs;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return null;
    }

    protected boolean init() {
        File path = FileUtils.canonicalToData(FileUtils.XSL_DIR);
        FilenameFilter xslExtension = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xsl");
            }
        };
        this.files = path.listFiles(xslExtension);
        if (this.files == null) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.settings.msg("dialog.exportlist.error.noxsldir"));
            return false;
        }
        if (this.files.length == 0) {
            GeneralPurposeDialogs.fatalMessage(this.getParent(), this.settings.msg("dialog.exportlist.error.noxslfiles"));
            return false;
        }
        return true;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "exportlistdialog"));
        this.shell.setText(this.settings.msg("dialog.exportlist.title"));
        Group settingsGroup = new Group((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        settingsGroup.setLayout((Layout)gridLayout);
        settingsGroup.setText(this.settings.msg("dialog.exportlist.options"));
        settingsGroup.setLayoutData((Object)"North");
        Label fileTypeLabel = new Label((Composite)settingsGroup, 0);
        fileTypeLabel.setText(this.settings.msg("dialog.exportlist.exportfiletype"));
        final Combo fileTypes = new Combo((Composite)settingsGroup, 8);
        fileTypes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        for (File file : this.files) {
            fileTypes.add(file.getName().substring(0, file.getName().length() - 4));
        }
        fileTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index;
                String file = ExportListDialog.this.filename.getText();
                String type = fileTypes.getItem(fileTypes.getSelectionIndex());
                int usi = type.lastIndexOf(95);
                if (usi != -1) {
                    type = type.substring(usi + 1);
                }
                if ((index = file.lastIndexOf(46)) == -1) {
                    ExportListDialog.this.filename.setText(file + '.' + type);
                } else {
                    ExportListDialog.this.filename.setText(file.substring(0, index + 1) + type);
                }
            }
        });
        Label fileLabel = new Label((Composite)settingsGroup, 0);
        fileLabel.setText(this.settings.msg("dialog.exportlist.filename"));
        this.filename = new Text((Composite)settingsGroup, 2048);
        this.filename.setText(FileUtils.EXPORT_DIR + "dbgllist");
        this.filename.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fileTypes.select(0);
        fileTypes.notifyListeners(13, new Event());
        BrowseButton browseButton = new BrowseButton((Composite)settingsGroup, 0);
        browseButton.connect(this.shell, this.filename, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, true, null);
        Label saveXmlLabel = new Label((Composite)settingsGroup, 0);
        saveXmlLabel.setText(this.settings.msg("dialog.exportlist.exportintermediatexml"));
        final Button saveXml = new Button((Composite)settingsGroup, 32);
        new Label((Composite)settingsGroup, 0);
        Button startButton = new Button((Composite)settingsGroup, 0);
        this.shell.setDefaultButton(startButton);
        startButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        startButton.setText(this.settings.msg("dialog.exportlist.startexport"));
        Button cancelButton = new Button((Composite)settingsGroup, 0);
        cancelButton.setLayoutData((Object)new GridData(120, -1));
        cancelButton.setText(this.settings.msg("button.cancel"));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportListDialog.this.shell.close();
            }
        });
        new Label((Composite)settingsGroup, 0);
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!ExportListDialog.this.isValid()) {
                    return;
                }
                try {
                    DOMSource xmlSource = new DOMSource(XmlUtils.getProfilesXML(ExportListDialog.this.profs, ExportListDialog.this.dbversionsList));
                    if (saveXml.getSelection()) {
                        XmlUtils.saveDomSource(xmlSource, FileUtils.canonicalToData(ExportListDialog.this.filename.getText() + ".xml"), null);
                    }
                    XmlUtils.saveDomSource(xmlSource, FileUtils.canonicalToData(ExportListDialog.this.filename.getText()), FileUtils.canonicalToData(FileUtils.XSL_DIR + fileTypes.getItem(fileTypes.getSelectionIndex()) + ".xsl"));
                    if (GeneralPurposeDialogs.confirmMessage(ExportListDialog.this.shell, ExportListDialog.this.settings.msg("dialog.exportlist.confirm.viewexport"))) {
                        PlatformUtils.openForBrowsing(FileUtils.canonicalToData(ExportListDialog.this.filename.getText()).getPath());
                    }
                }
                catch (IOException ex1) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell, ex1.getMessage());
                }
                catch (TransformerException ex2) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell, ex2.getMessage());
                }
                catch (ParserConfigurationException ex3) {
                    GeneralPurposeDialogs.warningMessage(ExportListDialog.this.shell, ex3.getMessage());
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String file = this.filename.getText();
        if ("".equals(file)) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.exportlist.required.filename"), (Control)this.filename);
        } else if (FileUtils.isExistingFile(FileUtils.canonicalToData(file))) {
            if (!GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.exportlist.confirm.overwrite", new Object[]{FileUtils.canonicalToData(file)}))) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.exportlist.notice.anotherfilename"), (Control)this.filename);
            }
        } else {
            File dir = FileUtils.canonicalToData(file).getParentFile();
            if (dir == null || !dir.exists()) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.exportlist.error.dirmissing"), (Control)this.filename);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }
}

