/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpGame;
import org.dbgl.util.FileUtils;
import org.dbgl.util.ImportThread;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import swing2swt.layout.BorderLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDialog
extends Dialog {
    private Text extract;
    private Text notes;
    private Table impDbVersionsList;
    private org.eclipse.swt.widgets.List myDbVersionsList;
    private Table profilesTable;
    private Button importProfileSettingsButton;
    private Button importCapturesButton;
    private Button importGameDataButton;
    private Text logText;
    private Label profileLabel;
    private Button cancelButton;
    protected Shell shell;
    private File archive;
    private String importTitle;
    private String importNotes;
    private boolean capturesAvailable = false;
    private boolean gamedataAvailable = false;
    private ExpGame[] profs;
    private List<DosboxVersion> dbversionsList;
    private List<Integer> dbmapping;
    private SortedSet<DosboxVersion> dbSet;
    private ImportThread importThread;

    public ImportDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ImportDialog(Shell parent, List<DosboxVersion> dbList, File arc, InputStream xml) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        this(parent, 0);
        this.dbversionsList = dbList;
        this.archive = arc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xml);
        xml.close();
        XPathFactory xfactory = XPathFactory.newInstance();
        XPath xPath = xfactory.newXPath();
        this.importTitle = xPath.evaluate("//title", doc);
        this.importNotes = xPath.evaluate("//notes", doc);
        this.capturesAvailable = Boolean.valueOf(xPath.evaluate("//captures-available", doc));
        this.gamedataAvailable = Boolean.valueOf(xPath.evaluate("//gamedata-available", doc));
        NodeList profNodes = (NodeList)xPath.evaluate("/document/profile", doc, XPathConstants.NODESET);
        this.profs = new ExpGame[profNodes.getLength()];
        NodeList dbNodes = (NodeList)xPath.evaluate("/document/profile/dosbox", doc, XPathConstants.NODESET);
        DosboxVersion[] dbversions = new DosboxVersion[dbNodes.getLength()];
        for (int i = 0; i < dbversions.length; ++i) {
            Node n = dbNodes.item(i);
            dbversions[i] = new DosboxVersion(i, xPath.evaluate("title", n), "", true, false, false, "", xPath.evaluate("version", n));
        }
        this.dbSet = new TreeSet<DosboxVersion>();
        for (DosboxVersion db : dbversions) {
            this.dbSet.add(db);
        }
        for (int i = 0; i < this.profs.length; ++i) {
            Node n = profNodes.item(i);
            this.profs[i] = new ExpGame(n, this.dbSet);
        }
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (this.importThread != null && !this.importThread.isAlive() && !this.cancelButton.getText().equals("Close")) {
                GeneralPurposeDialogs.infoMessage(this.shell, "Import completed successfully.");
                this.profileLabel.setText("Please review the log below for possible problems");
                this.profileLabel.pack();
                this.cancelButton.setText("Close");
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.importThread;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.setSize(500, 630);
        this.shell.setText("Import " + this.importTitle);
        Group settingsGroup = new Group((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        settingsGroup.setLayout((Layout)gridLayout);
        settingsGroup.setText("Options");
        settingsGroup.setLayoutData((Object)"North");
        this.notes = new Text((Composite)settingsGroup, 2890);
        GridData gridData_3 = new GridData(4, 0x1000000, true, false, 4, 1);
        gridData_3.heightHint = 40;
        this.notes.setLayoutData((Object)gridData_3);
        this.notes.setText(this.importNotes);
        this.importProfileSettingsButton = new Button((Composite)settingsGroup, 32);
        this.importProfileSettingsButton.setSelection(true);
        this.importProfileSettingsButton.setLayoutData((Object)new GridData());
        this.importProfileSettingsButton.setText("Import Profile settings");
        final Button fullSettingsButton = new Button((Composite)settingsGroup, 16);
        fullSettingsButton.setSelection(true);
        fullSettingsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        fullSettingsButton.setText("Full settings");
        final Button incrementalSettingsButton = new Button((Composite)settingsGroup, 16);
        incrementalSettingsButton.setLayoutData((Object)new GridData());
        incrementalSettingsButton.setText("Incremental settings");
        new Label((Composite)settingsGroup, 0);
        this.importCapturesButton = new Button((Composite)settingsGroup, 32);
        this.importCapturesButton.setSelection(this.capturesAvailable);
        this.importCapturesButton.setEnabled(this.capturesAvailable);
        this.importCapturesButton.setText("Import Captures");
        new Label((Composite)settingsGroup, 0);
        new Label((Composite)settingsGroup, 0);
        new Label((Composite)settingsGroup, 0);
        this.importGameDataButton = new Button((Composite)settingsGroup, 32);
        this.importGameDataButton.setLayoutData((Object)new GridData());
        this.importGameDataButton.setSelection(this.gamedataAvailable);
        this.importGameDataButton.setEnabled(this.gamedataAvailable);
        this.importGameDataButton.setText("Import Game data");
        Label belowLabel = new Label((Composite)settingsGroup, 0);
        belowLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        belowLabel.setText("Into");
        this.extract = new Text((Composite)settingsGroup, 2048);
        this.extract.setText(FileUtils.DOSROOT_DIR);
        this.extract.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.importProfileSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                incrementalSettingsButton.setEnabled(!incrementalSettingsButton.isEnabled());
                fullSettingsButton.setEnabled(!fullSettingsButton.isEnabled());
                ImportDialog.this.importCapturesButton.setEnabled(!ImportDialog.this.importCapturesButton.isEnabled());
            }
        });
        Button button = new Button((Composite)settingsGroup, 0);
        button.setText("button");
        Group profilesGroup = new Group((Composite)settingsGroup, 0);
        profilesGroup.setText("Profiles");
        profilesGroup.setLayoutData((Object)new GridData(4, 4, false, true, 4, 1));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        profilesGroup.setLayout((Layout)gridLayout_1);
        this.profilesTable = new Table((Composite)profilesGroup, 67616);
        this.profilesTable.setHeaderVisible(true);
        GridData gridData_1 = new GridData(4, 4, true, true, 1, 2);
        gridData_1.heightHint = 80;
        this.profilesTable.setLayoutData((Object)gridData_1);
        this.profilesTable.setLinesVisible(true);
        TableColumn title = new TableColumn(this.profilesTable, 0);
        title.setWidth(260);
        title.setText("Title");
        TableColumn subdir = new TableColumn(this.profilesTable, 0);
        subdir.setWidth(120);
        subdir.setText("Subdirectory");
        for (ExpGame prof : this.profs) {
            TableItem item = new TableItem(this.profilesTable, 0);
            item.setText(prof.getTitle());
            item.setText(1, FileUtils.makeRelativeTo(prof.getGameDir(), new File(this.extract.getText())).getPath());
        }
        this.profilesTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    ImportDialog.this.refillImportedDBVersionsList();
                }
            }
        });
        Button allButton = new Button((Composite)profilesGroup, 0);
        allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable.getItems()) {
                    item.setChecked(true);
                }
                ImportDialog.this.refillImportedDBVersionsList();
            }
        });
        allButton.setLayoutData((Object)new GridData(50, -1));
        allButton.setText("All");
        Button noneButton = new Button((Composite)profilesGroup, 0);
        noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TableItem item : ImportDialog.this.profilesTable.getItems()) {
                    item.setChecked(false);
                }
                ImportDialog.this.refillImportedDBVersionsList();
            }
        });
        GridData gridData = new GridData(16384, 1024, false, false);
        gridData.widthHint = 50;
        noneButton.setLayoutData((Object)gridData);
        noneButton.setText("None");
        Group dosboxVersionsGroup = new Group((Composite)settingsGroup, 0);
        dosboxVersionsGroup.setText("DOSBox versions");
        dosboxVersionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        dosboxVersionsGroup.setLayout((Layout)gridLayout_2);
        Label importedVersionsLabel = new Label((Composite)dosboxVersionsGroup, 0);
        importedVersionsLabel.setText("Imported versions");
        Label label_2 = new Label((Composite)dosboxVersionsGroup, 2);
        label_2.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        Label configuredVersionsLabel = new Label((Composite)dosboxVersionsGroup, 0);
        configuredVersionsLabel.setText("Configured versions");
        this.impDbVersionsList = new Table((Composite)dosboxVersionsGroup, 67584);
        this.impDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int impIdx = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                int mappedId = (Integer)ImportDialog.this.dbmapping.get(impIdx);
                int myIdx = DosboxVersion.findById(ImportDialog.this.dbversionsList, mappedId);
                ImportDialog.this.myDbVersionsList.select(myIdx);
            }
        });
        this.impDbVersionsList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.myDbVersionsList = new org.eclipse.swt.widgets.List((Composite)dosboxVersionsGroup, 2560);
        this.myDbVersionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImportDialog.this.impDbVersionsList.getSelectionIndex();
                if (idx != -1) {
                    int myIdx = ImportDialog.this.myDbVersionsList.getSelectionIndex();
                    ImportDialog.this.dbmapping.add(idx, ((DosboxVersion)ImportDialog.this.dbversionsList.get(myIdx)).getId());
                }
            }
        });
        GridData gridData_4 = new GridData(4, 0x1000000, true, false);
        gridData_4.heightHint = 80;
        this.myDbVersionsList.setLayoutData((Object)gridData_4);
        for (DosboxVersion ver : this.dbversionsList) {
            this.myDbVersionsList.add(ver.getTitle() + " (" + ver.getVersion() + ")");
        }
        this.dbmapping = new ArrayList<Integer>();
        for (DosboxVersion dbversion : this.dbSet) {
            TableItem item = new TableItem(this.impDbVersionsList, 0);
            item.setText(dbversion.getTitle() + " (" + dbversion.getVersion() + ")");
            this.dbmapping.add(dbversion.findBestMatchId(this.dbversionsList));
        }
        for (TableItem item : this.profilesTable.getItems()) {
            item.setChecked(true);
        }
        this.refillImportedDBVersionsList();
        final Button startButton = new Button((Composite)settingsGroup, 0);
        this.shell.setDefaultButton(startButton);
        startButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        startButton.setText("Start Import");
        this.cancelButton = new Button((Composite)settingsGroup, 0);
        this.cancelButton.setLayoutData((Object)new GridData(80, -1));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.shell.close();
            }
        });
        new Label((Composite)settingsGroup, 0);
        Group progressGroup = new Group((Composite)this.shell, 0);
        progressGroup.setLayout((Layout)new GridLayout());
        progressGroup.setText("Progress");
        final ProgressBar progressBar = new ProgressBar((Composite)progressGroup, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.profileLabel = new Label((Composite)progressGroup, 0);
        this.logText = new Text((Composite)progressGroup, 2826);
        GridData gridData_2 = new GridData(4, 4, true, true);
        gridData_2.minimumHeight = 100;
        this.logText.setLayoutData((Object)gridData_2);
        startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ImportDialog.this.isValid()) {
                    return;
                }
                try {
                    ArrayList<ExpGame> profiles = new ArrayList<ExpGame>();
                    for (int i = 0; i < ImportDialog.this.profs.length; ++i) {
                        TableItem it = ImportDialog.this.profilesTable.getItem(i);
                        if (!it.getChecked()) continue;
                        int oldId = ImportDialog.this.profs[i].getDbversionId();
                        int newId = ImportDialog.this.getDosboxVersionId(oldId);
                        ImportDialog.this.profs[i].setDbversionId(newId);
                        ImportDialog.this.profs[i].setGameDir(new File(it.getText(1)));
                        profiles.add(ImportDialog.this.profs[i]);
                    }
                    if (ImportDialog.this.importGameDataButton.getSelection() && !ImportDialog.this.isValidDirs()) {
                        return;
                    }
                    ImportDialog.this.importThread = new ImportThread(ImportDialog.this.importProfileSettingsButton.getSelection(), ImportDialog.this.importCapturesButton.getSelection(), ImportDialog.this.importGameDataButton.getSelection(), fullSettingsButton.getSelection(), ImportDialog.this.archive, profiles, ImportDialog.this.dbversionsList, ImportDialog.this.logText, progressBar, ImportDialog.this.profileLabel);
                    startButton.setEnabled(false);
                    ImportDialog.this.importThread.start();
                }
                catch (IOException ex) {
                    GeneralPurposeDialogs.warningMessage(ImportDialog.this.shell, ex.getMessage());
                    ImportDialog.this.importThread = null;
                }
            }
        });
        new Label((Composite)settingsGroup, 0);
        final TableEditor editor = new TableEditor(this.profilesTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        this.profilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)ImportDialog.this.profilesTable, 0);
                newEditor.setText(item.getText(1));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent me) {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(1, text.getText());
                    }
                });
                newEditor.selectAll();
                editor.setEditor((Control)newEditor, item, 1);
            }
        });
        this.importGameDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
            }
        });
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (!this.haveProfileToImport()) {
            GeneralPurposeDialogs.addError("You must select at least 1 profile to import.", (Control)this.profilesTable);
        }
        if (!this.haveCategoryToImport()) {
            GeneralPurposeDialogs.addError("You must select at least 1 category to import.", (Control)this.profilesTable);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean isValidDirs() {
        GeneralPurposeDialogs.initErrorDialog();
        for (ExpGame prof : this.profs) {
            File location = new File(new File(this.extract.getText()), prof.getGameDir().getPath());
            if (!location.isDirectory()) continue;
            GeneralPurposeDialogs.addError("At least 1 directory (" + location + ") already exists. You cannot install a game to that location.", (Control)this.profilesTable);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private void refillImportedDBVersionsList() {
        int idx = 0;
        for (DosboxVersion dbversion : this.dbSet) {
            int dbid = dbversion.getId();
            TableItem ti = this.impDbVersionsList.getItem(idx);
            Display d = this.shell.getDisplay();
            Color c = this.isUsed(dbid) ? null : d.getSystemColor(15);
            ti.setForeground(c);
            ++idx;
        }
    }

    private boolean isUsed(int dbVersionId) {
        for (int i = 0; i < this.profs.length; ++i) {
            TableItem item = this.profilesTable.getItem(i);
            int dbid = this.profs[i].getDbversionId();
            if (!item.getChecked() || dbVersionId != dbid) continue;
            return true;
        }
        return false;
    }

    private boolean haveProfileToImport() {
        for (TableItem item : this.profilesTable.getItems()) {
            if (!item.getChecked()) continue;
            return true;
        }
        return false;
    }

    private boolean haveCategoryToImport() {
        return this.importProfileSettingsButton.getSelection() || this.importGameDataButton.getSelection();
    }

    private int getDosboxVersionId(int oldId) {
        int index = 0;
        for (DosboxVersion ver : this.dbSet) {
            if (ver.getId() == oldId) {
                return this.dbmapping.get(index);
            }
            ++index;
        }
        return -1;
    }
}

