/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpGame;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.util.FileUtils;
import org.dbgl.util.XmlUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportThread
extends Thread {
    private static final String FORMAT_VERSION = "1.0";
    private String title;
    private int profileNumber;
    private StringBuffer messageLog;
    private Display display;
    private Text log;
    private ProgressBar progressBar;
    private Label profileLabel;
    private Profile[] profs;
    private List<DosboxVersion> dbversionsList;
    private String exportTitle;
    private String exportNotes;
    private boolean exportCaptures;
    private boolean exportGameData;
    private File target;
    private File xmlFile;

    public ExportThread(Profile[] p, List<DosboxVersion> dbList, String et, String en, boolean ec, boolean eg, File n, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profs = p;
        this.dbversionsList = dbList;
        this.exportTitle = et;
        this.exportNotes = en;
        this.exportCaptures = ec;
        this.exportGameData = eg;
        this.xmlFile = new File("profiles.xml");
        this.target = n;
        this.messageLog = new StringBuffer();
        this.progressBar.setMaximum(this.profs.length);
    }

    @Override
    public void run() {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.target));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmldoc = builder.newDocument();
            Element root = xmldoc.createElement("document");
            Element export = xmldoc.createElement("export");
            XmlUtils.addElement(xmldoc, export, "format-version", FORMAT_VERSION);
            XmlUtils.addElement(xmldoc, export, "title", this.exportTitle);
            XmlUtils.addCDataElement(xmldoc, export, "notes", this.exportNotes);
            XmlUtils.addElement(xmldoc, export, "generator-title", "DOSBox Game Launcher");
            XmlUtils.addElement(xmldoc, export, "generator-version", "0.67");
            XmlUtils.addElement(xmldoc, export, "captures-available", String.valueOf(this.exportCaptures));
            XmlUtils.addElement(xmldoc, export, "gamedata-available", String.valueOf(this.exportGameData));
            root.appendChild(export);
            this.profileNumber = 0;
            while (this.profileNumber < this.profs.length) {
                Profile prof = this.profs[this.profileNumber];
                this.title = prof.getTitle();
                this.messageLog = new StringBuffer();
                int dbIndex = DosboxVersion.findById(this.dbversionsList, prof.getDbversionId());
                CompositeConfiguration fullCConf = new CompositeConfiguration(this.dbversionsList.get(dbIndex), prof, false, null, System.out);
                File canonicalSrc = fullCConf.getCompositeConf().getCanonicalMainDir();
                File dst = fullCConf.getExportGameDir(this.profileNumber);
                if (this.exportCaptures) {
                    File captures = new File(FileUtils.constructCapturesDir(this.profileNumber));
                    try {
                        FileUtils.zipDir(prof.getCanonicalCaptures(), zos, captures);
                    }
                    catch (IOException e) {
                        this.messageLog.append(this.title + ": Captures could not be exported: " + e.getMessage() + "\n");
                    }
                }
                if (this.exportGameData) {
                    try {
                        FileUtils.zipDir(canonicalSrc, zos, new File(FileUtils.DOSROOT_DIR, dst.getPath()));
                    }
                    catch (IOException e) {
                        this.messageLog.append(this.title + ": Game data could not be exported: " + e.getMessage() + "\n");
                    }
                }
                String setup = prof.getSetup();
                ExpGame expProf = new ExpGame(this.profileNumber, FileUtils.PROFILES_DIR + this.profileNumber + ".conf", FileUtils.CAPTURES_DIR + this.profileNumber, setup, fullCConf.getFullConf(), fullCConf.getIncrConf(), dst, prof);
                Element profElement = expProf.getXml(xmldoc, this.dbversionsList);
                root.appendChild(profElement);
                if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed()) break;
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        ExportThread.this.profileLabel.setText("Exported " + ExportThread.this.title);
                        ExportThread.this.profileLabel.pack();
                        ExportThread.this.log.append(ExportThread.this.messageLog.toString());
                        ExportThread.this.progressBar.setSelection(ExportThread.this.profileNumber + 1);
                    }
                });
                ++this.profileNumber;
            }
            xmldoc.appendChild(root);
            FileUtils.zipEntry(this.xmlFile, zos, XmlUtils.domToInputStream(xmldoc));
            zos.close();
        }
        catch (Exception e) {
            this.messageLog.append(e.getMessage() + '\n');
            this.display.asyncExec(new Runnable(){

                public void run() {
                    ExportThread.this.log.append(ExportThread.this.messageLog.toString());
                }
            });
        }
    }
}

