/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpGame;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportThread
extends Thread {
    private String title;
    private int profileNumber;
    private StringBuffer messageLog;
    private Display display;
    private Text log;
    private ProgressBar progressBar;
    private Label profileLabel;
    private boolean importProfileSettings;
    private boolean importCaptures;
    private boolean importGameData;
    private boolean importFullSettings;
    private File archive;
    private List<ExpGame> profiles;
    private List<DosboxVersion> dbversionsList;

    public ImportThread(boolean ip, boolean ic, boolean ig, boolean f, File a, List<ExpGame> profs, List<DosboxVersion> dbList, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.importProfileSettings = ip;
        this.importCaptures = ic;
        this.importGameData = ig;
        this.importFullSettings = f;
        this.archive = a;
        this.profiles = profs;
        this.dbversionsList = dbList;
        this.progressBar.setMaximum(this.profiles.size());
    }

    @Override
    public void run() {
        Database db = Database.getInstance();
        this.profileNumber = 0;
        while (this.profileNumber < this.profiles.size()) {
            try {
                ExpGame p = this.profiles.get(this.profileNumber);
                this.title = p.getTitle();
                this.messageLog = new StringBuffer();
                String newCapturesString = null;
                if (this.importProfileSettings) {
                    int devId = KeyValuePair.findIdByValue(db.readDevelopersList(), p.getDeveloperName());
                    int publId = KeyValuePair.findIdByValue(db.readPublishersList(), p.getPublisherName());
                    int genId = KeyValuePair.findIdByValue(db.readGenresList(), p.getGenre());
                    int yrId = KeyValuePair.findIdByValue(db.readYearsList(), p.getYear());
                    int statId = KeyValuePair.findIdByValue(db.readStatusList(), p.getStatus());
                    int[] custIndex = new int[]{-1, -1, -1, -1};
                    for (int i = 0; i < 4; ++i) {
                        custIndex[i] = KeyValuePair.findIdByValue(db.readCustomList(i), p.getCustomString(i));
                    }
                    int profileId = db.addOrEditProfile(this.title, p.getDeveloperName(), p.getPublisherName(), p.getGenre(), p.getYear(), p.getStatus(), p.getSetup(), p.getSetupParameters(), p.getNotes(), p.isDefault(), devId, publId, genId, yrId, statId, p.getDbversionId(), p.getLinks(), p.getCustomStrings(), p.getCustomInts(), custIndex, p.getLinkTitles(), -1);
                    DosboxVersion assocDBVersion = this.dbversionsList.get(DosboxVersion.findById(this.dbversionsList, p.getDbversionId()));
                    CompositeConfiguration gameCConf = new CompositeConfiguration(assocDBVersion, null, this.importFullSettings ? p.getFullConfig() : p.getIncrConfig(), false, null, System.out);
                    String newConfString = FileUtils.constructUniqueConfigFileString(profileId, p.getTitle(), gameCConf.getCompositeConf());
                    newCapturesString = FileUtils.constructCapturesDir(profileId);
                    gameCConf.save(FileUtils.canonicalToData(newConfString), null, System.out);
                    db.updateProfileConf(newConfString, newCapturesString, profileId);
                    if (this.importCaptures) {
                        File cap = FileUtils.canonicalToData(newCapturesString);
                        if (!cap.exists()) {
                            FileUtils.createDir(cap);
                            try {
                                FileUtils.extractZip(this.archive, new File(p.getCaptures()), cap);
                            }
                            catch (IOException e) {
                                this.messageLog.append(this.title + ": captures could not be imported: " + e.getMessage() + "\n");
                            }
                        } else {
                            this.messageLog.append("Directory " + cap + " already exists, " + "skipping capture extraction for " + this.title + "\n");
                        }
                    }
                }
                if (this.importGameData) {
                    File gamedir = FileUtils.canonicalToDosroot(p.getGameDir().getPath());
                    if (!gamedir.exists()) {
                        FileUtils.createDir(gamedir);
                        try {
                            FileUtils.extractZip(this.archive, p.getGameDir(), gamedir);
                        }
                        catch (IOException e) {
                            this.messageLog.append(this.title + ": game data could not be imported: " + e.getMessage() + "\n");
                        }
                    } else {
                        this.messageLog.append("Directory " + gamedir + " already exists, " + "skipping game data extraction for " + this.title + "\n");
                    }
                }
            }
            catch (SQLException e) {
                this.messageLog.append(e.getMessage() + '\n');
            }
            if (this.display.isDisposed() || this.log.isDisposed() || this.progressBar.isDisposed()) break;
            this.display.asyncExec(new Runnable(){

                public void run() {
                    ImportThread.this.profileLabel.setText("Imported " + ImportThread.this.title + "...");
                    ImportThread.this.profileLabel.pack();
                    ImportThread.this.log.append(ImportThread.this.messageLog.toString());
                    ImportThread.this.progressBar.setSelection(ImportThread.this.profileNumber + 1);
                }
            });
            ++this.profileNumber;
        }
    }
}

