/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.Settings;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Configuration;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.widgets.Shell;

public class CompositeConfiguration {
    private Configuration baseConf;
    private Configuration compositeConf;
    private DosboxVersion dbversion;

    public CompositeConfiguration(DosboxVersion dbversion, boolean force, Shell shell, PrintStream ps) {
        this.processConfiguration(dbversion.getCanonicalConfFile(), null, true, force, shell, ps);
        this.dbversion = dbversion;
    }

    public CompositeConfiguration(DosboxVersion dbversion, Profile profile, boolean force, Shell shell, PrintStream ps) {
        this(dbversion, profile.getCanonicalConfFile(), null, force, shell, ps);
    }

    public CompositeConfiguration(DosboxVersion dbversion, Template template, boolean force, Shell shell, PrintStream ps) {
        this(dbversion, FileUtils.constructCanonicalTemplateFileLocation(template.getId()), null, force, shell, ps);
    }

    public CompositeConfiguration(DosboxVersion dbversion, File file, String contents, boolean force, Shell shell, PrintStream ps) {
        this(dbversion, force, shell, ps);
        if (file != null || contents != null) {
            this.processConfiguration(file, contents, false, force, shell, ps);
        }
    }

    public CompositeConfiguration(CompositeConfiguration comp, DosboxVersion dbversion, Template template, boolean force, Shell shell, PrintStream ps) {
        this(dbversion, FileUtils.constructCanonicalTemplateFileLocation(template.getId()), null, force, shell, ps);
        if (this.baseConf != null && this.compositeConf != null) {
            Configuration uniqueMountPoints = new Configuration(comp.compositeConf, true, this.baseConf, false);
            Configuration otherAutoSettings = new Configuration(comp.compositeConf, false);
            this.compositeConf.setAutoexecSettings(otherAutoSettings.isLoadfix(), otherAutoSettings.getLoadfixValue(), otherAutoSettings.getMain(), otherAutoSettings.getMainParameters(), otherAutoSettings.getImg1(), otherAutoSettings.getImg2());
            if (uniqueMountPoints != null && uniqueMountPoints.getNrOfMounts() > 0) {
                int m = this.compositeConf.getNrOfMounts();
                for (int i = m - 1; i >= 0; --i) {
                    this.compositeConf.removeMount(i);
                }
                this.compositeConf.addMounts(uniqueMountPoints);
            }
        }
    }

    public CompositeConfiguration(CompositeConfiguration comp, DosboxVersion dbversion, boolean keepValues, boolean isTemplate, Shell shell, PrintStream ps) {
        this.baseConf = comp.baseConf;
        this.compositeConf = comp.compositeConf;
        this.dbversion = comp.dbversion;
        Configuration uniqueMountPoints = null;
        Configuration otherAutoSettings = null;
        if (this.baseConf != null && this.compositeConf != null) {
            uniqueMountPoints = new Configuration(this.compositeConf, true, this.baseConf, this.dbversion != dbversion);
            otherAutoSettings = new Configuration(this.compositeConf, keepValues);
        }
        if (keepValues) {
            if (!this.update(dbversion, shell, ps, isTemplate)) {
                this.compositeConf = null;
            }
        } else {
            this.processConfiguration(dbversion.getCanonicalConfFile(), null, true, false, shell, ps);
            this.dbversion = dbversion;
        }
        if (this.compositeConf != null && otherAutoSettings != null) {
            if (keepValues) {
                this.compositeConf.setAutoexecSettings(otherAutoSettings.isExit(), otherAutoSettings.getMixer(), otherAutoSettings.getKeyb(), otherAutoSettings.getIpxnet(), otherAutoSettings.isBooter());
            } else {
                this.compositeConf.setAutoexecSettings(otherAutoSettings.isExit(), otherAutoSettings.isBooter());
            }
            this.compositeConf.setAutoexecSettings(otherAutoSettings.isLoadfix(), otherAutoSettings.getLoadfixValue(), otherAutoSettings.getMain(), otherAutoSettings.getMainParameters(), otherAutoSettings.getImg1(), otherAutoSettings.getImg2());
        }
        if (!(this.compositeConf == null || uniqueMountPoints == null || this.dbversion == comp.dbversion && keepValues)) {
            this.compositeConf.addMounts(uniqueMountPoints);
        }
    }

    private boolean update(DosboxVersion dbversion, Shell shell, PrintStream ps, boolean isTemplate) {
        Configuration org = new Configuration(this.compositeConf, false, null, false);
        this.processConfiguration(dbversion.getCanonicalConfFile(), null, true, false, shell, ps);
        if (this.baseConf == null) {
            if (shell != null && GeneralPurposeDialogs.confirmMessage(shell, Settings.getInstance().msg(isTemplate ? "general.confirm.missingdosboxconftemplate" : "general.confirm.missingdosboxconfprofile"))) {
                this.processConfiguration(dbversion.getCanonicalConfFile(), null, true, true, shell, ps);
            } else {
                GeneralPurposeDialogs.warningMessage(ps, Settings.getInstance().msg("general.error.readconf", new Object[]{dbversion.getCanonicalConfFile()}));
                return false;
            }
        }
        this.compositeConf.updateAndExtendWithValuesFrom(org);
        this.dbversion = dbversion;
        return true;
    }

    public void setCompositeConf(Configuration configuration) {
        this.compositeConf = configuration;
    }

    private void save(boolean substract, File target, Shell shell, PrintStream ps) {
        Configuration toSave = new Configuration(this.compositeConf, false, null, false);
        toSave.strip(this.baseConf);
        toSave.setFixedCycles();
        if (substract) {
            toSave.substract(this.baseConf);
        }
        try {
            toSave.saveToFile(target, false, this.baseConf);
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ps, ex.getMessage());
        }
    }

    public void save(Template template, Shell shell, PrintStream ps) {
        this.save(true, FileUtils.constructCanonicalTemplateFileLocation(template.getId()), shell, ps);
    }

    public void save(Profile profile, Shell shell, PrintStream ps) {
        this.compositeConf.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(profile.getId()));
        this.save(this.dbversion != null && this.dbversion.isMultiConfig(), profile.getCanonicalConfFile(), shell, ps);
    }

    public void save(File file, Shell shell, PrintStream ps) {
        this.save(this.dbversion != null && this.dbversion.isMultiConfig(), file, shell, ps);
    }

    public String getFullConf() {
        return this.compositeConf.toString(false, this.baseConf);
    }

    public String getIncrConf() {
        Configuration toSave = new Configuration(this.compositeConf, false, null, false);
        toSave.strip(this.baseConf);
        toSave.setFixedCycles();
        if (this.dbversion != null && this.dbversion.isMultiConfig()) {
            toSave.substract(this.baseConf);
        }
        return toSave.toString(false, this.baseConf);
    }

    public File getExportGameDir(int index) {
        return new File("./" + index + "/");
    }

    public Configuration getBaseConf() {
        return this.baseConf;
    }

    public Configuration getCompositeConf() {
        return this.compositeConf;
    }

    public int getDbversionId() {
        return this.dbversion.getId();
    }

    private void init() {
        this.baseConf = null;
        this.compositeConf = null;
        this.dbversion = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConfiguration(File file, String contents, boolean base, boolean force, Shell shell, PrintStream ps) {
        if (base) {
            try {
                this.init();
                this.baseConf = file == null ? new Configuration(new StringReader(contents)) : new Configuration(file, true);
                if (!this.baseConf.hasParsingProblems()) return;
                GeneralPurposeDialogs.warningMessage(shell, ps, this.baseConf.getParsingProblems());
                return;
            }
            catch (IOException ex) {
                GeneralPurposeDialogs.warningMessage(shell, ps, ex.getMessage());
                if (!force) return;
                this.baseConf = new Configuration();
                return;
            }
            finally {
                if (this.baseConf != null) {
                    this.compositeConf = new Configuration(this.baseConf, true, null, false);
                    this.compositeConf.unsetFixedCycles();
                }
            }
        }
        try {
            this.compositeConf.setAutoexecSettings(false);
            if (file == null) {
                this.compositeConf.parseConfigurationFile(new StringReader(contents), "unknown", true);
            } else {
                this.compositeConf.parseConfigurationFile(file, true);
            }
            this.compositeConf.unsetFixedCycles();
        }
        catch (IOException ex) {
            GeneralPurposeDialogs.warningMessage(shell, ps, ex.getMessage());
        }
        if (!this.compositeConf.hasParsingProblems()) return;
        GeneralPurposeDialogs.warningMessage(shell, ps, this.compositeConf.getParsingProblems());
    }

    public String[] addMount(String mount) {
        return this.compositeConf.addMount(mount);
    }

    public String[] removeMount(int index) {
        if (index < this.baseConf.getNrOfMounts()) {
            return this.compositeConf.toggleMount(index);
        }
        return this.compositeConf.removeMount(index);
    }

    public String[] editMount(int index, String mount) {
        if (index < this.baseConf.getNrOfMounts()) {
            this.compositeConf.unMount(index);
            return this.compositeConf.addMount(mount);
        }
        return this.compositeConf.replaceMount(index, mount);
    }

    public String getRequiredMount(boolean booter, String exe) {
        return this.compositeConf.getRequiredMount(booter, exe);
    }

    public String[] addRequiredMount(boolean booter, String exe) {
        return this.compositeConf.addRequiredMount(booter, exe);
    }
}

