/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.Mount;
import org.dbgl.model.Settings;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Section;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private Map<String, Section> sections;
    private Autoexec autoexec;
    private StringBuffer parsingProblems = new StringBuffer();
    private Settings settings;

    public Configuration() {
        this.sections = new LinkedHashMap<String, Section>();
        this.autoexec = new Autoexec(new String[0]);
        this.settings = Settings.getInstance();
    }

    public Configuration(Configuration conf, boolean keepLoadfix) {
        this();
        this.autoexec = new Autoexec(conf.autoexec);
        if (!keepLoadfix) {
            this.autoexec.loadfix = false;
            this.autoexec.loadfixValue = 0;
        }
    }

    public Configuration(Configuration conf, boolean mountingsOnly, Configuration baseConf, boolean switchDbversion) {
        this();
        for (String key : conf.sections.keySet()) {
            this.sections.put(key, new Section(conf.sections.get(key)));
        }
        this.autoexec = mountingsOnly ? new Autoexec(conf.autoexec.mountingpoints, baseConf == null ? null : baseConf.autoexec, switchDbversion) : new Autoexec(conf.autoexec);
    }

    public Configuration(File file, boolean toLowerCase) throws IOException {
        this();
        this.parseConfigurationFile(file, toLowerCase);
    }

    public Configuration(Reader reader) throws IOException {
        this();
        this.parseConfigurationFile(reader, "profiles.xml", false);
    }

    public Set<String> getSectionKeys() {
        return this.sections.keySet();
    }

    public void saveToFile(File file, boolean ordered, Configuration baseConf) throws IOException {
        try {
            BufferedWriter configData = new BufferedWriter(new FileWriter(file));
            configData.write(this.toString(ordered, baseConf));
            configData.flush();
            configData.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(this.settings.msg("general.error.savefile", new Object[]{file}));
        }
    }

    public final void parseConfigurationFile(File file, boolean toLowerCase) throws IOException {
        try {
            this.parseConfigurationFile(new FileReader(file), file.getPath(), toLowerCase);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IOException(this.settings.msg("general.error.openfile", new Object[]{file}));
        }
    }

    public void parseConfigurationFile(Reader reader, String file, boolean toLowerCase) throws IOException {
        try {
            String orgTextLine;
            BufferedReader configData = new BufferedReader(reader);
            String currSectionTitle = null;
            Section currSection = null;
            boolean lastItemHadMissingSection = false;
            ArrayList<String> autoexecLines = new ArrayList<String>();
            while ((orgTextLine = configData.readLine()) != null) {
                orgTextLine = orgTextLine.trim();
                String textLine = toLowerCase ? orgTextLine.toLowerCase() : orgTextLine;
                if (textLine.length() <= 0 || textLine.charAt(0) == '#') continue;
                if (textLine.charAt(0) == '[') {
                    int start = textLine.indexOf(91);
                    int end = textLine.lastIndexOf(93);
                    if (end == -1) {
                        this.parsingProblems.append(this.settings.msg("general.error.parseconf", new Object[]{file, textLine})).append('\n');
                        continue;
                    }
                    currSectionTitle = textLine.substring(start + 1, end);
                    if (this.sections.containsKey(currSectionTitle)) {
                        currSection = this.sections.get(currSectionTitle);
                        continue;
                    }
                    if ("autoexec".equals(currSectionTitle)) continue;
                    currSection = new Section();
                    this.sections.put(currSectionTitle, currSection);
                    continue;
                }
                if (currSectionTitle == null) {
                    if (!lastItemHadMissingSection) {
                        this.parsingProblems.append(this.settings.msg("general.error.sectionmissing", new Object[]{file, textLine})).append('\n');
                    }
                    lastItemHadMissingSection = true;
                    continue;
                }
                if ("autoexec".equals(currSectionTitle)) {
                    autoexecLines.add(orgTextLine);
                } else {
                    int end = textLine.indexOf(61);
                    if (end == -1) {
                        this.parsingProblems.append(this.settings.msg("general.error.parseconf", new Object[]{file, textLine})).append('\n');
                    } else {
                        String name = textLine.substring(0, end).trim();
                        String value = textLine.substring(end + 1).trim();
                        if ("gui".equals(currSectionTitle) || "database".equals(currSectionTitle) || "directory".equals(currSectionTitle)) {
                            value = orgTextLine.substring(end + 1).trim();
                        }
                        currSection.items.put(name, value);
                    }
                }
                lastItemHadMissingSection = false;
            }
            configData.close();
            this.autoexec.parseLines(autoexecLines.toArray(new String[autoexecLines.size()]), false);
        }
        catch (IOException e) {
            e.printStackTrace();
            StringBuffer msg = new StringBuffer(this.settings.msg("general.error.readconf", new Object[]{file}));
            if (this.parsingProblems.length() > 0) {
                msg.append('\n').append(this.getParsingProblems());
            }
            throw new IOException(msg.toString());
        }
    }

    public boolean hasValue(String sectionTitle, String sectionItem) {
        return this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).items.containsKey(sectionItem);
    }

    public String getValue(String sectionTitle, String sectionItem) {
        String result = null;
        if (this.sections.containsKey(sectionTitle)) {
            result = this.sections.get((Object)sectionTitle).items.get(sectionItem);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public int getIntValue(String sectionTitle, String sectionItem) {
        try {
            return Integer.parseInt(this.getValue(sectionTitle, sectionItem));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public boolean getBooleanValue(String sectionTitle, String sectionItem) {
        return Boolean.valueOf(this.getValue(sectionTitle, sectionItem));
    }

    public void setValue(String sectionTitle, String sectionItem, String value) {
        Section sec = this.createSection(sectionTitle);
        sec.items.put(sectionItem, value);
    }

    public void setIntValue(String sectionTitle, String sectionItem, int value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void setBooleanValue(String sectionTitle, String sectionItem, boolean value) {
        this.setValue(sectionTitle, sectionItem, String.valueOf(value));
    }

    public void updateValue(String sectionTitle, String sectionItem, String value) {
        if (this.sections.containsKey(sectionTitle) && this.sections.get((Object)sectionTitle).items.containsKey(sectionItem)) {
            this.sections.get((Object)sectionTitle).items.put(sectionItem, value);
        }
    }

    public void updateValue(String section, String oldItem, String newItem, String value, Configuration base) {
        if (base.hasValue(section, newItem)) {
            this.updateValue(section, newItem, value);
        } else {
            this.updateValue(section, oldItem, value);
        }
    }

    public String[] getItems(String sectionTitle) {
        return new TreeMap<String, String>(this.sections.get((Object)sectionTitle).items).keySet().toArray(new String[0]);
    }

    public String[] getValues(String sectionTitle, String sectionItem) {
        String val = this.getValue(sectionTitle, sectionItem);
        if (val.length() <= 0) {
            return new String[0];
        }
        String[] res = val.split(" ");
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].replaceAll("<space>", " ");
        }
        return res;
    }

    public String getMultilineValues(String sectionTitle, String sectionItem, String delimiter) {
        return StringUtils.stringArrayToString(this.getValues(sectionTitle, sectionItem), delimiter);
    }

    public void setMultilineValues(String sectionTitle, String sectionItem, String values, String delimiter) {
        this.setValue(sectionTitle, sectionItem, values.replaceAll(" ", "<space>").replace(delimiter, " ").trim());
    }

    public int[] getIntValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToIntArray(this.getValue(sectionTitle, sectionItem));
    }

    public void setIntValues(String sectionTitle, String sectionItem, int[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.intArrayToString(values));
    }

    public boolean[] getBooleanValues(String sectionTitle, String sectionItem) {
        return StringUtils.stringToBooleanArray(this.getValue(sectionTitle, sectionItem));
    }

    public void setBooleanValues(String sectionTitle, String sectionItem, boolean[] values) {
        this.setValue(sectionTitle, sectionItem, StringUtils.booleanArrayToString(values));
    }

    public void removeValue(String sectionTitle, String sectionItem) {
        if (this.sections.containsKey(sectionTitle)) {
            Section sec = this.sections.get(sectionTitle);
            sec.items.remove(sectionItem);
            if (sec.items.isEmpty()) {
                this.sections.remove(sectionTitle);
            }
        }
    }

    public void removeSection(String title) {
        this.sections.remove(title);
    }

    public void updateAndExtendWithValuesFrom(Configuration conf) {
        this.update(conf);
        for (String sectionTitle : conf.sections.keySet()) {
            for (String sectionItem : conf.getItems(sectionTitle)) {
                this.setValue(sectionTitle, sectionItem, conf.getValue(sectionTitle, sectionItem));
            }
        }
    }

    public void update(Configuration conf) {
        conf.transferSetting("sblaster", "type", "sblaster", "sbtype", this);
        conf.transferSetting("sblaster", "base", "sblaster", "sbbase", this);
        conf.transferSetting("gus", "rate", "gus", "gusrate", this);
        conf.transferSetting("gus", "base", "gus", "gusbase", this);
        if (!this.hasValue("midi", "intelligent") && conf.hasValue("midi", "intelligent")) {
            boolean mpu = conf.getBooleanValue("midi", "mpu401");
            boolean intelli = conf.getBooleanValue("midi", "intelligent");
            conf.setValue("midi", "mpu401", mpu ? (intelli ? "intelligent" : "uart") : "none");
            conf.removeValue("midi", "intelligent");
        } else if (this.hasValue("midi", "intelligent") && !conf.hasValue("midi", "intelligent")) {
            String mpu = conf.getValue("midi", "mpu401");
            conf.setBooleanValue("midi", "mpu401", !mpu.equalsIgnoreCase("none"));
            conf.setBooleanValue("midi", "intelligent", mpu.equalsIgnoreCase("intelligent"));
        }
        conf.transferSetting("bios", "joysticktype", "joystick", "joysticktype", this);
        if (this.hasValue("cpu", "cputype") && !conf.hasValue("cpu", "cputype")) {
            if (conf.getValue("dosbox", "machine").equalsIgnoreCase("vga")) {
                conf.removeValue("dosbox", "machine");
            }
            if (conf.getValue("dos", "keyboardlayout").equalsIgnoreCase("none")) {
                conf.removeValue("dos", "keyboardlayout");
            }
        } else if (conf.hasValue("cpu", "cputype") && !this.hasValue("cpu", "cputype")) {
            String mach = conf.getValue("dosbox", "machine");
            if (!(mach.equalsIgnoreCase("cga") || mach.equalsIgnoreCase("hercules") || mach.equalsIgnoreCase("pcjr") || mach.equalsIgnoreCase("tandy"))) {
                conf.removeValue("dosbox", "machine");
            }
            if (conf.getValue("dos", "keyboardlayout").equalsIgnoreCase("auto")) {
                conf.removeValue("dos", "keyboardlayout");
            }
            conf.removeValue("cpu", "cputype");
        }
        conf.transferSetting("midi", "device", "midi", "mididevice", this);
        conf.transferSetting("midi", "config", "midi", "midiconfig", this);
        conf.transferSetting("sblaster", "mixer", "sblaster", "sbmixer", this);
        if (conf.hasValue("gus", "irq1") && !this.hasValue("gus", "irq1") && this.hasValue("gus", "gusirq")) {
            conf.setValue("gus", "gusirq", conf.getValue("gus", "irq1"));
            conf.removeValue("gus", "irq1");
            conf.removeValue("gus", "irq2");
            conf.setValue("gus", "gusdma", conf.getValue("gus", "dma1"));
            conf.removeValue("gus", "dma1");
            conf.removeValue("gus", "dma2");
        } else if (conf.hasValue("gus", "gusirq") && !this.hasValue("gus", "gusirq") && this.hasValue("gus", "irq1")) {
            conf.setValue("gus", "irq1", conf.getValue("gus", "gusirq"));
            conf.setValue("gus", "irq2", conf.getValue("gus", "gusirq"));
            conf.removeValue("gus", "gusirq");
            conf.setValue("gus", "dma1", conf.getValue("gus", "gusdma"));
            conf.setValue("gus", "dma2", conf.getValue("gus", "gusdma"));
            conf.removeValue("gus", "gusdma");
        }
    }

    private void transferSetting(String oldSection, String oldItem, String newSection, String newItem, Configuration newConf) {
        if (this.hasValue(oldSection, oldItem) && !newConf.hasValue(oldSection, oldItem) && newConf.hasValue(newSection, newItem)) {
            this.setValue(newSection, newItem, this.getValue(oldSection, oldItem));
            this.removeValue(oldSection, oldItem);
        } else if (this.hasValue(newSection, newItem) && !newConf.hasValue(newSection, newItem) && newConf.hasValue(oldSection, oldItem)) {
            this.setValue(oldSection, oldItem, this.getValue(newSection, newItem));
            this.removeValue(newSection, newItem);
        }
    }

    public void strip(Configuration conf) {
        Configuration newConf = new Configuration();
        for (String key : this.sections.keySet()) {
            if (!conf.sections.containsKey(key)) continue;
            for (String item : this.sections.get((Object)key).items.keySet()) {
                if (!conf.sections.get((Object)key).items.containsKey(item)) continue;
                newConf.setValue(key, item, this.sections.get((Object)key).items.get(item));
            }
        }
        this.sections = newConf.sections;
    }

    public void setFixedCycles() {
        String cycles;
        if (this.hasValue("cpu", "cputype") && this.hasValue("cpu", "cycles") && !this.hasValue("sblaster", "oplemu") && !(cycles = this.getValue("cpu", "cycles")).contains("auto") && !cycles.contains("max")) {
            this.setValue("cpu", "cycles", "fixed " + cycles);
        }
    }

    public void unsetFixedCycles() {
        String cycles;
        if (this.hasValue("cpu", "cycles") && (cycles = this.getValue("cpu", "cycles")).startsWith("fixed ")) {
            this.setValue("cpu", "cycles", cycles.substring(6));
        }
    }

    public String toString(boolean ordered, Configuration baseConf) {
        StringBuffer result = new StringBuffer();
        for (String key : this.sections.keySet()) {
            result.append("[" + key + "]" + PlatformUtils.EOLN);
            result.append(this.sections.get(key).toString(ordered)).append(PlatformUtils.EOLN);
        }
        String auto = baseConf == null ? this.autoexec.getString(null) : this.autoexec.getString(baseConf.autoexec.mountingpoints);
        if (auto.length() > 0) {
            result.append("[autoexec]").append(PlatformUtils.EOLN).append(auto).append(PlatformUtils.EOLN);
        }
        return result.toString();
    }

    protected Section createSection(String sectionTitle) {
        if (this.sections.containsKey(sectionTitle)) {
            return this.sections.get(sectionTitle);
        }
        Section newSection = new Section();
        this.sections.put(sectionTitle, newSection);
        return newSection;
    }

    public void substract(Configuration conf) {
        for (String key : conf.sections.keySet()) {
            if (!this.sections.containsKey(key)) continue;
            Section mysec = this.sections.get(key);
            mysec.substract(conf.sections.get(key));
            if (!mysec.items.isEmpty()) continue;
            this.sections.remove(key);
        }
    }

    public boolean hasParsingProblems() {
        return this.parsingProblems.length() > 0;
    }

    public final String getParsingProblems() {
        String result = this.parsingProblems.toString();
        this.parsingProblems = new StringBuffer();
        return result;
    }

    public File getCanonicalMainDir() {
        if (this.isBooter()) {
            return FileUtils.getCanMainFile(new File(this.autoexec.img1)).getParentFile();
        }
        return FileUtils.getCanMainFile(new File(this.autoexec.main)).getParentFile();
    }

    public void makeRelative(File basePath) {
        for (Mount mount : this.autoexec.mountingpoints) {
            mount.makeRelative(basePath);
        }
        if (this.isBooter()) {
            this.autoexec.img1 = FileUtils.makeRelativeTo(new File(this.autoexec.img1), basePath).getPath();
            this.autoexec.img2 = FileUtils.makeRelativeTo(new File(this.autoexec.img2), basePath).getPath();
        } else {
            this.autoexec.main = FileUtils.makeRelativeTo(new File(this.autoexec.main), basePath).getPath();
        }
    }

    public void makeUnRelative(File basePath) {
        for (Mount mount : this.autoexec.mountingpoints) {
            mount.makeUnRelative(basePath);
        }
        if (this.isBooter()) {
            this.autoexec.img1 = FileUtils.prefixAndSanitizeToDosroot(basePath, new File(this.autoexec.img1)).getPath();
            this.autoexec.img2 = FileUtils.prefixAndSanitizeToDosroot(basePath, new File(this.autoexec.img2)).getPath();
        } else {
            this.autoexec.main = FileUtils.prefixAndSanitizeToDosroot(basePath, new File(this.autoexec.main)).getPath();
        }
    }

    public String[] addMount(String mount) {
        this.autoexec.addMount(mount);
        return this.getMountingpoints();
    }

    public void addMounts(Configuration conf) {
        for (Mount m : conf.autoexec.mountingpoints) {
            this.autoexec.mountingpoints.add(m);
        }
    }

    public String[] removeMount(int index) {
        this.autoexec.mountingpoints.remove(index);
        return this.getMountingpoints();
    }

    public String[] toggleMount(int index) {
        this.autoexec.mountingpoints.get(index).toggleMount();
        return this.getMountingpoints();
    }

    public void unMount(int index) {
        Mount mnt = this.autoexec.mountingpoints.get(index);
        if (!mnt.isUnmounted()) {
            mnt.toggleMount();
        }
    }

    public String[] replaceMount(int index, String mount) {
        try {
            this.autoexec.mountingpoints.set(index, new Mount(mount));
        }
        catch (InvalidMountstringException invalidMountstringException) {
            // empty catch block
        }
        return this.getMountingpoints();
    }

    public int getNrOfMounts() {
        return this.autoexec.mountingpoints.size();
    }

    public String getRequiredMount(boolean booter, String main) {
        if (this.autoexec.convertToDosboxPath(main)[0].length() > 0) {
            return null;
        }
        try {
            return new Mount(booter, main, this.getMountingpoints()).getPathAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] addRequiredMount(boolean booter, String main) {
        try {
            if (FileUtils.containsIso(main) != -1) {
                Mount tmp = new Mount(booter, ".", this.getMountingpoints());
                if (tmp.getDriveletter() == 'C') {
                    this.addMount(tmp.toString());
                }
                return this.addMount(new Mount(booter, main, this.getMountingpoints()).toString());
            }
            return this.addMount(new Mount(booter, main, this.getMountingpoints()).toString());
        }
        catch (Exception e) {
            return this.getMountingpoints();
        }
    }

    public boolean isExit() {
        return this.autoexec.exit;
    }

    public boolean isLoadfix() {
        return this.autoexec.loadfix;
    }

    public String getLoadfixValue() {
        return this.autoexec.loadfixValue > 0 ? String.valueOf(this.autoexec.loadfixValue) : "";
    }

    public String getKeyb() {
        return this.autoexec.keyb;
    }

    public String getMixer() {
        return this.autoexec.mixer;
    }

    public String getIpxnet() {
        return this.autoexec.ipxnet;
    }

    public String[] getMountingpoints() {
        String[] result = new String[this.autoexec.mountingpoints.size()];
        int mountIndex = 0;
        for (Mount mount : this.autoexec.mountingpoints) {
            result[mountIndex++] = mount.toString(true);
        }
        return result;
    }

    public String getImg1() {
        if ("file".equals(this.autoexec.img1)) {
            return "";
        }
        return this.autoexec.img1;
    }

    public String getImg2() {
        return this.autoexec.img2;
    }

    public String getMain() {
        return this.autoexec.main;
    }

    public boolean isBooter() {
        return this.autoexec.img1.length() > 0;
    }

    public String getMainParameters() {
        return this.autoexec.params;
    }

    public boolean isIncomplete() {
        return this.autoexec.img1.length() == 0 && this.autoexec.main.length() == 0;
    }

    public void setAutoexecSettings(boolean exit) {
        this.autoexec.exit = exit;
    }

    public void setAutoexecSettings(boolean exit, boolean booter) {
        this.autoexec.exit = exit;
        this.autoexec.img1 = booter ? "file" : "";
    }

    public void setAutoexecSettings(boolean exit, String mixer, String keyb, String ipxnet, boolean booter) {
        this.setAutoexecSettings(exit, booter);
        this.autoexec.mixer = mixer;
        this.autoexec.keyb = keyb;
        this.autoexec.ipxnet = ipxnet;
    }

    public void setAutoexecSettings(String main, String params) {
        this.autoexec.main = main;
        this.autoexec.params = params;
    }

    public void setAutoexecSettings(boolean loadfix, String loadfixValue, String main, String params, String img1, String img2) {
        this.setAutoexecSettings(main, params);
        this.autoexec.loadfix = loadfix;
        try {
            this.autoexec.loadfixValue = Integer.parseInt(loadfixValue);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.autoexec.img1 = img1;
        this.autoexec.img2 = img2;
    }
}

