/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.List;
import org.dbgl.model.KeyValuePair;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoSelectCombo {
    private final Combo combo;
    private int currentLength;
    private boolean mutex;

    public AutoSelectCombo(Composite composite, int style, List<KeyValuePair> possibleValues, Object layoutData) {
        this.combo = new Combo(composite, style);
        this.combo.setLayoutData(layoutData);
        this.combo.setVisibleItemCount(15);
        for (KeyValuePair val : possibleValues) {
            this.combo.add(val.getValue());
        }
        this.combo.pack();
        this.currentLength = 0;
        this.mutex = false;
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!AutoSelectCombo.this.mutex) {
                    int index = AutoSelectCombo.this.indexOfClosestMatch(AutoSelectCombo.this.combo.getText());
                    int newLength = AutoSelectCombo.this.combo.getText().length();
                    if (newLength > AutoSelectCombo.this.currentLength && index != -1) {
                        AutoSelectCombo.this.mutex = true;
                        AutoSelectCombo.this.combo.setText(AutoSelectCombo.this.combo.getText() + AutoSelectCombo.this.combo.getItem(index).substring(newLength));
                        AutoSelectCombo.this.combo.setSelection(new Point(newLength, AutoSelectCombo.this.combo.getText().length()));
                        AutoSelectCombo.this.mutex = false;
                    }
                    AutoSelectCombo.this.currentLength = newLength;
                }
            }
        });
    }

    public String getText() {
        return this.combo.getText();
    }

    public void setText(String arg0) {
        this.combo.setText(arg0);
        this.currentLength = this.combo.getText().length();
    }

    private int indexOfClosestMatch(String text) {
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            if (!this.combo.getItem(i).toLowerCase().startsWith(text.toLowerCase())) continue;
            return i;
        }
        return -1;
    }
}

