/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpProfile
extends Profile {
    private static final XPathFactory xfactory = XPathFactory.newInstance();
    private static final XPath xPath = xfactory.newXPath();
    private CompositeConfiguration conf;
    private File baseDir;
    private File gameDir;
    private String importedFullConfig;
    private String importedIncrConfig;
    private int importedId;

    public ExpProfile(int id, CompositeConfiguration conf, File gDir, Profile prof) {
        super(id, prof.getConfPathAndFile(), prof.getCaptures(), prof);
        this.conf = conf;
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = gDir;
    }

    public ExpProfile(Node n, int dbversionIndex) throws XPathExpressionException {
        super(xPath.evaluate("title", n), Boolean.valueOf(xPath.evaluate("meta-info/favorite", n)));
        this.importedId = Integer.valueOf(xPath.evaluate("id", n));
        this.confPathAndFile = PlatformUtils.pathToNativePath(xPath.evaluate("config-file/raw", n));
        this.captures = PlatformUtils.pathToNativePath(xPath.evaluate("captures/raw", n));
        this.baseDir = FileUtils.makeRelativeToDosroot(new File("."));
        this.gameDir = new File(PlatformUtils.pathToNativePath(xPath.evaluate("game-dir/raw", n)));
        this.setup = PlatformUtils.pathToNativePath(xPath.evaluate("setup", n));
        this.setupParams = xPath.evaluate("setup-parameters", n);
        this.developerName = xPath.evaluate("meta-info/developer", n);
        this.publisherName = xPath.evaluate("meta-info/publisher", n);
        this.year = xPath.evaluate("meta-info/year", n);
        this.genre = xPath.evaluate("meta-info/genre", n);
        this.status = xPath.evaluate("meta-info/status", n);
        this.notes = xPath.evaluate("meta-info/notes", n);
        this.customString = new String[]{xPath.evaluate("meta-info/custom1", n), xPath.evaluate("meta-info/custom2", n), xPath.evaluate("meta-info/custom3", n), xPath.evaluate("meta-info/custom4", n), xPath.evaluate("meta-info/custom5", n), xPath.evaluate("meta-info/custom6", n), xPath.evaluate("meta-info/custom7", n), xPath.evaluate("meta-info/custom8", n)};
        this.customInt = new int[]{Integer.valueOf(xPath.evaluate("meta-info/custom9", n)), Integer.valueOf(xPath.evaluate("meta-info/custom10", n))};
        this.link = new String[]{PlatformUtils.pathToNativePath(xPath.evaluate("meta-info/link1/raw", n)), PlatformUtils.pathToNativePath(xPath.evaluate("meta-info/link2/raw", n)), PlatformUtils.pathToNativePath(xPath.evaluate("meta-info/link3/raw", n)), PlatformUtils.pathToNativePath(xPath.evaluate("meta-info/link4/raw", n))};
        this.linkTitle = new String[]{xPath.evaluate("meta-info/link1/title", n), xPath.evaluate("meta-info/link2/title", n), xPath.evaluate("meta-info/link3/title", n), xPath.evaluate("meta-info/link4/title", n)};
        this.importedFullConfig = xPath.evaluate("full-configuration", n);
        this.importedIncrConfig = xPath.evaluate("incremental-configuration", n);
        this.dbversionId = dbversionIndex;
    }

    public void setDbversionId(int id) {
        this.dbversionId = id;
    }

    public int getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int importedId) {
        this.importedId = importedId;
    }

    public String getCapturesExport() {
        return FileUtils.constructCapturesDir(this.getId());
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setGameDir(File gameDir) {
        this.gameDir = gameDir;
    }

    public String getImportedFullConfig() {
        return this.importedFullConfig;
    }

    public String getImportedIncrConfig() {
        return this.importedIncrConfig;
    }

    public CompositeConfiguration getConf() {
        return this.conf;
    }

    public void setConf(CompositeConfiguration conf) {
        this.conf = conf;
    }

    public Element getXml(Document xmldoc, List<DosboxVersion> dbversionsList) {
        int i;
        boolean listExport = this.conf == null;
        Element profEmt = xmldoc.createElement("profile");
        XmlUtils.addCDataElement(xmldoc, profEmt, "title", this.getTitle());
        XmlUtils.addElement(xmldoc, profEmt, "id", String.valueOf(this.getId()));
        Element captures = xmldoc.createElement("captures");
        XmlUtils.addElement(xmldoc, captures, "raw", this.getCapturesExport());
        if (listExport) {
            XmlUtils.addElement(xmldoc, captures, "url", this.getCapturesAsUrl());
        }
        profEmt.appendChild(captures);
        Element config = xmldoc.createElement("config-file");
        XmlUtils.addElement(xmldoc, config, "raw", FileUtils.makeRelativeToData(new File(this.getConfPathAndFile())).getPath());
        if (listExport) {
            XmlUtils.addElement(xmldoc, config, "url", this.getConfFileAsUrl());
        }
        profEmt.appendChild(config);
        if (this.gameDir != null) {
            Element gamedir = xmldoc.createElement("game-dir");
            XmlUtils.addElement(xmldoc, gamedir, "raw", PlatformUtils.toDosboxPath(this.gameDir.getPath()));
            profEmt.appendChild(gamedir);
        }
        XmlUtils.addElement(xmldoc, profEmt, "setup", this.getSetup());
        XmlUtils.addElement(xmldoc, profEmt, "setup-parameters", this.getSetupParameters());
        Element meta = xmldoc.createElement("meta-info");
        XmlUtils.addCDataElement(xmldoc, meta, "developer", this.getDeveloperName());
        XmlUtils.addCDataElement(xmldoc, meta, "publisher", this.getPublisherName());
        XmlUtils.addCDataElement(xmldoc, meta, "year", this.getYear());
        XmlUtils.addCDataElement(xmldoc, meta, "genre", this.getGenre());
        XmlUtils.addCDataElement(xmldoc, meta, "status", this.getStatus());
        XmlUtils.addElement(xmldoc, meta, "favorite", String.valueOf(this.isDefault()));
        XmlUtils.addCDataElement(xmldoc, meta, "notes", XmlUtils.cleanEolnForXml(this.getNotes()));
        for (i = 0; i < 8; ++i) {
            XmlUtils.addCDataElement(xmldoc, meta, "custom" + (i + 1), this.getCustomString(i));
        }
        for (i = 0; i < 2; ++i) {
            XmlUtils.addElement(xmldoc, meta, "custom" + (i + 9), String.valueOf(this.getCustomInt(i)));
        }
        for (i = 0; i < 4; ++i) {
            Element link = xmldoc.createElement("link" + (i + 1));
            XmlUtils.addElement(xmldoc, link, "raw", this.getLink(i));
            if (listExport) {
                XmlUtils.addElement(xmldoc, link, "url", this.getLinkAsUrl(i));
            }
            XmlUtils.addCDataElement(xmldoc, link, "title", this.getLinkTitle(i));
            meta.appendChild(link);
        }
        profEmt.appendChild(meta);
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "full-configuration", XmlUtils.cleanEolnForXml(this.conf.getFullConf()));
        }
        if (this.conf != null) {
            XmlUtils.addCDataElement(xmldoc, profEmt, "incremental-configuration", XmlUtils.cleanEolnForXml(this.conf.getIncrConf()));
        }
        DosboxVersion dbv = dbversionsList.get(DosboxVersion.findById(dbversionsList, this.getDbversionId()));
        Element dosbox = xmldoc.createElement("dosbox");
        XmlUtils.addCDataElement(xmldoc, dosbox, "title", dbv.getValue());
        XmlUtils.addElement(xmldoc, dosbox, "version", dbv.getVersion());
        profEmt.appendChild(dosbox);
        return profEmt;
    }
}

