/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.model.Mount;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Autoexec {
    List<Mount> mountingpoints;
    boolean loadfix;
    int loadfixValue;
    String main;
    String img1;
    String img2;
    boolean exit;
    String params;
    String mixer;
    String keyb;
    String ipxnet;

    Autoexec(Autoexec other) {
        this.mountingpoints = new ArrayList<Mount>(other.mountingpoints);
        this.loadfix = other.loadfix;
        this.loadfixValue = other.loadfixValue;
        this.main = other.main;
        this.img1 = other.img1;
        this.img2 = other.img2;
        this.exit = other.exit;
        this.params = other.params;
        this.mixer = other.mixer;
        this.keyb = other.keyb;
        this.ipxnet = other.ipxnet;
    }

    Autoexec(String[] orgLines) {
        this.parseLines(orgLines, true);
    }

    void init() {
        this.mountingpoints = new ArrayList<Mount>();
        this.loadfix = false;
        this.loadfixValue = 0;
        this.main = "";
        this.img1 = "";
        this.img2 = "";
        this.exit = false;
        this.params = "";
        this.mixer = "";
        this.keyb = "";
        this.ipxnet = "";
    }

    Autoexec(List<Mount> mountingpoints, Autoexec baseMounts, boolean switchDbversion) {
        this.init();
        this.exit = true;
        if (switchDbversion) {
            int start;
            for (int i = start = baseMounts == null ? 0 : baseMounts.mountingpoints.size(); i < mountingpoints.size(); ++i) {
                this.mountingpoints.add(new Mount(mountingpoints.get(i)));
            }
        } else {
            int max = baseMounts == null ? 0 : baseMounts.mountingpoints.size();
            for (int i = 0; i < mountingpoints.size(); ++i) {
                if (i < max && mountingpoints.get(i).equals(baseMounts.mountingpoints.get(i))) continue;
                this.mountingpoints.add(new Mount(mountingpoints.get(i)));
            }
        }
    }

    void parseLines(String[] orgLines, boolean init) {
        if (init) {
            this.init();
        }
        if (orgLines.length == 0) {
            return;
        }
        char driveletter = '\u0000';
        char imgdriveletter1 = '\u0000';
        char imgdriveletter2 = '\u0000';
        String remainder = "";
        String executable = "";
        String image1 = "";
        String image2 = "";
        int exeIndex = -1;
        for (String orgLine : orgLines) {
            String line = orgLine.toLowerCase();
            if (line.startsWith("mount") || line.startsWith("imgmount")) {
                this.addMount(orgLine);
            } else if (line.endsWith(":") && line.length() == 2) {
                driveletter = line.charAt(0);
            } else if (line.startsWith("cd\\")) {
                remainder = PlatformUtils.toNativePath(orgLine).substring(2);
            } else if (line.startsWith("cd ")) {
                remainder = PlatformUtils.toNativePath(orgLine).substring(3);
            } else if (line.startsWith("keyb ") || line.startsWith("keyb.com ")) {
                this.keyb = orgLine.substring(line.indexOf(32) + 1);
            } else if (line.startsWith("mixer ") || line.startsWith("mixer.com ")) {
                this.mixer = orgLine.substring(line.indexOf(32) + 1);
            } else if (line.startsWith("ipxnet ") || line.startsWith("ipxnet.com ")) {
                this.ipxnet = orgLine.substring(line.indexOf(32) + 1);
            } else {
                exeIndex = line.indexOf(FileUtils.EXECUTABLES[0]);
                if (exeIndex != -1 || (exeIndex = line.indexOf(FileUtils.EXECUTABLES[1])) != -1 || (exeIndex = line.indexOf(FileUtils.EXECUTABLES[2])) != -1) {
                    int spaceAfterIndex;
                    executable = orgLine;
                    int spaceBeforeIndex = executable.lastIndexOf(32, exeIndex);
                    if (spaceBeforeIndex != -1) {
                        executable = executable.substring(spaceBeforeIndex + 1);
                    }
                    if ((spaceAfterIndex = executable.indexOf(32)) != -1) {
                        this.params = orgLine.substring(spaceBeforeIndex + spaceAfterIndex + 2);
                        executable = executable.substring(0, spaceAfterIndex);
                    }
                } else if (line.startsWith("boot ")) {
                    int spaceIndex = line.indexOf(32, 5);
                    if (spaceIndex == -1) {
                        spaceIndex = line.length();
                    } else {
                        imgdriveletter2 = line.charAt(spaceIndex + 1);
                        image2 = PlatformUtils.toNativePath(orgLine).substring(spaceIndex + 3);
                    }
                    imgdriveletter1 = line.charAt(5);
                    image1 = PlatformUtils.toNativePath(orgLine).substring(7, spaceIndex);
                    if (imgdriveletter1 == '\\' && "ile".equals(image1)) {
                        this.img1 = "file";
                    }
                } else if (line.startsWith("exit")) {
                    this.exit = true;
                }
            }
            if (!line.startsWith("loadfix -") || line.startsWith("loadfix -f")) continue;
            this.loadfix = true;
            int endIndex = line.indexOf(32, 9);
            if (endIndex == -1) {
                endIndex = line.length();
            }
            try {
                this.loadfixValue = Integer.parseInt(line.substring(9, endIndex));
            }
            catch (NumberFormatException e) {
                this.loadfixValue = 0;
            }
        }
        for (Mount mount : this.mountingpoints) {
            char mount_drive = mount.getDriveletter();
            String mountPath = mount.getHostPathAsString();
            if (Character.toUpperCase(driveletter) == mount_drive) {
                this.main = FileUtils.sanitizeToDosroot(mountPath + remainder + File.separatorChar + executable);
                continue;
            }
            if (Character.toUpperCase(imgdriveletter1) == mount_drive) {
                this.img1 = FileUtils.sanitizeToDosroot(mountPath + image1);
            }
            if (Character.toUpperCase(imgdriveletter2) != mount_drive) continue;
            this.img2 = FileUtils.sanitizeToDosroot(mountPath + image2);
        }
    }

    String getString(List<Mount> baseMounts) {
        String[] dosboxLocation;
        List<Mount> shortList;
        StringBuffer result = new StringBuffer();
        if (!"".equals(this.keyb)) {
            result.append("keyb.com ").append(this.keyb).append(PlatformUtils.EOLN);
        }
        if (!"".equals(this.ipxnet)) {
            result.append("ipxnet.com ").append(this.ipxnet).append(PlatformUtils.EOLN);
        }
        if (baseMounts == null) {
            shortList = this.mountingpoints;
        } else {
            shortList = new ArrayList<Mount>();
            for (int i = 0; i < this.mountingpoints.size(); ++i) {
                if (i < baseMounts.size() && this.mountingpoints.get(i).equals(baseMounts.get(i))) continue;
                shortList.add(this.mountingpoints.get(i));
            }
        }
        for (Mount mount : shortList) {
            result.append(mount.toString()).append(PlatformUtils.EOLN);
        }
        if (!"".equals(this.mixer)) {
            result.append("mixer.com ").append(this.mixer).append(PlatformUtils.EOLN);
        }
        if (!"".equals(this.main)) {
            dosboxLocation = this.convertToDosboxPath(this.main);
            result.append(dosboxLocation[0] + PlatformUtils.EOLN);
            result.append("cd \\" + dosboxLocation[1] + PlatformUtils.EOLN);
            if (this.loadfix) {
                result.append("loadfix -").append(this.loadfixValue).append(PlatformUtils.EOLN);
            }
            if (dosboxLocation[2].toLowerCase().endsWith(FileUtils.EXECUTABLES[2])) {
                result.append("call ");
            }
            result.append(dosboxLocation[2]);
            if (!"".equals(this.params)) {
                result.append(' ').append(this.params);
            }
            if (this.loadfix) {
                result.append(PlatformUtils.EOLN).append("loadfix -f");
            }
            if (this.exit) {
                result.append(PlatformUtils.EOLN).append("exit");
            }
        } else if (!"".equals(this.img1)) {
            if (this.loadfix) {
                result.append("loadfix -").append(this.loadfixValue).append(PlatformUtils.EOLN);
            }
            dosboxLocation = this.convertToDosboxPath(this.img1);
            result.append("boot ").append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
            if (!dosboxLocation[1].equals("")) {
                result.append('\\');
            }
            result.append(dosboxLocation[2]);
            if (!"".equals(this.img2)) {
                dosboxLocation = this.convertToDosboxPath(this.img2);
                result.append(' ').append(dosboxLocation[0]).append('\\').append(dosboxLocation[1]);
                if (!dosboxLocation[1].equals("")) {
                    result.append('\\');
                }
                result.append(dosboxLocation[2]);
            }
            if (this.loadfix) {
                result.append(PlatformUtils.EOLN).append("loadfix -f");
            }
        } else if (this.exit) {
            result.append("exit");
        }
        return result.toString();
    }

    String[] convertToDosboxPath(String hostFileLocation) {
        File hostFile = new File(hostFileLocation);
        String[] result = new String[]{"", "", hostFile.getName()};
        int maxLengthMount = 0;
        for (Mount mount : this.mountingpoints) {
            File dosboxDir = mount.canBeUsedFor(hostFile);
            if (dosboxDir == null || mount.getPathAsString().length() <= maxLengthMount) continue;
            result[0] = mount.getDriveletter() + ":";
            result[1] = dosboxDir.getParent() == null ? "" : dosboxDir.getParent();
            maxLengthMount = mount.getPathAsString().length();
        }
        result[1] = PlatformUtils.toDosboxPath(result[1]);
        return result;
    }

    void addMount(String mount) {
        block4: {
            try {
                Mount mnt = new Mount(mount);
                if (mnt.isUnmounted()) {
                    for (Mount m : this.mountingpoints) {
                        if (m.getDriveletter() != mnt.getDriveletter()) continue;
                        m.toggleMount();
                        break block4;
                    }
                    break block4;
                }
                this.mountingpoints.add(mnt);
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
    }
}

